/*
 * Decompiled with CFR 0.152.
 */
package oracle.dbtools.crest.swingui.multidimensional;

import java.awt.Dimension;
import java.util.ArrayList;
import java.util.Iterator;
import oracle.dbtools.crest.model.design.DesignObject;
import oracle.dbtools.crest.model.design.DesignPart;
import oracle.dbtools.crest.model.design.Note;
import oracle.dbtools.crest.model.design.multidimensional.AbstractMDObject;
import oracle.dbtools.crest.model.design.multidimensional.Cube;
import oracle.dbtools.crest.model.design.multidimensional.Level;
import oracle.dbtools.crest.model.design.multidimensional.Link;
import oracle.dbtools.crest.model.design.multidimensional.MultidimensionalDesign;
import oracle.dbtools.crest.model.design.multidimensional.RaggedHLink;
import oracle.dbtools.crest.swingui.AbstractController;
import oracle.dbtools.crest.swingui.ApplicationView;
import oracle.dbtools.crest.swingui.DesignPartView;
import oracle.dbtools.crest.swingui.ProgressDialog;
import oracle.dbtools.crest.swingui.TVNote;
import oracle.dbtools.crest.swingui.TopView;
import oracle.dbtools.crest.swingui.multidimensional.AbstractMDTV;
import oracle.dbtools.crest.swingui.multidimensional.ControllerMultidimensional;
import oracle.dbtools.crest.swingui.multidimensional.DPVMultidimensional;
import oracle.dbtools.crest.swingui.multidimensional.TVCube;
import oracle.dbtools.crest.swingui.multidimensional.TVDimension;
import oracle.dbtools.crest.swingui.multidimensional.TVLevel;
import oracle.dbtools.crest.swingui.multidimensional.TVLink;
import oracle.dbtools.crest.swingui.multidimensional.TVRaggedHLink;

public class DPVCompactMultidimentional
extends DPVMultidimensional {
    private static final Dimension TOPVIEW_SIZE = new Dimension(100, 100);
    private AbstractController controller;

    public DPVCompactMultidimentional(ApplicationView applicationView, DesignPart desPart) {
        super(applicationView, desPart);
        this.controller = new ControllerMultidimensional(applicationView);
        this.controller.setName("Multidimensional");
        this.controller.setDesignPartView(this);
    }

    @Override
    public TopView createViewFor(DesignObject object) {
        TopView view = null;
        if (object instanceof Cube) {
            TVCube tv = new TVCube(this.getApplicationView(), this);
            tv.setModel(object);
            view = tv;
            view.setSize(new Dimension(TOPVIEW_SIZE));
        } else {
            if (object instanceof Note) {
                TVNote tv = new TVNote(this.getApplicationView(), this);
                tv.setModel(object);
                return tv;
            }
            if (object instanceof Level) {
                TVLevel tv = new TVLevel(this.getApplicationView(), this);
                tv.setModel(object);
                view = tv;
                Dimension d = new Dimension(170, 65);
                view.setSize(d);
            } else if (object instanceof oracle.dbtools.crest.model.design.multidimensional.Dimension) {
                TVDimension tv = new TVDimension(this.getApplicationView(), this);
                tv.setModel(object);
                view = tv;
                Dimension d = new Dimension(80, 30);
                view.setSize(d);
            } else if (object instanceof Link) {
                TVLink tv = new TVLink(this.getApplicationView(), this);
                tv.setModel(object);
                view = tv;
                view.setSize(new Dimension(TOPVIEW_SIZE));
            } else if (object instanceof RaggedHLink) {
                TVRaggedHLink tv = new TVRaggedHLink(this.getApplicationView(), this);
                tv.setModel(object);
                view = tv;
                view.setSize(new Dimension(TOPVIEW_SIZE));
            } else {
                return null;
            }
        }
        return view;
    }

    @Override
    public void objectAdded(DesignPart designPart, DesignObject object) {
        if (ApplicationView.loading || this.getApplicationView().getCurrentDPV() != this) {
            return;
        }
        TopView view = this.getViewFor(object);
        if (view == null) {
            this.addViewFor(object);
        }
    }

    @Override
    public AbstractController getController() {
        return this.controller;
    }

    @Override
    public boolean isLeaf() {
        return false;
    }

    @Override
    public boolean isMainDiagram() {
        return false;
    }

    public void generateDiagram() {
        AbstractMDTV targetTV;
        AbstractMDTV sourceTV;
        AbstractMDObject link;
        ArrayList col = new ArrayList();
        ((MultidimensionalDesign)this.getDesignPart()).getCubeSet().addAllElementsTo(col);
        ((MultidimensionalDesign)this.getDesignPart()).getDimensionSet().addAllElementsTo(col);
        ((MultidimensionalDesign)this.getDesignPart()).getLevelSet().addAllElementsTo(col);
        for (AbstractMDObject mdObject : col) {
            TopView topView;
            if (mdObject.getFirstViewForDPV(this) != null || (topView = mdObject.getFirstViewForDPV(this.getDesignPart().getMainView())) == null) continue;
            topView.createViewSynonim(this);
        }
        Iterator it = ((MultidimensionalDesign)this.getDesignPart()).getLinkSet().iterator();
        while (it.hasNext()) {
            link = (Link)it.next();
            if (((Link)link).getFirstViewForDPV(this) != null) continue;
            sourceTV = (AbstractMDTV)((Link)link).getSourceMDObject().getFirstViewForDPV(this);
            targetTV = (AbstractMDTV)((Link)link).getTargetMDObject().getFirstViewForDPV(this);
            if (sourceTV == null || targetTV == null) continue;
            ((Link)link).setSourceTV(sourceTV);
            ((Link)link).setTargetTV(targetTV);
        }
        it = ((MultidimensionalDesign)this.getDesignPart()).getRaggedHLinkSet().iterator();
        while (it.hasNext()) {
            link = (RaggedHLink)it.next();
            if (((RaggedHLink)link).getFirstViewForDPV(this) != null) continue;
            sourceTV = (AbstractMDTV)((RaggedHLink)link).getSourceMDObject().getFirstViewForDPV(this);
            targetTV = (AbstractMDTV)((RaggedHLink)link).getTargetMDObject().getFirstViewForDPV(this);
            if (sourceTV == null || targetTV == null) continue;
            ((RaggedHLink)link).setSourceTV(sourceTV);
            ((RaggedHLink)link).setTargetTV(targetTV);
        }
        this.rearrangeDiagram(true);
    }

    @Override
    public DesignPartView getCompactDiagram() {
        return null;
    }

    @Override
    public void setDirty(boolean dirty) {
        super.setDirty(dirty);
        if (dirty) {
            this.getMultidimensionalDesign().getMainView().setDirty(true);
        }
    }

    @Override
    public void setVisible(boolean flag) {
        boolean old_dirty = this.isDirty();
        boolean old_main_dirty = this.getMultidimensionalDesign().getMainView().isDirty();
        super.setVisible(flag);
        if (flag && !this.getDesign().isLoading()) {
            if (!old_dirty) {
                this.setDirty(old_dirty);
            }
            if (!old_main_dirty) {
                this.getMultidimensionalDesign().getMainView().setDirty(old_main_dirty);
            }
        }
    }

    @Override
    public void setVisible(boolean flag, ProgressDialog monitor) {
        boolean old_dirty = this.isDirty();
        boolean old_main_dirty = this.getMultidimensionalDesign().getMainView().isDirty();
        super.setVisible(flag, monitor);
        if (flag) {
            if (!old_dirty) {
                this.setDirty(old_dirty);
            }
            if (!old_main_dirty) {
                this.getMultidimensionalDesign().getMainView().setDirty(old_main_dirty);
            }
        }
    }
}

