/*
 * Decompiled with CFR 0.152.
 */
package oracle.dbtools.crest.swingui.multidimensional;

import java.awt.Dimension;
import java.awt.Font;
import java.awt.FontMetrics;
import java.awt.Point;
import java.awt.Rectangle;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.TreeMap;
import javax.swing.AbstractAction;
import javax.swing.JCheckBoxMenuItem;
import javax.swing.JMenu;
import javax.swing.JMenuItem;
import javax.swing.JPopupMenu;
import oracle.dbtools.crest.fcp.DataModelerAddin;
import oracle.dbtools.crest.model.design.ContainedObject;
import oracle.dbtools.crest.model.design.ContainerObject;
import oracle.dbtools.crest.model.design.DesignObject;
import oracle.dbtools.crest.model.design.DesignPart;
import oracle.dbtools.crest.model.design.DiagramView;
import oracle.dbtools.crest.model.design.EditableFonts;
import oracle.dbtools.crest.model.design.ImageObject;
import oracle.dbtools.crest.model.design.Label;
import oracle.dbtools.crest.model.design.Legend;
import oracle.dbtools.crest.model.design.Note;
import oracle.dbtools.crest.model.design.multidimensional.AbstractMDObject;
import oracle.dbtools.crest.model.design.multidimensional.CalculatedAttribute;
import oracle.dbtools.crest.model.design.multidimensional.Cube;
import oracle.dbtools.crest.model.design.multidimensional.Hierarchy;
import oracle.dbtools.crest.model.design.multidimensional.Level;
import oracle.dbtools.crest.model.design.multidimensional.Link;
import oracle.dbtools.crest.model.design.multidimensional.Measure;
import oracle.dbtools.crest.model.design.multidimensional.MultidimensionalDesign;
import oracle.dbtools.crest.model.design.multidimensional.RaggedHLink;
import oracle.dbtools.crest.swingui.AbstractController;
import oracle.dbtools.crest.swingui.ApplicationView;
import oracle.dbtools.crest.swingui.DesignPartView;
import oracle.dbtools.crest.swingui.MenuUtils;
import oracle.dbtools.crest.swingui.TVDiagramView;
import oracle.dbtools.crest.swingui.TVImage;
import oracle.dbtools.crest.swingui.TVLabel;
import oracle.dbtools.crest.swingui.TVLegend;
import oracle.dbtools.crest.swingui.TVNote;
import oracle.dbtools.crest.swingui.TopView;
import oracle.dbtools.crest.swingui.multidimensional.ControllerMultidimensional;
import oracle.dbtools.crest.swingui.multidimensional.Messages;
import oracle.dbtools.crest.swingui.multidimensional.TVCube;
import oracle.dbtools.crest.swingui.multidimensional.TVDimension;
import oracle.dbtools.crest.swingui.multidimensional.TVLevel;
import oracle.dbtools.crest.swingui.multidimensional.TVLink;
import oracle.dbtools.crest.swingui.multidimensional.TVRaggedHLink;

public class DPVMultidimensional
extends DesignPartView {
    private static final Dimension TOPVIEW_SIZE = new Dimension(100, 100);
    public static final String MI_FACT_ENTITIES = Messages.getString("DPVMultidimensional.Entities");
    private ControllerMultidimensional controller;
    private int xdelta = 70;
    private int ydelta = 40;
    private int xcube = 10;
    private int xdimension = 100;
    private int xlevel = 150;
    private int ydimension = 10;
    private Map arrangedMap = new TreeMap();
    private JPopupMenu menu;
    private JMenuItem miPaste;
    private JCheckBoxMenuItem miAutoRoute;
    private JCheckBoxMenuItem miGridEnabled;
    private JCheckBoxMenuItem miShowGrid;
    private JCheckBoxMenuItem miShowPageGrid;
    private JMenu detailsMenu;
    private JCheckBoxMenuItem miAllDetails;
    private JCheckBoxMenuItem miNameOnly;
    private JCheckBoxMenuItem miElements;
    private JCheckBoxMenuItem miKeys;
    private JCheckBoxMenuItem miShowLegend;
    public static final String TOOLBAR_NAME = "Multidimensional Model";

    public DPVMultidimensional(ApplicationView applicationView, DesignPart desPart) {
        super(applicationView, desPart);
        this.controller = new ControllerMultidimensional(applicationView);
        this.controller.setName("Multidimensional");
        this.controller.setDesignPartView(this);
    }

    @Override
    public TopView createViewFor(DesignObject object) {
        return this.createTopViewFor(object);
    }

    @Override
    public AbstractController getController() {
        return this.controller;
    }

    public TopView createViewSynonim(DesignObject object) {
        AbstractMDObject mdObject = (AbstractMDObject)object;
        TopView tv = mdObject.getFirstViewForDPV(this);
        if (tv == null) {
            if (object instanceof Cube) {
                tv = new TVCube(this.getApplicationView(), this);
            } else if (object instanceof oracle.dbtools.crest.model.design.multidimensional.Dimension) {
                tv = new TVDimension(this.getApplicationView(), this);
            } else if (object instanceof Link) {
                tv = new TVLink(this.getApplicationView(), this);
            } else if (object instanceof Level) {
                tv = new TVLevel(this.getApplicationView(), this);
            } else if (object instanceof RaggedHLink) {
                tv = new TVRaggedHLink(this.getApplicationView(), this);
            }
        }
        if (tv != null) {
            tv.setModel(object);
            this.modelToView.put(object, tv);
            this.add(tv);
        }
        return tv;
    }

    public MultidimensionalDesign getMultidimensionalDesign() {
        return (MultidimensionalDesign)this.getDesignPart();
    }

    public void rearrangeDiagram(boolean recalculateSize) {
        this.xdelta = 70;
        this.ydelta = 40;
        this.xcube = 10;
        this.xdimension = 100;
        this.xlevel = 150;
        this.ydimension = 10;
        this.arrangedMap.clear();
        if (recalculateSize) {
            this.resetSize();
        }
        Dimension dim = this.getLargestDimension(this.getMultidimensionalDesign().getCubeSet().iterator());
        this.xdimension = this.xcube + dim.width + 2 * this.xdelta;
        dim = this.getLargestDimension(this.getMultidimensionalDesign().getDimensionSet().iterator());
        this.xlevel = this.xdimension + dim.width + 2 * this.xdelta;
        Iterator it = this.getMultidimensionalDesign().getCubeSet().iterator();
        while (it.hasNext()) {
            Cube cube = (Cube)it.next();
            this.rearrangeCube(cube);
        }
        it = this.getMultidimensionalDesign().getDimensionSet().iterator();
        while (it.hasNext()) {
            oracle.dbtools.crest.model.design.multidimensional.Dimension dimension = (oracle.dbtools.crest.model.design.multidimensional.Dimension)it.next();
            Object obj = this.arrangedMap.get(dimension.getObjectID());
            if (obj != null) continue;
            this.rearrangeDimension(dimension);
            this.arrangedMap.put(dimension.getObjectID(), dimension);
        }
        it = this.getMultidimensionalDesign().getLevelSet().iterator();
        int xstart = this.xlevel;
        while (it.hasNext()) {
            Level level = (Level)it.next();
            Object obj = this.arrangedMap.get(level.getObjectID());
            if (obj != null) continue;
            this.positionObject(level, xstart, this.ydimension);
            Rectangle r = this.getDesObjBounds(level);
            xstart = xstart + r.width + this.xdelta;
            this.arrangedMap.put(level.getObjectID(), level);
        }
        it = this.getMultidimensionalDesign().getLinkSet().iterator();
        while (it.hasNext()) {
            Link link = (Link)it.next();
            TVLink tv = (TVLink)link.getTopView();
            tv.getEdge().straightLine(false);
            tv = null;
        }
        this.arrangedMap.clear();
    }

    private void resetSize() {
        ArrayList all = new ArrayList();
        this.getMultidimensionalDesign().getCubeSet().addAllElementsTo(all);
        this.getMultidimensionalDesign().getLevelSet().addAllElementsTo(all);
        this.getMultidimensionalDesign().getDimensionSet().addAllElementsTo(all);
        for (DesignObject object : all) {
            this.resetSizeOf(object);
        }
    }

    private void resetSizeOf(DesignObject object) {
        TopView tv = ((AbstractMDObject)object).getFirstViewForDPV(this);
        if (tv != null) {
            Rectangle r = tv.getCalculatedBounds();
            if (tv.getCellView() != null) {
                tv.getCellView().setNewBounds(new Rectangle(r.x, r.y, r.width, r.height));
            } else {
                tv.setBounds(new Rectangle(r.x, r.y, r.width, r.height));
            }
        }
    }

    private Dimension getLargestDimension(Iterator it) {
        int height = 0;
        int widht = 0;
        while (it.hasNext()) {
            DesignObject dobj = (DesignObject)it.next();
            Object obj = this.arrangedMap.get(dobj.getObjectID());
            if (obj != null) continue;
            TopView tv = ((AbstractMDObject)dobj).getFirstViewForDPV(this);
            if (tv == null) {
                tv = dobj.getTopView();
            }
            if (tv == null) continue;
            Rectangle r = tv.getCellView() != null ? tv.getCellView().getBounds().getBounds() : tv.getBounds();
            if (r.height > height) {
                height = r.height;
            }
            if (r.width <= widht) continue;
            widht = r.width;
        }
        return new Dimension(widht, height);
    }

    private void rearrangeCube(Cube cube) {
        int ystart = this.ydimension;
        for (oracle.dbtools.crest.model.design.multidimensional.Dimension dimension : cube.getDimensions()) {
            Object obj = this.arrangedMap.get(dimension.getObjectID());
            if (obj != null) continue;
            this.rearrangeDimension(dimension);
            this.arrangedMap.put(dimension.getObjectID(), dimension);
        }
        Rectangle r = this.getDesObjBounds(cube);
        if (ystart + r.height > this.ydimension) {
            this.ydimension = ystart + r.height + this.ydelta;
        } else {
            int ycenter = ystart + (this.ydimension - ystart - this.ydelta) / 2;
            if (ycenter + r.height / 2 > this.ydimension) {
                ycenter = this.ydimension - r.height / 2;
            }
            ystart = ycenter - r.height / 2;
        }
        this.positionObject(cube, this.xcube, ystart);
        this.arrangedMap.put(cube.getObjectID(), cube);
    }

    private void rearrangeDimension(oracle.dbtools.crest.model.design.multidimensional.Dimension dimension) {
        int ystart = this.ydimension;
        for (Hierarchy hier : dimension.getHierarchies()) {
            Dimension dim = this.getLargestDimension(hier.getLevels().iterator());
            this.rearrangeHierarcy(hier);
            this.ydimension = this.ydimension + dim.height + this.ydelta;
        }
        Rectangle r = this.getDesObjBounds(dimension);
        if (ystart + r.height > this.ydimension) {
            this.ydimension = ystart + r.height + this.ydelta;
        } else {
            int ycenter = ystart + (this.ydimension - ystart - this.ydelta) / 2;
            if (ycenter + r.height / 2 > this.ydimension) {
                ycenter = this.ydimension - r.height / 2;
            }
            ystart = ycenter - r.height / 2;
        }
        this.positionObject(dimension, this.xdimension, ystart);
        this.arrangedMap.put(dimension.getObjectID(), dimension);
    }

    private void rearrangeHierarcy(Hierarchy hier) {
        Iterator it = hier.getLevels().iterator();
        int xstart = this.xlevel;
        while (it.hasNext()) {
            Rectangle r;
            Level level = (Level)it.next();
            Object obj = this.arrangedMap.get(level.getObjectID());
            if (obj == null) {
                this.positionObject(level, xstart, this.ydimension);
                r = this.getDesObjBounds(level);
                if (r == null) continue;
                xstart = xstart + r.width + this.xdelta;
                this.arrangedMap.put(level.getObjectID(), level);
                continue;
            }
            r = this.getDesObjBounds(level);
            xstart = xstart + r.width + this.xdelta;
        }
    }

    private Rectangle getDesObjBounds(DesignObject object) {
        Rectangle r = null;
        TopView tv = ((AbstractMDObject)object).getFirstViewForDPV(this);
        if (tv == null) {
            tv = object.getTopView();
        }
        if (tv != null) {
            r = tv.getCellView() != null ? tv.getCellView().getBounds().getBounds() : tv.getBounds();
        }
        return r;
    }

    private void positionObject(DesignObject object, int x, int y) {
        Rectangle r = this.getDesObjBounds(object);
        TopView tv = ((AbstractMDObject)object).getFirstViewForDPV(this);
        if (tv != null && r != null) {
            if (tv.getCellView() != null) {
                tv.getCellView().setNewBounds(new Rectangle(x, y, r.width, r.height));
            } else {
                tv.setBounds(new Rectangle(x, y, r.width, r.height));
            }
        }
    }

    @Override
    public DesignPartView createSubordinateView(ApplicationView applicationView, DesignPart desPart) {
        return new DPVMultidimensional(this.getApplicationView(), this.getDesignPart());
    }

    @Override
    public TopView createTopViewFor(DesignObject object) {
        TopView view = null;
        if (object instanceof Cube) {
            TVCube tv = new TVCube(this.getApplicationView(), this);
            tv.setModel(object);
            view = tv;
            view.setSize(new Dimension(TOPVIEW_SIZE));
        } else {
            if (object instanceof Note) {
                TVNote tv = new TVNote(this.getApplicationView(), this);
                tv.setModel(object);
                return tv;
            }
            if (object instanceof ImageObject) {
                TVImage tv = new TVImage(this.getApplicationView(), this);
                tv.setModel(object);
                return tv;
            }
            if (object instanceof Legend) {
                TVLegend tv = new TVLegend(this.getApplicationView(), this);
                tv.setModel(object);
                return tv;
            }
            if (object instanceof Level) {
                TVLevel tv = new TVLevel(this.getApplicationView(), this);
                tv.setModel(object);
                view = tv;
                Dimension d = new Dimension(170, 65);
                view.setSize(d);
            } else if (object instanceof oracle.dbtools.crest.model.design.multidimensional.Dimension) {
                TVDimension tv = new TVDimension(this.getApplicationView(), this);
                tv.setModel(object);
                view = tv;
                Dimension d = new Dimension(80, 30);
                view.setSize(d);
            } else if (object instanceof Link) {
                TVLink tv = new TVLink(this.getApplicationView(), this);
                tv.setModel(object);
                view = tv;
                view.setSize(new Dimension(TOPVIEW_SIZE));
            } else if (object instanceof RaggedHLink) {
                TVRaggedHLink tv = new TVRaggedHLink(this.getApplicationView(), this);
                tv.setModel(object);
                view = tv;
                view.setSize(new Dimension(TOPVIEW_SIZE));
            } else if (object instanceof DiagramView) {
                TVDiagramView tv = new TVDiagramView(this.getApplicationView(), this);
                tv.setModel(object);
                view = tv;
                view.setSize(new Dimension(TOPVIEW_SIZE));
            } else if (object instanceof Label) {
                TVLabel tv = new TVLabel(this.getApplicationView(), this);
                tv.setModel(object);
                view = tv;
                view.setSize(new Dimension(TOPVIEW_SIZE));
            } else {
                return null;
            }
        }
        this.registerForTreemodel(view);
        this.setDirty(true);
        return view;
    }

    @Override
    public JPopupMenu getPopupMenu() {
        this.menu = new JPopupMenu();
        if (this.isEditable()) {
            this.addUndoRedo(this.menu);
            this.menu.addSeparator();
            this.miPaste = this.menu.add(new AbstractAction(MI_PASTE){

                @Override
                public void actionPerformed(ActionEvent e) {
                    DPVMultidimensional.this.getController().paste(DPVMultidimensional.this.pt);
                }
            });
            this.miPaste.setIcon(this.getConfiguration().getIcon("PASTE_ICON", 16));
            this.menu.addSeparator();
            this.menu.add(this.getDetailsMenu());
            this.menu.addSeparator();
            this.menu.add(this.getLayoutSubMenu());
        }
        this.menu.add(this.getGoToDiagramMenu());
        this.menu.addSeparator();
        this.menu.add(this.getShowMenu());
        this.menu.addSeparator();
        this.menu.add(DataModelerAddin.findOrCreateVersioningMenu(this.menu));
        this.menu.addSeparator();
        JMenuItem miProperties = this.menu.add(new AbstractAction(MI_PROPERTIES){

            @Override
            public void actionPerformed(ActionEvent e) {
                DPVMultidimensional.this.getDesignPart().showPropertyDialog();
            }
        });
        miProperties.setIcon(this.getConfiguration().getIcon("PROPERTIES_ICON", 16));
        if (this.isEditable()) {
            this.miGridEnabled.setSelected(this.isGridEnabled());
            this.miPaste.setEnabled(this.canPaste());
            this.miAutoRoute.setSelected(this.isAutoRoute());
            this.miAllDetails.setSelected(this.showAllDetails());
            this.miNameOnly.setSelected(this.isShowNamesOnly());
            this.miElements.setSelected(this.showElements());
            this.miKeys.setSelected(this.showKeys());
        }
        return this.menu;
    }

    public JMenu getShowMenu() {
        JMenu showMenu = new JMenu(MenuUtils.getMnemonicStr(MI_SHOW));
        showMenu.setMnemonic(MenuUtils.getMnemonicKey(MI_SHOW));
        this.miShowGrid = new JCheckBoxMenuItem(MI_SHOW_GRID);
        this.miShowGrid.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent event) {
                DPVMultidimensional.this.setShowGrid(!DPVMultidimensional.this.showGrid());
            }
        });
        showMenu.add(this.miShowGrid);
        this.miShowPageGrid = new JCheckBoxMenuItem(MI_SHOW_PAGE_GRID);
        this.miShowPageGrid.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent event) {
                DPVMultidimensional.this.setShowPageGrid(!DPVMultidimensional.this.showPageGrid());
            }
        });
        showMenu.add(this.miShowPageGrid);
        showMenu.addSeparator();
        this.miShowLegend = new JCheckBoxMenuItem(MI_SHOW_LEGEND);
        this.miShowLegend.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent event) {
                DPVMultidimensional.this.setShowLegend(!DPVMultidimensional.this.showLegend());
            }
        });
        showMenu.add(this.miShowLegend);
        this.miShowGrid.setSelected(this.showGrid());
        this.miShowPageGrid.setSelected(this.showPageGrid());
        this.miShowLegend.setSelected(this.showLegend());
        return showMenu;
    }

    @Override
    public JMenu getDetailsMenu() {
        this.detailsMenu = new JMenu(MenuUtils.getMnemonicStr(MI_DETAILS));
        this.detailsMenu.setMnemonic(MenuUtils.getMnemonicKey(MI_DETAILS));
        this.miAllDetails = new JCheckBoxMenuItem(MenuUtils.getMnemonicStr(MI_ALL_DETAILS));
        this.miAllDetails.setMnemonic(MenuUtils.getMnemonicKey(MI_ALL_DETAILS));
        this.miNameOnly = new JCheckBoxMenuItem(MenuUtils.getMnemonicStr(MI_NAMES_ONLY));
        this.miNameOnly.setMnemonic(MenuUtils.getMnemonicKey(MI_NAMES_ONLY));
        this.miElements = new JCheckBoxMenuItem(MenuUtils.getMnemonicStr(MI_ELEMENTS));
        this.miElements.setMnemonic(MenuUtils.getMnemonicKey(MI_ELEMENTS));
        this.miKeys = new JCheckBoxMenuItem(MenuUtils.getMnemonicStr(MI_FACT_ENTITIES));
        this.miKeys.setMnemonic(MenuUtils.getMnemonicKey(MI_FACT_ENTITIES));
        this.miAllDetails.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent event) {
                DPVMultidimensional.this.setShowAllDetails(true);
                DPVMultidimensional.this.setShowNamesOnly(false);
                DPVMultidimensional.this.setShowElements(false);
                DPVMultidimensional.this.setShowDatatype(false);
                DPVMultidimensional.this.setShowKeys(false);
                DPVMultidimensional.this.getWorkSpace().invalidate();
                DPVMultidimensional.this.getWorkSpace().repaint();
            }
        });
        this.detailsMenu.add(this.miAllDetails);
        this.detailsMenu.addSeparator();
        this.miNameOnly.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent event) {
                DPVMultidimensional.this.setShowNamesOnly(true);
                DPVMultidimensional.this.setShowAllDetails(false);
                DPVMultidimensional.this.setShowNamesOnly(true);
                DPVMultidimensional.this.setShowElements(false);
                DPVMultidimensional.this.setShowDatatype(false);
                DPVMultidimensional.this.setShowKeys(false);
                DPVMultidimensional.this.getWorkSpace().invalidate();
                DPVMultidimensional.this.getWorkSpace().repaint();
            }
        });
        this.detailsMenu.add(this.miNameOnly);
        this.miKeys.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent event) {
                DPVMultidimensional.this.setShowKeys(!DPVMultidimensional.this.showKeys());
                if (DPVMultidimensional.this.showKeys()) {
                    DPVMultidimensional.this.setShowAllDetails(false);
                    DPVMultidimensional.this.setShowNamesOnly(false);
                } else if (!DPVMultidimensional.this.showElements()) {
                    DPVMultidimensional.this.setShowAllDetails(true);
                }
                DPVMultidimensional.this.getWorkSpace().invalidate();
                DPVMultidimensional.this.getWorkSpace().repaint();
            }
        });
        this.detailsMenu.add(this.miKeys);
        this.miElements.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent event) {
                DPVMultidimensional.this.setShowElements(!DPVMultidimensional.this.showElements());
                if (!DPVMultidimensional.this.showElements()) {
                    DPVMultidimensional.this.setShowDatatype(false);
                    if (!DPVMultidimensional.this.showKeys()) {
                        DPVMultidimensional.this.setShowAllDetails(true);
                    }
                } else {
                    DPVMultidimensional.this.setShowAllDetails(false);
                    DPVMultidimensional.this.setShowNamesOnly(false);
                }
                DPVMultidimensional.this.getWorkSpace().invalidate();
                DPVMultidimensional.this.getWorkSpace().repaint();
            }
        });
        this.detailsMenu.add(this.miElements);
        this.miAllDetails.setSelected(this.showAllDetails());
        this.miNameOnly.setSelected(this.isShowNamesOnly());
        this.miElements.setSelected(this.showElements());
        this.miKeys.setSelected(this.showKeys());
        return this.detailsMenu;
    }

    @Override
    public boolean isStorable() {
        return false;
    }

    public DesignPartView getCompactDiagram() {
        return this.getMultidimensionalDesign().getCompactDiagram();
    }

    public void setCompactDiagram(DesignPartView diagram) {
    }

    @Override
    public String getToolbarName() {
        return TOOLBAR_NAME;
    }

    public void resizeCubes() {
        List cubes = (List)this.getTVCubes();
        for (TopView topView : cubes) {
            if (topView == null) continue;
            this.resizeCubes(topView);
        }
    }

    public Collection getTVCubes() {
        ArrayList<TopView> col = new ArrayList<TopView>();
        for (TopView tv : this.topViews) {
            if (!(tv instanceof TVCube)) continue;
            col.add(tv);
        }
        return col;
    }

    public void resizeCubes(TopView topView) {
        Dimension dim = this.getCubeSize(topView, (Cube)topView.getModel());
        if (topView.getCellView() != null) {
            Point pos = topView.getCellView().getBounds().getBounds().getLocation();
            topView.getCellView().setNewBounds(new Rectangle(new Point(pos.x, pos.y), dim));
        } else {
            Point pos = topView.getLocation();
            topView.setBounds(new Rectangle(new Point(pos.x, pos.y), dim));
        }
    }

    private Dimension getCubeSize(TopView tv, Cube cube) {
        int colTextHeight;
        int w = 35;
        int h = 25;
        int colCount = 0;
        String title = cube.getName();
        Font titleFont = tv.getFontObject(EditableFonts.FO_TITLE).getFont();
        FontMetrics fm = this.getFontMetrics(titleFont);
        int titleLength = fm.stringWidth(title);
        h = colTextHeight = fm.getHeight();
        h = Math.max(colTextHeight, titleFont.getSize());
        h += 12;
        if (this.isShowNamesOnly()) {
            return new Dimension(w * 2 + titleLength, h);
        }
        int keyWidth = 0;
        int colWidth = 0;
        if (this.showAllDetails() || this.showKeys()) {
            Font feFont = tv.getFontObject(EditableFonts.FO_FACT_ENTITIES).getFont();
            fm = this.getFontMetrics(feFont);
            int keyCount = 0;
            StringBuffer sb = new StringBuffer();
            boolean firstn = true;
            for (ContainerObject ent : cube.getFactEntities()) {
                ++keyCount;
                if (firstn) {
                    sb.append(ent.getName());
                    firstn = false;
                    continue;
                }
                sb.append(", ").append(ent.getName());
            }
            if (keyCount > 0) {
                keyWidth = fm.stringWidth(sb.toString()) + 5;
                h += 6;
                colTextHeight = fm.getHeight();
                h += colTextHeight;
            }
        }
        if (this.showAllDetails() || this.showElements()) {
            Font measureFont = tv.getFontObject(EditableFonts.FO_MEASURE).getFont();
            fm = this.getFontMetrics(measureFont);
            boolean isFunc = false;
            boolean isFormula = false;
            if (cube.getMeasures().size() > 0) {
                for (Measure measure : cube.getMeasures()) {
                    ++colCount;
                    int cl = fm.stringWidth(measure.getName());
                    colWidth = Math.max(cl, colWidth);
                    if (measure.getDefaultAggregationFunction() != null) {
                        isFunc = true;
                    }
                    if (!measure.isFormula()) continue;
                    isFormula = true;
                }
            }
            if (colCount > 0) {
                h += 6;
                colTextHeight = fm.getHeight();
                h += colCount * colTextHeight;
                int cl = fm.stringWidth("XXX");
                if (isFunc) {
                    cl += fm.stringWidth("XXXXX");
                }
                if (isFormula) {
                    cl += fm.stringWidth("XXXXX");
                }
                colWidth += cl;
            }
            Font attrFont = tv.getFontObject(EditableFonts.FO_CHILD_TO_PARENT).getFont();
            fm = this.getFontMetrics(attrFont);
            colCount = 0;
            List links = cube.getOutgoingLinks();
            for (Link link : links) {
                Object[] attributes = link.getRollupLink().getChildToParentAttributes().toArray();
                for (int i = 0; i < attributes.length; ++i) {
                    ++colCount;
                    Object name = ((DesignObject)attributes[i]).getName();
                    if (link.getRollupLink().isRolePlaying()) {
                        name = (String)name + " " + link.getRollupLink().getName();
                    } else {
                        oracle.dbtools.crest.model.design.multidimensional.Dimension dim = (oracle.dbtools.crest.model.design.multidimensional.Dimension)link.getTargetMDObject();
                        name = (String)name + " " + dim.getName();
                    }
                    int cl = fm.stringWidth("XXX");
                    colWidth = Math.max(cl += fm.stringWidth((String)name), colWidth);
                }
            }
            if (colCount > 0) {
                h += 6;
                colTextHeight = fm.getHeight();
                h += colCount * colTextHeight;
            }
        }
        int colLength = 1;
        colLength = Math.max(keyWidth, colLength + colWidth);
        colLength = Math.max(titleLength, colLength);
        return new Dimension(w + colLength, h);
    }

    public void resizeDimensions() {
        List dimensions = (List)this.getTVDimensions();
        for (TopView topView : dimensions) {
            if (topView == null) continue;
            this.resizeDimensions(topView);
        }
    }

    public Collection getTVDimensions() {
        ArrayList<TopView> col = new ArrayList<TopView>();
        for (TopView tv : this.topViews) {
            if (!(tv instanceof TVDimension)) continue;
            col.add(tv);
        }
        return col;
    }

    public void resizeDimensions(TopView topView) {
        Dimension dim = this.getDimensionSize(topView, (oracle.dbtools.crest.model.design.multidimensional.Dimension)topView.getModel());
        if (topView.getCellView() != null) {
            Point pos = topView.getCellView().getBounds().getBounds().getLocation();
            topView.getCellView().setNewBounds(new Rectangle(new Point(pos.x, pos.y), dim));
        } else {
            Point pos = topView.getLocation();
            topView.setBounds(new Rectangle(new Point(pos.x, pos.y), dim));
        }
    }

    private Dimension getDimensionSize(TopView tv, oracle.dbtools.crest.model.design.multidimensional.Dimension dim) {
        int colTextHeight;
        int w = 35;
        int h = 25;
        String title = dim.getName();
        Font titleFont = tv.getFontObject(EditableFonts.FO_TITLE).getFont();
        FontMetrics fm = this.getFontMetrics(titleFont);
        int titleLength = fm.stringWidth(title);
        h = colTextHeight = fm.getHeight();
        h = Math.max(colTextHeight, titleFont.getSize());
        return new Dimension(w * 2 + titleLength, h += 6);
    }

    public void resizeLevels() {
        List levels = (List)this.getTVLevels();
        for (TopView topView : levels) {
            if (topView == null) continue;
            this.resizeLevels(topView);
        }
    }

    public Collection getTVLevels() {
        ArrayList<TopView> col = new ArrayList<TopView>();
        for (TopView tv : this.topViews) {
            if (!(tv instanceof TVLevel)) continue;
            col.add(tv);
        }
        return col;
    }

    public void resizeLevels(TopView topView) {
        Dimension dim = this.getLevelSize(topView, (Level)topView.getModel());
        if (topView.getCellView() != null) {
            Point pos = topView.getCellView().getBounds().getBounds().getLocation();
            topView.getCellView().setNewBounds(new Rectangle(new Point(pos.x, pos.y), dim));
        } else {
            Point pos = topView.getLocation();
            topView.setBounds(new Rectangle(new Point(pos.x, pos.y), dim));
        }
    }

    private Dimension getLevelSize(TopView tv, Level level) {
        int colTextHeight;
        int w = 35;
        int h = 25;
        int colCount = 0;
        String title = level.getName();
        Font titleFont = tv.getFontObject(EditableFonts.FO_TITLE).getFont();
        FontMetrics fm = this.getFontMetrics(titleFont);
        int titleLength = fm.stringWidth(title);
        h = colTextHeight = fm.getHeight();
        h = Math.max(colTextHeight, titleFont.getSize());
        h += 6;
        if (this.isShowNamesOnly()) {
            return new Dimension(w * 2 + titleLength, h);
        }
        int keyWidth = 0;
        int colWidth = 0;
        if (this.showAllDetails() || this.showKeys()) {
            Font feFont = tv.getFontObject(EditableFonts.FO_LEVEL_ENTITY).getFont();
            fm = this.getFontMetrics(feFont);
            ContainerObject ent = level.getLevelEntity();
            if (ent != null) {
                keyWidth = fm.stringWidth(ent.getName());
                h += 6;
                colTextHeight = fm.getHeight();
                h += colTextHeight;
            }
        }
        if (this.showAllDetails() || this.showElements()) {
            Font measureFont = tv.getFontObject(EditableFonts.FO_ATTRIBUTE).getFont();
            fm = this.getFontMetrics(measureFont);
            ArrayList elems = new ArrayList();
            elems.addAll(level.getLevelKey());
            elems.addAll(level.getSlowChangingAttributes());
            elems.addAll(level.getCalculatedAttributes());
            Object[] elements = elems.toArray();
            for (int i = 0; i < elements.length; ++i) {
                String func;
                DesignObject attribute = (DesignObject)elements[i];
                ++colCount;
                int cl = fm.stringWidth("XXX");
                cl += fm.stringWidth(attribute.getName());
                if (attribute instanceof CalculatedAttribute && (func = ((CalculatedAttribute)attribute).getFunction()) != null) {
                    cl += fm.stringWidth(func);
                }
                colWidth = Math.max(cl, colWidth);
            }
            if (colCount > 0) {
                h += 6;
                colTextHeight = fm.getHeight();
                h += colCount * colTextHeight;
            }
            colCount = 0;
            if (level.isValueBasedHierarchy()) {
                Object[] attributes = level.getParentKey().toArray();
                for (int j = 0; j < attributes.length; ++j) {
                    ContainedObject attr = (ContainedObject)attributes[j];
                    ++colCount;
                    int cl = fm.stringWidth("XX");
                    colWidth = Math.max(cl += fm.stringWidth(attr.getName()), colWidth);
                }
                if (colCount > 0) {
                    colTextHeight = fm.getHeight();
                    h += colCount * colTextHeight;
                }
            } else {
                Object[] links = level.getOutgoingLinks().toArray();
                if (links.length > 0) {
                    for (int i = 0; i < links.length; ++i) {
                        Link link = (Link)links[i];
                        Iterator ita = link.getRollupLink().getChildToParentAttributes().iterator();
                        while (ita.hasNext()) {
                            String name = ((DesignObject)ita.next()).getName();
                            ++colCount;
                            int cl = fm.stringWidth("XX");
                            colWidth = Math.max(cl += fm.stringWidth(name), colWidth);
                        }
                    }
                    if (colCount > 0) {
                        colTextHeight = fm.getHeight();
                        h += colCount * colTextHeight;
                    }
                }
            }
        }
        int colLength = 1;
        colLength = Math.max(keyWidth, colLength + colWidth);
        colLength = Math.max(titleLength, colLength);
        return new Dimension(w + colLength, h);
    }

    private JMenu getLayoutSubMenu() {
        JMenu miLayout = new JMenu(Messages.getString("DPVMultidimensional.Layout"));
        this.miGridEnabled = new JCheckBoxMenuItem(MI_SNAP_TO_GRID);
        this.miGridEnabled.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent event) {
                DPVMultidimensional.this.setGridEnabled(!DPVMultidimensional.this.isGridEnabled());
            }
        });
        miLayout.add(this.miGridEnabled);
        miLayout.addSeparator();
        this.miAutoRoute = new JCheckBoxMenuItem(MI_AUTO_ROUTE);
        this.miAutoRoute.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent event) {
                DPVMultidimensional.this.setAutoRoute(!DPVMultidimensional.this.isAutoRoute());
                DPVMultidimensional.this.getWorkSpace().updateSettings();
            }
        });
        miLayout.add(this.miAutoRoute);
        miLayout.addSeparator();
        miLayout.add(this.getStraightenLinesItem());
        miLayout.add(new AbstractAction(MI_RESIZE_OBJECTS_TO_VISIBLE){

            @Override
            public void actionPerformed(ActionEvent e) {
                DPVMultidimensional.this.startAutoLayoutEdit(DesignPartView.MI_RESIZE_OBJECTS_TO_VISIBLE + " of " + DPVMultidimensional.this.getName());
                try {
                    DPVMultidimensional.this.resizeCubes();
                    DPVMultidimensional.this.resizeDimensions();
                    DPVMultidimensional.this.resizeLevels();
                    if (!DPVMultidimensional.this.isAutoRoute()) {
                        DPVMultidimensional.this.straightenLines(false);
                    }
                }
                finally {
                    DPVMultidimensional.this.stopAutoLayoutEdit();
                }
            }
        });
        return miLayout;
    }
}

