/*
 * Decompiled with CFR 0.152.
 */
package oracle.dbtools.crest.swingui.printing;

import java.awt.Component;
import java.io.File;
import java.net.URL;
import java.text.MessageFormat;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import javax.swing.JOptionPane;
import oracle.dbtools.crest.swingui.ApplicationView;
import oracle.dbtools.crest.swingui.GUIConfiguration;
import oracle.dbtools.crest.swingui.diagram.Diagram;
import oracle.dbtools.crest.swingui.printing.Messages;
import oracle.dbtools.crest.util.logging.Logger;
import oracle.dbtools.raptor.ui.URLFileChooser;
import oracle.ide.Ide;
import oracle.ide.net.URLChooser;
import oracle.ide.net.URLFactory;
import oracle.ide.net.URLFilter;

public abstract class AbstractExporter {
    protected static final String PNG = "png";
    protected static final String JPG = "jpg";
    protected static final String GIF = "gif";
    protected static final String SVG = "svg";
    protected static final String PDF = "pdf";
    private static File lastFolder = null;
    protected URLChooser fileChooser = new URLFileChooser();
    private static final Logger LOGGER = new Logger(AbstractExporter.class);
    private ApplicationView appView;
    private List filterList;

    public AbstractExporter(ApplicationView appView) {
        this.appView = appView;
        this.filterList = new ArrayList();
    }

    public abstract void export(Diagram var1);

    protected abstract boolean isSupportedExtension(String var1);

    public ApplicationView getAppView() {
        return this.appView;
    }

    public List getFilterList() {
        return this.filterList;
    }

    protected static String getExtension(File f) {
        String ext = null;
        String s = f.getName();
        int i = s.lastIndexOf(46);
        if (i > 0 && i < s.length() - 1) {
            ext = s.substring(i + 1).toLowerCase();
        }
        return ext;
    }

    protected abstract String getTitle();

    private String getDefaultExtension() {
        URLFilter filter = this.fileChooser.getSelectedFilter();
        String filterDescription = filter.toString();
        String extension = filterDescription.substring(filterDescription.indexOf("(") + 2, filterDescription.indexOf(")"));
        return extension;
    }

    protected String changeExtension(String originalName, String newExtension) {
        int lastDot = originalName.lastIndexOf(".");
        if (lastDot != -1) {
            return originalName.substring(0, lastDot) + newExtension;
        }
        return originalName + newExtension;
    }

    protected File getFile() {
        try {
            File file;
            this.fileChooser.clearChooseableURLFilters();
            this.fileChooser.setSelectionScope(0);
            this.fileChooser.setSelectionMode(0);
            this.fileChooser.setShowJarsAsDirs(false);
            ((URLFileChooser)this.fileChooser).setPathContext("dataModeler_Exports");
            Iterator it = this.filterList.iterator();
            while (it.hasNext()) {
                this.fileChooser.setURLFilter((URLFilter)it.next());
            }
            if (this.filterList.size() > 0) {
                this.fileChooser.setURLFilter((URLFilter)this.filterList.get(0));
            }
            String path = "";
            if (lastFolder != null) {
                path = lastFolder.getPath();
                this.fileChooser.setSelectedURL(URLFactory.newDirURL((File)lastFolder));
            } else {
                String lastDir = this.appView.getSettings().getDefaultSavePath();
                if (lastDir != null && lastDir.length() > 0) {
                    path = lastDir;
                    this.fileChooser.setSelectedURL(URLFactory.newDirURL((String)lastDir));
                } else {
                    URL url = this.appView.getUserHomeDirectory();
                    if (url != null) {
                        path = url.getPath();
                        this.fileChooser.setSelectedURL(url);
                    }
                }
            }
            String fileName = this.appView.getCurrentDPV().getName() + this.getDefaultExtension();
            File f = new File(path, fileName);
            URL url = URLFactory.newFileURL((File)f);
            this.fileChooser.setSelectedURL(url);
            int status = this.fileChooser.showSaveDialog((Component)Ide.getMainWindow(), this.getTitle());
            if (status == 0 && (file = new File(this.fileChooser.getSelectedURL().getPath())) != null) {
                lastFolder = file.getParentFile();
                if (file.exists()) {
                    status = JOptionPane.showConfirmDialog((Component)Ide.getMainWindow(), MessageFormat.format(Messages.getString("AbstractExporter.FileExists"), file.getAbsolutePath()), Messages.getString("AbstractExporter.Warning"), 0, 3, GUIConfiguration.getInstance().getIcon("SAVE_ICON", 32));
                    if (status == 1) {
                        return null;
                    }
                    return file;
                }
                return file;
            }
        }
        catch (Exception e) {
            LOGGER.error("AbstractExporter.getFile", e);
        }
        return null;
    }

    protected String getFileName(File file) {
        return this.changeExtension(file.getAbsolutePath(), this.getDefaultExtension());
    }
}

