/*
 * Decompiled with CFR 0.152.
 */
package oracle.dbtools.crest.swingui.wizards.metadata.oracle;

import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.List;
import javax.swing.BorderFactory;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTabbedPane;
import javax.swing.JTable;
import javax.swing.border.TitledBorder;
import javax.swing.table.AbstractTableModel;
import javax.swing.table.DefaultTableCellRenderer;
import javax.swing.table.TableColumn;
import javax.swing.table.TableModel;
import oracle.dbtools.crest.imports.metadata.AbstractDBMExtractionHandler;
import oracle.dbtools.crest.imports.metadata.DBObject;
import oracle.dbtools.crest.imports.metadata.ImportDBShowEntry;
import oracle.dbtools.crest.model.ModelObject;
import oracle.dbtools.crest.model.design.storage.StorageDesign;
import oracle.dbtools.crest.model.design.storage.oracle.StorageDesignOracle;
import oracle.dbtools.crest.model.design.storage.oracle.TableProxySetOracle;
import oracle.dbtools.crest.model.design.storage.oracle.TableViewProxySetOracle;
import oracle.dbtools.crest.swingui.WindowsTableHeader;
import oracle.dbtools.crest.swingui.wizards.Messages;
import oracle.dbtools.crest.swingui.wizards.metadata.AbstractDBMExtractionWizardImpl;
import oracle.dbtools.crest.swingui.wizards.metadata.DBMExtractionWizard;

public class DBMExtractionWizardOracle
extends AbstractDBMExtractionWizardImpl {
    private static DBMExtractionWizardOracle impl;
    protected JTable tbTableSpaces;
    protected JTable tbTempTableSpaces;
    protected JTable tbUndoTableSpaces;
    protected JTable tbUsers;
    protected JTable tbRoles;
    protected JTable tbDirectories;
    protected JTable tbExternalTables;
    protected JTable tbMViewLogs;
    protected JTable tbContexts;
    protected JTable tbClusters;
    protected JTable tbSequence;
    protected JTable tbSynonyms;
    protected JTable tbDimensions;
    protected JTable tbTypes;
    protected JTable tbPackages;
    protected JTable tbProcedures;
    protected JTable tbFunctions;
    protected List lsTableSpaces = new ArrayList();
    protected List lsTempTableSpaces = new ArrayList();
    protected List lsUndoTableSpaces = new ArrayList();
    protected List lsUsers = new ArrayList();
    protected List lsRoles = new ArrayList();
    protected List lsDirectories = new ArrayList();
    protected List lsExternalTables = new ArrayList();
    protected List lsMViewLogs = new ArrayList();
    protected List lsContexts = new ArrayList();
    protected List lsClusters = new ArrayList();
    protected List lsSequence = new ArrayList();
    protected List lsSynonyms = new ArrayList();
    protected List lsDimensions = new ArrayList();
    protected List lsTypes = new ArrayList();
    protected List lsPackages = new ArrayList();
    protected List lsProcedures = new ArrayList();
    protected List lsFunctions = new ArrayList();
    private JPanel warning;

    public DBMExtractionWizardOracle(DBMExtractionWizard wizard) {
        super(wizard);
    }

    public static AbstractDBMExtractionWizardImpl getInstance(DBMExtractionWizard wizard) {
        if (impl == null) {
            impl = new DBMExtractionWizardOracle(wizard);
        }
        return impl;
    }

    public static void clearInstance() {
        impl = null;
    }

    @Override
    protected List getCurrentList() {
        int tab = this.getTabbedPane().getSelectedIndex();
        switch (tab) {
            case 0: {
                return this.lsTables;
            }
            case 1: {
                return this.lsViews;
            }
            case 2: {
                return this.lsUsers;
            }
            case 3: {
                return this.lsRoles;
            }
            case 4: {
                return this.lsDirectories;
            }
            case 5: {
                return this.lsExternalTables;
            }
            case 6: {
                return this.lsMViewLogs;
            }
            case 7: {
                return this.lsContexts;
            }
            case 8: {
                return this.lsClusters;
            }
            case 9: {
                return this.lsSequence;
            }
            case 10: {
                return this.lsSynonyms;
            }
            case 11: {
                return this.lsTableSpaces;
            }
            case 12: {
                return this.lsTempTableSpaces;
            }
            case 13: {
                return this.lsDimensions;
            }
            case 14: {
                return this.lsTypes;
            }
            case 15: {
                return this.lsPackages;
            }
            case 16: {
                return this.lsProcedures;
            }
            case 17: {
                return this.lsFunctions;
            }
            case 18: {
                return this.lsUndoTableSpaces;
            }
        }
        return this.lsTables;
    }

    @Override
    protected void addTabs() {
        this.tbTables = this.addTab(this.tbTables, this.lsTables, Messages.getString("DBMExtractionWizardOracle.Tables"), this.showTab("TABLE"));
        this.tbViews = this.addTab(this.tbViews, this.lsViews, Messages.getString("DBMExtractionWizardOracle.Views"), this.showTab("VIEW"));
        this.tbUsers = this.addSimpleTab(this.tbUsers, this.lsUsers, Messages.getString("DBMExtractionWizardOracle.Users"), this.showTab("USER"));
        this.tbRoles = this.addSimpleTab(this.tbRoles, this.lsRoles, Messages.getString("DBMExtractionWizardOracle.Roles"), this.showTab("ROLE"));
        this.tbDirectories = this.addSimpleTab(this.tbDirectories, this.lsDirectories, Messages.getString("DBMExtractionWizardOracle.Directories"), this.showTab("DIRECTORY"));
        this.tbExternalTables = this.addTab(this.tbExternalTables, this.lsExternalTables, Messages.getString("DBMExtractionWizardOracle.ExternalTables"), this.showTab("EXTERNAL TABLE"));
        this.tbMViewLogs = this.addTab(this.tbMViewLogs, this.lsMViewLogs, Messages.getString("DBMExtractionWizardOracle.MViewLogs"), this.showTab("MVIEW_LOG"));
        this.tbContexts = this.addSimpleTab(this.tbContexts, this.lsContexts, Messages.getString("DBMExtractionWizardOracle.Contexts"), this.showTab("CONTEXT"));
        this.tbClusters = this.addTab(this.tbClusters, this.lsClusters, Messages.getString("DBMExtractionWizardOracle.Clusters"), this.showTab("CLUSTER"));
        this.tbSequence = this.addTab(this.tbSequence, this.lsSequence, Messages.getString("DBMExtractionWizardOracle.Sequences"), this.showTab("SEQUENCE"));
        this.tbSynonyms = this.addTab(this.tbSynonyms, this.lsSynonyms, Messages.getString("DBMExtractionWizardOracle.Synonyms"), this.showTab("SYNONYM"));
        this.tbTableSpaces = this.addSimpleTab(this.tbTableSpaces, this.lsTableSpaces, Messages.getString("DBMExtractionWizardOracle.TableSpaces"), this.showTab("TABLESPACE"));
        this.tbTempTableSpaces = this.addSimpleTab(this.tbTempTableSpaces, this.lsTempTableSpaces, Messages.getString("DBMExtractionWizardOracle.TempTableSpaces"), this.showTab("TEMP TABLESPACE"));
        this.tbDimensions = this.addTab(this.tbDimensions, this.lsDimensions, Messages.getString("DBMExtractionWizardOracle.Dimensions"), this.showTab("DIMENSION"));
        this.tbTypes = this.addTypesTab(Messages.getString("DBMExtractionWizardOracle.Types"), new TypeModel(this.lsTypes), this.showTab("OBJECT"));
        this.tbTypes.setDefaultRenderer(Object.class, new TypeCellRender());
        this.tbPackages = this.addTab(this.tbPackages, this.lsPackages, Messages.getString("DBMExtractionWizardOracle.Packages"), this.showTab("PACKAGE"));
        this.tbProcedures = this.addTab(this.tbProcedures, this.lsProcedures, Messages.getString("DBMExtractionWizardOracle.StoredProcedures"), this.showTab("PROCEDURE"));
        this.tbFunctions = this.addTab(this.tbFunctions, this.lsFunctions, Messages.getString("DBMExtractionWizardOracle.Functions"), this.showTab("FUNCTION"));
    }

    private boolean showTab(String objectType) {
        AbstractDBMExtractionHandler handler = this.wizard.getController().getDBMExtractionHandler(this.wizard.getSelectedConnectionType());
        List showList = handler.getShowList();
        if (showList != null) {
            for (ImportDBShowEntry showEntry : showList) {
                if (!objectType.equals(showEntry.getHandlerType())) continue;
                return showEntry.isShow();
            }
        }
        return true;
    }

    private JTable addTypesTab(String name, AbstractTableModel model, boolean showTab) {
        JTable table = new JTable(model);
        table.setAutoCreateRowSorter(true);
        WindowsTableHeader.setSortedHeader(table);
        TableColumn column = table.getColumnModel().getColumn(0);
        column.setPreferredWidth(50);
        column = table.getColumnModel().getColumn(1);
        column.setPreferredWidth(60);
        column = table.getColumnModel().getColumn(2);
        column.setPreferredWidth(60);
        JPanel panel = new JPanel(new BorderLayout());
        JScrollPane sp = new JScrollPane(table);
        panel.add((Component)sp, "Center");
        this.warning = new JPanel(new BorderLayout());
        TitledBorder border = BorderFactory.createTitledBorder("");
        this.warning.setBorder(BorderFactory.createTitledBorder(border, Messages.getString("DBMExtractionWizardOracle.Warning"), 1, 2, null, Color.RED));
        JLabel label = new JLabel();
        label.setText(Messages.getString("DBMExtractionWizardOracle.ExistingTypeOverridden"));
        label.setForeground(Color.RED);
        this.warning.add((Component)label, "North");
        this.warning.setVisible(false);
        panel.add((Component)this.warning, "South");
        if (showTab) {
            this.getTabbedPane().addTab(name, panel);
        }
        return table;
    }

    protected JTable addSimpleTab(JTable table, List list, String name, boolean showTab) {
        table = new JTable(new SimpleModel(list));
        table.setAutoCreateRowSorter(true);
        WindowsTableHeader.setSortedHeader(table);
        TableColumn column = table.getColumnModel().getColumn(0);
        column.setPreferredWidth(50);
        column = table.getColumnModel().getColumn(1);
        column.setPreferredWidth(300);
        JScrollPane sp = new JScrollPane(table);
        if (showTab) {
            this.getTabbedPane().addTab(name, sp);
        }
        return table;
    }

    @Override
    protected void updateTables() {
        this.tbTables.updateUI();
        this.tbViews.updateUI();
        this.tbTableSpaces.updateUI();
        this.tbUsers.updateUI();
        this.tbRoles.updateUI();
        this.tbDirectories.updateUI();
        this.tbExternalTables.updateUI();
        this.tbMViewLogs.updateUI();
        this.tbContexts.updateUI();
        this.tbTempTableSpaces.updateUI();
        this.tbContexts.updateUI();
        this.tbClusters.updateUI();
        this.tbSequence.updateUI();
        this.tbSynonyms.updateUI();
        this.tbDimensions.updateUI();
        this.tbTypes.updateUI();
        this.tbPackages.updateUI();
        this.tbProcedures.updateUI();
        this.tbFunctions.updateUI();
        if (this.tbUndoTableSpaces != null) {
            this.tbUndoTableSpaces.updateUI();
        }
    }

    @Override
    protected void clearAll() {
        this.lsTables.clear();
        this.lsViews.clear();
        this.lsTableSpaces.clear();
        this.lsTempTableSpaces.clear();
        this.lsUndoTableSpaces.clear();
        this.lsUsers.clear();
        this.lsRoles.clear();
        this.lsDirectories.clear();
        this.lsExternalTables.clear();
        this.lsMViewLogs.clear();
        this.lsContexts.clear();
        this.lsClusters.clear();
        this.lsSequence.clear();
        this.lsSynonyms.clear();
        this.lsDimensions.clear();
        this.lsTypes.clear();
        this.lsPackages.clear();
        this.lsProcedures.clear();
        this.lsFunctions.clear();
    }

    @Override
    protected JTabbedPane getTabbedPane() {
        if (this.tpane == null) {
            this.tpane = new JTabbedPane(3);
        }
        return this.tpane;
    }

    private void addAditionalTabs() {
        String undoTSName = Messages.getString("DBMExtractionWizardOracle.UndoTableSpaces");
        if (this.wizard.getController().getDBMExtractionHandler(this.wizard.getSelectedConnectionType()).getDBMajorVersion() > 8) {
            this.tbUndoTableSpaces = this.addSimpleTab(this.tbUndoTableSpaces, this.lsUndoTableSpaces, undoTSName, this.showTab("UNDO TABLESPACE"));
        } else {
            if (this.tbUndoTableSpaces != null) {
                this.getTabbedPane().remove(this.getTabbedPane().indexOfTab(undoTSName));
            }
            this.tbUndoTableSpaces = null;
        }
    }

    /*
     * Exception decompiling
     */
    @Override
    protected boolean getDBObjects(boolean next) {
        /*
         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
         * 
         * org.benf.cfr.reader.util.ConfusedCFRException: Tried to end blocks [3[CATCHBLOCK]], but top level block is 2[TRYBLOCK]
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.processEndingBlocks(Op04StructuredStatement.java:435)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.buildNestedBlocks(Op04StructuredStatement.java:484)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op03SimpleStatement.createInitialStructuredBlock(Op03SimpleStatement.java:736)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:850)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
         *     at org.benf.cfr.reader.Main.main(Main.java:54)
         */
        throw new IllegalStateException("Decompilation failed");
    }

    @Override
    protected void initSpecificObjects(List dbObjects) {
        this.clearAll();
        for (DBObject dbo : dbObjects) {
            String type = dbo.getType();
            if (type.equalsIgnoreCase("TABLE")) {
                this.lsTables.add(dbo);
                continue;
            }
            if (type.equalsIgnoreCase("VIEW")) {
                this.lsViews.add(dbo);
                continue;
            }
            if (type.equalsIgnoreCase("TABLESPACE")) {
                this.lsTableSpaces.add(dbo);
                continue;
            }
            if (type.equalsIgnoreCase("TEMP TABLESPACE")) {
                this.lsTempTableSpaces.add(dbo);
                continue;
            }
            if (type.equalsIgnoreCase("UNDO TABLESPACE")) {
                this.lsUndoTableSpaces.add(dbo);
                continue;
            }
            if (type.equalsIgnoreCase("USER")) {
                this.lsUsers.add(dbo);
                continue;
            }
            if (type.equalsIgnoreCase("ROLE")) {
                this.lsRoles.add(dbo);
                continue;
            }
            if (type.equalsIgnoreCase("CONTEXT")) {
                this.lsContexts.add(dbo);
                continue;
            }
            if (type.equalsIgnoreCase("DIRECTORY")) {
                this.lsDirectories.add(dbo);
                continue;
            }
            if (type.equalsIgnoreCase("EXTERNAL TABLE")) {
                this.lsExternalTables.add(dbo);
                continue;
            }
            if (type.equalsIgnoreCase("MVIEW_LOG")) {
                this.lsMViewLogs.add(dbo);
                continue;
            }
            if (type.equalsIgnoreCase("CLUSTER")) {
                this.lsClusters.add(dbo);
                continue;
            }
            if (type.equalsIgnoreCase("SEQUENCE")) {
                this.lsSequence.add(dbo);
                continue;
            }
            if (type.equalsIgnoreCase("SYNONYM")) {
                this.lsSynonyms.add(dbo);
                continue;
            }
            if (type.equalsIgnoreCase("DIMENSION")) {
                this.lsDimensions.add(dbo);
                continue;
            }
            if (type.equalsIgnoreCase("PACKAGE")) {
                this.lsPackages.add(dbo);
                continue;
            }
            if (type.equalsIgnoreCase("PROCEDURE")) {
                this.lsProcedures.add(dbo);
                continue;
            }
            if (type.equalsIgnoreCase("FUNCTION")) {
                this.lsFunctions.add(dbo);
                continue;
            }
            if (!type.equalsIgnoreCase("OBJECT") && !type.equalsIgnoreCase("COLLECTION")) continue;
            this.lsTypes.add(dbo);
        }
        Collections.sort(this.lsTypes, new TypeComparator());
        this.setTypeWarning();
    }

    @Override
    public List getSelectedObjects() {
        ArrayList<DBObject> list = new ArrayList<DBObject>();
        for (DBObject dbo : this.lsTables) {
            if (!dbo.isSelected()) continue;
            list.add(dbo);
        }
        for (DBObject dbo : this.lsViews) {
            if (!dbo.isSelected()) continue;
            list.add(dbo);
        }
        for (DBObject dbo : this.lsTableSpaces) {
            if (!dbo.isSelected()) continue;
            list.add(dbo);
        }
        for (DBObject dbo : this.lsTempTableSpaces) {
            if (!dbo.isSelected()) continue;
            list.add(dbo);
        }
        if (this.tbUndoTableSpaces != null) {
            for (DBObject dbo : this.lsUndoTableSpaces) {
                if (!dbo.isSelected()) continue;
                list.add(dbo);
            }
        }
        for (DBObject dbo : this.lsRoles) {
            if (!dbo.isSelected()) continue;
            list.add(dbo);
        }
        for (DBObject dbo : this.lsUsers) {
            if (!dbo.isSelected()) continue;
            list.add(dbo);
        }
        for (DBObject dbo : this.lsDirectories) {
            if (!dbo.isSelected()) continue;
            list.add(dbo);
        }
        for (DBObject dbo : this.lsExternalTables) {
            if (!dbo.isSelected()) continue;
            list.add(dbo);
        }
        for (DBObject dbo : this.lsMViewLogs) {
            if (!dbo.isSelected()) continue;
            list.add(dbo);
        }
        for (DBObject dbo : this.lsContexts) {
            if (!dbo.isSelected()) continue;
            list.add(dbo);
        }
        for (DBObject dbo : this.lsClusters) {
            if (!dbo.isSelected()) continue;
            list.add(dbo);
        }
        for (DBObject dbo : this.lsSequence) {
            if (!dbo.isSelected()) continue;
            list.add(dbo);
        }
        for (DBObject dbo : this.lsSynonyms) {
            if (!dbo.isSelected()) continue;
            list.add(dbo);
        }
        for (DBObject dbo : this.lsDimensions) {
            if (!dbo.isSelected()) continue;
            list.add(dbo);
        }
        for (DBObject dbo : this.lsPackages) {
            if (!dbo.isSelected()) continue;
            list.add(dbo);
        }
        for (DBObject dbo : this.lsProcedures) {
            if (!dbo.isSelected()) continue;
            list.add(dbo);
        }
        for (DBObject dbo : this.lsFunctions) {
            if (!dbo.isSelected()) continue;
            list.add(dbo);
        }
        for (DBObject dbo : this.lsTypes) {
            if (!dbo.isSelected()) continue;
            list.add(dbo);
        }
        return list;
    }

    @Override
    public void setSelected(DBObject dbObj, boolean selected) {
        if (dbObj != null) {
            dbObj.setSelected(selected);
            if (!dbObj.isRequiredSet()) {
                // empty if block
            }
        }
    }

    @Override
    protected int getFilterColumn(JTable table) {
        int col = super.getFilterColumn(table);
        if (col < 0) {
            TableModel model = table.getModel();
            if (model instanceof SimpleModel) {
                return ((SimpleModel)model).getFilterColumn();
            }
            if (model instanceof TypeModel) {
                return ((TypeModel)model).getFilterColumn();
            }
        }
        return col;
    }

    private void setTypeWarning() {
        if (!this.lsTypes.isEmpty()) {
            DBObject dbo = (DBObject)this.lsTypes.get(0);
            if (dbo.getStatus().equals(DBObject.NAME_EXIST)) {
                this.warning.setVisible(true);
            } else {
                this.warning.setVisible(false);
            }
        }
    }

    @Override
    public void applySelectionForExisting(StorageDesign sd, List dbObjects) {
        if (!(sd instanceof StorageDesignOracle)) {
            return;
        }
        StorageDesignOracle sdo = (StorageDesignOracle)sd;
        for (DBObject dbo : dbObjects) {
            boolean hasSchema;
            String type = dbo.getType();
            ModelObject obj = null;
            String schema = dbo.getSchema();
            String name = dbo.getName();
            boolean bl = hasSchema = schema != null && !"".equals(schema);
            if (hasSchema) {
                if (type.equalsIgnoreCase("TABLE")) {
                    obj = sdo.getTableProxySet().getByUserSchemaAndName(schema, name);
                } else if (type.equalsIgnoreCase("VIEW")) {
                    obj = sdo.getTableViewProxySet().getBySchemaAndName(schema, name);
                } else if (type.equalsIgnoreCase("OBJECT")) {
                    obj = sdo.getStructuredTypeProxySet().getBySchemaAndName(schema, name);
                } else if (type.equalsIgnoreCase("COLLECTION")) {
                    obj = sdo.getCollectionTypeProxySet().getByOwnerAndName(schema, name);
                } else if (type.equalsIgnoreCase("EXTERNAL TABLE")) {
                    obj = sdo.getExternalTableSet().getByOwnerAndName(schema, name);
                } else if (type.equalsIgnoreCase("MVIEW_LOG")) {
                    obj = sdo.getMaterializedViewLogSet().getBySchemaAndName(schema, name);
                } else if (type.equalsIgnoreCase("CLUSTER")) {
                    obj = sdo.getClusterSet().getByOwnerAndName(schema, name);
                } else if (type.equalsIgnoreCase("SEQUENCE")) {
                    obj = sdo.getSequenceSet().getByUserSchemaAndName(schema, name);
                } else if (type.equalsIgnoreCase("SYNONYM")) {
                    obj = sdo.getSynonymSet().getByUserAndName(schema, name);
                } else if (type.equalsIgnoreCase("DIMENSION")) {
                    obj = sdo.getDimensionSet().getByOwnerAndName(schema, name);
                } else if (type.equalsIgnoreCase("PACKAGE")) {
                    obj = sdo.getPackageSet().getByOwnerAndName(schema, name);
                } else if (type.equalsIgnoreCase("PROCEDURE")) {
                    obj = sdo.getStoredProcedureSet().getByOwnerAndName(schema, name);
                } else if (type.equalsIgnoreCase("FUNCTION")) {
                    obj = sdo.getFunctionSet().getByOwnerAndName(schema, name);
                }
            } else if (type.equalsIgnoreCase("TABLE")) {
                obj = ((TableProxySetOracle)sdo.getTableProxySet()).getByName(name);
            } else if (type.equalsIgnoreCase("VIEW")) {
                obj = ((TableViewProxySetOracle)sdo.getTableViewProxySet()).getByName(name);
            } else if (type.equalsIgnoreCase("OBJECT")) {
                obj = sdo.getStructuredTypeProxySet().getByName(name);
            } else if (type.equalsIgnoreCase("COLLECTION")) {
                obj = sdo.getCollectionTypeProxySet().getByName(name);
            } else if (type.equalsIgnoreCase("USER")) {
                obj = sdo.getUserSet().getByName(name);
            } else if (type.equalsIgnoreCase("ROLE")) {
                obj = sdo.getRoleSet().getByName(name);
            } else if (type.equalsIgnoreCase("DIRECTORY")) {
                obj = sdo.getDirectorySet().getByName(name);
            } else if (type.equalsIgnoreCase("EXTERNAL TABLE")) {
                obj = sdo.getExternalTableSet().getByName(name);
            } else if (type.equalsIgnoreCase("MVIEW_LOG")) {
                obj = sdo.getMaterializedViewLogSet().getByName(name);
            } else if (type.equalsIgnoreCase("CONTEXT")) {
                obj = sdo.getContextSet().getByName(name);
            } else if (type.equalsIgnoreCase("CLUSTER")) {
                obj = sdo.getClusterSet().getByName(name);
            } else if (type.equalsIgnoreCase("SEQUENCE")) {
                obj = sdo.getSequenceSet().getByName(name);
            } else if (type.equalsIgnoreCase("SYNONYM")) {
                obj = sdo.getSynonymSet().getByName(name);
            } else if (type.equalsIgnoreCase("TABLESPACE")) {
                obj = sdo.getTableSpaceSet().getByName(name);
            } else if (type.equalsIgnoreCase("TEMP TABLESPACE")) {
                obj = sdo.getTemporaryTablespaceSet().getByName(name);
            } else if (type.equalsIgnoreCase("DIMENSION")) {
                obj = sdo.getDimensionSet().getByName(name);
            } else if (type.equalsIgnoreCase("PACKAGE")) {
                obj = sdo.getPackageSet().getByName(name);
            } else if (type.equalsIgnoreCase("PROCEDURE")) {
                obj = sdo.getStoredProcedureSet().getByName(name);
            } else if (type.equalsIgnoreCase("FUNCTION")) {
                obj = sdo.getFunctionSet().getByName(name);
            } else if (type.equalsIgnoreCase("UNDO TABLESPACE")) {
                obj = sdo.getUndoTablespaceSet().getByName(name);
            }
            if (obj == null) continue;
            dbo.setSelected(true);
        }
    }

    class TypeCellRender
    extends DefaultTableCellRenderer {
        TypeCellRender() {
        }

        @Override
        public Component getTableCellRendererComponent(JTable table, Object value, boolean isSelected, boolean hasFocus, int row, int column) {
            Component comp = super.getTableCellRendererComponent(table, value, isSelected, hasFocus, row, column);
            DBObject dbo = (DBObject)DBMExtractionWizardOracle.this.lsTypes.get(row);
            if (dbo.getStatus().equals(DBObject.NAME_EXIST)) {
                comp.setForeground(Color.RED);
            } else {
                comp.setForeground(Color.BLACK);
            }
            return comp;
        }
    }

    class TypeComparator
    implements Comparator {
        TypeComparator() {
        }

        public int compare(Object o1, Object o2) {
            if (o1 instanceof DBObject && o2 instanceof DBObject) {
                DBObject dbo1 = (DBObject)o1;
                DBObject dbo2 = (DBObject)o2;
                if (dbo1.getStatus().equals(DBObject.NAME_EXIST)) {
                    return -1;
                }
                if (dbo2.getStatus().equals(DBObject.NAME_EXIST)) {
                    return 1;
                }
                return 0;
            }
            return o1.toString().compareTo(o2.toString());
        }
    }

    class TypeModel
    extends AbstractTableModel {
        List list;

        public TypeModel(List list) {
            this.list = list;
        }

        @Override
        public int getColumnCount() {
            return 4;
        }

        @Override
        public int getRowCount() {
            return this.list.size();
        }

        @Override
        public String getColumnName(int column) {
            if (column == 0) {
                return Messages.getString("DBMExtractionWizardOracle.Selected");
            }
            if (column == 1) {
                return Messages.getString("DBMExtractionWizardOracle.Schema");
            }
            if (column == 2) {
                return Messages.getString("DBMExtractionWizardOracle.ObjectName");
            }
            if (column == 3) {
                return Messages.getString("DBMExtractionWizardOracle.Status");
            }
            return "";
        }

        public int getFilterColumn() {
            return 2;
        }

        @Override
        public boolean isCellEditable(int rowIndex, int columnIndex) {
            return columnIndex == 0;
        }

        public Class getColumnClass(int c) {
            if (c == 0) {
                return Boolean.class;
            }
            return String.class;
        }

        @Override
        public Object getValueAt(int row, int col) {
            DBObject dbo = (DBObject)this.list.get(row);
            switch (col) {
                case 0: {
                    return dbo.isSelected();
                }
                case 1: {
                    return dbo.getSchema();
                }
                case 2: {
                    return dbo.getName();
                }
                case 3: {
                    return dbo.getStatus();
                }
            }
            return new Integer(row * col);
        }

        @Override
        public void setValueAt(Object aValue, int rowIndex, int columnIndex) {
            if (columnIndex == 0) {
                DBObject dbo = (DBObject)this.list.get(rowIndex);
                DBMExtractionWizardOracle.this.setSelected(dbo, (Boolean)aValue);
            }
        }
    }

    class SimpleModel
    extends AbstractTableModel {
        List list;

        public SimpleModel(List list) {
            this.list = list;
        }

        @Override
        public int getColumnCount() {
            return 2;
        }

        @Override
        public int getRowCount() {
            return this.list.size();
        }

        @Override
        public String getColumnName(int column) {
            if (column == 0) {
                return Messages.getString("DBMExtractionWizardOracle.Selected");
            }
            if (column == 1) {
                return Messages.getString("DBMExtractionWizardOracle.Name");
            }
            return "";
        }

        public int getFilterColumn() {
            return 1;
        }

        @Override
        public boolean isCellEditable(int rowIndex, int columnIndex) {
            return columnIndex == 0;
        }

        public Class getColumnClass(int c) {
            if (c == 0) {
                return Boolean.class;
            }
            return String.class;
        }

        @Override
        public Object getValueAt(int row, int col) {
            if (row < this.list.size()) {
                DBObject dbo = (DBObject)this.list.get(row);
                switch (col) {
                    case 0: {
                        return dbo.isSelected();
                    }
                    case 1: {
                        return dbo.getName();
                    }
                }
                return null;
            }
            return null;
        }

        @Override
        public void setValueAt(Object aValue, int rowIndex, int columnIndex) {
            if (columnIndex == 0) {
                DBObject dbo = (DBObject)this.list.get(rowIndex);
                DBMExtractionWizardOracle.this.setSelected(dbo, (Boolean)aValue);
            }
        }
    }
}

