/*
 * Decompiled with CFR 0.152.
 */
package oracle.jdeveloper.audit.extension;

import java.lang.reflect.Array;
import java.util.logging.Level;
import javax.ide.util.MetaClass;
import oracle.jdeveloper.audit.extension.Definition;
import oracle.jdeveloper.audit.extension.DefinitionContext;

public class TypeDefinition<T>
extends Definition {
    private final ClassLoader loader;
    private String typeName;
    private Class<? extends T> type;
    private boolean loaded;

    public TypeDefinition(ClassLoader loader, DefinitionContext context) {
        super(context);
        this.loader = loader;
    }

    public TypeDefinition(Class<? extends T> type, DefinitionContext context) {
        super(context);
        this.loader = type.getClassLoader();
        this.typeName = type.getName();
        this.loaded = true;
        this.type = type;
    }

    public String getTypeName() {
        return this.typeName;
    }

    public void setTypeName(String name) {
        this.typeName = name;
    }

    public ClassLoader getLoader() {
        return this.loader;
    }

    public boolean isLoaded() {
        return this.loaded;
    }

    public Class<? extends T> getType() {
        return this.getType(false);
    }

    public Class<? extends T> getType(boolean force) {
        return this.getType(force, true);
    }

    Class<? extends T> getType(boolean force, boolean shortCircuit) {
        if (this.loaded) {
            return this.type;
        }
        if (this.typeName == null) {
            return null;
        }
        boolean extensionLoaded = this.isExtensionLoaded();
        if (!force && !extensionLoaded) {
            return null;
        }
        this.loaded = true;
        try {
            if (shortCircuit && !extensionLoaded) {
                try {
                    ClassLoader auditLoader = TypeDefinition.class.getClassLoader();
                    if (this.typeName.endsWith("[]")) {
                        Class componentType = new MetaClass(auditLoader, this.typeName.substring(0, this.typeName.length() - 2).trim()).toClass();
                        this.type = Array.newInstance(componentType, 1).getClass();
                    } else {
                        this.type = new MetaClass(auditLoader, this.typeName).toClass();
                    }
                    return this.type;
                }
                catch (ClassNotFoundException auditLoader) {
                    // empty catch block
                }
            }
            if (this.typeName.endsWith("[]")) {
                Class componentType = new MetaClass(this.loader, this.typeName.substring(0, this.typeName.length() - 2).trim()).toClass();
                this.type = Array.newInstance(componentType, 1).getClass();
            } else {
                this.type = new MetaClass(this.loader, this.typeName).toClass();
            }
        }
        catch (ClassNotFoundException e) {
            this.log(Level.SEVERE, e, "Class \"{0}\" not found: {1}", this.typeName, e);
        }
        return this.type;
    }

    public T getInstance() {
        return this.getInstance(false);
    }

    public T getInstance(boolean force) {
        return this.getInstance(force, true);
    }

    T getInstance(boolean force, boolean shortCircuit) {
        Class<T> type = this.getType(force, shortCircuit);
        if (type != null) {
            try {
                return type.getConstructor(new Class[0]).newInstance(new Object[0]);
            }
            catch (Throwable e) {
                this.log(Level.SEVERE, e, "Instance \"{0}\" not created: {1}", this.typeName, e);
            }
        }
        return null;
    }

    public boolean equals(Object that) {
        return this.getClass() == that.getClass() && this.typeName.equals(((TypeDefinition)that).typeName);
    }

    public int hashCode() {
        return this.typeName.hashCode();
    }

    @Override
    public String toString() {
        return this.typeName;
    }
}

