/*
 * Decompiled with CFR 0.152.
 */
package oracle.jdeveloper.audit.model;

import java.net.URL;
import oracle.ide.model.Node;
import oracle.jdeveloper.audit.model.ContainerModelAdapter;
import oracle.jdeveloper.audit.model.Dependency;
import oracle.jdeveloper.audit.model.FileDependency;
import oracle.jdeveloper.audit.model.ModelAdapter;
import oracle.jdeveloper.audit.model.ModelFactory;
import oracle.jdeveloper.audit.model.ModelType;

public abstract class FileModelAdapter
extends ModelAdapter {
    protected FileModelAdapter(ModelFactory factory, ModelType model, ContainerModelAdapter workspace, ContainerModelAdapter project, ContainerModelAdapter directory, Node node, URL url) {
        super(factory, model, workspace, project, directory, node, url);
    }

    protected FileModelAdapter(ModelFactory factory, ModelType model, ContainerModelAdapter workspace, ContainerModelAdapter project, ContainerModelAdapter directory, Node node, URL url, String primaryCollationKey) {
        super(factory, model, workspace, project, directory, node, url, primaryCollationKey);
    }

    @Override
    public URL getUrl() {
        return this.getNode().getURL();
    }

    public String getRelativePath() {
        return this.getDirectory().getRelativePath() + "/" + this.getSimpleName();
    }

    @Override
    public ContainerModelAdapter getContainingAdapter() {
        ContainerModelAdapter containingDirectory = this.getDirectoryAdapter();
        return containingDirectory != null ? containingDirectory : this.getProjectAdapter();
    }

    @Override
    public Dependency getDependency() {
        return new FileDependency(this.getUrl(), this.getProject(), this.getWorkspace());
    }

    @Override
    public boolean isFile() {
        return true;
    }

    @Override
    public FileModelAdapter getFileAdapter() {
        return this;
    }

    @Override
    public boolean contains(ModelAdapter that) {
        assert (this.getFactory() == that.getFactory()) : "generation mismatch: " + this + " - " + that;
        return this == that;
    }

    @Override
    public int compareTo(ModelAdapter that) {
        if (that == null) {
            return 1;
        }
        if (this == that) {
            return 0;
        }
        assert (this.getFactory() == that.getFactory()) : "generation mismatch: " + this + " - " + that;
        int comparison = FileModelAdapter.compareSiblings(this.getWorkspaceAdapter(), that.getWorkspaceAdapter());
        if (comparison != 0) {
            return comparison;
        }
        comparison = FileModelAdapter.compareSiblings(this.getProjectAdapter(), that.getProjectAdapter());
        if (comparison != 0) {
            return comparison;
        }
        comparison = this.getDirectoryAdapter().compareTo(that.getDirectoryAdapter());
        if (comparison != 0) {
            return comparison;
        }
        return FileModelAdapter.compareSiblings(this, that.getFileAdapter());
    }
}

