/*
 * Decompiled with CFR 0.152.
 */
package oracle.jdeveloper.audit.service;

import java.net.URL;
import java.util.logging.Level;
import java.util.logging.LogRecord;
import java.util.logging.Logger;
import oracle.ide.net.URLFileSystem;
import oracle.jdeveloper.audit.model.Location;
import oracle.jdeveloper.audit.model.ModelAdapter;
import oracle.jdevimpl.audit.util.Strings;

public class AuditLogger {
    public static final String NAME = new String("oracle.ide.audit");
    private static final Logger LOGGER = Logger.getLogger(NAME);

    public static Logger getLogger() {
        return LOGGER;
    }

    public static void error(String message, Object ... arguments) {
        int length;
        LogRecord record = new LogRecord(Level.SEVERE, message);
        if (arguments != null && (length = arguments.length) > 0) {
            record.setParameters(arguments);
            Object lastArgument = arguments[length - 1];
            if (lastArgument instanceof Throwable) {
                record.setThrown((Throwable)lastArgument);
            }
        }
        LOGGER.log(record);
    }

    public static void error(Throwable thrown, String message, Object ... arguments) {
        AuditLogger.log(Level.SEVERE, thrown, message, arguments);
    }

    public static void warning(String message, Object ... arguments) {
        LOGGER.log(Level.WARNING, message, arguments);
    }

    public static void informational(String message, Object ... arguments) {
        LOGGER.log(Level.INFO, message, arguments);
    }

    public static void log(Level level, String message, Object ... arguments) {
        LOGGER.log(level, message, arguments);
    }

    public static void log(Level level, Throwable thrown, String message, Object ... arguments) {
        LogRecord record = new LogRecord(level, message);
        if (thrown != null) {
            record.setThrown(thrown);
        }
        if (arguments != null && arguments.length > 0) {
            record.setParameters(arguments);
        }
        LOGGER.log(record);
    }

    public static void log(Throwable thrown, String what, Object who, String context, ModelAdapter model, Location location, Object ... detail) {
        String workspace = "<workspace unavailable>";
        String project = "<project unavailable>";
        String file = "<file unavailable>";
        String source = "<source unavailable>";
        if (model == null && location != null) {
            model = location.getModel();
        }
        if (model != null) {
            workspace = model.getWorkspace() != null ? model.getWorkspace().getLongLabel() : "<workspace null>";
            project = model.getProject() != null ? model.getProject().getLongLabel() : "<project null>";
            URL url = model.getUrl();
            String string = file = url != null ? URLFileSystem.getPlatformPathName((URL)url) : "<file null>";
            if (url != null && location != null && !(thrown instanceof VirtualMachineError)) {
                int length;
                file = file + ":" + (model.getLineOffset(location.getOffset()) + 1);
                int offset = location.getOffset();
                for (length = Math.min(location.getLength(), 4000); length > 0 && Character.isWhitespace(model.getCharacter(offset + length - 1)); --length) {
                }
                String text = model.getText(offset, length);
                if (text != null) {
                    source = text;
                }
            }
        }
        Object[] arguments = new Object[5 + (detail != null ? detail.length : 0)];
        arguments[0] = workspace;
        arguments[1] = project;
        arguments[2] = file;
        arguments[3] = "----------------";
        arguments[4] = source;
        for (int i = 5; i < arguments.length; ++i) {
            arguments[i] = detail[i - 5];
        }
        AuditLogger.log(thrown, what, who, context, arguments);
    }

    public static void log(Throwable thrown, String what, Object who, String context, Object ... detail) {
        StringBuilder message = new StringBuilder();
        Object[] arguments = new Object[4 + (detail != null ? detail.length : 0)];
        message.append("{0}");
        arguments[0] = Strings.capitalize(what);
        if (who != null) {
            message.append(" {1} threw");
            arguments[1] = who.getClass().getName();
        } else {
            message.append(" handled");
        }
        message.append(" {2}:");
        arguments[2] = thrown.getClass().getName();
        message.append("\n#### {3} EXCEPTION CONTEXT BEGIN (stack trace follows)");
        arguments[3] = context.toUpperCase();
        for (int i = 4; i < arguments.length; ++i) {
            message.append("\n{").append(i).append('}');
            arguments[i] = detail[i - 4];
        }
        message.append("\n#### {3} EXCEPTION CONTEXT END (stack trace follows)");
        AuditLogger.error(thrown, message.toString(), arguments);
    }
}

