/*
 * Decompiled with CFR 0.152.
 */
package oracle.jdevimpl.audit.core;

import java.net.URL;
import java.util.List;
import java.util.concurrent.BlockingQueue;
import javax.swing.Action;
import oracle.ide.model.Project;
import oracle.ide.model.Workspace;
import oracle.javatools.status.Severity;
import oracle.javatools.util.NullArgumentException;
import oracle.jdeveloper.audit.AuditManager;
import oracle.jdeveloper.audit.analyzer.Analyzer;
import oracle.jdeveloper.audit.analyzer.AuditTaskContext;
import oracle.jdeveloper.audit.analyzer.IssueReport;
import oracle.jdeveloper.audit.analyzer.Rule;
import oracle.jdeveloper.audit.model.Location;
import oracle.jdeveloper.audit.model.ModelAccessError;
import oracle.jdeveloper.audit.model.ModelAdapter;
import oracle.jdeveloper.audit.model.ModelFactory;
import oracle.jdeveloper.audit.service.Suppression;
import oracle.jdeveloper.audit.service.Transformer;
import oracle.jdeveloper.audit.service.Violation;
import oracle.jdeveloper.audit.transform.Transform;
import oracle.jdevimpl.audit.core.DefaultAuditor;

public class DefaultAuditTaskContext
implements AuditTaskContext {
    private DefaultAuditor auditor;
    private Analyzer analyzer;
    private ModelFactory factory;
    private BlockingQueue<Violation> queue;
    private TaskViolation pendingViolation;

    public DefaultAuditTaskContext(DefaultAuditor auditor, Analyzer analyzer, ModelFactory factory, BlockingQueue<Violation> queue) {
        this.auditor = auditor;
        this.analyzer = analyzer;
        this.factory = factory;
        this.queue = queue;
    }

    @Override
    public boolean isCancelled() {
        return this.auditor.isCancelled();
    }

    @Override
    public <T extends ModelAdapter> ModelAdapter getModel(Class<T> type, URL url, Project project, Workspace workspace) {
        return this.factory.getModelAdapter(type, url, project, workspace);
    }

    @Override
    public <T extends ModelAdapter> ModelAdapter getModelAdapter(Class<T> type, URL url, Project project, Workspace workspace) {
        return this.factory.getModelAdapter(type, url, project, workspace);
    }

    @Override
    public IssueReport report(Rule rule, Location location) {
        return this.report(rule, location, null);
    }

    @Override
    public IssueReport report(Rule rule, ModelAdapter model, Object construct) {
        return this.report(rule, model.getLocation(construct), construct);
    }

    private IssueReport report(Rule rule, Location location, Object construct) {
        if (rule == null) {
            throw new NullArgumentException("null rule");
        }
        if (this.pendingViolation != null) {
            this.queue.add(this.pendingViolation);
        }
        this.pendingViolation = new TaskViolation(this.analyzer, rule, location, construct);
        return this.pendingViolation;
    }

    @Override
    public void taskCompleted() {
        if (this.pendingViolation != null) {
            this.queue.add(this.pendingViolation);
        }
        this.queue.add(null);
    }

    private static class TaskViolation
    implements Violation,
    IssueReport {
        private Rule rule;
        private String variation;
        private Location location;
        private Object construct;
        private Location focusLocation;
        private int parameterCount;
        private String[] parameterNames = new String[256];
        private Object[] parameterValues = new Object[256];
        private int transformMask;
        private Transform defaultTransform;

        public TaskViolation(Analyzer analyzer, Rule rule, Location location, Object construct) {
            if (rule == null) {
                throw new NullArgumentException("null rule");
            }
            this.rule = rule;
            this.variation = null;
            this.location = location;
            this.construct = construct;
            this.focusLocation = null;
            this.parameterCount = 0;
            int transformCount = rule.getTransforms().length;
            this.transformMask = (1 << transformCount) - 1;
            this.defaultTransform = rule.getDefaultTransform();
        }

        @Override
        public void addParameter(String name, Object value) {
            this.parameterNames[this.parameterCount] = name;
            this.parameterValues[this.parameterCount++] = value;
        }

        @Override
        public void addConstructParameter(String name, Object construct) {
            this.addParameter(name, this.location.getModel().getLocation(construct));
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void addConstructParameter(String name, ModelAdapter model, Object construct) {
            try {
                model.beginRead();
            }
            catch (InterruptedException e) {
                Thread.currentThread().interrupt();
                return;
            }
            try {
                this.addParameter(name, model.getLocation(construct));
            }
            finally {
                model.endRead();
            }
        }

        @Override
        public void setFocusLocation(Object construct) {
            if (construct == null) {
                return;
            }
            Location location = this.location.getModel().getLocation(construct);
            if (location != null) {
                this.focusLocation = location;
            }
        }

        @Override
        public void setFocusLocation(Location location) {
            this.focusLocation = location;
        }

        @Override
        public void setVariation(String name) {
            if (name != null) {
                for (String variation : this.rule.variations()) {
                    if (!variation.equals(name)) continue;
                    this.variation = variation;
                    return;
                }
                throw new IllegalArgumentException("No variation \"" + name + "\" defined for rule " + this.rule.id());
            }
            this.variation = null;
        }

        @Override
        public void hideAllTransforms() {
            this.transformMask = 0;
            this.defaultTransform = null;
        }

        @Override
        public void showTransform(Transform transform) {
            Transform[] transforms = this.rule.getTransforms();
            for (int i = 0; i < transforms.length; ++i) {
                if (transform != transforms[i]) continue;
                this.transformMask |= 1 << i;
                return;
            }
        }

        @Override
        public void hideTransform(Transform transform) {
            Transform[] transforms = this.rule.getTransforms();
            for (int i = 0; i < transforms.length; ++i) {
                if (transform != transforms[i]) continue;
                this.transformMask &= ~(1 << i);
                return;
            }
        }

        @Override
        public void setDefaultTransform(Transform fix) {
            this.defaultTransform = fix;
        }

        public String getMessage() {
            return this.rule.message(this);
        }

        public String getHtmlMessage() {
            return this.rule.htmlMessage(this);
        }

        public Severity getSeverity() {
            return this.rule.getSeverity().getIssueSeverity();
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public Object getConstruct() {
            ModelAdapter model = this.location.getModel();
            boolean locked = false;
            try {
                model.beginRead();
                locked = true;
                Object object = model.getConstruct(this.location);
                return object;
            }
            catch (ModelAccessError e) {
                Object var4_6 = null;
                return var4_6;
            }
            catch (InterruptedException e) {
                Thread.currentThread().interrupt();
                Object var4_7 = null;
                return var4_7;
            }
            finally {
                if (locked) {
                    model.endRead();
                }
            }
        }

        public int getOffset() {
            return this.getFocusLocation().getOffset();
        }

        public int getLength() {
            return this.getFocusLocation().getLength();
        }

        public boolean hasTransforms() {
            return this.getTransformCount() > 0;
        }

        public List<? extends Action> getTransforms() {
            Transformer transformer = AuditManager.getAuditManager().createTransformer();
            return transformer.createTransformActions(this, null, null);
        }

        @Override
        public void cancel() {
            throw new UnsupportedOperationException("cancel unsupported for task violation reports");
        }

        @Override
        public Location getLocation() {
            return this.location;
        }

        @Override
        public int getParameterCount() {
            return this.parameterCount;
        }

        @Override
        public String getParameterName(int index) {
            return this.parameterNames[index];
        }

        @Override
        public Object getParameterValue(int index) {
            return this.parameterValues[index];
        }

        @Override
        public Object getParameterValue(String name) {
            int i = this.getParameterCount();
            while (i-- > 0) {
                if (!name.equals(this.getParameterName(i))) continue;
                return this.getParameterValue(i);
            }
            return null;
        }

        @Override
        public Location getFocusLocation() {
            if (this.focusLocation == null && this.construct != null) {
                this.focusLocation = this.location.getModel().getFocusLocation(this.construct, this.location);
            }
            return this.focusLocation;
        }

        @Override
        public Rule getRule() {
            return this.rule;
        }

        @Override
        public String getVariation() {
            return this.variation;
        }

        @Override
        public int getTransformCount() {
            int count = 0;
            for (int i = 0; i < 15; ++i) {
                if ((this.transformMask & 1 << i) == 0) continue;
                ++count;
            }
            return count;
        }

        @Override
        public Transform getTransform(int index) {
            for (int i = 0; i < 15; ++i) {
                if ((this.transformMask & 1 << i) == 0 || index-- != 0) continue;
                return this.rule.getTransforms()[i];
            }
            throw new IndexOutOfBoundsException(index + " of " + this.getTransformCount());
        }

        @Override
        public Transform getDefaultTransform() {
            Transform[] transforms = this.rule.getTransforms();
            for (int i = 0; i < transforms.length; ++i) {
                if ((this.transformMask & 1 << i) == 0 || transforms[i] != this.defaultTransform) continue;
                return this.defaultTransform;
            }
            return null;
        }

        @Override
        public int getSuppressionCount() {
            return 0;
        }

        @Override
        public Suppression getSuppression(int index) {
            throw new IndexOutOfBoundsException(index + " of 0");
        }

        @Override
        public int getSerialNumber() {
            return 0;
        }
    }
}

