/*
 * Decompiled with CFR 0.152.
 */
package oracle.jdevimpl.audit.model;

import java.net.URL;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.Set;
import oracle.ide.net.URLFileSystem;
import oracle.ide.util.IntersectedFilters;
import oracle.ide.util.TriStateBoolean;
import oracle.javatools.util.Log;
import oracle.javatools.util.MultiMap;
import oracle.jdeveloper.audit.model.ContentCache;
import oracle.jdeveloper.audit.model.ContentDirectory;
import oracle.jdeveloper.audit.model.ContentRoot;
import oracle.jdevimpl.audit.model.DefaultContentDirectory;
import oracle.jdevimpl.audit.model.DefaultContentRoot;

public class DefaultContentCache
implements ContentCache {
    private List<ContentRoot> roots;
    private static final Log LOG = new Log("model");

    public DefaultContentCache(List<ContentRoot> roots) {
        Collections.sort(roots);
        this.roots = roots;
    }

    @Override
    public Collection<ContentRoot> getRoots() {
        return this.roots;
    }

    @Override
    public Collection<ContentRoot> getRoots(URL url) {
        ContentRoot root;
        ArrayList<ContentRoot> result = new ArrayList<ContentRoot>();
        DefaultContentRoot key = new DefaultContentRoot(url);
        int index = Collections.binarySearch(this.roots, key);
        if (index >= 0) {
            root = this.roots.get(index);
            if (this.acceptsUrl(root, url)) {
                result.add(root);
            }
        } else {
            index = -index - 1;
        }
        while (--index >= 0 && (root = this.roots.get(index)).compareTo(key) <= 0) {
            if (!root.contains(key) || !this.acceptsUrl(root, url)) continue;
            result.add(root);
        }
        LOG.trace("content set roots for {0}: {1}", (Object)url, result);
        return result;
    }

    @Override
    public boolean acceptsUrl(ContentRoot root, URL url) {
        IntersectedFilters filters = root.getFilters();
        String path = URLFileSystem.toRelativeSpec((URL)url, (URL)root.getUrl(), (boolean)true);
        if (path == null) {
            return false;
        }
        if (this.isDirectory(path)) {
            return filters.inferFromFilters(path) != TriStateBoolean.FALSE;
        }
        return filters.isIncluded(path);
    }

    private boolean isDirectory(String path) {
        int length = path.length();
        return length == 0 || path.charAt(length - 1) == '/';
    }

    @Override
    public Collection<ContentDirectory> getRootDirectories(Set<ContentRoot.Type> types) {
        URL rootsUrl;
        ArrayList<ContentDirectory> directories = new ArrayList<ContentDirectory>();
        MultiMap rootsByUrl = new MultiMap();
        for (ContentRoot root : this.getRoots()) {
            if (!types.contains((Object)root.getType())) continue;
            rootsUrl = root.getUrl();
            if (URLFileSystem.exists((URL)rootsUrl)) {
                rootsByUrl.add((Object)rootsUrl, (Object)root);
                continue;
            }
            LOG.trace("skipping nonexistent root {0}", this.roots);
        }
        for (Map.Entry entry : rootsByUrl.entrySet()) {
            rootsUrl = (URL)entry.getKey();
            Collection roots = (Collection)entry.getValue();
            DefaultContentDirectory directory = new DefaultContentDirectory(rootsUrl, "", roots);
            directories.add(directory);
        }
        LOG.trace("root content set directories {0}", directories);
        return directories;
    }

    @Override
    public Collection<ContentDirectory> getDirectories(URL url) {
        ArrayList<ContentDirectory> directories = new ArrayList<ContentDirectory>();
        MultiMap rootsByUrl = new MultiMap();
        for (ContentRoot root : this.getRoots(url)) {
            rootsByUrl.add((Object)root.getUrl(), (Object)root);
        }
        URL directoryUrl = URLFileSystem.isDirectoryPath((URL)url) ? url : URLFileSystem.getParent((URL)url);
        for (Map.Entry entry : rootsByUrl.entrySet()) {
            URL rootsUrl = (URL)entry.getKey();
            Collection roots = (Collection)entry.getValue();
            String path = URLFileSystem.toRelativeSpec((URL)directoryUrl, (URL)rootsUrl, (boolean)true);
            if (path == null) continue;
            DefaultContentDirectory directory = new DefaultContentDirectory(directoryUrl, path, roots);
            directories.add(directory);
        }
        LOG.trace("content set directories for {0}: {1}", (Object)url, directories);
        return directories;
    }

    @Override
    public ContentDirectory getContainingDirectory(ContentDirectory directory) {
        if (directory.getDepth() == 0) {
            return null;
        }
        String path = directory.getRelativePath();
        int slash = path.lastIndexOf(47);
        String parentPath = slash < 0 ? "" : path.substring(0, slash);
        return new DefaultContentDirectory(URLFileSystem.getParent((URL)directory.getURL()), parentPath, directory.getRoots());
    }
}

