/*
 * Decompiled with CFR 0.152.
 */
package oracle.jdevimpl.audit.model;

import java.util.Collection;
import java.util.EnumSet;
import java.util.Iterator;
import javax.swing.Icon;
import oracle.ide.model.Element;
import oracle.ide.model.Node;
import oracle.ide.model.Project;
import oracle.ide.model.WorkingSet;
import oracle.ide.model.Workspace;
import oracle.jdeveloper.audit.model.ContainerModelAdapter;
import oracle.jdeveloper.audit.model.ContentCache;
import oracle.jdeveloper.audit.model.ContentDirectory;
import oracle.jdeveloper.audit.model.ContentRoot;
import oracle.jdeveloper.audit.model.Location;
import oracle.jdeveloper.audit.model.ModelAdapter;
import oracle.jdeveloper.audit.model.ModelFactory;
import oracle.jdeveloper.audit.model.ModelType;

public class WorkspaceModelAdapter
extends ContainerModelAdapter {
    private final Workspace workspace;

    public WorkspaceModelAdapter(ModelFactory factory, ModelType type, Workspace workspace) {
        super(factory, type, workspace, workspace.getURL());
        this.workspace = workspace;
    }

    @Override
    public ContainerModelAdapter getContainingAdapter() {
        return (ContainerModelAdapter)this.getFactory().getModelRoot().getModel();
    }

    @Override
    public Workspace getWorkspace() {
        return this.workspace;
    }

    @Override
    public Project getProject() {
        return null;
    }

    @Override
    public ContentDirectory getDirectory() {
        return null;
    }

    @Override
    protected void collectContainedElements() {
        ModelFactory factory = this.getFactory();
        ContentCache cache = factory.getContentSetCache(null, this.workspace);
        Collection<ContentDirectory> roots = cache.getRootDirectories(EnumSet.of(ContentRoot.WORKSPACE));
        for (ContentDirectory directory : roots) {
            this.addContainedElement(directory, directory.getURL());
        }
        WorkingSet workingSet = factory.getWorkingSet();
        Iterator i = this.workspace.getChildren();
        while (i.hasNext()) {
            Node node = (Node)i.next();
            if (!(node instanceof Project) || workingSet != null && !workingSet.isIncluded((Project)node)) continue;
            this.addContainedElement((Element)node, node.getURL());
        }
    }

    @Override
    public int compareTo(ModelAdapter that) {
        if (this == that) {
            return 0;
        }
        assert (this.getFactory() == that.getFactory()) : "generation mismatch: " + this + " - " + that;
        int comparison = WorkspaceModelAdapter.compareSiblings(this, that.getWorkspaceAdapter());
        if (comparison == 0) {
            comparison = -1;
        }
        return comparison;
    }

    @Override
    public boolean contains(ModelAdapter that) {
        assert (this.getFactory() == that.getFactory()) : "generation mismatch: " + this + " - " + that;
        ContainerModelAdapter thatWorkspace = that.getWorkspaceAdapter();
        return this == thatWorkspace;
    }

    @Override
    public boolean contains(Object construct, Location location) {
        assert (this.getFactory() == location.getModel().getFactory()) : "generation mismatch: " + this + " - " + location;
        assert (this.getWorkspace().equals(construct));
        assert (this == location.getModel());
        return true;
    }

    @Override
    public Node getNode() {
        return this.workspace;
    }

    @Override
    public boolean isModifiable() {
        return !this.workspace.isReadOnly();
    }

    @Override
    public Object getLabel(Object construct) {
        String text = ((Element)construct).getShortLabel();
        WorkingSet workingSet = this.getFactory().getWorkingSet();
        if (workingSet != null) {
            text = text + " (" + workingSet.getName() + ')';
        }
        return text;
    }

    @Override
    public Object getSummary(Object construct) {
        return ((Element)construct).getToolTipText();
    }

    @Override
    public Icon getIcon(Object construct) {
        return ((Element)construct).getIcon();
    }
}

