/*
 * Decompiled with CFR 0.152.
 */
package oracle.jdevimpl.audit.profile;

import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.beans.PropertyChangeSupport;
import java.io.IOException;
import java.net.URL;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import javax.swing.AbstractListModel;
import javax.swing.ComboBoxModel;
import oracle.javatools.util.Log;
import oracle.jdeveloper.audit.extension.AuditHook;
import oracle.jdeveloper.audit.extension.BeanDefinition;
import oracle.jdeveloper.audit.extension.ExtensionBean;
import oracle.jdeveloper.audit.service.Profile;
import oracle.jdeveloper.audit.service.ProfileRepository;
import oracle.jdeveloper.audit.service.ProfileTransaction;
import oracle.jdevimpl.audit.core.DefaultProfile;

public class ProfileModel
extends AbstractListModel<Profile>
implements ComboBoxModel<Profile>,
PropertyChangeListener {
    private List<Profile> profiles;
    private Map<Profile, ProfileTransaction> transactions;
    private ProfileRepository repository;
    private Profile selectedProfile;
    private PropertyChangeSupport support = new PropertyChangeSupport(this);
    private Comparator<Profile> PROFILE_COMPARATOR = new Comparator<Profile>(){

        @Override
        public int compare(Profile p1, Profile p2) {
            return p1.getName().compareToIgnoreCase(p2.getName());
        }
    };
    private Comparator<Object> PROFILE_NAME_COMPARATOR = new Comparator<Object>(){

        @Override
        public int compare(Object o1, Object o2) {
            String s1 = o1 instanceof Profile ? ((Profile)o1).getName() : (String)o1;
            String s2 = o2 instanceof Profile ? ((Profile)o2).getName() : (String)o2;
            return ProfileRepository.normalizeProfileName(s1).compareTo(ProfileRepository.normalizeProfileName(s2));
        }
    };
    private static final Log LOG = new Log("profile");

    public ProfileModel(ProfileRepository repository) {
        this.repository = repository;
        this.profiles = new ArrayList<Profile>(repository.getProfiles());
        Collections.sort(this.profiles, this.PROFILE_COMPARATOR);
        this.transactions = new HashMap<Profile, ProfileTransaction>();
    }

    public void addPropertyChangeListener(PropertyChangeListener listener) {
        this.support.addPropertyChangeListener(listener);
    }

    public void removePropertyChangeListener(PropertyChangeListener listener) {
        this.support.removePropertyChangeListener(listener);
    }

    @Override
    public int getSize() {
        return this.profiles.size();
    }

    @Override
    public Profile getElementAt(int index) {
        return this.profiles.get(index);
    }

    public Profile getProfile(String name) {
        if (name == null) {
            return null;
        }
        int index = this.profileIndex(name);
        return index >= 0 ? this.getElementAt(index) : null;
    }

    public Profile getProfile(String name, String key) {
        Profile profile = this.getProfile(name);
        if (profile != null) {
            return profile;
        }
        if (key != null) {
            for (int i = 0; i < this.profiles.size(); ++i) {
                profile = this.getElementAt(i);
                if (!key.equals(profile.getId())) continue;
                return profile;
            }
        }
        return this.getElementAt(0);
    }

    public void remove() {
        Profile profile = this.getSelectedItem();
        LOG.trace("removing profile {0}", (Object)profile);
        if (profile == null) {
            return;
        }
        assert (profile.getId() == null);
        int index = Collections.binarySearch(this.profiles, profile, this.PROFILE_COMPARATOR);
        if (index < 0) {
            return;
        }
        this.transactions.remove(profile);
        this.profiles.remove(index);
        if (this.selectedProfile.equals(profile)) {
            Profile newItem = null;
            int newIndex = Math.min(index, this.profiles.size() - 1);
            if (newIndex >= 0) {
                newItem = this.profiles.get(newIndex);
            }
            this.setSelectedItem(newItem);
        }
        this.fireIntervalRemoved(this, index, index);
    }

    @Override
    public void setSelectedItem(Object item) {
        LOG.trace("setting selection in combobox to {0}", item);
        if (item == this.selectedProfile) {
            return;
        }
        Profile profile = (Profile)item;
        if (profile != null) {
            int index = Collections.binarySearch(this.profiles, profile, this.PROFILE_COMPARATOR);
            if (index < 0) {
                index = -index - 1;
                this.profiles.add(index, profile);
                this.fireIntervalAdded(this, index, index);
            } else if (profile != this.profiles.get(index)) {
                this.profiles.set(index, profile);
                this.fireContentsChanged(index);
            }
        }
        this.selectedProfile = profile;
        this.fireSelectionChanged();
    }

    @Override
    public Profile getSelectedItem() {
        return this.selectedProfile;
    }

    public boolean contains(String name) {
        return this.profileIndex(name) >= 0;
    }

    public Collection<BeanDefinition<?>> getDefinitions() {
        return AuditHook.getAuditHook().getBeansById().values();
    }

    public boolean isSealed() {
        return this.getTransaction().isSealed();
    }

    public void setSealed(boolean sealed) {
        this.getTransaction().setSealed(sealed);
    }

    public boolean isEnabled(String id) {
        return this.getTransaction().isEnabled(id);
    }

    public void setEnabled(String id, boolean enabled) {
        this.getTransaction().setEnabled(id, enabled);
    }

    public ExtensionBean getBean(String id) {
        return this.getTransaction().getBean(id, true);
    }

    public boolean isModified(String id) {
        return this.getTransaction().isModified(id);
    }

    private int profileIndex(String name) {
        return Collections.binarySearch(this.profiles, name, this.PROFILE_NAME_COMPARATOR);
    }

    public boolean nameMatches(String name1, String name2) {
        return ProfileRepository.normalizeProfileName(name1).equals(ProfileRepository.normalizeProfileName(name2));
    }

    private ProfileTransaction getTransaction() {
        if (this.selectedProfile == null) {
            throw new IllegalStateException("selected profile null");
        }
        return this.getTransaction(this.selectedProfile);
    }

    private ProfileTransaction getTransaction(Profile profile) {
        ProfileTransaction transaction = this.transactions.get(profile);
        if (transaction == null) {
            transaction = profile.createTransaction();
            transaction.addPropertyChangeListener(this);
            this.transactions.put(profile, transaction);
        }
        return transaction;
    }

    public void saveAs(String newName, Profile overwrittenProfile) throws IOException {
        Profile savedProfile;
        LOG.trace("saving {0} as {1}, key {2}, over {3}", (Object)this.selectedProfile, (Object)newName, (Object)this.selectedProfile.getId(), (Object)overwrittenProfile);
        ArrayList<Profile> changedProfiles = new ArrayList<Profile>(2);
        ProfileTransaction transaction = this.getTransaction();
        if (transaction.isModified()) {
            changedProfiles.add(this.selectedProfile);
        }
        if (overwrittenProfile == null) {
            savedProfile = transaction.createProfile(newName);
            transaction.revert();
        } else if (this.nameMatches(this.selectedProfile.getName(), overwrittenProfile.getName())) {
            savedProfile = this.selectedProfile;
            transaction.apply();
        } else {
            savedProfile = overwrittenProfile;
            if (this.isModified(overwrittenProfile)) {
                changedProfiles.add(overwrittenProfile);
            }
            ProfileTransaction overwrittenTransaction = this.getTransaction(overwrittenProfile);
            overwrittenTransaction.setProperties(transaction);
            transaction.revert();
            overwrittenTransaction.apply();
        }
        for (Profile profile : changedProfiles) {
            this.fireContentsChanged(profile);
        }
        this.repository.save(savedProfile);
        this.setSelectedItem(savedProfile);
        assert (!this.isModified(savedProfile) && !this.isNew(savedProfile));
        LOG.trace("completed saving {0} as {1}, key {2}, over {3}", (Object)this.selectedProfile, (Object)newName, (Object)this.selectedProfile.getId(), (Object)overwrittenProfile);
    }

    public void importAs(URL url, String newName, Profile overwrittenProfile) throws IOException {
        Profile savedProfile;
        LOG.trace("importing {0} as {1} over {2}", (Object)url, (Object)newName, (Object)overwrittenProfile);
        ArrayList<Profile> changedProfiles = new ArrayList<Profile>(2);
        if (overwrittenProfile == null) {
            savedProfile = new DefaultProfile(newName, url);
        } else {
            savedProfile = overwrittenProfile;
            ProfileTransaction transaction = this.getTransaction(overwrittenProfile);
            if (transaction.isModified()) {
                changedProfiles.add(overwrittenProfile);
            }
            transaction.setProperties(new DefaultProfile(newName, url));
            transaction.apply();
        }
        for (Profile profile : changedProfiles) {
            this.fireContentsChanged(profile);
        }
        this.repository.save(savedProfile);
        this.setSelectedItem(savedProfile);
        assert (!this.isModified(savedProfile) && !this.isNew(savedProfile));
        LOG.trace("completed importing {0} as {1} over {2}", (Object)url, (Object)newName, (Object)overwrittenProfile);
    }

    public void exportAs(URL url, String name) throws IOException {
        LOG.trace("exporting {0} to {1} as {2}", (Object)this, (Object)url, (Object)name);
        this.getTransaction().createProfile(name).save(url);
    }

    public void revert() {
        if (this.selectedProfile == null) {
            throw new IllegalStateException("no selected profile");
        }
        if (!this.isModified(this.selectedProfile)) {
            throw new IllegalStateException("no modified profile");
        }
        ProfileTransaction transaction = this.getTransaction(this.selectedProfile);
        transaction.revert();
        this.fireContentsChanged(this.selectedProfile);
    }

    public void restoreDefaults() {
        if (this.selectedProfile == null) {
            throw new IllegalStateException("no selected profile");
        }
        String key = this.selectedProfile.getId();
        if (key == null) {
            throw new IllegalStateException("no default profile");
        }
        Profile defaultProfile = this.repository.getDefaultProfile(key);
        LOG.trace("resetting {0} to {1}", (Object)this.selectedProfile, (Object)defaultProfile);
        assert (defaultProfile != null);
        ProfileTransaction transaction = this.getTransaction();
        boolean wasModified = transaction.isModified();
        transaction.setProperties(defaultProfile);
        if (wasModified != transaction.isModified()) {
            this.fireContentsChanged(this.selectedProfile);
        }
    }

    public boolean isModified(Profile profile) {
        ProfileTransaction transaction = this.transactions.get(profile);
        return transaction != null && transaction.isModified();
    }

    public boolean isNew(Profile profile) {
        return !this.repository.exists(profile.getName());
    }

    public void apply() throws IOException {
        HashSet<Profile> existingProfiles = new HashSet<Profile>(this.repository.getProfiles());
        LOG.trace("applying changes from {0} to {1}", existingProfiles, this.profiles);
        int i = this.profiles.size();
        while (i-- > 0) {
            Profile profile = this.profiles.get(i);
            existingProfiles.remove(profile);
            ProfileTransaction transaction = this.transactions.get(profile);
            if (transaction == null || !transaction.isModified()) continue;
            transaction.apply();
            this.repository.save(profile);
            this.fireContentsChanged(i);
        }
        for (Profile profile : existingProfiles) {
            this.repository.delete(profile);
        }
        assert (this.profiles.equals(this.sort(this.repository.getProfiles())));
        LOG.trace("completed applying changes to {0}", this.profiles);
    }

    public void cancel() {
        HashSet<Profile> existingProfiles = new HashSet<Profile>(this.repository.getProfiles());
        LOG.trace("canceling changes from {0} to {1}", existingProfiles, this.profiles);
        int i = this.profiles.size();
        while (i-- > 0) {
            Profile profile = this.profiles.get(i);
            existingProfiles.remove(profile);
            ProfileTransaction transaction = this.transactions.get(profile);
            if (transaction == null || !transaction.isModified()) continue;
            transaction.revert();
            this.fireContentsChanged(i);
        }
        for (Profile profile : existingProfiles) {
            int index = Collections.binarySearch(this.profiles, profile, this.PROFILE_COMPARATOR);
            assert (index < 0);
            index = -index - 1;
            this.profiles.add(index, profile);
            this.fireIntervalAdded(this, index, index);
        }
        assert (this.profiles.equals(this.sort(this.repository.getProfiles())));
        LOG.trace("completed canceling changes to {0}", this.profiles);
    }

    private List<Profile> sort(List<Profile> list) {
        Collections.sort(list, this.PROFILE_COMPARATOR);
        return list;
    }

    @Override
    public void propertyChange(PropertyChangeEvent event) {
        assert (LOG.trace("handling property '{0}:{1}' in {2} changed", event.getSource(), (Object)event.getPropertyName(), (Object)this));
        if (event.getSource() instanceof ProfileTransaction && event.getPropertyName().equals("modified")) {
            ProfileTransaction transaction = (ProfileTransaction)event.getSource();
            Profile profile = transaction.getProfile();
            LOG.trace("handling modified property changed from {0}", (Object)transaction);
            this.fireContentsChanged(profile);
        }
        this.support.firePropertyChange(event);
    }

    public void fireSelectionChanged() {
        LOG.trace("firing selection changed");
        this.fireContentsChanged(this, -1, -1);
    }

    public void fireContentsChanged(Profile profile) {
        int index = this.profiles.indexOf(profile);
        assert (index >= 0);
        LOG.trace("firing contents changed for {1} at {0}", index, (Object)profile);
        this.fireContentsChanged(this, index, index);
    }

    public void fireContentsChanged(int index) {
        assert (index >= 0);
        LOG.trace("firing contents changed for {1} at {0}", index, (Object)this.profiles.get(index));
        this.fireContentsChanged(this, index, index);
    }

    public String toString() {
        return "ProfileModel " + this.selectedProfile + (this.selectedProfile != null && this.isModified(this.selectedProfile) ? "*" : "");
    }
}

