/*
 * Decompiled with CFR 0.152.
 */
package oracle.jdevimpl.audit.report;

import java.io.BufferedInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.net.URL;
import javax.xml.transform.ErrorListener;
import javax.xml.transform.Result;
import javax.xml.transform.Source;
import javax.xml.transform.Transformer;
import javax.xml.transform.TransformerException;
import javax.xml.transform.TransformerFactory;
import javax.xml.transform.stream.StreamSource;
import oracle.ide.Ide;
import oracle.ide.net.URLFileSystem;
import oracle.ide.util.IdeUtil;
import oracle.javatools.util.Log;
import oracle.xml.parser.v2.SAXParser;
import org.xml.sax.Attributes;
import org.xml.sax.ContentHandler;
import org.xml.sax.SAXException;
import org.xml.sax.helpers.DefaultHandler;

public class StyleSheet {
    private final URL url;
    private final String name;
    private String suffix;
    private static final Log LOG = new Log("stylesheet");

    public StyleSheet(URL url) {
        this.url = url;
        this.name = URLFileSystem.getName((URL)url);
    }

    public String getName() {
        return this.name;
    }

    public String getOutputSuffix() {
        if (this.suffix == null) {
            this.suffix = new SuffixScanner(this.url).getSuffix();
        }
        return this.suffix;
    }

    public URL getUrl() {
        return this.url;
    }

    public String toString() {
        return this.getName();
    }

    public void apply(Source input, Result output, String outputEncoding) throws IOException, TransformerException {
        if (outputEncoding == null) {
            outputEncoding = IdeUtil.getIdeIanaEncoding();
        }
        BufferedInputStream transformStream = null;
        boolean throwing = false;
        try {
            transformStream = new BufferedInputStream(URLFileSystem.openInputStream((URL)this.getUrl()));
            TransformerFactory factory = TransformerFactory.newInstance();
            StreamSource transform = new StreamSource(transformStream);
            Transformer transformer = factory.newTransformer(transform);
            transformer.setErrorListener(new ThrowingErrorListener());
            transformer.setOutputProperty("encoding", outputEncoding);
            transformer.setParameter("newline", Ide.getEnvironOptions().getLineBreakSequence());
            transformer.transform(input, output);
        }
        catch (IOException e) {
            throwing = true;
            throw e;
        }
        catch (TransformerException e) {
            throwing = true;
            throw e;
        }
        finally {
            block13: {
                try {
                    if (transformStream != null) {
                        ((InputStream)transformStream).close();
                    }
                }
                catch (IOException e) {
                    if (throwing) break block13;
                    throw e;
                }
            }
        }
    }

    private static class ThrowingErrorListener
    implements ErrorListener {
        private ThrowingErrorListener() {
        }

        @Override
        public void error(TransformerException e) throws TransformerException {
            throw e;
        }

        @Override
        public void fatalError(TransformerException e) throws TransformerException {
            throw e;
        }

        @Override
        public void warning(TransformerException e) throws TransformerException {
            throw e;
        }
    }

    private static class SuffixScanner
    extends DefaultHandler {
        private String suffix = ".txt";

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public SuffixScanner(URL url) {
            InputStream stream = null;
            try {
                SAXParser parser = new SAXParser();
                parser.setPreserveWhitespace(false);
                parser.setAttribute("oracle.xml.parser.XMLParser.Standalone", (Object)Boolean.TRUE);
                parser.setPreserveWhitespace(false);
                parser.setContentHandler((ContentHandler)this);
                stream = URLFileSystem.openInputStream((URL)url);
                parser.parse(stream);
            }
            catch (SAXException sAXException) {
            }
            catch (Exception exception) {
            }
            finally {
                try {
                    if (stream != null) {
                        stream.close();
                    }
                }
                catch (IOException iOException) {}
            }
        }

        public String getSuffix() {
            return this.suffix;
        }

        @Override
        public void startElement(String namespaceURI, String localName, String qualifiedName, Attributes attributes) throws SAXException {
            LOG.trace("starting element {0}, {1}, {2}", (Object)localName, (Object)qualifiedName, (Object)attributes);
            if ("xsl:output".equals(qualifiedName)) {
                String method = attributes.getValue("", "method");
                this.suffix = "text".equals(method) ? ".txt" : ("html".equals(method) ? ".html" : ".xml");
                throw new SAXException("done");
            }
        }
    }
}

