/*
 * Decompiled with CFR 0.152.
 */
package oracle.jdevimpl.audit.swing;

import java.util.Collections;
import java.util.List;
import javax.swing.tree.TreePath;
import oracle.javatools.util.Log;
import oracle.jdevimpl.audit.swing.AbstractTreeModel;
import oracle.jdevimpl.audit.swing.CheckBoxTreeModel;

public abstract class AbstractCheckBoxTreeModel
extends AbstractTreeModel
implements CheckBoxTreeModel {
    private Log LOG = new Log("checkboxtreemodel");

    @Override
    public abstract Object getRoot();

    @Override
    public Object getChild(Object parent, int index) {
        CheckBoxNode node = (CheckBoxNode)parent;
        if (!node.isSubtreeVisible()) {
            throw new IllegalStateException(parent + " not visible");
        }
        int count = 0;
        for (CheckBoxNode child : node.getChildren()) {
            if (!child.isSubtreeVisible() || count++ != index) continue;
            return child;
        }
        throw new IndexOutOfBoundsException(index + " >= " + count);
    }

    @Override
    public int getChildCount(Object parent) {
        return ((CheckBoxNode)parent).getVisibleChildCount();
    }

    @Override
    public int getIndexOfChild(Object parent, Object child) {
        CheckBoxNode node = (CheckBoxNode)parent;
        if (!node.isSubtreeVisible()) {
            throw new IllegalStateException(parent + " not visible");
        }
        int count = 0;
        for (CheckBoxNode c : node.getChildren()) {
            if (!c.isSubtreeVisible()) continue;
            if (c == child) {
                return count;
            }
            ++count;
        }
        return -1;
    }

    @Override
    public boolean isLeaf(Object node) {
        return ((CheckBoxNode)node).isLeaf();
    }

    @Override
    public void valueForPathChanged(TreePath path, Object newValue) {
    }

    @Override
    public Boolean getState(Object node) {
        return ((CheckBoxNode)node).getState();
    }

    public boolean isModified(Object node) {
        boolean modified = ((CheckBoxNode)node).isSubtreeModified();
        this.LOG.trace("modified {0} valid {1} for {2}", (Object)modified, (Object)((CheckBoxNode)node).valid, node);
        return modified;
    }

    @Override
    public void stateForPathChanged(TreePath path, boolean newState) {
        TreePath parentPath;
        CheckBoxNode node = (CheckBoxNode)path.getLastPathComponent();
        boolean changed = node.treeChanged(path, newState);
        if (changed && (parentPath = path.getParentPath()) != null) {
            CheckBoxNode parent = (CheckBoxNode)parentPath.getLastPathComponent();
            parent.childChanged(parentPath, node, false);
        }
    }

    public void treeChanged(TreePath path) {
        TreePath parentPath;
        CheckBoxNode node = (CheckBoxNode)path.getLastPathComponent();
        boolean changed = node.treeChanged(path, null);
        if (changed && (parentPath = path.getParentPath()) != null) {
            CheckBoxNode parent = (CheckBoxNode)parentPath.getLastPathComponent();
            parent.childChanged(parentPath, node, false);
        }
    }

    public void treeChanged() {
        CheckBoxNode root = (CheckBoxNode)this.getRoot();
        root.treeChanged(new TreePath(root), null);
    }

    public void nodeChanged(TreePath path) {
        if (path == null) {
            return;
        }
        CheckBoxNode node = (CheckBoxNode)path.getLastPathComponent();
        if (!node.isViewable()) {
            return;
        }
        TreePath parentPath = path.getParentPath();
        if (parentPath != null) {
            CheckBoxNode parent = (CheckBoxNode)parentPath.getLastPathComponent();
            parent.childChanged(parentPath, node, true);
        }
    }

    @Override
    public String convertValueToText(Object node) {
        return ((CheckBoxNode)node).getLabel();
    }

    protected abstract class CheckBoxNode<T extends CheckBoxNode> {
        private boolean valid;
        private boolean visible;
        private Boolean state = false;
        private boolean modified;
        private int visibleCount;

        protected CheckBoxNode() {
        }

        protected List<T> getChildren() {
            return Collections.emptyList();
        }

        protected int getVisibleChildCount() {
            if (!this.isSubtreeVisible()) {
                throw new IllegalStateException(this + " not visible");
            }
            return this.visibleCount;
        }

        protected boolean isLeaf() {
            return false;
        }

        protected boolean isVisible() {
            return true;
        }

        protected Boolean getState() {
            this.validate();
            return this.state;
        }

        protected void setState(boolean state) {
            this.state = state;
        }

        protected boolean isModified() {
            return false;
        }

        protected abstract String getLabel();

        private boolean isViewable() {
            return this.valid && this.visible;
        }

        private void invalidate() {
            this.valid = false;
        }

        private void validate() {
            if (this.valid || this.isLeaf()) {
                return;
            }
            this.visible = this.isVisible();
            this.modified = this.isModified();
            this.state = false;
            this.visibleCount = 0;
            for (CheckBoxNode child : this.getChildren()) {
                if (!child.isSubtreeVisible()) continue;
                Boolean childState = child.getState();
                if (this.visibleCount++ == 0) {
                    this.state = childState;
                } else if (this.state != childState) {
                    this.state = null;
                }
                this.visible = true;
                this.modified |= child.isSubtreeModified();
            }
            this.valid = true;
        }

        boolean isSubtreeVisible() {
            if (!this.valid) {
                if (this.isLeaf()) {
                    this.visible = this.isVisible();
                    this.valid = true;
                } else {
                    this.validate();
                }
            }
            return this.visible;
        }

        boolean isSubtreeModified() {
            if (!this.valid) {
                if (this.isLeaf()) {
                    this.modified = this.isModified();
                    this.valid = true;
                } else {
                    this.validate();
                }
            }
            return this.modified;
        }

        private boolean treeChanged(TreePath nodePath, Boolean requestedState) {
            boolean changed;
            if (this != nodePath.getLastPathComponent()) {
                throw new IllegalArgumentException(this + " not last component of " + nodePath);
            }
            if (requestedState != null) {
                requestedState = (boolean)requestedState;
            }
            boolean oldViewable = this.isViewable();
            Boolean oldState = false;
            boolean oldModified = false;
            if (oldViewable) {
                oldState = this.getState();
                oldModified = this.isSubtreeModified();
            }
            int beforeCount = 0;
            int afterCount = 0;
            List<T> children = this.getChildren();
            int size = children.size();
            int[] insertedIndices = new int[size];
            Object[] insertedChildren = new Object[size];
            int insertedCount = 0;
            int[] removedIndices = new int[size];
            Object[] removedChildren = new Object[size];
            int removedCount = 0;
            int[] changedIndices = new int[size];
            Object[] changedChildren = new Object[size];
            int changedCount = 0;
            for (CheckBoxNode child : children) {
                boolean oldChildViewable = child.isViewable();
                Boolean oldChildState = false;
                boolean oldChildModified = false;
                if (oldChildViewable) {
                    oldChildState = child.getState();
                    oldChildModified = child.isSubtreeModified();
                }
                child.treeChanged(nodePath.pathByAddingChild(child), requestedState);
                boolean newChildViewable = child.isSubtreeVisible();
                if (!oldChildViewable && newChildViewable) {
                    insertedChildren[insertedCount] = child;
                    insertedIndices[insertedCount++] = afterCount;
                } else if (oldChildViewable && !newChildViewable) {
                    removedChildren[removedCount] = child;
                    removedIndices[removedCount++] = beforeCount;
                } else if (newChildViewable && oldChildViewable && (oldChildState != child.getState() || oldChildModified != child.isSubtreeModified())) {
                    changedChildren[changedCount] = child;
                    changedIndices[changedCount++] = afterCount;
                }
                if (oldChildViewable) {
                    ++beforeCount;
                }
                if (!newChildViewable) continue;
                ++afterCount;
            }
            if (requestedState != null) {
                this.setState(requestedState);
            }
            this.invalidate();
            boolean newViewable = this.isSubtreeVisible();
            if (!this.isLeaf() && oldViewable && newViewable) {
                if (removedCount > 0) {
                    if (removedCount < size) {
                        Object[] objectArray = removedChildren;
                        removedChildren = new Object[removedCount];
                        System.arraycopy(objectArray, 0, removedChildren, 0, removedCount);
                        int[] nArray = removedIndices;
                        removedIndices = new int[removedCount];
                        System.arraycopy(nArray, 0, removedIndices, 0, removedCount);
                    }
                    AbstractCheckBoxTreeModel.this.LOG.trace("firing tree nodes removed: {0}", removedChildren);
                    AbstractCheckBoxTreeModel.this.fireTreeNodesRemoved(AbstractCheckBoxTreeModel.this, nodePath.getPath(), removedIndices, removedChildren);
                }
                if (insertedCount > 0) {
                    if (insertedCount < size) {
                        Object[] objectArray = insertedChildren;
                        insertedChildren = new Object[insertedCount];
                        System.arraycopy(objectArray, 0, insertedChildren, 0, insertedCount);
                        int[] nArray = insertedIndices;
                        insertedIndices = new int[insertedCount];
                        System.arraycopy(nArray, 0, insertedIndices, 0, insertedCount);
                    }
                    AbstractCheckBoxTreeModel.this.LOG.trace("firing tree nodes inserted: {0}", insertedChildren);
                    AbstractCheckBoxTreeModel.this.fireTreeNodesInserted(AbstractCheckBoxTreeModel.this, nodePath.getPath(), insertedIndices, insertedChildren);
                }
                if (changedCount > 0) {
                    if (changedCount < size) {
                        Object[] objectArray = changedChildren;
                        changedChildren = new Object[changedCount];
                        System.arraycopy(objectArray, 0, changedChildren, 0, changedCount);
                        int[] nArray = changedIndices;
                        changedIndices = new int[changedCount];
                        System.arraycopy(nArray, 0, changedIndices, 0, changedCount);
                    }
                    AbstractCheckBoxTreeModel.this.LOG.trace("firing tree nodes removed: {0}", changedChildren);
                    AbstractCheckBoxTreeModel.this.fireTreeNodesChanged(AbstractCheckBoxTreeModel.this, nodePath.getPath(), changedIndices, changedChildren);
                }
            }
            if (newViewable) {
                Boolean newState = this.getState();
                boolean newModified = this.isSubtreeModified();
                changed = !oldViewable || oldState != newState || oldModified != newModified;
                AbstractCheckBoxTreeModel.this.LOG.trace("treeChanged ({0}, {1}) changed {2}, state {3}, modified {4}", (Object)nodePath, (Object)requestedState, (Object)changed, (Object)newState, (Object)newModified);
            } else {
                changed = oldViewable;
                AbstractCheckBoxTreeModel.this.LOG.trace("treeChanged ({0}, {1}) changed {2}", (Object)nodePath, (Object)requestedState, (Object)changed);
            }
            return changed;
        }

        private void childChanged(TreePath nodePath, CheckBoxNode child, boolean revalidate) {
            boolean changed;
            if (this != nodePath.getLastPathComponent()) {
                throw new IllegalArgumentException(this + " not last component of " + nodePath);
            }
            if (!child.isViewable()) {
                throw new IllegalArgumentException(child + " not viewable");
            }
            if (!this.isViewable()) {
                throw new IllegalArgumentException(this + " not viewable");
            }
            int childIndex = AbstractCheckBoxTreeModel.this.getIndexOfChild(this, child);
            if (childIndex < 0) {
                throw new IllegalArgumentException(child + " not child of " + nodePath);
            }
            if (revalidate) {
                assert (child.valid);
                Boolean oldState = child.state;
                boolean oldModified = child.modified;
                child.invalidate();
                Boolean newState = child.getState();
                boolean newModified = child.isSubtreeModified();
                changed = oldState != newState || oldModified != newModified;
                AbstractCheckBoxTreeModel.this.LOG.trace("childChanged {0} in {1}, changed {2}, state {3}, modified {4}", (Object)child, (Object)nodePath, (Object)changed, (Object)newState, (Object)newModified);
            } else {
                AbstractCheckBoxTreeModel.this.LOG.trace("childChanged {0} in {1}", (Object)child, (Object)nodePath);
                changed = true;
            }
            if (changed) {
                AbstractCheckBoxTreeModel.this.fireTreeNodesChanged(AbstractCheckBoxTreeModel.this, nodePath.getPath(), new int[]{childIndex}, new Object[]{child});
                TreePath parentPath = nodePath.getParentPath();
                if (parentPath != null) {
                    CheckBoxNode parent = (CheckBoxNode)parentPath.getLastPathComponent();
                    parent.childChanged(parentPath, this, true);
                }
            }
        }
    }
}

