/*
 * Decompiled with CFR 0.152.
 */
package oracle.jdevimpl.audit.swing;

import java.applet.Applet;
import java.awt.Component;
import java.awt.Container;
import java.awt.Dialog;
import java.awt.Dimension;
import java.awt.Frame;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Image;
import java.awt.Insets;
import java.awt.Point;
import java.awt.Rectangle;
import java.awt.Toolkit;
import java.awt.Window;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.ComponentEvent;
import java.awt.event.ComponentListener;
import java.awt.event.WindowEvent;
import java.awt.event.WindowListener;
import java.net.URL;
import java.util.ArrayList;
import java.util.List;
import javax.ide.util.MissingIconException;
import javax.swing.AbstractAction;
import javax.swing.ActionMap;
import javax.swing.ComponentInputMap;
import javax.swing.ImageIcon;
import javax.swing.InputMap;
import javax.swing.JButton;
import javax.swing.JComponent;
import javax.swing.JDialog;
import javax.swing.JPanel;
import javax.swing.KeyStroke;
import javax.swing.SwingUtilities;
import oracle.bali.ewt.button.DialogButtonBar;
import oracle.bali.ewt.dialog.DialogHeader;
import oracle.bali.ewt.util.WindowUtils;
import oracle.ide.Ide;
import oracle.ide.ProductInformation;
import oracle.ide.help.HelpInfo;
import oracle.ide.help.HelpSystem;
import oracle.javatools.util.FormatBundle;
import oracle.javatools.util.Log;
import oracle.jdevimpl.audit.swing.DialogFactoryBundle;

public class DialogFactory
implements ComponentListener,
WindowListener {
    private static final Log LOG = new Log(new String[]{"dialog", "dialog-detail"});
    private static final Log LOG_DETAIL = new Log("dialog-detail");
    private boolean modal = true;
    private String title;
    private boolean defaultCloseButtonIgnored;
    private String description;
    private boolean resizable = true;
    private boolean minimumSizeTracksPreferredSize;
    private Dimension minimumSize;
    private Dimension minimumInitialSize;
    private float expansionFactor = 1.0f;
    private Component content;
    private Rectangle lastBounds;
    private JButton applyButton;
    private ActionListener applyAction;
    private JButton cancelButton;
    private ActionListener cancelAction;
    private JButton closeButton;
    private ActionListener closeAction;
    private JButton helpButton;
    private String helpTopic;
    private JButton okButton;
    private ActionListener okAction;
    private List<JButton> customButtons = new ArrayList<JButton>();
    private JButton defaultButton;
    private Component initialComponent;
    private JDialog dialog;
    private volatile JButton terminatingButton = null;
    private static final FormatBundle bundle = new FormatBundle(DialogFactoryBundle.class);

    public JButton addApplyButton(JButton button) {
        if (button == null) {
            button = this.createDefaultButton("apply");
        }
        this.applyButton = button;
        return button;
    }

    public JButton addApplyAction(ActionListener action) {
        if (this.applyButton == null) {
            this.applyButton = this.createDefaultButton("apply");
        }
        this.applyAction = action;
        return this.applyButton;
    }

    public JButton addCancelButton(JButton button) {
        if (this.closeButton != null) {
            throw new IllegalStateException("close button added");
        }
        if (button == null) {
            button = this.createDefaultButton("cancel");
        }
        this.cancelButton = button;
        return button;
    }

    public JButton addCancelAction(ActionListener action) {
        if (this.closeButton != null) {
            throw new IllegalStateException("close button added");
        }
        if (this.cancelButton == null) {
            this.cancelButton = this.createDefaultButton("cancel");
        }
        this.cancelAction = action;
        return this.cancelButton;
    }

    public JButton addCloseButton(JButton button) {
        if (this.cancelButton != null) {
            throw new IllegalStateException("cancel button added");
        }
        if (button == null) {
            button = this.createDefaultButton("close");
        }
        this.closeButton = button;
        return button;
    }

    public JButton addCloseAction(ActionListener action) {
        if (this.cancelButton != null) {
            throw new IllegalStateException("cancel button added");
        }
        if (this.closeButton == null) {
            this.closeButton = this.createDefaultButton("close");
        }
        this.closeAction = action;
        return this.closeButton;
    }

    public JButton addCustomButton(JButton button) {
        if (button == null) {
            throw new IllegalArgumentException("button == null");
        }
        this.customButtons.add(button);
        return button;
    }

    public JButton addOkButton(JButton button) {
        if (button == null) {
            button = this.createDefaultButton("ok");
        }
        this.okButton = button;
        return button;
    }

    public JButton addOkAction(ActionListener action) {
        if (this.okButton == null) {
            this.okButton = this.createDefaultButton("ok");
        }
        this.okAction = action;
        return this.okButton;
    }

    public JButton getApplyButton() {
        return this.applyButton;
    }

    public JButton getCancelButton() {
        return this.cancelButton;
    }

    public JButton getCloseButton() {
        return this.closeButton;
    }

    public JButton getHelpButton() {
        return this.helpButton;
    }

    public Rectangle getLastBounds() {
        return this.lastBounds;
    }

    public JButton getOkButton() {
        return this.okButton;
    }

    public void hide() {
        if (this.dialog != null) {
            LOG.trace("disposing of dialog");
            this.dialog.removeWindowListener(this);
            this.dialog.removeComponentListener(this);
            WindowUtils.unregisterWindow((Window)this.dialog);
            this.lastBounds = this.dialog.getBounds();
            this.dialog.dispose();
        }
        this.dialog = null;
    }

    public void setContent(Component content) {
        this.content = content;
    }

    public void setDefaultCloseButtonIgnored(boolean ignored) {
        this.defaultCloseButtonIgnored = ignored;
    }

    public void setDefaultButton(JButton button) {
        if (this.okButton != button && this.applyButton != button && this.cancelButton != button && this.closeButton != button && !this.customButtons.contains(button)) {
            throw new IllegalArgumentException("button " + button + " not added");
        }
        this.defaultButton = button;
    }

    public void setDescription(String description) {
        this.description = description;
    }

    public void setExpansionFactor(float factor) {
        this.expansionFactor = factor;
    }

    public void setInitialFocus(Component component) {
        this.initialComponent = component;
    }

    public void setHelpTopic(String topic) {
        this.helpTopic = topic;
        this.helpButton = this.createDefaultButton("help");
    }

    public void setResizable(boolean resizable) {
        this.resizable = resizable;
    }

    public void setMinimumSizeTracksPreferredSize(boolean tracks) {
        this.minimumSizeTracksPreferredSize = tracks;
    }

    public void setMinimumSize(Dimension size) {
        if (this.minimumSize != null && (size.width > this.minimumInitialSize.width || size.height > this.minimumInitialSize.height)) {
            throw new IllegalArgumentException(size + " > " + this.minimumInitialSize);
        }
        this.minimumSize = size;
    }

    public void setMinimumInitialSize(Dimension size) {
        if (this.minimumSize != null && (size.width < this.minimumSize.width || size.height < this.minimumSize.height)) {
            throw new IllegalArgumentException(size + " < " + this.minimumSize);
        }
        this.minimumInitialSize = size;
    }

    public void setModal(boolean modal) {
        this.modal = modal;
    }

    public void setTerminatingButton(JButton button) {
        if (!this.customButtons.contains(button)) {
            throw new IllegalArgumentException("button not custom button");
        }
        button.addActionListener(new TerminatingAction(button, null));
    }

    public void setTitle(String title) {
        this.title = title;
    }

    public JButton show() {
        return this.show(null);
    }

    public JButton show(Component parent) {
        return this.show(parent, null);
    }

    public JButton show(Component parent, Rectangle bounds) {
        AbstractAction action;
        Window window;
        this.dialog = parent != null ? ((window = SwingUtilities.getWindowAncestor(parent)) instanceof Frame ? new JDialog((Frame)window, this.title, this.modal) : new JDialog((Dialog)window, this.title, this.modal)) : new JDialog((Frame)Ide.getMainWindow(), this.title, this.modal);
        WindowUtils.registerWindow((Window)this.dialog);
        this.dialog.setDefaultCloseOperation(0);
        this.dialog.setResizable(this.resizable);
        DialogButtonBar buttons = new DialogButtonBar();
        ComponentInputMap inputMap = new ComponentInputMap((JComponent)buttons);
        ActionMap actionMap = new ActionMap();
        if (this.applyButton != null) {
            buttons.add((Component)this.applyButton, DialogButtonBar.CONSTRAINT_APPLY);
            if (this.applyAction != null) {
                this.applyButton.addActionListener(this.applyAction);
            }
            this.applyButton.setDefaultCapable(this.defaultButton == this.applyButton);
        }
        if (this.cancelButton != null) {
            buttons.add((Component)this.cancelButton, DialogButtonBar.CONSTRAINT_CANCEL);
            action = new TerminatingAction(this.cancelButton, this.cancelAction);
            this.cancelButton.addActionListener(action);
            ((InputMap)inputMap).put(KeyStroke.getKeyStroke(27, 0), "cancel");
            actionMap.put("cancel", action);
            this.cancelButton.setDefaultCapable(this.defaultButton == this.cancelButton);
        }
        if (this.helpButton != null) {
            buttons.add((Component)this.helpButton, DialogButtonBar.CONSTRAINT_HELP);
            action = new HelpAction();
            this.helpButton.addActionListener(action);
            ((InputMap)inputMap).put(KeyStroke.getKeyStroke(112, 0), "help");
            ((InputMap)inputMap).put(KeyStroke.getKeyStroke(156, 0), "help");
            actionMap.put("help", action);
            this.helpButton.setDefaultCapable(false);
        }
        if (this.okButton != null) {
            buttons.add((Component)this.okButton, DialogButtonBar.CONSTRAINT_YES);
            action = new TerminatingAction(this.okButton, this.okAction);
            this.okButton.addActionListener(action);
            if (this.cancelButton == null) {
                ((InputMap)inputMap).put(KeyStroke.getKeyStroke(27, 0), "ok");
                actionMap.put("ok", action);
            }
            this.okButton.setDefaultCapable(this.defaultButton == this.okButton);
        }
        for (JButton button : this.customButtons) {
            buttons.add((Component)button);
            button.setDefaultCapable(this.defaultButton == button);
        }
        if (buttons.getComponentCount() <= (this.helpTopic == null ? 0 : 1)) {
            this.closeButton = this.createDefaultButton("close");
        }
        if (this.closeButton != null) {
            buttons.add((Component)this.closeButton, DialogButtonBar.CONSTRAINT_CANCEL);
            action = new TerminatingAction(this.closeButton, this.closeAction);
            this.closeButton.addActionListener(action);
            ((InputMap)inputMap).put(KeyStroke.getKeyStroke(27, 0), "close");
            actionMap.put("close", action);
            this.closeButton.setDefaultCapable(this.defaultButton == this.closeButton);
        }
        if (this.defaultButton != null) {
            this.dialog.getRootPane().setDefaultButton(this.defaultButton);
        }
        SwingUtilities.replaceUIInputMap((JComponent)buttons, 2, inputMap);
        SwingUtilities.replaceUIActionMap((JComponent)buttons, actionMap);
        JPanel panel = new JPanel(new GridBagLayout());
        GridBagConstraints constraints = new GridBagConstraints(0, 0, 1, 1, 0.0, 0.0, 18, 1, new Insets(0, 10, 0, 10), 0, 0);
        if (this.description != null) {
            Image image;
            try {
                URL url = ProductInformation.getProductInformation().getIcon().getURL();
                image = new ImageIcon(url).getImage();
            }
            catch (MissingIconException e) {
                image = null;
            }
            constraints.insets.top = 10;
            panel.add((Component)new DialogHeader(this.description, image), constraints);
            ++constraints.gridy;
        }
        constraints.weighty = 1.0;
        constraints.weightx = 1.0;
        constraints.insets.top = 16;
        panel.add(this.content, constraints);
        constraints.weighty = 0.0;
        constraints.weightx = 0.0;
        ++constraints.gridy;
        constraints.anchor = 13;
        constraints.insets.top = 16;
        constraints.insets.bottom = 10;
        panel.add((Component)buttons, constraints);
        this.dialog.getContentPane().add(panel);
        Dimension initialMinimumSize = this.minimumInitialSize != null ? this.minimumInitialSize : this.minimumSize;
        this.dialog.setMinimumSize(initialMinimumSize);
        this.dialog.pack();
        if (this.minimumSizeTracksPreferredSize) {
            Dimension size = this.dialog.getPreferredSize();
            if (this.minimumSize != null && (this.minimumSize.width > size.width || this.minimumSize.height > size.height)) {
                size = new Dimension(Math.max(this.minimumSize.width, size.width), Math.max(this.minimumSize.height, size.height));
            }
            this.minimumSize = size;
        }
        LOG.trace("dialog packed: {0} preferred {1}", (Object)this.dialog.getSize(), (Object)this.dialog.getPreferredSize());
        if (LOG_DETAIL.isEnabled()) {
            this.dump(this.dialog, 0, 0, "");
        }
        this.dialog.setMinimumSize(this.minimumSize);
        if (bounds == null) {
            Toolkit toolkit = Toolkit.getDefaultToolkit();
            Dimension screenSize = toolkit.getScreenSize();
            Insets screenInsets = toolkit.getScreenInsets(this.dialog.getGraphicsConfiguration());
            screenSize.width = Math.min(screenSize.width - screenInsets.left - screenInsets.right, 800);
            screenSize.height = Math.min(screenSize.height - screenInsets.top - screenInsets.bottom, 600);
            Dimension size = new Dimension(Math.min(this.dialog.getWidth(), screenSize.width), Math.min(this.dialog.getHeight(), screenSize.height));
            Dimension expandedSize = new Dimension(size.width, Math.min((int)((float)size.height * this.expansionFactor), screenSize.height));
            this.dialog.setSize(expandedSize);
            this.dialog.setLocationRelativeTo(parent);
            this.dialog.setSize(size);
        } else {
            this.dialog.setBounds(bounds);
        }
        this.dialog.addWindowListener(this);
        this.dialog.addComponentListener(this);
        this.dialog.setVisible(true);
        return this.terminatingButton;
    }

    private void dump(Component component, int x, int y, String indent) {
        Rectangle bounds = component.getBounds();
        LOG.trace("{0}{1}: [{2},{3},{4},{5}]", new Object[]{indent, component.getClass().getSimpleName(), x += bounds.x, y += bounds.y, bounds.width, bounds.height});
        if (component instanceof Container) {
            for (Component child : ((Container)component).getComponents()) {
                this.dump(child, x, y, indent + "  ");
            }
        }
    }

    private JButton createDefaultButton(String name) {
        JButton button = new JButton(bundle.get(name + ".text"));
        String mnemonic = bundle.get(name + ".mnemonic");
        if (mnemonic != null && mnemonic.length() == 1) {
            button.setMnemonic(mnemonic.charAt(0));
        }
        return button;
    }

    @Override
    public void componentHidden(ComponentEvent e) {
        LOG.trace("dialog hidden: {0}", (Object)this.lastBounds);
    }

    @Override
    public void componentMoved(ComponentEvent e) {
    }

    @Override
    public void componentResized(ComponentEvent e) {
        Dimension min = this.dialog.getMinimumSize();
        Dimension size = this.dialog.getSize();
        LOG.trace("dialog sized to {0}: showing {1} minSize {2}", (Object)size, (Object)this.dialog.isShowing(), (Object)min);
        if (size.width < min.width || size.height < min.height) {
            int width = Math.max(min.width, size.width);
            int height = Math.max(min.height, size.height);
            LOG.trace("dialog resetting size to java.awt.Dimension[width={0},height={1}])", width, height);
            this.dialog.setSize(width, height);
        }
    }

    @Override
    public void componentShown(ComponentEvent e) {
        LOG.trace("dialog shown: {0}", (Object)this.dialog.getSize());
    }

    @Override
    public void windowActivated(WindowEvent e) {
    }

    @Override
    public void windowClosed(WindowEvent e) {
    }

    @Override
    public void windowClosing(WindowEvent e) {
        if (!this.defaultCloseButtonIgnored) {
            this.terminatingButton = null;
            this.hide();
        }
    }

    @Override
    public void windowDeactivated(WindowEvent e) {
    }

    @Override
    public void windowDeiconified(WindowEvent e) {
    }

    @Override
    public void windowIconified(WindowEvent e) {
    }

    @Override
    public void windowOpened(WindowEvent e) {
        if (this.initialComponent != null) {
            this.initialComponent.requestFocus();
        }
    }

    public void setLocationRelativeTo(JDialog dialog, Component c) {
        Container root = null;
        if (c != null) {
            if (c instanceof Window || c instanceof Applet) {
                root = (Container)c;
            } else {
                for (Container parent = c.getParent(); parent != null; parent = parent.getParent()) {
                    if (!(parent instanceof Window) && !(parent instanceof Applet)) continue;
                    root = parent;
                    break;
                }
            }
        }
        if (c != null && !c.isShowing() || root == null || !root.isShowing()) {
            Dimension paneSize = dialog.getSize();
            Dimension screenSize = dialog.getToolkit().getScreenSize();
            Insets screenInsets = dialog.getToolkit().getScreenInsets(dialog.getGraphicsConfiguration());
            dialog.setLocation(screenInsets.left + (screenSize.width - screenInsets.left - screenInsets.right - paneSize.width) / 2, screenInsets.top + (screenSize.height - screenInsets.top - screenInsets.bottom - paneSize.height) / 2);
        } else {
            Point invokerScreenLocation;
            Dimension invokerSize = c.getSize();
            if (root instanceof Applet) {
                invokerScreenLocation = c.getLocationOnScreen();
            } else {
                invokerScreenLocation = new Point(0, 0);
                for (Component tc = c; tc != null; tc = tc.getParent()) {
                    Point tcl = tc.getLocation();
                    invokerScreenLocation.x += tcl.x;
                    invokerScreenLocation.y += tcl.y;
                    if (tc == root) break;
                }
            }
            Rectangle windowBounds = dialog.getBounds();
            int dx = invokerScreenLocation.x + (invokerSize.width - windowBounds.width >> 1);
            int dy = invokerScreenLocation.y + (invokerSize.height - windowBounds.height >> 1);
            Dimension ss = dialog.getToolkit().getScreenSize();
            Insets si = dialog.getToolkit().getScreenInsets(dialog.getGraphicsConfiguration());
            if (dy + windowBounds.height > ss.height - si.bottom) {
                dy = ss.height - si.bottom - windowBounds.height;
                int n = dx = invokerScreenLocation.x < ss.width >> 1 ? invokerScreenLocation.x + invokerSize.width : invokerScreenLocation.x - windowBounds.width;
            }
            if (dx + windowBounds.width > ss.width) {
                dx = ss.width - windowBounds.width;
            }
            if (dx < 0) {
                dx = 0;
            }
            if (dy < 0) {
                dy = 0;
            }
            dialog.setLocation(dx, dy);
        }
    }

    private class HelpAction
    extends AbstractAction {
        private HelpAction() {
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            LOG.trace("help requested for \"{0}\"", (Object)DialogFactory.this.helpTopic);
            HelpSystem.getHelpSystem().showHelp(new HelpInfo(DialogFactory.this.helpTopic));
        }
    }

    private class TerminatingAction
    extends AbstractAction {
        private JButton button;
        private ActionListener action;

        public TerminatingAction(JButton button, ActionListener action) {
            this.button = button;
            this.action = action;
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            LOG.trace("terminating button {0} clicked", (Object)this.button);
            DialogFactory.this.terminatingButton = this.button;
            if (this.action != null) {
                this.action.actionPerformed(e);
            } else {
                DialogFactory.this.hide();
            }
        }
    }
}

