/*
 * Decompiled with CFR 0.152.
 */
package oracle.jdevimpl.audit.util;

import java.beans.IntrospectionException;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.lang.reflect.Modifier;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.Map;
import oracle.jdeveloper.audit.extension.PropertyTypeMethod;
import oracle.jdeveloper.audit.service.AuditLogger;
import oracle.jdevimpl.audit.util.PropertyDescriptor;

public class Beans {
    private static final Map<Class<?>, BeanDescriptor> beanDescriptors = new HashMap();

    private Beans() {
    }

    public static Collection<PropertyDescriptor> getPropertyDescriptors(Object bean) {
        return Beans.getBeanDescriptor(bean.getClass()).getProperties(bean);
    }

    public static PropertyDescriptor getPropertyDescriptor(Object bean, String propertyName) {
        return Beans.getBeanDescriptor(bean.getClass()).getProperty(bean, propertyName);
    }

    public static Object getPropertyValue(Object bean, String propertyName) throws IntrospectionException, InvocationTargetException, IllegalAccessException {
        PropertyDescriptor descriptor = Beans.getPropertyDescriptor(bean, propertyName);
        if (descriptor == null) {
            throw new IllegalArgumentException("property " + propertyName + " of bean " + bean + " not found");
        }
        return descriptor.getReadMethod().invoke(bean, new Object[0]);
    }

    public static void setPropertyValue(Object bean, String propertyName, Object value) throws IntrospectionException, InvocationTargetException, IllegalAccessException {
        PropertyDescriptor descriptor = Beans.getPropertyDescriptor(bean, propertyName);
        if (descriptor == null) {
            throw new IllegalArgumentException("property " + propertyName + " of bean " + bean + " not found");
        }
        descriptor.getWriteMethod().invoke(bean, value);
    }

    public static <T> void copyProperties(T fromBean, T toBean) throws IntrospectionException, IllegalAccessException, InvocationTargetException {
        for (PropertyDescriptor property : Beans.getPropertyDescriptors(fromBean)) {
            property.getWriteMethod().invoke(toBean, property.getReadMethod().invoke(fromBean, new Object[0]));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static BeanDescriptor getBeanDescriptor(Class<?> beanType) {
        Map<Class<?>, BeanDescriptor> map = beanDescriptors;
        synchronized (map) {
            BeanDescriptor descriptor = beanDescriptors.get(beanType);
            if (descriptor == null) {
                descriptor = new BeanDescriptor(Beans.getBeanDescriptor(beanType.getSuperclass()), beanType);
                beanDescriptors.put(beanType, descriptor);
            }
            return descriptor;
        }
    }

    private static String decapitalize(String methodName, int offset, int endOffset) {
        if (offset >= endOffset) {
            throw new IllegalArgumentException(offset + " >= " + endOffset);
        }
        StringBuilder builder = new StringBuilder();
        builder.append(methodName, offset, endOffset);
        if (builder.length() <= 1 || !Character.isUpperCase(builder.charAt(1))) {
            builder.setCharAt(0, Character.toLowerCase(builder.charAt(0)));
        }
        return builder.toString();
    }

    static {
        beanDescriptors.put(Object.class, new BeanDescriptor(null, Object.class));
    }

    private static class BeanDescriptor {
        private final Class<?> beanType;
        private final Map<String, Method> readMethods = new HashMap<String, Method>();
        private final Map<String, Method> writeMethods = new HashMap<String, Method>();
        private Map<String, PropertyDescriptor> descriptors;
        private boolean annotated;

        BeanDescriptor(BeanDescriptor superType, Class<?> beanType) {
            this.beanType = beanType;
            if (superType != null) {
                this.readMethods.putAll(superType.readMethods);
                this.writeMethods.putAll(superType.writeMethods);
            }
            block4: for (Method method : beanType.getDeclaredMethods()) {
                int modifiers = method.getModifiers();
                if (!Modifier.isPublic(modifiers) || Modifier.isStatic(modifiers)) continue;
                String methodName = method.getName();
                int methodNameLength = methodName.length();
                Class<?> returnType = method.getReturnType();
                Class<?>[] types = method.getParameterTypes();
                switch (types.length) {
                    case 0: {
                        String name;
                        Method superMethod;
                        if (methodName.startsWith("is")) {
                            if (methodNameLength < 3 || !Boolean.TYPE.equals(returnType)) continue block4;
                            this.readMethods.put(Beans.decapitalize(methodName, 2, methodNameLength), method);
                            continue block4;
                        }
                        if (!methodName.startsWith("get") || methodNameLength < 4 || Void.TYPE.equals(returnType) || (superMethod = this.readMethods.put(name = Beans.decapitalize(methodName, 3, methodNameLength), method)) == null || !superMethod.getName().startsWith("is")) continue block4;
                        this.readMethods.put(name, superMethod);
                        continue block4;
                    }
                    case 1: {
                        if (!methodName.startsWith("set") || methodNameLength < 4 || !Void.TYPE.equals(returnType) || Void.TYPE.equals(types[0])) continue block4;
                        this.writeMethods.put(Beans.decapitalize(methodName, 3, methodNameLength), method);
                    }
                }
            }
        }

        private Map<String, PropertyDescriptor> getDescriptors() {
            ArrayList<String> names = new ArrayList<String>(this.readMethods.keySet());
            Collections.sort(names);
            this.descriptors = new LinkedHashMap<String, PropertyDescriptor>(names.size());
            for (String propertyName : names) {
                Method writeMethod = this.writeMethods.get(propertyName);
                if (writeMethod == null) continue;
                Method readMethod = this.readMethods.get(propertyName);
                Class<?> propertyType = readMethod.getReturnType();
                if (!propertyType.equals(writeMethod.getParameterTypes()[0])) {
                    AuditLogger.warning("type conflict between setter {0} and getter {1} for {2} property of {3}", writeMethod, readMethod, propertyName, this.beanType);
                }
                PropertyTypeMethod annotation = writeMethod.getAnnotation(PropertyTypeMethod.class);
                Method typeMethod = null;
                if (annotation != null) {
                    String typeMethodName = annotation.value();
                    try {
                        if (annotation != null) {
                            typeMethod = this.beanType.getMethod(typeMethodName, new Class[0]);
                            this.annotated = true;
                        }
                    }
                    catch (NullPointerException e) {
                        AuditLogger.error(e, "type for property " + propertyName + " of type " + this.beanType + " not available because indicated method name is null", new Object[0]);
                    }
                    catch (NoSuchMethodException e) {
                        AuditLogger.error(e, "type for property " + propertyName + " of type " + this.beanType + " not available because indicated method \"" + typeMethodName + "\" not found", new Object[0]);
                    }
                    catch (SecurityException e) {
                        AuditLogger.error(e, "type for property " + propertyName + " of type " + this.beanType + " not available because indicated method \"" + typeMethodName + "\" not accessible", new Object[0]);
                    }
                    catch (Exception e) {
                        AuditLogger.error(e, "type for property " + propertyName + " of type " + this.beanType + " not bound after unexpected exception: " + e, new Object[0]);
                    }
                }
                this.descriptors.put(propertyName, new PropertyDescriptor(propertyName, propertyType, readMethod, writeMethod, typeMethod));
            }
            return this.descriptors;
        }

        private PropertyDescriptor getProperty(Object bean, String propertyName) {
            Method typeMethod;
            PropertyDescriptor descriptor = this.getDescriptors().get(propertyName);
            if (descriptor != null && (typeMethod = descriptor.getTypeMethod()) != null) {
                try {
                    descriptor = new PropertyDescriptor(descriptor, (Class)typeMethod.invoke(bean, new Object[0]));
                }
                catch (Exception e) {
                    AuditLogger.error(e, "type for property " + descriptor.getName() + " of type " + bean.getClass() + " not bound after unexpected exception: " + e, new Object[0]);
                }
            }
            return descriptor;
        }

        private Collection<PropertyDescriptor> getProperties(Object bean) {
            Map<String, PropertyDescriptor> descriptors = this.getDescriptors();
            if (this.annotated) {
                ArrayList<PropertyDescriptor> boundDescriptors = new ArrayList<PropertyDescriptor>(descriptors.size());
                for (PropertyDescriptor descriptor : descriptors.values()) {
                    Method typeMethod = descriptor.getTypeMethod();
                    if (typeMethod != null) {
                        try {
                            descriptor = new PropertyDescriptor(descriptor, (Class)typeMethod.invoke(bean, new Object[0]));
                        }
                        catch (Exception e) {
                            AuditLogger.error(e, "type for property " + descriptor.getName() + " of type " + bean.getClass() + " not bound after unexpected exception: " + e, new Object[0]);
                        }
                    }
                    boundDescriptors.add(descriptor);
                }
                return boundDescriptors;
            }
            return descriptors.values();
        }
    }
}

