/*
 * Decompiled with CFR 0.152.
 */
package ilog.views.graphlayout.internalutil.genericgrapher;

import ilog.views.IlvRect;
import ilog.views.graphlayout.IlvGraphLayout;
import ilog.views.graphlayout.IlvGraphModel;
import ilog.views.graphlayout.internalutil.LayoutUtil;
import ilog.views.graphlayout.internalutil.LogResUtil;
import ilog.views.graphlayout.internalutil.genericgrapher.IlvAbstractGraphAdapter;
import ilog.views.graphlayout.internalutil.genericgrapher.IlvAbstractGraphElement;
import ilog.views.graphlayout.internalutil.genericgrapher.IlvAbstractLink;
import ilog.views.graphlayout.internalutil.genericgrapher.IlvAbstractNode;
import java.util.Enumeration;
import java.util.NoSuchElementException;
import java.util.Vector;

public class IlvAbstractGraph
extends IlvAbstractNode {
    private Vector a = new Vector(20);
    private Vector b;
    private Vector c;
    private Enumeration d;

    public IlvAbstractGraph(IlvGraphModel ilvGraphModel) {
        super(ilvGraphModel, ilvGraphModel.boundingBox());
    }

    public IlvGraphModel getGraphModel() {
        return (IlvGraphModel)this.getOriginalObject();
    }

    public void addAbstractGraphAdapter(IlvAbstractGraphAdapter ilvAbstractGraphAdapter) {
        this.a.addElement(ilvAbstractGraphAdapter);
    }

    public void addNode(IlvAbstractNode ilvAbstractNode) {
        if (ilvAbstractNode.hasParent(this)) {
            Object[] objectArray = new Object[]{ilvAbstractNode, this};
            LogResUtil.logAndThrowIllegalArgExc(IlvGraphLayout.class, "graphlayout.expert.message.6040E", objectArray);
        }
        if (this.b == null) {
            this.b = new Vector(25, 25);
        }
        this.b.addElement(ilvAbstractNode);
        ilvAbstractNode.a(this);
        this.setStructureUpToDate(false);
    }

    public void addLink(IlvAbstractLink ilvAbstractLink) {
        if (ilvAbstractLink.hasParent(this)) {
            Object[] objectArray = new Object[]{ilvAbstractLink, this};
            LogResUtil.logAndThrowIllegalArgExc(IlvGraphLayout.class, "graphlayout.expert.message.6041E", objectArray);
        }
        if (this.b == null) {
            LogResUtil.logAndThrowIllegalArgExc(IlvGraphLayout.class, "graphlayout.expert.message.6064E");
        }
        if (!ilvAbstractLink.getFrom().hasParent(this)) {
            LogResUtil.logAndThrowIllegalArgExc(IlvGraphLayout.class, "graphlayout.expert.message.6065E");
        }
        if (!ilvAbstractLink.getTo().hasParent(this)) {
            LogResUtil.logAndThrowIllegalArgExc(IlvGraphLayout.class, "graphlayout.expert.message.6066E");
        }
        if (this.c == null) {
            this.c = new Vector(50, 50);
        }
        this.c.addElement(ilvAbstractLink);
        ilvAbstractLink.a(this);
        ilvAbstractLink.getFrom().a(ilvAbstractLink);
        ilvAbstractLink.getTo().c(ilvAbstractLink);
        this.setStructureUpToDate(false);
    }

    public void removeObject(IlvAbstractGraphElement ilvAbstractGraphElement) {
        if (ilvAbstractGraphElement instanceof IlvAbstractLink) {
            this.removeLink((IlvAbstractLink)ilvAbstractGraphElement);
        } else if (ilvAbstractGraphElement instanceof IlvAbstractNode) {
            this.removeNode((IlvAbstractNode)ilvAbstractGraphElement);
        } else {
            LogResUtil.logAndThrowIllegalArgExc(IlvGraphLayout.class, "graphlayout.expert.message.6067E");
        }
    }

    public void removeLink(IlvAbstractLink ilvAbstractLink) {
        ilvAbstractLink.getFrom().b(ilvAbstractLink);
        ilvAbstractLink.getTo().d(ilvAbstractLink);
        ilvAbstractLink.b(this);
        if (this.c != null) {
            this.c.removeElement(ilvAbstractLink);
        }
        this.setStructureUpToDate(false);
    }

    public void removeNode(IlvAbstractNode ilvAbstractNode) {
        Enumeration enumeration = this.getLinksFrom(ilvAbstractNode);
        Enumeration enumeration2 = this.getLinksTo(ilvAbstractNode);
        ilvAbstractNode.h();
        ilvAbstractNode.i();
        while (enumeration.hasMoreElements()) {
            IlvAbstractLink ilvAbstractLink = (IlvAbstractLink)enumeration.nextElement();
            if (ilvAbstractLink.getTo() == ilvAbstractNode) continue;
            this.removeLink(ilvAbstractLink);
        }
        while (enumeration2.hasMoreElements()) {
            this.removeLink((IlvAbstractLink)enumeration2.nextElement());
        }
        ilvAbstractNode.b(this);
        if (this.b != null) {
            this.b.removeElement(ilvAbstractNode);
        }
        this.setStructureUpToDate(false);
    }

    public void deleteAll() {
        Object object;
        Enumeration enumeration = this.getNodes();
        while (enumeration.hasMoreElements()) {
            object = (IlvAbstractNode)enumeration.nextElement();
            ((IlvAbstractGraphElement)object).b(this);
        }
        object = this.getLinks();
        while (object.hasMoreElements()) {
            IlvAbstractLink ilvAbstractLink = (IlvAbstractLink)object.nextElement();
            ilvAbstractLink.b(this);
        }
        this.b = null;
        this.c = null;
        this.setStructureUpToDate(false);
    }

    private void a(IlvAbstractNode ilvAbstractNode) {
        block5: {
            block4: {
                if (ilvAbstractNode == null) {
                    LogResUtil.logAndThrowIllegalArgExc(IlvGraphLayout.class, "graphlayout.expert.message.6068E");
                }
                if (this.b == null) break block4;
                if (ilvAbstractNode.hasParent(this)) break block5;
            }
            LogResUtil.logAndThrowIllegalArgExc(IlvGraphLayout.class, "graphlayout.expert.message.6069E");
        }
    }

    public Enumeration getNodesAndLinks() {
        if (this.b == null) {
            return this.getLinks();
        }
        if (this.c == null) {
            return this.getNodes();
        }
        return new IlvDoubleVectorEnumerator(this.b, this.c);
    }

    public Enumeration getNodes() {
        if (this.b == null) {
            if (this.d == null) {
                this.d = LayoutUtil.GetVoidEnumeration();
            }
            return this.d;
        }
        return this.b.elements();
    }

    public final Vector getNodesVector() {
        return this.b;
    }

    public int getNodesCount() {
        if (this.b == null) {
            return 0;
        }
        return this.b.size();
    }

    public Enumeration getLinks() {
        if (this.c == null) {
            if (this.d == null) {
                this.d = LayoutUtil.GetVoidEnumeration();
            }
            return this.d;
        }
        return this.c.elements();
    }

    public Vector getLinksVector() {
        return this.c;
    }

    public int getLinksCount() {
        if (this.c == null) {
            return 0;
        }
        return this.c.size();
    }

    public Enumeration getLinksFrom(IlvAbstractNode ilvAbstractNode) {
        this.a(ilvAbstractNode);
        return ilvAbstractNode.d();
    }

    public int getLinksFromCount(IlvAbstractNode ilvAbstractNode) {
        this.a(ilvAbstractNode);
        return ilvAbstractNode.e();
    }

    public Enumeration getLinksTo(IlvAbstractNode ilvAbstractNode) {
        this.a(ilvAbstractNode);
        return ilvAbstractNode.b();
    }

    public int getLinksToCount(IlvAbstractNode ilvAbstractNode) {
        this.a(ilvAbstractNode);
        return ilvAbstractNode.c();
    }

    public Enumeration getLinks(IlvAbstractNode ilvAbstractNode) {
        this.a(ilvAbstractNode);
        return ilvAbstractNode.f();
    }

    public int getLinksCount(IlvAbstractNode ilvAbstractNode) {
        this.a(ilvAbstractNode);
        return ilvAbstractNode.g();
    }

    public Enumeration getNeighbors(IlvAbstractNode ilvAbstractNode) {
        this.a(ilvAbstractNode);
        return new IlvNeighborsEnumeration(ilvAbstractNode, this.getLinks(ilvAbstractNode));
    }

    public IlvAbstractNode getOpposite(IlvAbstractLink ilvAbstractLink, IlvAbstractNode ilvAbstractNode) {
        return ilvAbstractLink.getOpposite(ilvAbstractNode);
    }

    public IlvAbstractNode getFrom(IlvAbstractLink ilvAbstractLink) {
        return ilvAbstractLink.getFrom();
    }

    public IlvAbstractNode getTo(IlvAbstractLink ilvAbstractLink) {
        return ilvAbstractLink.getTo();
    }

    public boolean isNode(IlvAbstractGraphElement ilvAbstractGraphElement) {
        return ilvAbstractGraphElement != null && ilvAbstractGraphElement instanceof IlvAbstractNode && this.b != null && ilvAbstractGraphElement.hasParent(this);
    }

    public boolean isLink(IlvAbstractGraphElement ilvAbstractGraphElement) {
        return ilvAbstractGraphElement != null && ilvAbstractGraphElement instanceof IlvAbstractLink && this.c != null && ilvAbstractGraphElement.hasParent(this);
    }

    public boolean isLinkBetween(IlvAbstractNode ilvAbstractNode, IlvAbstractNode ilvAbstractNode2) {
        IlvAbstractLink ilvAbstractLink;
        this.a(ilvAbstractNode);
        this.a(ilvAbstractNode2);
        Enumeration enumeration = this.getLinksFrom(ilvAbstractNode);
        while (enumeration.hasMoreElements()) {
            ilvAbstractLink = (IlvAbstractLink)enumeration.nextElement();
            if (ilvAbstractLink.getTo() != ilvAbstractNode2) continue;
            return true;
        }
        enumeration = this.getLinksFrom(ilvAbstractNode2);
        while (enumeration.hasMoreElements()) {
            ilvAbstractLink = (IlvAbstractLink)enumeration.nextElement();
            if (ilvAbstractLink.getTo() != ilvAbstractNode) continue;
            return true;
        }
        return false;
    }

    public void move(IlvAbstractNode ilvAbstractNode, float f, float f2) {
        ilvAbstractNode.a(f, f2);
        this.setGeometryUpToDate(false);
    }

    public IlvRect boundingBox(IlvAbstractNode ilvAbstractNode) {
        return ilvAbstractNode.boundingBox();
    }

    public void setStructureUpToDate(boolean bl) {
        if (this.a == null || bl) {
            return;
        }
        for (int i = 0; i < this.a.size(); ++i) {
            IlvAbstractGraphAdapter ilvAbstractGraphAdapter = (IlvAbstractGraphAdapter)this.a.elementAt(i);
            ilvAbstractGraphAdapter.structChanged();
        }
    }

    public void setGeometryUpToDate(boolean bl) {
        if (this.a == null || bl) {
            return;
        }
        for (int i = 0; i < this.a.size(); ++i) {
            IlvAbstractGraphAdapter ilvAbstractGraphAdapter = (IlvAbstractGraphAdapter)this.a.elementAt(i);
            ilvAbstractGraphAdapter.geomChanged();
        }
    }

    class IlvDoubleVectorEnumerator
    implements Enumeration {
        Vector a;
        Vector b;
        int c;

        IlvDoubleVectorEnumerator(Vector vector, Vector vector2) {
            this.a = vector;
            this.b = vector2;
            this.c = 0;
        }

        @Override
        public boolean hasMoreElements() {
            if (this.a == null && this.b == null) {
                return false;
            }
            if (this.a == null) {
                return this.c < this.b.size();
            }
            if (this.b == null) {
                return this.c < this.a.size();
            }
            return this.c < this.a.size() + this.b.size();
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public Object nextElement() {
            int n = 0;
            int n2 = 0;
            if (this.a != null) {
                n = this.a.size();
            }
            if (this.b != null) {
                n2 = this.b.size();
            }
            if (n > 0) {
                if (this.c < n) {
                    Vector vector = this.a;
                    synchronized (vector) {
                        return this.a.elementAt(this.c++);
                    }
                }
                if (n2 > 0) {
                    if (this.c - n < n2) {
                        Vector vector = this.b;
                        synchronized (vector) {
                            return this.b.elementAt(this.c++ - n);
                        }
                    }
                    throw new NoSuchElementException("IlvDoubleVectorEnumerator");
                }
            } else if (n2 > 0 && this.c < n2) {
                Vector vector = this.b;
                synchronized (vector) {
                    return this.b.elementAt(this.c++);
                }
            }
            throw new NoSuchElementException("IlvDoubleVectorEnumerator");
        }
    }

    final class IlvNeighborsEnumeration
    implements Enumeration {
        Enumeration a;
        IlvAbstractNode b;

        IlvNeighborsEnumeration(IlvAbstractNode ilvAbstractNode, Enumeration enumeration) {
            this.b = ilvAbstractNode;
            this.a = enumeration;
        }

        @Override
        public boolean hasMoreElements() {
            return this.a.hasMoreElements();
        }

        public Object nextElement() {
            if (!this.hasMoreElements()) {
                throw new NoSuchElementException("IlvNeighborsEnumeration");
            }
            IlvAbstractLink ilvAbstractLink = (IlvAbstractLink)this.a.nextElement();
            return ilvAbstractLink.getOpposite(this.b);
        }
    }
}

