/*
 * Decompiled with CFR 0.152.
 */
package ilog.views.hypergraph.crossing;

import ilog.views.IlvApplyObject;
import ilog.views.IlvGrapher;
import ilog.views.IlvGraphic;
import ilog.views.IlvGraphicBag;
import ilog.views.IlvGraphicEnumeration;
import ilog.views.IlvGraphicFilter;
import ilog.views.IlvManager;
import ilog.views.IlvManagerLayer;
import ilog.views.IlvManagerView;
import ilog.views.IlvPoint;
import ilog.views.IlvRect;
import ilog.views.IlvTransformer;
import ilog.views.event.ManagerContentChangedEvent;
import ilog.views.event.ManagerContentChangedListener;
import ilog.views.event.ObjectInsertedEvent;
import ilog.views.event.ObjectLayerChangedEvent;
import ilog.views.event.ObjectRemovedEvent;
import ilog.views.event.ObjectVisibilityChangedEvent;
import ilog.views.hypergraph.crossing.IlvCrossing;
import ilog.views.hypergraph.crossing.IlvCrossingAwareObject;
import ilog.views.hypergraph.crossing.IlvCrossingAwareSegment;
import ilog.views.hypergraph.crossing.IlvCrossingOwner;
import ilog.views.hypergraph.crossing.IlvParameterizedCrossingAwareObject;
import java.util.Enumeration;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Vector;

public class IlvCrossingCalculation {
    private static final String a = "__IlvCrossingCalculationHorizontalPreferred".intern();
    private static final String b = "__IlvCrossingCalculationNestedCalculation".intern();
    private static final String c = "__IlvCrossingAwareObjectNumPerLayer".intern();

    private IlvCrossingCalculation() {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void calculateCrossings(IlvCrossingAwareObject ilvCrossingAwareObject, IlvTransformer ilvTransformer, IlvManagerView ilvManagerView, boolean bl, boolean bl2) {
        if (!ilvCrossingAwareObject.isCrossingEnabled()) {
            return;
        }
        IlvGraphic ilvGraphic = ilvCrossingAwareObject.getCrossingAwareGraphic();
        IlvManager ilvManager = IlvCrossingCalculation.getOwningManager(ilvGraphic);
        if (ilvManager == null) {
            return;
        }
        if (ilvManagerView != null) {
            ilvTransformer = ilvManager.getDrawingTransformer(ilvManagerView);
        }
        CalcCrossingsApplyObject calcCrossingsApplyObject = new CalcCrossingsApplyObject();
        calcCrossingsApplyObject.a = ilvCrossingAwareObject;
        calcCrossingsApplyObject.b = ilvTransformer;
        calcCrossingsApplyObject.e = bl;
        calcCrossingsApplyObject.d = ilvManagerView;
        ilvCrossingAwareObject.setCrossingAdjusting(true);
        IlvCrossingCalculation.a(ilvManager, bl2, true);
        try {
            ilvCrossingAwareObject.removeAllCrossings(ilvTransformer);
            if (bl2) {
                IlvManager ilvManager2 = (IlvManager)ilvGraphic.getTopLevelGraphicBag();
                if (ilvManager2 == null) {
                    return;
                }
                IlvTransformer ilvTransformer2 = ilvManager.getTopLevelTransformer();
                IlvTransformer ilvTransformer3 = new IlvTransformer();
                ilvTransformer2.computeInverse(ilvTransformer3);
                ilvTransformer3.compose(ilvTransformer);
                IlvRect ilvRect = ilvGraphic.boundingBox(ilvTransformer);
                IlvRect ilvRect2 = new IlvRect(ilvRect);
                ilvTransformer3.inverse(ilvRect2);
                IlvCrossingCalculation.a(ilvManager2, ilvRect2, ilvRect, ilvTransformer3, calcCrossingsApplyObject, true);
            } else {
                IlvRect ilvRect = ilvGraphic.boundingBox(ilvTransformer);
                IlvRect ilvRect3 = new IlvRect(ilvRect);
                if (ilvTransformer != null) {
                    ilvTransformer.inverse(ilvRect3);
                }
                IlvCrossingCalculation.a(ilvManager, ilvRect3, ilvRect, ilvTransformer, calcCrossingsApplyObject, false);
            }
        }
        finally {
            IlvCrossingCalculation.a(ilvManager, bl2, false);
            ilvCrossingAwareObject.setCrossingAdjusting(false);
        }
    }

    private static void a(IlvManager ilvManager, IlvRect ilvRect, IlvRect ilvRect2, IlvTransformer ilvTransformer, CalcCrossingsApplyObject calcCrossingsApplyObject, boolean bl) {
        IlvManagerLayer ilvManagerLayer;
        ContentChangedListener.a((IlvGraphicBag)ilvManager, true);
        calcCrossingsApplyObject.c = ilvTransformer;
        int n = ilvManager.getLayersCount();
        for (int i = 0; i < n; ++i) {
            ilvManagerLayer = ilvManager.getManagerLayer(i);
            if (IlvCrossingCalculation.a(ilvManagerLayer) <= 0) continue;
            ilvManagerLayer.mapIntersects(ilvRect, ilvRect2, (IlvApplyObject)calcCrossingsApplyObject, null, ilvTransformer);
        }
        if (bl) {
            IlvGraphicEnumeration ilvGraphicEnumeration = ilvManager.getManagers();
            while (ilvGraphicEnumeration.hasMoreElements()) {
                ilvManagerLayer = (IlvManager)ilvGraphicEnumeration.nextElement();
                if (!ilvManagerLayer.intersects(ilvRect, ilvRect2, ilvTransformer)) continue;
                IlvTransformer ilvTransformer2 = ilvManagerLayer.getTransformer();
                ilvTransformer2.compose(ilvTransformer);
                IlvRect ilvRect3 = new IlvRect(ilvRect2);
                ilvTransformer2.inverse(ilvRect3);
                IlvCrossingCalculation.a((IlvManager)ilvManagerLayer, ilvRect3, ilvRect2, ilvTransformer2, calcCrossingsApplyObject, true);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void calculateCrossings(IlvManager ilvManager, HashSet hashSet, IlvManagerView ilvManagerView, boolean bl, boolean bl2) {
        int n;
        Vector<IlvGraphic> vector = new Vector<IlvGraphic>();
        IlvGraphicEnumeration ilvGraphicEnumeration = ilvManager.getObjects(bl2);
        while (ilvGraphicEnumeration.hasMoreElements()) {
            IlvGraphic ilvGraphic = ilvGraphicEnumeration.nextElement();
            if (!(ilvGraphic instanceof IlvCrossingAwareObject) || hashSet.contains(ilvGraphic)) continue;
            vector.addElement(ilvGraphic);
        }
        int n2 = hashSet.size();
        int n3 = vector.size();
        int n4 = 0;
        IlvCrossingAwareObject[] ilvCrossingAwareObjectArray = new IlvCrossingAwareObject[n2];
        Iterator iterator = hashSet.iterator();
        while (iterator.hasNext()) {
            ilvCrossingAwareObjectArray[n4++] = (IlvCrossingAwareObject)iterator.next();
        }
        IlvCrossingCalculation.a(ilvManager, bl2, true);
        for (n = 0; n < n2; ++n) {
            ilvCrossingAwareObjectArray[n].setCrossingAdjusting(true);
        }
        try {
            Object object;
            for (n = 0; n < n2; ++n) {
                IlvGraphic ilvGraphic = ilvCrossingAwareObjectArray[n].getCrossingAwareGraphic();
                object = IlvCrossingCalculation.getOwningManager(ilvGraphic);
                if (object == null) continue;
                IlvTransformer ilvTransformer = object.getDrawingTransformer(ilvManagerView);
                ilvCrossingAwareObjectArray[n].removeAllCrossings(ilvTransformer);
            }
            for (n = 0; n < n2; ++n) {
                int n5;
                if (!ilvCrossingAwareObjectArray[n].isCrossingEnabled()) continue;
                for (n5 = n; n5 < n2; ++n5) {
                    if (!ilvCrossingAwareObjectArray[n5].isCrossingEnabled()) continue;
                    IlvCrossingCalculation.calculateCrossings(ilvCrossingAwareObjectArray[n], ilvCrossingAwareObjectArray[n5], null, null, ilvManagerView, bl);
                }
                for (n5 = 0; n5 < n3; ++n5) {
                    object = (IlvCrossingAwareObject)vector.elementAt(n5);
                    if (!object.isCrossingEnabled()) continue;
                    IlvCrossingCalculation.calculateCrossings(ilvCrossingAwareObjectArray[n], (IlvCrossingAwareObject)object, null, null, ilvManagerView, bl);
                }
            }
        }
        finally {
            for (n = n2 - 1; n >= 0; --n) {
                ilvCrossingAwareObjectArray[n].setCrossingAdjusting(false);
            }
            IlvCrossingCalculation.a(ilvManager, bl2, false);
        }
    }

    static void a(IlvManager ilvManager, boolean bl, boolean bl2) {
        if (ilvManager == null) {
            return;
        }
        ilvManager.setContentsAdjusting(bl2);
        if (bl) {
            IlvGraphicEnumeration ilvGraphicEnumeration = ilvManager.getManagers();
            while (ilvGraphicEnumeration.hasMoreElements()) {
                IlvCrossingCalculation.a((IlvManager)ilvGraphicEnumeration.nextElement(), true, bl2);
            }
        }
    }

    public static void calculateCrossings(IlvCrossingAwareObject ilvCrossingAwareObject, IlvCrossingAwareObject ilvCrossingAwareObject2, IlvTransformer ilvTransformer, IlvTransformer ilvTransformer2, IlvManagerView ilvManagerView, boolean bl) {
        IlvCrossingAwareSegment[] ilvCrossingAwareSegmentArray;
        IlvCrossingAwareSegment[] ilvCrossingAwareSegmentArray2;
        ilvCrossingAwareObject.setCrossingAdjusting(true);
        ilvCrossingAwareObject2.setCrossingAdjusting(true);
        if (ilvManagerView != null) {
            ilvCrossingAwareSegmentArray2 = (IlvCrossingAwareSegment[])ilvCrossingAwareObject.getCrossingAwareGraphic().getGraphicBag();
            ilvCrossingAwareSegmentArray = (IlvManager)ilvCrossingAwareObject2.getCrossingAwareGraphic().getGraphicBag();
            ilvTransformer = ilvCrossingAwareSegmentArray2.getDrawingTransformer(ilvManagerView);
            ilvTransformer2 = ilvCrossingAwareSegmentArray2 == ilvCrossingAwareSegmentArray ? ilvTransformer : ilvCrossingAwareSegmentArray.getDrawingTransformer(ilvManagerView);
        }
        ilvCrossingAwareSegmentArray = ilvCrossingAwareSegmentArray2 = ilvCrossingAwareObject.getCrossingAwareSegments(ilvTransformer);
        if (ilvCrossingAwareObject.getCrossingAwareGraphic() != ilvCrossingAwareObject2.getCrossingAwareGraphic()) {
            ilvCrossingAwareSegmentArray = ilvCrossingAwareObject2.getCrossingAwareSegments(ilvTransformer2);
        }
        int n = ilvCrossingAwareSegmentArray2.length;
        int n2 = ilvCrossingAwareSegmentArray.length;
        for (int i = 0; i < n; ++i) {
            IlvCrossingAwareSegment ilvCrossingAwareSegment = ilvCrossingAwareSegmentArray2[i];
            IlvPoint ilvPoint = ilvCrossingAwareSegment.getStartPoint();
            IlvPoint ilvPoint2 = ilvCrossingAwareSegment.getEndPoint();
            double d = ilvPoint.x - ilvPoint2.x;
            double d2 = ilvPoint.y - ilvPoint2.y;
            if (d == 0.0 && d2 == 0.0) continue;
            for (int j = 0; j < n2; ++j) {
                IlvCrossing ilvCrossing;
                double d3;
                double d4;
                IlvCrossingAwareSegment ilvCrossingAwareSegment2 = ilvCrossingAwareSegmentArray[j];
                if (ilvCrossingAwareSegment2.isIncident(ilvCrossingAwareSegment)) continue;
                IlvPoint ilvPoint3 = ilvCrossingAwareSegment2.getStartPoint();
                IlvPoint ilvPoint4 = ilvCrossingAwareSegment2.getEndPoint();
                double d5 = ilvPoint3.x - ilvPoint4.x;
                double d6 = ilvPoint3.y - ilvPoint4.y;
                if (d5 == 0.0 && d6 == 0.0 || ilvCrossingAwareObject.getCrossingAwareGraphic() == ilvCrossingAwareObject2.getCrossingAwareGraphic() && j <= i || (d4 = d * d6) == (d3 = d5 * d2)) continue;
                float f = (float)(((double)ilvPoint.x * d3 - (double)ilvPoint3.x * d4 + (double)(ilvPoint3.y - ilvPoint.y) * d * d5) / (d3 - d4));
                float f2 = (float)(((double)ilvPoint.y * d4 - (double)ilvPoint3.y * d3 + (double)(ilvPoint3.x - ilvPoint.x) * d2 * d6) / (d4 - d3));
                if (!(Math.abs(d) > Math.abs(d2)) ? f2 <= Math.min(ilvPoint.y, ilvPoint2.y) || Math.max(ilvPoint.y, ilvPoint2.y) <= f2 : f <= Math.min(ilvPoint.x, ilvPoint2.x) || Math.max(ilvPoint.x, ilvPoint2.x) <= f) continue;
                if (Math.abs(d5) > Math.abs(d6) ? f <= Math.min(ilvPoint3.x, ilvPoint4.x) || Math.max(ilvPoint3.x, ilvPoint4.x) <= f : f2 <= Math.min(ilvPoint3.y, ilvPoint4.y) || Math.max(ilvPoint3.y, ilvPoint4.y) <= f2) continue;
                double d7 = Math.abs(d) * Math.abs(d6);
                double d8 = Math.abs(d5) * Math.abs(d2);
                boolean bl2 = true;
                if (d7 < d8) {
                    bl2 = !bl;
                } else if (d7 > d8) {
                    bl2 = bl;
                } else {
                    boolean bl3 = bl2 = ilvCrossingAwareObject.hashCode() < ilvCrossingAwareObject2.hashCode();
                }
                if (bl2) {
                    ilvCrossing = ilvCrossingAwareSegment.createCrossing(f, f2, ilvCrossingAwareSegment2);
                    ilvCrossingAwareSegment.getCrossingOwner().addCrossing(ilvCrossing, true);
                    if (!ilvCrossingAwareSegment.getCrossingOwner().isCachingCrossings()) continue;
                    ilvCrossingAwareSegment2.getCrossingOwner().addCrossing(ilvCrossing, false);
                    continue;
                }
                ilvCrossing = ilvCrossingAwareSegment2.createCrossing(f, f2, ilvCrossingAwareSegment);
                ilvCrossingAwareSegment2.getCrossingOwner().addCrossing(ilvCrossing, true);
                if (!ilvCrossingAwareSegment2.getCrossingOwner().isCachingCrossings()) continue;
                ilvCrossingAwareSegment.getCrossingOwner().addCrossing(ilvCrossing, false);
            }
        }
        ilvCrossingAwareObject2.setCrossingAdjusting(false);
        ilvCrossingAwareObject.setCrossingAdjusting(false);
    }

    public static IlvManager getOwningManager(IlvGraphic ilvGraphic) {
        IlvGraphicBag ilvGraphicBag = ilvGraphic.getGraphicBag();
        if (ilvGraphicBag instanceof IlvManager) {
            return (IlvManager)ilvGraphicBag;
        }
        return null;
    }

    public static void removeCrossings(Iterator iterator) {
        while (iterator.hasNext()) {
            IlvCrossing ilvCrossing = (IlvCrossing)iterator.next();
            IlvCrossingOwner ilvCrossingOwner = ilvCrossing.getActiveOwner();
            IlvCrossingOwner ilvCrossingOwner2 = ilvCrossing.getPassiveOwner();
            ilvCrossingOwner2.removeCrossing(ilvCrossing);
            if (!ilvCrossingOwner2.isCachingCrossings()) {
                ilvCrossingOwner.markCrossingCacheInvalid();
            }
            ilvCrossingOwner.removeCrossing(ilvCrossing);
        }
    }

    public static boolean seeEachOther(IlvGraphic ilvGraphic, IlvGraphic ilvGraphic2) {
        IlvGrapher ilvGrapher;
        IlvGrapher ilvGrapher2;
        if (!(ilvGraphic.getGraphicBag() instanceof IlvGrapher)) {
            return false;
        }
        if (!(ilvGraphic2.getGraphicBag() instanceof IlvGrapher)) {
            return false;
        }
        IlvGrapher ilvGrapher3 = (IlvGrapher)ilvGraphic.getGraphicBag();
        if (ilvGrapher3 == (ilvGrapher2 = (IlvGrapher)ilvGraphic2.getGraphicBag())) {
            return true;
        }
        if (ilvGrapher3 == null || ilvGrapher2 == null) {
            return false;
        }
        IlvGrapher ilvGrapher4 = IlvGrapher.getLowestCommonGrapher((IlvGraphic)ilvGraphic, (IlvGraphic)ilvGraphic2);
        boolean bl = false;
        boolean bl2 = false;
        boolean bl3 = false;
        boolean bl4 = false;
        int n = ilvGrapher3.getLayer(ilvGraphic);
        int n2 = ilvGrapher2.getLayer(ilvGraphic2);
        if (ilvGrapher3 != ilvGrapher4) {
            for (ilvGrapher = ilvGrapher3; ilvGrapher != null; ilvGrapher = ilvGrapher.getParent()) {
                if (ilvGrapher.isCollapsed()) {
                    bl3 = true;
                }
                if (ilvGrapher.getFrame() != null && ilvGrapher.getFrame().isOpaque((IlvManager)ilvGrapher)) {
                    bl = true;
                }
                if (ilvGrapher.getGraphicBag() != ilvGrapher4) continue;
                n = ilvGrapher4.getLayer((IlvGraphic)ilvGrapher);
                break;
            }
        }
        if (ilvGrapher2 != ilvGrapher4) {
            for (ilvGrapher = ilvGrapher2; ilvGrapher != null; ilvGrapher = ilvGrapher.getParent()) {
                if (ilvGrapher.isCollapsed()) {
                    bl4 = true;
                }
                if (ilvGrapher.getFrame() != null && ilvGrapher.getFrame().isOpaque((IlvManager)ilvGrapher)) {
                    bl2 = true;
                }
                if (ilvGrapher.getGraphicBag() != ilvGrapher4) continue;
                n2 = ilvGrapher4.getLayer((IlvGraphic)ilvGrapher);
                break;
            }
        }
        if (bl3 || bl4) {
            return false;
        }
        if (bl) {
            if (bl2) {
                return false;
            }
            return n2 >= n;
        }
        if (bl2) {
            return n >= n2;
        }
        return true;
    }

    public static void setHorizontalPreferred(IlvManager ilvManager, boolean bl) {
        if (ilvManager.getGraphicBag() != null) {
            ilvManager = (IlvManager)ilvManager.getTopLevelGraphicBag();
        }
        boolean bl2 = IlvCrossingCalculation.isHorizontalPreferred(ilvManager);
        if (bl) {
            ilvManager.removeProperty(a);
        } else {
            ilvManager.setProperty(a, (Object)a);
        }
        if (bl2 != bl) {
            HashSet hashSet = IlvCrossingCalculation.getCrossingAwareObjects(ilvManager, true, true);
            Enumeration enumeration = ilvManager.getViews();
            while (enumeration.hasMoreElements()) {
                IlvManagerView ilvManagerView = (IlvManagerView)enumeration.nextElement();
                IlvCrossingCalculation.calculateCrossings(ilvManager, hashSet, ilvManagerView, bl, true);
            }
        }
    }

    public static boolean isHorizontalPreferred(IlvManager ilvManager) {
        if (ilvManager.getGraphicBag() != null) {
            ilvManager = (IlvManager)ilvManager.getTopLevelGraphicBag();
        }
        return ilvManager.getProperty(a) == null;
    }

    public static void setNestedCrossingCalculation(IlvManager ilvManager, boolean bl) {
        if (ilvManager.getGraphicBag() != null) {
            ilvManager = (IlvManager)ilvManager.getTopLevelGraphicBag();
        }
        boolean bl2 = IlvCrossingCalculation.isNestedCrossingCalculation(ilvManager);
        if (bl) {
            ilvManager.removeProperty(b);
        } else {
            ilvManager.setProperty(b, (Object)b);
        }
        if (bl2 != bl) {
            HashSet hashSet = IlvCrossingCalculation.getCrossingAwareObjects(ilvManager, true, true);
            Enumeration enumeration = ilvManager.getViews();
            while (enumeration.hasMoreElements()) {
                IlvManagerView ilvManagerView = (IlvManagerView)enumeration.nextElement();
                IlvCrossingCalculation.calculateCrossings(ilvManager, hashSet, ilvManagerView, bl, true);
            }
        }
    }

    public static boolean isNestedCrossingCalculation(IlvManager ilvManager) {
        if (ilvManager.getGraphicBag() != null) {
            ilvManager = (IlvManager)ilvManager.getTopLevelGraphicBag();
        }
        return ilvManager.getProperty(b) == null;
    }

    public static HashSet getCrossingAwareObjects(IlvManager ilvManager, boolean bl, boolean bl2) {
        HashSet<IlvGraphic> hashSet = new HashSet<IlvGraphic>();
        IlvGraphicEnumeration ilvGraphicEnumeration = ilvManager.getObjects(bl);
        while (ilvGraphicEnumeration.hasMoreElements()) {
            IlvGraphic ilvGraphic = ilvGraphicEnumeration.nextElement();
            if (!(ilvGraphic instanceof IlvCrossingAwareObject) || !((IlvCrossingAwareObject)ilvGraphic).isCrossingEnabled() && bl2) continue;
            hashSet.add(ilvGraphic);
        }
        return hashSet;
    }

    public static void setCrossingEnabled(IlvManager ilvManager, boolean bl, IlvGraphicFilter ilvGraphicFilter, final boolean bl2, boolean bl3) {
        IlvApplyObject ilvApplyObject = new IlvApplyObject(){

            public void apply(IlvGraphic ilvGraphic, Object object) {
                ((IlvParameterizedCrossingAwareObject)ilvGraphic).setCrossingEnabled(bl2);
            }
        };
        IlvCrossingCalculation.a(ilvManager, bl, ilvGraphicFilter, ilvApplyObject, bl3);
    }

    public static void setGap(IlvManager ilvManager, boolean bl, IlvGraphicFilter ilvGraphicFilter, final float f, boolean bl2) {
        IlvApplyObject ilvApplyObject = new IlvApplyObject(){

            public void apply(IlvGraphic ilvGraphic, Object object) {
                ((IlvParameterizedCrossingAwareObject)ilvGraphic).setGap(f);
            }
        };
        IlvCrossingCalculation.a(ilvManager, bl, ilvGraphicFilter, ilvApplyObject, bl2);
    }

    public static void setGapZoomable(IlvManager ilvManager, boolean bl, IlvGraphicFilter ilvGraphicFilter, final boolean bl2, boolean bl3) {
        IlvApplyObject ilvApplyObject = new IlvApplyObject(){

            public void apply(IlvGraphic ilvGraphic, Object object) {
                ((IlvParameterizedCrossingAwareObject)ilvGraphic).setGapZoomable(bl2);
            }
        };
        IlvCrossingCalculation.a(ilvManager, bl, ilvGraphicFilter, ilvApplyObject, bl3);
    }

    public static void setLayerOfCrossingGraphic(IlvManager ilvManager, boolean bl, IlvGraphicFilter ilvGraphicFilter, final int n, boolean bl2) {
        IlvApplyObject ilvApplyObject = new IlvApplyObject(){

            public void apply(IlvGraphic ilvGraphic, Object object) {
                ((IlvParameterizedCrossingAwareObject)ilvGraphic).setLayerOfCrossingGraphic(n);
            }
        };
        IlvCrossingCalculation.a(ilvManager, bl, ilvGraphicFilter, ilvApplyObject, bl2);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static void a(IlvManager ilvManager, boolean bl, IlvGraphicFilter ilvGraphicFilter, IlvApplyObject ilvApplyObject, boolean bl2) {
        if (bl2) {
            ilvManager.initReDraws();
        }
        ilvManager.setContentsAdjusting(true, true);
        try {
            HashSet hashSet = IlvCrossingCalculation.getCrossingAwareObjects(ilvManager, bl, false);
            for (IlvGraphic ilvGraphic : hashSet) {
                if (!(ilvGraphic instanceof IlvParameterizedCrossingAwareObject) || ilvGraphicFilter != null && !ilvGraphicFilter.accept(ilvGraphic)) continue;
                if (ilvGraphic.getGraphicBag() != null) {
                    ilvGraphic.getGraphicBag().applyToObject(ilvGraphic, ilvApplyObject, null, bl2);
                    continue;
                }
                ilvApplyObject.apply(ilvGraphic, null);
            }
        }
        finally {
            ilvManager.setContentsAdjusting(false, true);
            if (bl2) {
                ilvManager.reDrawViews();
            }
        }
    }

    static int a(IlvManagerLayer ilvManagerLayer) {
        NumberObjs numberObjs = (NumberObjs)ilvManagerLayer.getProperty(c);
        if (numberObjs == null) {
            return 0;
        }
        return numberObjs.a;
    }

    static final class ContentChangedListener
    implements ManagerContentChangedListener {
        private IlvManager a;
        private int b = 0;
        private static final String c = "__IlvCrossingAwareObjectContentChangedListenerProperty".intern();

        ContentChangedListener() {
        }

        static ContentChangedListener a(IlvGraphicBag ilvGraphicBag, boolean bl) {
            if (ilvGraphicBag == null) {
                return null;
            }
            IlvManager ilvManager = (IlvManager)ilvGraphicBag;
            ContentChangedListener contentChangedListener = (ContentChangedListener)ilvManager.getProperty(c);
            if (contentChangedListener == null && bl) {
                contentChangedListener = new ContentChangedListener();
                contentChangedListener.a = ilvManager;
                contentChangedListener.a.addManagerContentChangedListener((ManagerContentChangedListener)contentChangedListener);
                ilvManager.setProperty(c, (Object)contentChangedListener);
                int n = ilvManager.getLayersCount();
                int n2 = 0;
                for (int i = 0; i < n; ++i) {
                    IlvManagerLayer ilvManagerLayer = ilvManager.getManagerLayer(i);
                    n2 += contentChangedListener.a(ilvManagerLayer);
                }
                contentChangedListener.b = n2;
            }
            return contentChangedListener;
        }

        private void a(IlvGraphic ilvGraphic) {
            if (ilvGraphic instanceof IlvCrossingAwareObject) {
                ++this.b;
                IlvManagerLayer ilvManagerLayer = this.a.getManagerLayer(ilvGraphic);
                this.a(ilvManagerLayer, 1);
            }
        }

        private void a(IlvGraphic ilvGraphic, IlvManagerLayer ilvManagerLayer) {
            if (ilvGraphic instanceof IlvCrossingAwareObject) {
                --this.b;
                if (this.b <= 0) {
                    this.a();
                } else {
                    this.a(ilvManagerLayer, -1);
                }
            }
        }

        private void a() {
            if (this.a != null) {
                int n = this.a.getLayersCount();
                for (int i = 0; i < n; ++i) {
                    IlvManagerLayer ilvManagerLayer = this.a.getManagerLayer(i);
                    ilvManagerLayer.setProperty(c, null);
                }
            }
        }

        private void a(IlvGraphic ilvGraphic, IlvManagerLayer ilvManagerLayer, IlvManagerLayer ilvManagerLayer2) {
            if (ilvGraphic instanceof IlvCrossingAwareObject) {
                if (ilvManagerLayer != null) {
                    this.a(ilvManagerLayer, -1);
                }
                if (ilvManagerLayer2 != null) {
                    this.a(ilvManagerLayer2, 1);
                }
            }
        }

        private void a(IlvGraphic ilvGraphic, boolean bl) {
            IlvCrossingAwareObject ilvCrossingAwareObject;
            IlvGraphic ilvGraphic2;
            if (ilvGraphic instanceof IlvCrossingAwareObject && (ilvGraphic2 = (ilvCrossingAwareObject = (IlvCrossingAwareObject)ilvGraphic).getCrossingGraphic()) != null) {
                boolean bl2 = this.a != null ? this.a.isVisible(ilvGraphic) : ilvGraphic.isVisible();
                IlvManager ilvManager = (IlvManager)ilvGraphic2.getGraphicBag();
                if (ilvManager != null) {
                    ilvManager.setVisible(ilvGraphic2, bl2, true);
                } else {
                    ilvGraphic2.setVisible(bl2);
                }
            }
        }

        private void a(IlvManagerLayer ilvManagerLayer, int n) {
            if (n == 0) {
                return;
            }
            NumberObjs numberObjs = (NumberObjs)ilvManagerLayer.getProperty(c);
            if (numberObjs == null) {
                ilvManagerLayer.setProperty(c, (Object)new NumberObjs(n));
            } else {
                numberObjs.a += n;
                if (numberObjs.a == 0) {
                    ilvManagerLayer.setProperty(c, null);
                }
            }
        }

        int a(IlvManagerLayer ilvManagerLayer) {
            int n = 0;
            IlvGraphicEnumeration ilvGraphicEnumeration = ilvManagerLayer.getElements();
            while (ilvGraphicEnumeration.hasMoreElements()) {
                if (!(ilvGraphicEnumeration.nextElement() instanceof IlvCrossingAwareObject)) continue;
                ++n;
            }
            if (n == 0) {
                ilvManagerLayer.setProperty(c, null);
            } else {
                NumberObjs numberObjs = (NumberObjs)ilvManagerLayer.getProperty(c);
                if (numberObjs == null) {
                    ilvManagerLayer.setProperty(c, (Object)new NumberObjs(n));
                } else {
                    numberObjs.a = n;
                }
            }
            return n;
        }

        public void contentsChanged(ManagerContentChangedEvent managerContentChangedEvent) {
            switch (managerContentChangedEvent.getType()) {
                case 1: {
                    IlvGraphic ilvGraphic = ((ObjectInsertedEvent)managerContentChangedEvent).getGraphicObject();
                    this.a(ilvGraphic);
                    break;
                }
                case 2: {
                    IlvGraphic ilvGraphic = ((ObjectRemovedEvent)managerContentChangedEvent).getGraphicObject();
                    this.a(ilvGraphic, ((ObjectRemovedEvent)managerContentChangedEvent).getLayer());
                    break;
                }
                case 16: {
                    ObjectLayerChangedEvent objectLayerChangedEvent = (ObjectLayerChangedEvent)managerContentChangedEvent;
                    IlvGraphic ilvGraphic = objectLayerChangedEvent.getGraphicObject();
                    this.a(ilvGraphic, objectLayerChangedEvent.getOldLayer(), objectLayerChangedEvent.getNewLayer());
                    break;
                }
                case 8: {
                    ObjectVisibilityChangedEvent objectVisibilityChangedEvent = (ObjectVisibilityChangedEvent)managerContentChangedEvent;
                    IlvGraphic ilvGraphic = objectVisibilityChangedEvent.getGraphicObject();
                    this.a(ilvGraphic, objectVisibilityChangedEvent.isObjectVisible());
                }
            }
        }
    }

    static final class NumberObjs {
        int a;

        NumberObjs(int n) {
            this.a = n;
        }
    }

    private static class CalcCrossingsApplyObject
    implements IlvApplyObject {
        IlvCrossingAwareObject a;
        IlvTransformer b;
        IlvTransformer c;
        IlvManagerView d;
        boolean e;

        private CalcCrossingsApplyObject() {
        }

        public void apply(IlvGraphic ilvGraphic, Object object) {
            IlvCrossingAwareObject ilvCrossingAwareObject;
            if (ilvGraphic instanceof IlvCrossingAwareObject && (ilvCrossingAwareObject = (IlvCrossingAwareObject)ilvGraphic).isCrossingEnabled() && IlvCrossingCalculation.seeEachOther(this.a.getCrossingAwareGraphic(), ilvCrossingAwareObject.getCrossingAwareGraphic())) {
                IlvCrossingCalculation.calculateCrossings(this.a, ilvCrossingAwareObject, this.b, this.c, this.d, this.e);
            }
        }
    }
}

