/*
 * Decompiled with CFR 0.152.
 */
package ilog.views.sdm.graphic;

import ilog.views.IlvDrawSelection;
import ilog.views.IlvGraphic;
import ilog.views.IlvPoint;
import ilog.views.IlvRect;
import ilog.views.IlvSelection;
import ilog.views.graphic.IlvLine;
import ilog.views.io.IlvFieldNotFoundException;
import ilog.views.io.IlvInputStream;
import ilog.views.io.IlvOutputStream;
import ilog.views.io.IlvReadFileException;
import ilog.views.sdm.graphic.IlvGeneralNode;
import java.io.IOException;

public class IlvDefaultLaneGraphic
extends IlvGeneralNode {
    private IlvLine a;
    private boolean b;
    private int c = 4;
    private boolean d = false;

    public IlvDefaultLaneGraphic() {
        this.setLabelPosition(16);
        this.setLabelMode(2);
        this.c = 4;
    }

    public IlvDefaultLaneGraphic(IlvDefaultLaneGraphic ilvDefaultLaneGraphic) {
        super(ilvDefaultLaneGraphic);
        this.c = ilvDefaultLaneGraphic.c;
        this.b = ilvDefaultLaneGraphic.b;
    }

    public IlvDefaultLaneGraphic(IlvInputStream ilvInputStream) throws IlvReadFileException {
        super(ilvInputStream);
        try {
            boolean bl = ilvInputStream.readBoolean("horizontal");
            this.c = bl ? 1 : 4;
        }
        catch (IlvFieldNotFoundException ilvFieldNotFoundException) {
            // empty catch block
        }
        try {
            this.c = ilvInputStream.readInt("side");
        }
        catch (IlvFieldNotFoundException ilvFieldNotFoundException) {
        }
        this.b = ilvInputStream.readBoolean("separator");
    }

    @Override
    public IlvGraphic copy() {
        return new IlvDefaultLaneGraphic(this);
    }

    @Override
    public void write(IlvOutputStream ilvOutputStream) throws IOException {
        super.write(ilvOutputStream);
        ilvOutputStream.write("side", this.c);
        ilvOutputStream.write("separator", this.b);
    }

    public boolean isHorizontal() {
        return this.c == 1;
    }

    public void setHorizontal(boolean bl) {
        this.setSide(bl ? 1 : 4);
    }

    public int getSide() {
        return this.c;
    }

    public void setSide(int n) {
        if (n != 4 && n != 8 && n != 1 && n != 2) {
            throw new IllegalArgumentException("Wrong side " + n);
        }
        if (n != this.c) {
            if (this.getLabelMode() != 0) {
                boolean bl;
                boolean bl2 = this.c == 4 || this.c == 8;
                boolean bl3 = bl = n == 4 || n == 8;
                if (bl2 != bl) {
                    this.realizeNeeded = true;
                }
            }
            this.c = n;
            this.layoutNeeded = true;
        }
    }

    public boolean isSeparatorVisible() {
        return this.b;
    }

    public void setSeparatorVisible(boolean bl) {
        if (bl != this.b) {
            this.b = bl;
            this.realizeNeeded = true;
        }
    }

    @Override
    public void setLabelPosition(int n) {
        if (n != this.getLabelPosition()) {
            this.realizeNeeded = true;
        }
        super.setLabelPosition(n);
    }

    @Override
    public int getLabelPosition() {
        return super.getLabelPosition();
    }

    @Override
    public IlvRect getShapeBBox() {
        if (this.realizeNeeded) {
            this.realize();
        }
        return super.getShapeBBox();
    }

    @Override
    protected void realize() {
        super.realize();
        this.d = false;
        if (this.b && this.getLabelPosition() == 16) {
            if (this.a == null) {
                this.a = new IlvLine(0.0f, 0.0f, 0.0f, 0.0f);
                this.a.setForeground(this.getStrokeColor());
            }
            if (this.a.getGraphicBag() != this) {
                this.addObject((IlvGraphic)this.a, false);
            }
        } else {
            if (this.a != null && this.a.getGraphicBag() == this) {
                this.removeObject((IlvGraphic)this.a, false);
            }
            this.a = null;
        }
    }

    private void b() {
        if (this.getSide() == 1 || this.getSide() == 2) {
            if (!this.d) {
                IlvRect ilvRect = this.getLabelBBox(null);
                IlvPoint ilvPoint = new IlvPoint(ilvRect.x + ilvRect.width / 2.0f, ilvRect.y + ilvRect.height / 2.0f);
                if (this.labels != null) {
                    for (int i = 0; i < this.labels.length; ++i) {
                        IlvGraphic ilvGraphic = this.labels[i];
                        ilvGraphic.rotate(ilvPoint, -90.0);
                    }
                }
                this.d = true;
            }
        } else if (this.d) {
            IlvRect ilvRect = this.getLabelBBox(null);
            IlvPoint ilvPoint = new IlvPoint(ilvRect.x + ilvRect.width / 2.0f, ilvRect.y + ilvRect.height / 2.0f);
            if (this.labels != null) {
                for (int i = 0; i < this.labels.length; ++i) {
                    IlvGraphic ilvGraphic = this.labels[i];
                    ilvGraphic.rotate(ilvPoint, 90.0);
                }
            }
            this.d = false;
        }
    }

    @Override
    protected void doLayout() {
        super.doLayout();
        this.b();
        IlvRect ilvRect = this.getLabelBBox(null);
        IlvRect ilvRect2 = this.getShapeBBox();
        float f = this.getLabelSpacing();
        switch (this.getSide()) {
            case 1: {
                if (this.getLabelPosition() == 16) {
                    this.moveLabel(ilvRect2.x + f, ilvRect2.y + ilvRect2.height / 2.0f - ilvRect.height / 2.0f, null);
                    if (this.a == null) break;
                    this.a.setFrom(new IlvPoint(ilvRect2.x + ilvRect.width + 2.0f * f, ilvRect2.y));
                    this.a.setTo(new IlvPoint(ilvRect2.x + ilvRect.width + 2.0f * f, ilvRect2.y + ilvRect2.height));
                    break;
                }
                this.moveLabel(ilvRect2.x - ilvRect.width - f, ilvRect2.y + ilvRect2.height / 2.0f - ilvRect.height / 2.0f, null);
                break;
            }
            case 2: {
                if (this.getLabelPosition() == 16) {
                    this.moveLabel(ilvRect2.x + ilvRect2.width - ilvRect.width - f, ilvRect2.y + ilvRect2.height / 2.0f - ilvRect.height / 2.0f, null);
                    if (this.a == null) break;
                    this.a.setFrom(new IlvPoint(ilvRect2.x + ilvRect2.width - ilvRect.width - 2.0f * f, ilvRect2.y));
                    this.a.setTo(new IlvPoint(ilvRect2.x + ilvRect2.width - ilvRect.width - 2.0f * f, ilvRect2.y + ilvRect2.height));
                    break;
                }
                this.moveLabel(ilvRect2.x + ilvRect2.width + f, ilvRect2.y + ilvRect2.height / 2.0f - ilvRect.height / 2.0f, null);
                break;
            }
            case 4: {
                if (this.getLabelPosition() == 16) {
                    this.moveLabel(ilvRect2.x + ilvRect2.width / 2.0f - ilvRect.width / 2.0f, ilvRect2.y + f, null);
                    if (this.a == null) break;
                    this.a.setFrom(new IlvPoint(ilvRect2.x, ilvRect2.y + ilvRect.height + 2.0f * f));
                    this.a.setTo(new IlvPoint(ilvRect2.x + ilvRect2.width, ilvRect2.y + ilvRect.height + 2.0f * f));
                    break;
                }
                this.moveLabel(ilvRect2.x + ilvRect2.width / 2.0f - ilvRect.width / 2.0f, ilvRect2.y - ilvRect.height - f, null);
                break;
            }
            case 8: {
                if (this.getLabelPosition() == 16) {
                    this.moveLabel(ilvRect2.x + ilvRect2.width / 2.0f - ilvRect.width / 2.0f, ilvRect2.y + ilvRect2.height - ilvRect.height - f, null);
                    if (this.a == null) break;
                    this.a.setFrom(new IlvPoint(ilvRect2.x, ilvRect2.y + ilvRect2.height - ilvRect.height - 2.0f * f));
                    this.a.setTo(new IlvPoint(ilvRect2.x + ilvRect2.width, ilvRect2.y + ilvRect2.height - ilvRect.height - 2.0f * f));
                    break;
                }
                this.moveLabel(ilvRect2.x + ilvRect2.width / 2.0f - ilvRect.width / 2.0f, ilvRect2.y + ilvRect2.height + f, null);
            }
        }
    }

    public IlvSelection makeSelection() {
        LaneSelection laneSelection = new LaneSelection((IlvGraphic)this);
        return laneSelection;
    }

    @Override
    float a() {
        switch (this.getSide()) {
            case 1: 
            case 2: {
                return this.getShapeHeight();
            }
            case 4: 
            case 8: {
                return this.getShapeWidth();
            }
        }
        return super.a();
    }

    private static class LaneSelection
    extends IlvDrawSelection {
        public LaneSelection(IlvGraphic ilvGraphic) {
            super(ilvGraphic);
        }

        public String getDefaultInteractor() {
            return "ilog.views.sdm.renderer.IlvLaneRenderer$ResizeLaneSelection";
        }
    }
}

