/*
 * Decompiled with CFR 0.152.
 */
package oracle.bali.jle.geom;

import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.io.Serializable;
import oracle.bali.jle.geom.NoninvertibleTransformException;
import oracle.bali.jle.geom.Point2D;

public class AffineTransform
implements Cloneable,
Serializable {
    public static final int IDENTITY = 0;
    public static final int TRANSLATION = 1;
    public static final int UNIFORM_SCALE = 2;
    public static final int GENERAL_SCALE = 4;
    public static final int ANY_SCALE_MASK = 6;
    public static final int QUADRANT_ROTATION = 8;
    public static final int GENERAL_ROTATION = 16;
    public static final int ANY_ROTATION_MASK = 24;
    public static final int GENERAL_TRANSFORM = 32;
    static final int APPLY_TRANSLATE = 1;
    static final int APPLY_SCALE = 2;
    static final int APPLY_SHEAR = 4;
    private static final int HI_SHIFT = 3;
    private static final int HI_TRANSLATE = 8;
    private static final int HI_SCALE = 16;
    private static final int HI_SHEAR = 32;
    double m00;
    double m10;
    double m01;
    double m11;
    double m02;
    double m12;
    transient int state;
    private static int[] rot90conversion = new int[]{4, 5, 4, 5, 2, 3, 6, 7};

    private AffineTransform(double m00, double m10, double m01, double m11, double m02, double m12, int state) {
        this.m00 = m00;
        this.m10 = m10;
        this.m01 = m01;
        this.m11 = m11;
        this.m02 = m02;
        this.m12 = m12;
        this.state = state;
    }

    public AffineTransform() {
        this.m11 = 1.0;
        this.m00 = 1.0;
    }

    public AffineTransform(AffineTransform Tx) {
        this.m00 = Tx.m00;
        this.m10 = Tx.m10;
        this.m01 = Tx.m01;
        this.m11 = Tx.m11;
        this.m02 = Tx.m02;
        this.m12 = Tx.m12;
        this.state = Tx.state;
    }

    public AffineTransform(float m00, float m10, float m01, float m11, float m02, float m12) {
        this.m00 = m00;
        this.m10 = m10;
        this.m01 = m01;
        this.m11 = m11;
        this.m02 = m02;
        this.m12 = m12;
        this.updateState();
    }

    public AffineTransform(float[] flatmatrix) {
        this.m00 = flatmatrix[0];
        this.m10 = flatmatrix[1];
        this.m01 = flatmatrix[2];
        this.m11 = flatmatrix[3];
        if (flatmatrix.length > 5) {
            this.m02 = flatmatrix[4];
            this.m12 = flatmatrix[5];
        }
        this.updateState();
    }

    public AffineTransform(float[][] matrix) {
        this.m00 = matrix[0][0];
        this.m10 = matrix[1][0];
        this.m01 = matrix[0][1];
        this.m11 = matrix[1][1];
        if (matrix[0].length > 2 && matrix[1].length > 2) {
            this.m02 = matrix[0][2];
            this.m12 = matrix[1][2];
        }
        this.updateState();
    }

    public AffineTransform(double m00, double m10, double m01, double m11, double m02, double m12) {
        this.m00 = m00;
        this.m10 = m10;
        this.m01 = m01;
        this.m11 = m11;
        this.m02 = m02;
        this.m12 = m12;
        this.updateState();
    }

    public AffineTransform(double[] flatmatrix) {
        this.m00 = flatmatrix[0];
        this.m10 = flatmatrix[1];
        this.m01 = flatmatrix[2];
        this.m11 = flatmatrix[3];
        if (flatmatrix.length > 5) {
            this.m02 = flatmatrix[4];
            this.m12 = flatmatrix[5];
        }
        this.updateState();
    }

    public AffineTransform(double[][] matrix) {
        this.m00 = matrix[0][0];
        this.m10 = matrix[1][0];
        this.m01 = matrix[0][1];
        this.m11 = matrix[1][1];
        if (matrix[0].length > 2 && matrix[1].length > 2) {
            this.m02 = matrix[0][2];
            this.m12 = matrix[1][2];
        }
        this.updateState();
    }

    public static AffineTransform getTranslateInstance(double tx, double ty) {
        AffineTransform Tx = new AffineTransform();
        Tx.setToTranslation(tx, ty);
        return Tx;
    }

    public static AffineTransform getRotateInstance(double theta) {
        AffineTransform Tx = new AffineTransform();
        Tx.setToRotation(theta);
        return Tx;
    }

    public static AffineTransform getRotateInstance(double theta, double x, double y) {
        AffineTransform Tx = new AffineTransform();
        Tx.setToRotation(theta, x, y);
        return Tx;
    }

    public static AffineTransform getScaleInstance(double sx, double sy) {
        AffineTransform Tx = new AffineTransform();
        Tx.setToScale(sx, sy);
        return Tx;
    }

    public static AffineTransform getShearInstance(double shx, double shy) {
        AffineTransform Tx = new AffineTransform();
        Tx.setToShear(shx, shy);
        return Tx;
    }

    public int getType() {
        int ret = 0;
        switch (this.state) {
            default: {
                this.stateError();
            }
            case 7: {
                ret = 1;
            }
            case 6: {
                if (this.m00 * this.m01 + this.m10 * this.m11 != 0.0) {
                    return 32;
                }
                ret |= 0x10;
                if (this.m00 != this.m11 || this.m01 != -this.m10) {
                    ret |= 4;
                    break;
                }
                if (this.m00 * this.m11 - this.m01 * this.m10 == 1.0) break;
                ret |= 2;
                break;
            }
            case 5: {
                ret = 1;
            }
            case 4: {
                ret |= 8;
                if (this.m01 != -this.m10) {
                    ret |= 4;
                    break;
                }
                if (this.m01 == 1.0 || this.m10 == 1.0) break;
                ret |= 2;
                break;
            }
            case 3: {
                ret = 1;
            }
            case 2: {
                if (this.m00 < 0.0 && this.m11 < 0.0) {
                    ret |= 8;
                }
                if (this.m00 == this.m11) {
                    ret |= 2;
                    break;
                }
                ret |= 4;
                break;
            }
            case 1: {
                ret = 1;
            }
            case 0: 
        }
        return ret;
    }

    public double getDeterminant() {
        return this.m00 * this.m11 - this.m01 * this.m10;
    }

    void updateState() {
        double M3;
        double M2;
        double M1;
        double M0 = this.m01;
        this.state = M0 == 0.0 && (M1 = this.m10) == 0.0 ? ((M0 = this.m00) == 1.0 && (M1 = this.m11) == 1.0 ? (this.m02 != 0.0 || this.m12 != 0.0 ? 1 : 0) : 2 | (this.m02 != 0.0 || this.m12 != 0.0 ? 1 : 0)) : ((M2 = this.m00) == 0.0 && (M3 = this.m11) == 0.0 ? 4 | (this.m02 != 0.0 || this.m12 != 0.0 ? 1 : 0) : 6 | (this.m02 != 0.0 || this.m12 != 0.0 ? 1 : 0));
    }

    private void stateError() {
        throw new InternalError("missing case in transform state switch");
    }

    public void getMatrix(double[] flatmatrix) {
        flatmatrix[0] = this.m00;
        flatmatrix[1] = this.m10;
        flatmatrix[2] = this.m01;
        flatmatrix[3] = this.m11;
        if (flatmatrix.length > 5) {
            flatmatrix[4] = this.m02;
            flatmatrix[5] = this.m12;
        }
    }

    public void getMatrix(double[][] matrix) {
        matrix[0][0] = this.m00;
        matrix[1][0] = this.m10;
        matrix[0][1] = this.m01;
        matrix[1][1] = this.m11;
        matrix[0][2] = this.m02;
        matrix[1][2] = this.m12;
    }

    public double getScaleX() {
        return this.m00;
    }

    public double getScaleY() {
        return this.m11;
    }

    public double getShearX() {
        return this.m01;
    }

    public double getShearY() {
        return this.m10;
    }

    public double getTranslateX() {
        return this.m02;
    }

    public double getTranslateY() {
        return this.m12;
    }

    public void translate(double tx, double ty) {
        switch (this.state) {
            default: {
                this.stateError();
            }
            case 7: {
                this.m02 = tx * this.m00 + ty * this.m01 + this.m02;
                this.m12 = tx * this.m10 + ty * this.m11 + this.m12;
                return;
            }
            case 6: {
                this.m02 = tx * this.m00 + ty * this.m01;
                this.m12 = tx * this.m10 + ty * this.m11;
                this.state = 7;
                return;
            }
            case 5: {
                this.m02 = ty * this.m01 + this.m02;
                this.m12 = tx * this.m10 + this.m12;
                return;
            }
            case 4: {
                this.m02 = ty * this.m01;
                this.m12 = tx * this.m10;
                this.state = 5;
                return;
            }
            case 3: {
                this.m02 = tx * this.m00 + this.m02;
                this.m12 = ty * this.m11 + this.m12;
                return;
            }
            case 2: {
                this.m02 = tx * this.m00;
                this.m12 = ty * this.m11;
                this.state = 3;
                return;
            }
            case 1: {
                this.m02 = tx + this.m02;
                this.m12 = ty + this.m12;
                return;
            }
            case 0: 
        }
        this.m02 = tx;
        this.m12 = ty;
        this.state = 1;
    }

    public void rotate(double theta) {
        double sin = Math.sin(theta);
        double cos = Math.cos(theta);
        if (Math.abs(sin) < 1.0E-15) {
            if (cos < 0.0) {
                this.m00 = -this.m00;
                this.m11 = -this.m11;
                int state = this.state;
                if ((state & 4) != 0) {
                    this.m01 = -this.m01;
                    this.m10 = -this.m10;
                } else {
                    this.state = this.m00 == 1.0 && this.m11 == 1.0 ? state & 0xFFFFFFFD : state | 2;
                }
            }
            return;
        }
        if (Math.abs(cos) < 1.0E-15) {
            if (sin < 0.0) {
                double M0 = this.m00;
                this.m00 = -this.m01;
                this.m01 = M0;
                M0 = this.m10;
                this.m10 = -this.m11;
                this.m11 = M0;
            } else {
                double M0 = this.m00;
                this.m00 = this.m01;
                this.m01 = -M0;
                M0 = this.m10;
                this.m10 = this.m11;
                this.m11 = -M0;
            }
            this.state = rot90conversion[this.state];
            return;
        }
        double M0 = this.m00;
        double M1 = this.m01;
        this.m00 = cos * M0 + sin * M1;
        this.m01 = -sin * M0 + cos * M1;
        M0 = this.m10;
        M1 = this.m11;
        this.m10 = cos * M0 + sin * M1;
        this.m11 = -sin * M0 + cos * M1;
        this.updateState();
    }

    public void rotate(double theta, double x, double y) {
        this.translate(x, y);
        this.rotate(theta);
        this.translate(-x, -y);
    }

    public void scale(double sx, double sy) {
        int state = this.state;
        switch (state) {
            default: {
                this.stateError();
            }
            case 6: 
            case 7: {
                this.m00 *= sx;
                this.m11 *= sy;
            }
            case 4: 
            case 5: {
                this.m01 *= sy;
                this.m10 *= sx;
                return;
            }
            case 2: 
            case 3: {
                this.m00 *= sx;
                this.m11 *= sy;
                return;
            }
            case 0: 
            case 1: 
        }
        this.m00 = sx;
        this.m11 = sy;
        this.state = state | 2;
    }

    public void shear(double shx, double shy) {
        int state = this.state;
        switch (state) {
            default: {
                this.stateError();
            }
            case 6: 
            case 7: {
                double M0 = this.m00;
                double M1 = this.m01;
                this.m00 = M0 + M1 * shy;
                this.m01 = M0 * shx + M1;
                M0 = this.m10;
                M1 = this.m11;
                this.m10 = M0 + M1 * shy;
                this.m11 = M0 * shx + M1;
                return;
            }
            case 4: 
            case 5: {
                this.m00 = this.m01 * shy;
                this.m11 = this.m10 * shx;
                this.state = state | 2;
                return;
            }
            case 2: 
            case 3: {
                this.m01 = this.m00 * shx;
                this.m10 = this.m11 * shy;
                this.state = state | 4;
                return;
            }
            case 0: 
            case 1: 
        }
        this.m01 = shx;
        this.m10 = shy;
        this.state = state | 2 | 4;
    }

    public void setToIdentity() {
        this.m11 = 1.0;
        this.m00 = 1.0;
        this.m12 = 0.0;
        this.m02 = 0.0;
        this.m01 = 0.0;
        this.m10 = 0.0;
        this.state = 0;
    }

    public void setToTranslation(double tx, double ty) {
        this.m00 = 1.0;
        this.m10 = 0.0;
        this.m01 = 0.0;
        this.m11 = 1.0;
        this.m02 = tx;
        this.m12 = ty;
        this.state = 1;
    }

    public void setToRotation(double theta) {
        this.m02 = 0.0;
        this.m12 = 0.0;
        double sin = Math.sin(theta);
        double cos = Math.cos(theta);
        if (Math.abs(sin) < 1.0E-15) {
            this.m10 = 0.0;
            this.m01 = 0.0;
            if (cos < 0.0) {
                this.m11 = -1.0;
                this.m00 = -1.0;
                this.state = 2;
            } else {
                this.m11 = 1.0;
                this.m00 = 1.0;
                this.state = 0;
            }
            return;
        }
        if (Math.abs(cos) < 1.0E-15) {
            this.m11 = 0.0;
            this.m00 = 0.0;
            if (sin < 0.0) {
                this.m01 = 1.0;
                this.m10 = -1.0;
            } else {
                this.m01 = -1.0;
                this.m10 = 1.0;
            }
            this.state = 4;
            return;
        }
        this.m00 = cos;
        this.m01 = -sin;
        this.m10 = sin;
        this.m11 = cos;
        this.state = 6;
    }

    public void setToRotation(double theta, double x, double y) {
        this.setToRotation(theta);
        double sin = this.m10;
        double oneMinusCos = 1.0 - this.m00;
        this.m02 = x * oneMinusCos + y * sin;
        this.m12 = y * oneMinusCos - x * sin;
        this.state |= 1;
    }

    public void setToScale(double sx, double sy) {
        this.m00 = sx;
        this.m10 = 0.0;
        this.m01 = 0.0;
        this.m11 = sy;
        this.m02 = 0.0;
        this.m12 = 0.0;
        this.state = 2;
    }

    public void setToShear(double shx, double shy) {
        this.m00 = 1.0;
        this.m01 = shx;
        this.m10 = shy;
        this.m11 = 1.0;
        this.m02 = 0.0;
        this.m12 = 0.0;
        this.state = 6;
    }

    public void setTransform(AffineTransform Tx) {
        this.m00 = Tx.m00;
        this.m10 = Tx.m10;
        this.m01 = Tx.m01;
        this.m11 = Tx.m11;
        this.m02 = Tx.m02;
        this.m12 = Tx.m12;
        this.state = Tx.state;
    }

    public void setTransform(double m00, double m10, double m01, double m11, double m02, double m12) {
        this.m00 = m00;
        this.m10 = m10;
        this.m01 = m01;
        this.m11 = m11;
        this.m02 = m02;
        this.m12 = m12;
        this.updateState();
    }

    public void concatenate(AffineTransform Tx) {
        int mystate = this.state;
        int txstate = Tx.state;
        switch (txstate << 3 | mystate) {
            case 0: 
            case 1: 
            case 2: 
            case 3: 
            case 4: 
            case 5: 
            case 6: 
            case 7: {
                return;
            }
            case 56: {
                this.m01 = Tx.m01;
                this.m10 = Tx.m10;
            }
            case 24: {
                this.m00 = Tx.m00;
                this.m11 = Tx.m11;
            }
            case 8: {
                this.m02 = Tx.m02;
                this.m12 = Tx.m12;
                this.state = txstate;
                return;
            }
            case 48: {
                this.m01 = Tx.m01;
                this.m10 = Tx.m10;
            }
            case 16: {
                this.m00 = Tx.m00;
                this.m11 = Tx.m11;
                this.state = txstate;
                return;
            }
            case 40: {
                this.m02 = Tx.m02;
                this.m12 = Tx.m12;
            }
            case 32: {
                this.m01 = Tx.m01;
                this.m10 = Tx.m10;
                this.m11 = 0.0;
                this.m00 = 0.0;
                this.state = txstate;
                return;
            }
            case 15: {
                double T02 = Tx.m02;
                double T12 = Tx.m12;
                this.m02 = T02 * this.m00 + T12 * this.m01 + this.m02;
                this.m12 = T02 * this.m10 + T12 * this.m11 + this.m12;
                return;
            }
            case 14: {
                double T02 = Tx.m02;
                double T12 = Tx.m12;
                this.m02 = T02 * this.m00 + T12 * this.m01;
                this.m12 = T02 * this.m10 + T12 * this.m11;
                this.state = 7;
                return;
            }
            case 13: {
                this.m02 = Tx.m12 * this.m01 + this.m02;
                this.m12 = Tx.m02 * this.m10 + this.m12;
                return;
            }
            case 12: {
                this.m02 = Tx.m12 * this.m01;
                this.m12 = Tx.m02 * this.m10;
                this.state = 5;
                return;
            }
            case 11: {
                this.m02 = Tx.m02 * this.m00 + this.m02;
                this.m12 = Tx.m12 * this.m11 + this.m12;
                return;
            }
            case 10: {
                this.m02 = Tx.m02 * this.m00;
                this.m12 = Tx.m12 * this.m11;
                this.state = 3;
                return;
            }
            case 9: {
                this.m02 = Tx.m02 + this.m02;
                this.m12 = Tx.m12 + this.m12;
                return;
            }
            case 22: 
            case 23: {
                double T00 = Tx.m00;
                double T11 = Tx.m11;
                this.m00 *= T00;
                this.m11 *= T11;
                this.m01 *= T11;
                this.m10 *= T00;
                return;
            }
            case 20: 
            case 21: {
                this.m01 *= Tx.m11;
                this.m10 *= Tx.m00;
                return;
            }
            case 18: 
            case 19: {
                this.m00 *= Tx.m00;
                this.m11 *= Tx.m11;
                return;
            }
            case 17: {
                this.m00 = Tx.m00;
                this.m11 = Tx.m11;
                this.state = 3;
                return;
            }
            case 38: 
            case 39: {
                double T01 = Tx.m01;
                double T10 = Tx.m10;
                double M0 = this.m00;
                this.m00 = this.m01 * T10;
                this.m01 = M0 * T01;
                M0 = this.m10;
                this.m10 = this.m11 * T10;
                this.m11 = M0 * T01;
                return;
            }
            case 36: 
            case 37: {
                this.m00 = this.m01 * Tx.m10;
                this.m01 = 0.0;
                this.m11 = this.m10 * Tx.m01;
                this.m10 = 0.0;
                this.state = mystate ^ 6;
                return;
            }
            case 34: 
            case 35: {
                this.m01 = this.m00 * Tx.m01;
                this.m00 = 0.0;
                this.m10 = this.m11 * Tx.m10;
                this.m11 = 0.0;
                this.state = mystate ^ 6;
                return;
            }
            case 33: {
                this.m00 = 0.0;
                this.m01 = Tx.m01;
                this.m10 = Tx.m10;
                this.m11 = 0.0;
                this.state = 5;
                return;
            }
        }
        double T00 = Tx.m00;
        double T01 = Tx.m01;
        double T02 = Tx.m02;
        double T10 = Tx.m10;
        double T11 = Tx.m11;
        double T12 = Tx.m12;
        switch (mystate) {
            default: {
                this.stateError();
            }
            case 6: {
                this.state = mystate | txstate;
            }
            case 7: {
                double M0 = this.m00;
                double M1 = this.m01;
                this.m00 = T00 * M0 + T10 * M1;
                this.m01 = T01 * M0 + T11 * M1;
                this.m02 += T02 * M0 + T12 * M1;
                M0 = this.m10;
                M1 = this.m11;
                this.m10 = T00 * M0 + T10 * M1;
                this.m11 = T01 * M0 + T11 * M1;
                this.m12 += T02 * M0 + T12 * M1;
                return;
            }
            case 4: 
            case 5: {
                double M0 = this.m01;
                this.m00 = T10 * M0;
                this.m01 = T11 * M0;
                this.m02 += T12 * M0;
                M0 = this.m10;
                this.m10 = T00 * M0;
                this.m11 = T01 * M0;
                this.m12 += T02 * M0;
                break;
            }
            case 2: 
            case 3: {
                double M0 = this.m00;
                this.m00 = T00 * M0;
                this.m01 = T01 * M0;
                this.m02 += T02 * M0;
                M0 = this.m11;
                this.m10 = T10 * M0;
                this.m11 = T11 * M0;
                this.m12 += T12 * M0;
                break;
            }
            case 1: {
                this.m00 = T00;
                this.m01 = T01;
                this.m02 += T02;
                this.m10 = T10;
                this.m11 = T11;
                this.m12 += T12;
                this.state = txstate | 1;
                return;
            }
        }
        this.updateState();
    }

    public void preConcatenate(AffineTransform Tx) {
        int mystate = this.state;
        int txstate = Tx.state;
        switch (txstate << 3 | mystate) {
            case 0: 
            case 1: 
            case 2: 
            case 3: 
            case 4: 
            case 5: 
            case 6: 
            case 7: {
                return;
            }
            case 8: 
            case 10: 
            case 12: 
            case 14: {
                this.m02 = Tx.m02;
                this.m12 = Tx.m12;
                this.state = mystate | 1;
                return;
            }
            case 9: 
            case 11: 
            case 13: 
            case 15: {
                this.m02 += Tx.m02;
                this.m12 += Tx.m12;
                return;
            }
            case 16: 
            case 17: {
                this.state = mystate | 2;
            }
            case 18: 
            case 19: 
            case 20: 
            case 21: 
            case 22: 
            case 23: {
                double T00 = Tx.m00;
                double T11 = Tx.m11;
                if ((mystate & 4) != 0) {
                    this.m01 *= T00;
                    this.m10 *= T11;
                    if ((mystate & 2) != 0) {
                        this.m00 *= T00;
                        this.m11 *= T11;
                    }
                } else {
                    this.m00 *= T00;
                    this.m11 *= T11;
                }
                if ((mystate & 1) != 0) {
                    this.m02 *= T00;
                    this.m12 *= T11;
                }
                return;
            }
            case 36: 
            case 37: {
                mystate |= 2;
            }
            case 32: 
            case 33: 
            case 34: 
            case 35: {
                this.state = mystate ^ 4;
            }
            case 38: 
            case 39: {
                double T01 = Tx.m01;
                double T10 = Tx.m10;
                double M0 = this.m00;
                this.m00 = this.m10 * T01;
                this.m10 = M0 * T10;
                M0 = this.m01;
                this.m01 = this.m11 * T01;
                this.m11 = M0 * T10;
                M0 = this.m02;
                this.m02 = this.m12 * T01;
                this.m12 = M0 * T10;
                return;
            }
        }
        double T00 = Tx.m00;
        double T01 = Tx.m01;
        double T02 = Tx.m02;
        double T10 = Tx.m10;
        double T11 = Tx.m11;
        double T12 = Tx.m12;
        switch (mystate) {
            default: {
                this.stateError();
            }
            case 7: {
                double M0 = this.m02;
                double M1 = this.m12;
                T02 += M0 * T00 + M1 * T01;
                T12 += M0 * T10 + M1 * T11;
            }
            case 6: {
                this.m02 = T02;
                this.m12 = T12;
                double M0 = this.m00;
                double M1 = this.m10;
                this.m00 = M0 * T00 + M1 * T01;
                this.m10 = M0 * T10 + M1 * T11;
                M0 = this.m01;
                M1 = this.m11;
                this.m01 = M0 * T00 + M1 * T01;
                this.m11 = M0 * T10 + M1 * T11;
                break;
            }
            case 5: {
                double M0 = this.m02;
                double M1 = this.m12;
                T02 += M0 * T00 + M1 * T01;
                T12 += M0 * T10 + M1 * T11;
            }
            case 4: {
                this.m02 = T02;
                this.m12 = T12;
                double M0 = this.m10;
                this.m00 = M0 * T01;
                this.m10 = M0 * T11;
                M0 = this.m01;
                this.m01 = M0 * T00;
                this.m11 = M0 * T10;
                break;
            }
            case 3: {
                double M0 = this.m02;
                double M1 = this.m12;
                T02 += M0 * T00 + M1 * T01;
                T12 += M0 * T10 + M1 * T11;
            }
            case 2: {
                this.m02 = T02;
                this.m12 = T12;
                double M0 = this.m00;
                this.m00 = M0 * T00;
                this.m10 = M0 * T10;
                M0 = this.m11;
                this.m01 = M0 * T01;
                this.m11 = M0 * T11;
                break;
            }
            case 1: {
                double M0 = this.m02;
                double M1 = this.m12;
                T02 += M0 * T00 + M1 * T01;
                T12 += M0 * T10 + M1 * T11;
            }
            case 0: {
                this.m02 = T02;
                this.m12 = T12;
                this.m00 = T00;
                this.m10 = T10;
                this.m01 = T01;
                this.m11 = T11;
                this.state = mystate | txstate;
                return;
            }
        }
        this.updateState();
    }

    public AffineTransform createInverse() throws NoninvertibleTransformException {
        switch (this.state) {
            default: {
                this.stateError();
            }
            case 7: {
                double det = this.m00 * this.m11 - this.m01 * this.m10;
                if (Math.abs(det) <= Double.MIN_VALUE) {
                    throw new NoninvertibleTransformException("Determinant is " + det);
                }
                return new AffineTransform(this.m11 / det, -this.m10 / det, -this.m01 / det, this.m00 / det, (this.m01 * this.m12 - this.m11 * this.m02) / det, (this.m10 * this.m02 - this.m00 * this.m12) / det, 7);
            }
            case 6: {
                double det = this.m00 * this.m11 - this.m01 * this.m10;
                if (Math.abs(det) <= Double.MIN_VALUE) {
                    throw new NoninvertibleTransformException("Determinant is " + det);
                }
                return new AffineTransform(this.m11 / det, -this.m10 / det, -this.m01 / det, this.m00 / det, 0.0, 0.0, 6);
            }
            case 5: {
                if (this.m01 == 0.0 || this.m10 == 0.0) {
                    throw new NoninvertibleTransformException("Determinant is 0");
                }
                return new AffineTransform(0.0, 1.0 / this.m01, 1.0 / this.m10, 0.0, -this.m12 / this.m10, -this.m02 / this.m01, 5);
            }
            case 4: {
                if (this.m01 == 0.0 || this.m10 == 0.0) {
                    throw new NoninvertibleTransformException("Determinant is 0");
                }
                return new AffineTransform(0.0, 1.0 / this.m01, 1.0 / this.m10, 0.0, 0.0, 0.0, 4);
            }
            case 3: {
                if (this.m00 == 0.0 || this.m11 == 0.0) {
                    throw new NoninvertibleTransformException("Determinant is 0");
                }
                return new AffineTransform(1.0 / this.m00, 0.0, 0.0, 1.0 / this.m11, -this.m02 / this.m00, -this.m12 / this.m11, 3);
            }
            case 2: {
                if (this.m00 == 0.0 || this.m11 == 0.0) {
                    throw new NoninvertibleTransformException("Determinant is 0");
                }
                return new AffineTransform(1.0 / this.m00, 0.0, 0.0, 1.0 / this.m11, 0.0, 0.0, 2);
            }
            case 1: {
                return new AffineTransform(1.0, 0.0, 0.0, 1.0, -this.m02, -this.m12, 1);
            }
            case 0: 
        }
        return new AffineTransform();
    }

    public Point2D transform(Point2D ptSrc, Point2D ptDst) {
        if (ptDst == null) {
            ptDst = ptSrc instanceof Point2D.Double ? new Point2D.Double() : new Point2D.Float();
        }
        double x = ptSrc.getX();
        double y = ptSrc.getY();
        switch (this.state) {
            default: {
                this.stateError();
            }
            case 7: {
                ptDst.setLocation(x * this.m00 + y * this.m01 + this.m02, x * this.m10 + y * this.m11 + this.m12);
                return ptDst;
            }
            case 6: {
                ptDst.setLocation(x * this.m00 + y * this.m01, x * this.m10 + y * this.m11);
                return ptDst;
            }
            case 5: {
                ptDst.setLocation(y * this.m01 + this.m02, x * this.m10 + this.m12);
                return ptDst;
            }
            case 4: {
                ptDst.setLocation(y * this.m01, x * this.m10);
                return ptDst;
            }
            case 3: {
                ptDst.setLocation(x * this.m00 + this.m02, y * this.m11 + this.m12);
                return ptDst;
            }
            case 2: {
                ptDst.setLocation(x * this.m00, y * this.m11);
                return ptDst;
            }
            case 1: {
                ptDst.setLocation(x + this.m02, y + this.m12);
                return ptDst;
            }
            case 0: 
        }
        ptDst.setLocation(x, y);
        return ptDst;
    }

    public void transform(Point2D[] ptSrc, int srcOff, Point2D[] ptDst, int dstOff, int numPts) {
        int state = this.state;
        block10: while (--numPts >= 0) {
            Point2D dst;
            Point2D src = ptSrc[srcOff++];
            double x = src.getX();
            double y = src.getY();
            if ((dst = ptDst[dstOff++]) == null) {
                dst = src instanceof Point2D.Double ? new Point2D.Double() : new Point2D.Float();
                ptDst[dstOff - 1] = dst;
            }
            switch (state) {
                default: {
                    this.stateError();
                }
                case 7: {
                    dst.setLocation(x * this.m00 + y * this.m01 + this.m02, x * this.m10 + y * this.m11 + this.m12);
                    continue block10;
                }
                case 6: {
                    dst.setLocation(x * this.m00 + y * this.m01, x * this.m10 + y * this.m11);
                    continue block10;
                }
                case 5: {
                    dst.setLocation(y * this.m01 + this.m02, x * this.m10 + this.m12);
                    continue block10;
                }
                case 4: {
                    dst.setLocation(y * this.m01, x * this.m10);
                    continue block10;
                }
                case 3: {
                    dst.setLocation(x * this.m00 + this.m02, y * this.m11 + this.m12);
                    continue block10;
                }
                case 2: {
                    dst.setLocation(x * this.m00, y * this.m11);
                    continue block10;
                }
                case 1: {
                    dst.setLocation(x + this.m02, y + this.m12);
                    continue block10;
                }
                case 0: 
            }
            dst.setLocation(x, y);
        }
    }

    public void transform(float[] srcPts, int srcOff, float[] dstPts, int dstOff, int numPts) {
        if (dstPts == srcPts && dstOff > srcOff && dstOff < srcOff + numPts * 2) {
            System.arraycopy(srcPts, srcOff, dstPts, dstOff, numPts * 2);
            srcOff = dstOff;
        }
        switch (this.state) {
            default: {
                this.stateError();
            }
            case 7: {
                double M00 = this.m00;
                double M01 = this.m01;
                double M02 = this.m02;
                double M10 = this.m10;
                double M11 = this.m11;
                double M12 = this.m12;
                while (--numPts >= 0) {
                    double x = srcPts[srcOff++];
                    double y = srcPts[srcOff++];
                    dstPts[dstOff++] = (float)(M00 * x + M01 * y + M02);
                    dstPts[dstOff++] = (float)(M10 * x + M11 * y + M12);
                }
                return;
            }
            case 6: {
                double M00 = this.m00;
                double M01 = this.m01;
                double M10 = this.m10;
                double M11 = this.m11;
                while (--numPts >= 0) {
                    double x = srcPts[srcOff++];
                    double y = srcPts[srcOff++];
                    dstPts[dstOff++] = (float)(M00 * x + M01 * y);
                    dstPts[dstOff++] = (float)(M10 * x + M11 * y);
                }
                return;
            }
            case 5: {
                double M01 = this.m01;
                double M02 = this.m02;
                double M10 = this.m10;
                double M12 = this.m12;
                while (--numPts >= 0) {
                    double x = srcPts[srcOff++];
                    dstPts[dstOff++] = (float)(M01 * (double)srcPts[srcOff++] + M02);
                    dstPts[dstOff++] = (float)(M10 * x + M12);
                }
                return;
            }
            case 4: {
                double M01 = this.m01;
                double M10 = this.m10;
                while (--numPts >= 0) {
                    double x = srcPts[srcOff++];
                    dstPts[dstOff++] = (float)(M01 * (double)srcPts[srcOff++]);
                    dstPts[dstOff++] = (float)(M10 * x);
                }
                return;
            }
            case 3: {
                double M00 = this.m00;
                double M02 = this.m02;
                double M11 = this.m11;
                double M12 = this.m12;
                while (--numPts >= 0) {
                    dstPts[dstOff++] = (float)(M00 * (double)srcPts[srcOff++] + M02);
                    dstPts[dstOff++] = (float)(M11 * (double)srcPts[srcOff++] + M12);
                }
                return;
            }
            case 2: {
                double M00 = this.m00;
                double M11 = this.m11;
                while (--numPts >= 0) {
                    dstPts[dstOff++] = (float)(M00 * (double)srcPts[srcOff++]);
                    dstPts[dstOff++] = (float)(M11 * (double)srcPts[srcOff++]);
                }
                return;
            }
            case 1: {
                double M02 = this.m02;
                double M12 = this.m12;
                while (--numPts >= 0) {
                    dstPts[dstOff++] = (float)((double)srcPts[srcOff++] + M02);
                    dstPts[dstOff++] = (float)((double)srcPts[srcOff++] + M12);
                }
                return;
            }
            case 0: 
        }
        if (srcPts != dstPts || srcOff != dstOff) {
            System.arraycopy(srcPts, srcOff, dstPts, dstOff, numPts * 2);
        }
    }

    public void transform(double[] srcPts, int srcOff, double[] dstPts, int dstOff, int numPts) {
        if (dstPts == srcPts && dstOff > srcOff && dstOff < srcOff + numPts * 2) {
            System.arraycopy(srcPts, srcOff, dstPts, dstOff, numPts * 2);
            srcOff = dstOff;
        }
        switch (this.state) {
            default: {
                this.stateError();
            }
            case 7: {
                double M00 = this.m00;
                double M01 = this.m01;
                double M02 = this.m02;
                double M10 = this.m10;
                double M11 = this.m11;
                double M12 = this.m12;
                while (--numPts >= 0) {
                    double x = srcPts[srcOff++];
                    double y = srcPts[srcOff++];
                    dstPts[dstOff++] = M00 * x + M01 * y + M02;
                    dstPts[dstOff++] = M10 * x + M11 * y + M12;
                }
                return;
            }
            case 6: {
                double M00 = this.m00;
                double M01 = this.m01;
                double M10 = this.m10;
                double M11 = this.m11;
                while (--numPts >= 0) {
                    double x = srcPts[srcOff++];
                    double y = srcPts[srcOff++];
                    dstPts[dstOff++] = M00 * x + M01 * y;
                    dstPts[dstOff++] = M10 * x + M11 * y;
                }
                return;
            }
            case 5: {
                double M01 = this.m01;
                double M02 = this.m02;
                double M10 = this.m10;
                double M12 = this.m12;
                while (--numPts >= 0) {
                    double x = srcPts[srcOff++];
                    dstPts[dstOff++] = M01 * srcPts[srcOff++] + M02;
                    dstPts[dstOff++] = M10 * x + M12;
                }
                return;
            }
            case 4: {
                double M01 = this.m01;
                double M10 = this.m10;
                while (--numPts >= 0) {
                    double x = srcPts[srcOff++];
                    dstPts[dstOff++] = M01 * srcPts[srcOff++];
                    dstPts[dstOff++] = M10 * x;
                }
                return;
            }
            case 3: {
                double M00 = this.m00;
                double M02 = this.m02;
                double M11 = this.m11;
                double M12 = this.m12;
                while (--numPts >= 0) {
                    dstPts[dstOff++] = M00 * srcPts[srcOff++] + M02;
                    dstPts[dstOff++] = M11 * srcPts[srcOff++] + M12;
                }
                return;
            }
            case 2: {
                double M00 = this.m00;
                double M11 = this.m11;
                while (--numPts >= 0) {
                    dstPts[dstOff++] = M00 * srcPts[srcOff++];
                    dstPts[dstOff++] = M11 * srcPts[srcOff++];
                }
                return;
            }
            case 1: {
                double M02 = this.m02;
                double M12 = this.m12;
                while (--numPts >= 0) {
                    dstPts[dstOff++] = srcPts[srcOff++] + M02;
                    dstPts[dstOff++] = srcPts[srcOff++] + M12;
                }
                return;
            }
            case 0: 
        }
        if (srcPts != dstPts || srcOff != dstOff) {
            System.arraycopy(srcPts, srcOff, dstPts, dstOff, numPts * 2);
        }
    }

    public void transform(float[] srcPts, int srcOff, double[] dstPts, int dstOff, int numPts) {
        switch (this.state) {
            default: {
                this.stateError();
            }
            case 7: {
                double M00 = this.m00;
                double M01 = this.m01;
                double M02 = this.m02;
                double M10 = this.m10;
                double M11 = this.m11;
                double M12 = this.m12;
                while (--numPts >= 0) {
                    double x = srcPts[srcOff++];
                    double y = srcPts[srcOff++];
                    dstPts[dstOff++] = M00 * x + M01 * y + M02;
                    dstPts[dstOff++] = M10 * x + M11 * y + M12;
                }
                return;
            }
            case 6: {
                double M00 = this.m00;
                double M01 = this.m01;
                double M10 = this.m10;
                double M11 = this.m11;
                while (--numPts >= 0) {
                    double x = srcPts[srcOff++];
                    double y = srcPts[srcOff++];
                    dstPts[dstOff++] = M00 * x + M01 * y;
                    dstPts[dstOff++] = M10 * x + M11 * y;
                }
                return;
            }
            case 5: {
                double M01 = this.m01;
                double M02 = this.m02;
                double M10 = this.m10;
                double M12 = this.m12;
                while (--numPts >= 0) {
                    double x = srcPts[srcOff++];
                    dstPts[dstOff++] = M01 * (double)srcPts[srcOff++] + M02;
                    dstPts[dstOff++] = M10 * x + M12;
                }
                return;
            }
            case 4: {
                double M01 = this.m01;
                double M10 = this.m10;
                while (--numPts >= 0) {
                    double x = srcPts[srcOff++];
                    dstPts[dstOff++] = M01 * (double)srcPts[srcOff++];
                    dstPts[dstOff++] = M10 * x;
                }
                return;
            }
            case 3: {
                double M00 = this.m00;
                double M02 = this.m02;
                double M11 = this.m11;
                double M12 = this.m12;
                while (--numPts >= 0) {
                    dstPts[dstOff++] = M00 * (double)srcPts[srcOff++] + M02;
                    dstPts[dstOff++] = M11 * (double)srcPts[srcOff++] + M12;
                }
                return;
            }
            case 2: {
                double M00 = this.m00;
                double M11 = this.m11;
                while (--numPts >= 0) {
                    dstPts[dstOff++] = M00 * (double)srcPts[srcOff++];
                    dstPts[dstOff++] = M11 * (double)srcPts[srcOff++];
                }
                return;
            }
            case 1: {
                double M02 = this.m02;
                double M12 = this.m12;
                while (--numPts >= 0) {
                    dstPts[dstOff++] = (double)srcPts[srcOff++] + M02;
                    dstPts[dstOff++] = (double)srcPts[srcOff++] + M12;
                }
                return;
            }
            case 0: 
        }
        while (--numPts >= 0) {
            dstPts[dstOff++] = srcPts[srcOff++];
            dstPts[dstOff++] = srcPts[srcOff++];
        }
    }

    public void transform(double[] srcPts, int srcOff, float[] dstPts, int dstOff, int numPts) {
        switch (this.state) {
            default: {
                this.stateError();
            }
            case 7: {
                double M00 = this.m00;
                double M01 = this.m01;
                double M02 = this.m02;
                double M10 = this.m10;
                double M11 = this.m11;
                double M12 = this.m12;
                while (--numPts >= 0) {
                    double x = srcPts[srcOff++];
                    double y = srcPts[srcOff++];
                    dstPts[dstOff++] = (float)(M00 * x + M01 * y + M02);
                    dstPts[dstOff++] = (float)(M10 * x + M11 * y + M12);
                }
                return;
            }
            case 6: {
                double M00 = this.m00;
                double M01 = this.m01;
                double M10 = this.m10;
                double M11 = this.m11;
                while (--numPts >= 0) {
                    double x = srcPts[srcOff++];
                    double y = srcPts[srcOff++];
                    dstPts[dstOff++] = (float)(M00 * x + M01 * y);
                    dstPts[dstOff++] = (float)(M10 * x + M11 * y);
                }
                return;
            }
            case 5: {
                double M01 = this.m01;
                double M02 = this.m02;
                double M10 = this.m10;
                double M12 = this.m12;
                while (--numPts >= 0) {
                    double x = srcPts[srcOff++];
                    dstPts[dstOff++] = (float)(M01 * srcPts[srcOff++] + M02);
                    dstPts[dstOff++] = (float)(M10 * x + M12);
                }
                return;
            }
            case 4: {
                double M01 = this.m01;
                double M10 = this.m10;
                while (--numPts >= 0) {
                    double x = srcPts[srcOff++];
                    dstPts[dstOff++] = (float)(M01 * srcPts[srcOff++]);
                    dstPts[dstOff++] = (float)(M10 * x);
                }
                return;
            }
            case 3: {
                double M00 = this.m00;
                double M02 = this.m02;
                double M11 = this.m11;
                double M12 = this.m12;
                while (--numPts >= 0) {
                    dstPts[dstOff++] = (float)(M00 * srcPts[srcOff++] + M02);
                    dstPts[dstOff++] = (float)(M11 * srcPts[srcOff++] + M12);
                }
                return;
            }
            case 2: {
                double M00 = this.m00;
                double M11 = this.m11;
                while (--numPts >= 0) {
                    dstPts[dstOff++] = (float)(M00 * srcPts[srcOff++]);
                    dstPts[dstOff++] = (float)(M11 * srcPts[srcOff++]);
                }
                return;
            }
            case 1: {
                double M02 = this.m02;
                double M12 = this.m12;
                while (--numPts >= 0) {
                    dstPts[dstOff++] = (float)(srcPts[srcOff++] + M02);
                    dstPts[dstOff++] = (float)(srcPts[srcOff++] + M12);
                }
                return;
            }
            case 0: 
        }
        while (--numPts >= 0) {
            dstPts[dstOff++] = (float)srcPts[srcOff++];
            dstPts[dstOff++] = (float)srcPts[srcOff++];
        }
    }

    public Point2D inverseTransform(Point2D ptSrc, Point2D ptDst) throws NoninvertibleTransformException {
        if (ptDst == null) {
            ptDst = ptSrc instanceof Point2D.Double ? new Point2D.Double() : new Point2D.Float();
        }
        double x = ptSrc.getX();
        double y = ptSrc.getY();
        switch (this.state) {
            default: {
                this.stateError();
            }
            case 7: {
                x -= this.m02;
                y -= this.m12;
            }
            case 6: {
                double det = this.m00 * this.m11 - this.m01 * this.m10;
                if (Math.abs(det) <= Double.MIN_VALUE) {
                    throw new NoninvertibleTransformException("Determinant is " + det);
                }
                ptDst.setLocation((x * this.m11 - y * this.m01) / det, (y * this.m00 - x * this.m10) / det);
                return ptDst;
            }
            case 5: {
                x -= this.m02;
                y -= this.m12;
            }
            case 4: {
                if (this.m01 == 0.0 || this.m10 == 0.0) {
                    throw new NoninvertibleTransformException("Determinant is 0");
                }
                ptDst.setLocation(y / this.m10, x / this.m01);
                return ptDst;
            }
            case 3: {
                x -= this.m02;
                y -= this.m12;
            }
            case 2: {
                if (this.m00 == 0.0 || this.m11 == 0.0) {
                    throw new NoninvertibleTransformException("Determinant is 0");
                }
                ptDst.setLocation(x / this.m00, y / this.m11);
                return ptDst;
            }
            case 1: {
                ptDst.setLocation(x - this.m02, y - this.m12);
                return ptDst;
            }
            case 0: 
        }
        ptDst.setLocation(x, y);
        return ptDst;
    }

    public void inverseTransform(double[] srcPts, int srcOff, double[] dstPts, int dstOff, int numPts) throws NoninvertibleTransformException {
        if (dstPts == srcPts && dstOff > srcOff && dstOff < srcOff + numPts * 2) {
            System.arraycopy(srcPts, srcOff, dstPts, dstOff, numPts * 2);
            srcOff = dstOff;
        }
        switch (this.state) {
            default: {
                this.stateError();
            }
            case 7: {
                double M00 = this.m00;
                double M01 = this.m01;
                double M02 = this.m02;
                double M10 = this.m10;
                double M11 = this.m11;
                double M12 = this.m12;
                double det = M00 * M11 - M01 * M10;
                if (Math.abs(det) <= Double.MIN_VALUE) {
                    throw new NoninvertibleTransformException("Determinant is " + det);
                }
                while (--numPts >= 0) {
                    double x = srcPts[srcOff++] - M02;
                    double y = srcPts[srcOff++] - M12;
                    dstPts[dstOff++] = (x * M11 - y * M01) / det;
                    dstPts[dstOff++] = (y * M00 - x * M10) / det;
                }
                return;
            }
            case 6: {
                double M00 = this.m00;
                double M01 = this.m01;
                double M10 = this.m10;
                double M11 = this.m11;
                double det = M00 * M11 - M01 * M10;
                if (Math.abs(det) <= Double.MIN_VALUE) {
                    throw new NoninvertibleTransformException("Determinant is " + det);
                }
                while (--numPts >= 0) {
                    double x = srcPts[srcOff++];
                    double y = srcPts[srcOff++];
                    dstPts[dstOff++] = (x * M11 - y * M01) / det;
                    dstPts[dstOff++] = (y * M00 - x * M10) / det;
                }
                return;
            }
            case 5: {
                double M01 = this.m01;
                double M02 = this.m02;
                double M10 = this.m10;
                double M12 = this.m12;
                if (M01 == 0.0 || M10 == 0.0) {
                    throw new NoninvertibleTransformException("Determinant is 0");
                }
                while (--numPts >= 0) {
                    double x = srcPts[srcOff++] - M02;
                    dstPts[dstOff++] = (srcPts[srcOff++] - M12) / M01;
                    dstPts[dstOff++] = x / M10;
                }
                return;
            }
            case 4: {
                double M01 = this.m01;
                double M10 = this.m10;
                if (M01 == 0.0 || M10 == 0.0) {
                    throw new NoninvertibleTransformException("Determinant is 0");
                }
                while (--numPts >= 0) {
                    double x = srcPts[srcOff++];
                    dstPts[dstOff++] = srcPts[srcOff++] / M01;
                    dstPts[dstOff++] = x / M10;
                }
                return;
            }
            case 3: {
                double M00 = this.m00;
                double M02 = this.m02;
                double M11 = this.m11;
                double M12 = this.m12;
                if (M00 == 0.0 || M11 == 0.0) {
                    throw new NoninvertibleTransformException("Determinant is 0");
                }
                while (--numPts >= 0) {
                    dstPts[dstOff++] = (srcPts[srcOff++] - M02) / M00;
                    dstPts[dstOff++] = (srcPts[srcOff++] - M12) / M11;
                }
                return;
            }
            case 2: {
                double M00 = this.m00;
                double M11 = this.m11;
                if (M00 == 0.0 || M11 == 0.0) {
                    throw new NoninvertibleTransformException("Determinant is 0");
                }
                while (--numPts >= 0) {
                    dstPts[dstOff++] = srcPts[srcOff++] / M00;
                    dstPts[dstOff++] = srcPts[srcOff++] / M11;
                }
                return;
            }
            case 1: {
                double M02 = this.m02;
                double M12 = this.m12;
                while (--numPts >= 0) {
                    dstPts[dstOff++] = srcPts[srcOff++] - M02;
                    dstPts[dstOff++] = srcPts[srcOff++] - M12;
                }
                return;
            }
            case 0: 
        }
        if (srcPts != dstPts || srcOff != dstOff) {
            System.arraycopy(srcPts, srcOff, dstPts, dstOff, numPts * 2);
        }
    }

    public Point2D deltaTransform(Point2D ptSrc, Point2D ptDst) {
        if (ptDst == null) {
            ptDst = ptSrc instanceof Point2D.Double ? new Point2D.Double() : new Point2D.Float();
        }
        double x = ptSrc.getX();
        double y = ptSrc.getY();
        switch (this.state) {
            default: {
                this.stateError();
            }
            case 6: 
            case 7: {
                ptDst.setLocation(x * this.m00 + y * this.m01, x * this.m10 + y * this.m11);
                return ptDst;
            }
            case 4: 
            case 5: {
                ptDst.setLocation(y * this.m01, x * this.m10);
                return ptDst;
            }
            case 2: 
            case 3: {
                ptDst.setLocation(x * this.m00, y * this.m11);
                return ptDst;
            }
            case 0: 
            case 1: 
        }
        ptDst.setLocation(x, y);
        return ptDst;
    }

    public void deltaTransform(double[] srcPts, int srcOff, double[] dstPts, int dstOff, int numPts) {
        if (dstPts == srcPts && dstOff > srcOff && dstOff < srcOff + numPts * 2) {
            System.arraycopy(srcPts, srcOff, dstPts, dstOff, numPts * 2);
            srcOff = dstOff;
        }
        switch (this.state) {
            default: {
                this.stateError();
            }
            case 6: 
            case 7: {
                double M00 = this.m00;
                double M01 = this.m01;
                double M10 = this.m10;
                double M11 = this.m11;
                while (--numPts >= 0) {
                    double x = srcPts[srcOff++];
                    double y = srcPts[srcOff++];
                    dstPts[dstOff++] = x * M00 + y * M01;
                    dstPts[dstOff++] = x * M10 + y * M11;
                }
                return;
            }
            case 4: 
            case 5: {
                double M01 = this.m01;
                double M10 = this.m10;
                while (--numPts >= 0) {
                    double x = srcPts[srcOff++];
                    dstPts[dstOff++] = srcPts[srcOff++] * M01;
                    dstPts[dstOff++] = x * M10;
                }
                return;
            }
            case 2: 
            case 3: {
                double M00 = this.m00;
                double M11 = this.m11;
                while (--numPts >= 0) {
                    dstPts[dstOff++] = srcPts[srcOff++] * M00;
                    dstPts[dstOff++] = srcPts[srcOff++] * M11;
                }
                return;
            }
            case 0: 
            case 1: 
        }
        if (srcPts != dstPts || srcOff != dstOff) {
            System.arraycopy(srcPts, srcOff, dstPts, dstOff, numPts * 2);
        }
    }

    private static double _matround(double matval) {
        return Math.rint(matval * 1.0E15) / 1.0E15;
    }

    public String toString() {
        return "AffineTransform[[" + AffineTransform._matround(this.m00) + ", " + AffineTransform._matround(this.m01) + ", " + AffineTransform._matround(this.m02) + "], [" + AffineTransform._matround(this.m10) + ", " + AffineTransform._matround(this.m11) + ", " + AffineTransform._matround(this.m12) + "]]";
    }

    public boolean isIdentity() {
        return this.state == 0;
    }

    public Object clone() {
        try {
            return super.clone();
        }
        catch (CloneNotSupportedException e) {
            throw new InternalError();
        }
    }

    public boolean equals(Object obj) {
        if (!(obj instanceof AffineTransform)) {
            return false;
        }
        AffineTransform a = (AffineTransform)obj;
        return this.m00 == a.m00 && this.m01 == a.m01 && this.m02 == a.m02 && this.m10 == a.m10 && this.m11 == a.m11 && this.m12 == a.m12;
    }

    private void writeObject(ObjectOutputStream s) throws ClassNotFoundException, IOException {
        s.defaultWriteObject();
    }

    private void readObject(ObjectInputStream s) throws ClassNotFoundException, IOException {
        s.defaultReadObject();
        this.updateState();
    }
}

