/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.premigration.api;

import com.oracle.premigration.PremigrationApp;
import com.oracle.premigration.cli.CommandLineArgs;
import com.oracle.premigration.commons.EnvironmentContext;
import com.oracle.premigration.commons.GlobalVariables;
import com.oracle.premigration.commons.lang.Language;
import com.oracle.premigration.dbinspector.CheckResult;
import com.oracle.premigration.dbinspector.ExecutionContext;
import com.oracle.premigration.dbinspector.SourceInspector;
import com.oracle.premigration.dbinspector.TargetInspector;
import com.oracle.premigration.exceptions.AccessDeniedException;
import com.oracle.premigration.helpers.AppVersion;
import com.oracle.premigration.helpers.Utilities;
import com.oracle.premigration.logger.PremigrationLogger;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.security.NoSuchAlgorithmException;
import java.sql.SQLException;
import java.util.logging.Level;
import javax.crypto.Cipher;
import oracle.jdbc.OracleDriver;

public class Premigration {
    static final Language lang = Language.getInstanceWithDefaultResources();

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static int run(CommandLineArgs cla, EnvironmentContext envCtx) {
        long startPremigrationRun = System.currentTimeMillis();
        PremigrationLogger log = null;
        String logFilePath = null;
        try {
            if (cla.isVersion()) {
                AppVersion.printVersionInfo(envCtx.getPrintStream());
                int n = CheckResult.PASS.getExitCode();
                return n;
            }
            if (cla.isSimpleVersion()) {
                envCtx.getPrintStream().println(AppVersion.getVersionString());
                int n = CheckResult.PASS.getExitCode();
                return n;
            }
            if (cla.getCompareVersion() != null) {
                int n = AppVersion.compareAppVersion(cla.getCompareVersion());
                return n;
            }
            if (cla.isCheckForUpdates()) {
                int n = AppVersion.checkForUpdates();
                return n;
            }
            cla.processOutFilePrefix();
            logFilePath = Utilities.getValidatedFilePath(cla.getOutdir(), GlobalVariables.LOG_OUTPUT_FILENAME);
            PremigrationLogger.newConfig(logFilePath, cla.getLoggingLevel(), envCtx.getCommandInvocationMode());
            log = PremigrationLogger.getLogger(PremigrationApp.class.getName());
            cla.validate(envCtx);
            String appVersion = AppVersion.getVersionString();
            String banner = lang.txt("APP_BANNER_MSG", appVersion);
            log.info(banner);
            Utilities.logEnvironmentVariables();
            log.info("System.getProperty(\"java.version\"): " + System.getProperty("java.version"));
            log.info("System.getProperty(\"java.class.path\"): " + System.getProperty("java.class.path"));
            log.info("JDBC Driver Version: " + OracleDriver.getDriverVersion());
            try {
                log.info("Cipher.getMaxAllowedKeyLength(\"AES\"): " + Cipher.getMaxAllowedKeyLength("AES"));
            }
            catch (NoSuchAlgorithmException e) {
                log.info("Error calling Cipher.getMaxAllowedKeyLength(\"AES\")", e);
            }
            envCtx.getPrintStream().println(banner);
            log.info("Effective command line: " + cla.getReconstitutedArgs());
            ExecutionContext exeCtx = new ExecutionContext(cla, envCtx);
            CheckResult overallResult = cla.isFetchTargetProps() ? TargetInspector.fetchTargetProps(exeCtx, appVersion) : SourceInspector.analyzeSource(exeCtx, appVersion);
            log.info("Elapsed time executing Premigration Advisor: " + Utilities.formatTimeInterval(System.currentTimeMillis() - startPremigrationRun));
            log.trace("Returning overall integer result to CLI: " + overallResult.getExitCode());
            int e = overallResult.getExitCode();
            return e;
        }
        catch (FileNotFoundException e) {
            String FileErrorMsg = Utilities.getErrorText("ERROR3002", e, new String[0]);
            Premigration.commonErrorHandling(log, envCtx, FileErrorMsg, e);
        }
        catch (AccessDeniedException | IOException e) {
            String ioErrorMsg = PremigrationLogger.isLoggerInitialized() ? Utilities.getErrorText("ERROR3000", e, new String[0]) : Utilities.getErrorTextNoAction("ERROR3000", e, new String[0]);
            Premigration.commonErrorHandling(log, envCtx, ioErrorMsg, e);
        }
        catch (SQLException e) {
            String sqlErrorMsg = Utilities.getErrorText("ERROR1004", e, new String[0]);
            Premigration.commonErrorHandling(log, envCtx, sqlErrorMsg, e);
        }
        catch (Throwable t) {
            String fatalMsg = Utilities.getErrorText("ERROR1005", t, new String[0]);
            Premigration.commonErrorHandling(log, envCtx, fatalMsg, t);
            if (t instanceof ArithmeticException) {
                String msg = lang.txt("APP_POSSIBLE_EXPIRED_ACCOUNT_MSG");
                Utilities.printAndLogErrorMessage(msg, envCtx, Level.SEVERE);
            }
        }
        finally {
            if (log != null) {
                log.shutdown();
            }
        }
        if (PremigrationLogger.isLoggerInitialized() && logFilePath != null) {
            envCtx.getErrWriter().println(lang.txt("APP_LOG_FILE_DETAILS_MSG", logFilePath));
        }
        return CheckResult.FATAL.getExitCode();
    }

    private static void commonErrorHandling(PremigrationLogger log, EnvironmentContext envCtx, String errorMsg, Throwable t) {
        envCtx.getErrWriter().println(errorMsg);
        if (log != null) {
            log.severe(errorMsg, t);
        }
    }
}

