/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.premigration.cli;

import com.oracle.premigration.commons.enums.LoggingLevel;
import com.oracle.premigration.commons.enums.MigrationMethod;
import com.oracle.premigration.commons.enums.ReportFormat;
import com.oracle.premigration.commons.enums.TargetCloud;
import com.oracle.premigration.commons.lang.Language;
import com.oracle.premigration.helpers.Utilities;
import java.util.ArrayList;
import java.util.EnumSet;
import lombok.NonNull;

public enum CliOption {
    HELP("h", "help", "help", "OPT_HELP_MSG", NumParams.TAKES_NO_ARGS, null, false),
    VERSION("v", "version", "version", "OPT_VERSION_MSG", NumParams.TAKES_NO_ARGS, null, false),
    TARGET_CLOUD("t", "targetcloud", "cloudType", "OPT_TARGET_CLOUD_MSG", NumParams.TAKES_ONE_ARG, EnumSet.allOf(TargetCloud.class), true),
    MIGRATION_METHOD("m", "migrationmethod", "migrationMethod", "OPT_MIGRATION_METHOD_MSG", NumParams.TAKES_ONE_OR_MORE_ARGS, EnumSet.allOf(MigrationMethod.class), false),
    CONNECT_STRING("c", "connectstring", "connectString", "OPT_CONNECTION_STRING_MSG", NumParams.TAKES_ONE_ARG, null, true),
    USERNAME("u", "username", "username", "OPT_USERNAME_MSG", NumParams.TAKES_ONE_ARG, null, false),
    SYSDBA("d", "sysdba", null, "OPT_SYSDBA_MSG", NumParams.TAKES_NO_ARGS, null, false),
    PDBNAME("p", "pdbname", "pdbName", "OPT_PDBNAME_MSG", NumParams.TAKES_ONE_ARG, null, false),
    EXCLUDE_SCHEMAS("x", "excludeschemas", "excludeSchemas", "OPT_EXCLUDE_SCHEMAS_MSG", NumParams.TAKES_ONE_OR_MORE_ARGS, null, false),
    FULL("f", "full", null, "OPT_FULL_MSG", NumParams.TAKES_NO_ARGS, null, false),
    SCHEMAS("s", "schemas", "schemaNames", "OPT_SCHEMAS_MSG", NumParams.TAKES_ONE_OR_MORE_ARGS, null, false),
    REPORT_FORMAT("r", "reportformat", "reportFormat", "OPT_REPORT_FORMAT_MSG", NumParams.TAKES_ONE_OR_MORE_ARGS, EnumSet.allOf(ReportFormat.class), false),
    OUTDIR("o", "outdir", "outputDirectory", "OPT_OUTDIR_MSG", NumParams.TAKES_ONE_ARG, null, false),
    OUTFILEPREFIX("P", "outfileprefix", "outFilePrefix", "OPT_OUTFILE_PREFIX_MSG", NumParams.TAKES_ONE_ARG, null, false),
    LOGGINGLEVEL("l", "logginglevel", "loggingLevel", "OPT_LOGGING_LEVEL_MSG", NumParams.TAKES_ONE_ARG, EnumSet.allOf(LoggingLevel.class), false),
    GETTARGETPROPS("g", "gettargetprops", null, "OPT_GET_TARGET_PROPS_MSG", NumParams.TAKES_NO_ARGS, null, true),
    ANALYSISPROPS("a", "analysisprops", "propertyFile", "OPT_ANALYSIS_PROPS_MSG", NumParams.TAKES_ONE_ARG, null, false),
    MAXTEXTROWS("n", "maxtextdatarows", "maxNumDataRows", "OPT_MAX_TEXT_ROWS_MSG", NumParams.TAKES_ONE_ARG, null, false),
    MAXRELEVANTOBJECTS("M", "maxrelevantobjects", "maxRelevantObjects", "OPT_MAX_RELEVANT_OBJECTS_MSG", NumParams.TAKES_ONE_ARG, null, false),
    SQL_IN_TEXT_REPORT("S", "sqltext", null, "OPT_INCLUDE_SQL_IN_TEXT_REPORT", NumParams.TAKES_NO_ARGS, null, false),
    UPDATE_CHECK("U", "updatecheck", null, "OPT_CHECK_FOR_UPDATE_MSG", NumParams.TAKES_NO_ARGS, null, false),
    SIMPLE_VERSION("V", "simpleversion", null, "OPT_SIMPLE_VERSION_MSG", NumParams.TAKES_NO_ARGS, null, false),
    COMPARE_VERSION("C", "compareversion", "simpleVersionString", "OPT_COMPARE_VERSION_MSG", NumParams.TAKES_ONE_ARG, null, false);

    private final String opt;
    private final String longOpt;
    private final String paramName;
    private final String messageKey;
    private final EnumSet<?> allowedValues;
    private final NumParams numParams;
    private final boolean required;
    final Language lang = Language.getInstance();

    private CliOption(String opt, @NonNull String longOpt, @NonNull String paramName, String messageKey, NumParams numParams, EnumSet<?> allowedValues, boolean required) {
        if (opt == null) {
            throw new NullPointerException("opt is marked non-null but is null");
        }
        if (longOpt == null) {
            throw new NullPointerException("longOpt is marked non-null but is null");
        }
        if (messageKey == null) {
            throw new NullPointerException("messageKey is marked non-null but is null");
        }
        if (numParams == null) {
            throw new NullPointerException("numParams is marked non-null but is null");
        }
        this.opt = opt;
        this.longOpt = longOpt;
        this.paramName = paramName;
        this.messageKey = messageKey;
        this.numParams = numParams;
        this.allowedValues = allowedValues;
        this.required = required;
        if (numParams != NumParams.TAKES_NO_ARGS && paramName == null) {
            throw new IllegalArgumentException("paramName cannot be null unless allowedValues is REQUIRED_NEVER");
        }
    }

    public String getOpt() {
        return this.opt;
    }

    public String getLongOpt() {
        return this.longOpt;
    }

    public String getDescription() {
        if (this.allowedValues == null) {
            return this.lang.txt(this.messageKey);
        }
        ArrayList<String> options = new ArrayList<String>();
        for (Enum allowedValue : this.allowedValues) {
            options.add(allowedValue.name().toLowerCase());
        }
        String optionList = Utilities.join(", ", options);
        return this.lang.txt(this.messageKey, optionList);
    }

    public String getParamName() {
        return this.paramName;
    }

    public NumParams getNumParams() {
        return this.numParams;
    }

    public boolean isRequired() {
        return this.required;
    }

    public static enum NumParams {
        TAKES_NO_ARGS,
        TAKES_ONE_ARG,
        TAKES_ONE_OR_MORE_ARGS;

    }
}

