/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.premigration.cli;

import com.oracle.premigration.cli.CliOption;
import com.oracle.premigration.cli.CommandLineArgs;
import com.oracle.premigration.commons.enums.LoggingLevel;
import com.oracle.premigration.commons.enums.MigrationMethod;
import com.oracle.premigration.commons.enums.ReportFormat;
import com.oracle.premigration.commons.enums.TargetCloud;
import com.oracle.premigration.commons.lang.Language;
import java.io.Console;
import java.io.PrintWriter;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.Scanner;
import java.util.logging.Level;
import org.apache.commons.cli.CommandLine;
import org.apache.commons.cli.DefaultParser;
import org.apache.commons.cli.HelpFormatter;
import org.apache.commons.cli.Option;
import org.apache.commons.cli.OptionGroup;
import org.apache.commons.cli.Options;
import org.apache.commons.cli.ParseException;

public class CommandParser {
    private static final Language lang = Language.getInstanceWithDefaultResources();
    private final Options helpOptions = new Options();
    private final Options sourceOptions = new Options();
    private final Options targetOptions = new Options();
    private final Options updateOptions = new Options();

    public CommandParser() {
        OptionGroup helpGroup = this.createGroup(CliOption.HELP, CliOption.VERSION);
        this.helpOptions.addOptionGroup(helpGroup);
        OptionGroup updateGroup = this.createGroup(CliOption.SIMPLE_VERSION, CliOption.COMPARE_VERSION, CliOption.UPDATE_CHECK);
        this.updateOptions.addOptionGroup(updateGroup);
        OptionGroup schemasGroup = this.createGroup(CliOption.SCHEMAS, CliOption.EXCLUDE_SCHEMAS);
        this.sourceOptions.addOptionGroup(schemasGroup);
        this.addOptions(this.sourceOptions, CliOption.TARGET_CLOUD, CliOption.CONNECT_STRING, CliOption.USERNAME, CliOption.SYSDBA, CliOption.PDBNAME, CliOption.FULL, CliOption.MIGRATION_METHOD, CliOption.ANALYSISPROPS, CliOption.OUTDIR, CliOption.OUTFILEPREFIX, CliOption.LOGGINGLEVEL, CliOption.REPORT_FORMAT, CliOption.MAXTEXTROWS, CliOption.SQL_IN_TEXT_REPORT, CliOption.MAXRELEVANTOBJECTS);
        this.addOptions(this.targetOptions, CliOption.GETTARGETPROPS, CliOption.CONNECT_STRING, CliOption.USERNAME, CliOption.SYSDBA, CliOption.PDBNAME, CliOption.OUTDIR, CliOption.OUTFILEPREFIX, CliOption.LOGGINGLEVEL);
    }

    public CommandLineArgs parse(String[] arguments) throws ParseException {
        DefaultParser parser = new DefaultParser();
        CommandLine helpCmd = parser.parse(this.helpOptions, arguments, true);
        if (arguments.length == 0 || helpCmd.hasOption(CliOption.HELP.getLongOpt()) || helpCmd.hasOption(CliOption.VERSION.getLongOpt())) {
            boolean help = arguments.length == 0 || helpCmd.hasOption(CliOption.HELP.getLongOpt());
            return CommandLineArgs.builder().outdir(CommandParser.getDefaultOutputDirectory()).help(help).version(helpCmd.hasOption(CliOption.VERSION.getLongOpt())).build();
        }
        CommandLine updateCmd = parser.parse(this.updateOptions, arguments, true);
        if (updateCmd.hasOption(CliOption.SIMPLE_VERSION.getLongOpt()) || updateCmd.hasOption(CliOption.COMPARE_VERSION.getLongOpt()) || updateCmd.hasOption(CliOption.UPDATE_CHECK.getLongOpt())) {
            String compareVersion = updateCmd.hasOption(CliOption.COMPARE_VERSION.getLongOpt()) ? updateCmd.getOptionValue(CliOption.COMPARE_VERSION.getLongOpt()) : null;
            return CommandLineArgs.builder().outdir(CommandParser.getDefaultOutputDirectory()).simpleVersion(updateCmd.hasOption(CliOption.SIMPLE_VERSION.getLongOpt())).compareVersion(compareVersion).checkForUpdates(updateCmd.hasOption(CliOption.UPDATE_CHECK.getLongOpt())).build();
        }
        try {
            CommandLine targetCmd = parser.parse(this.targetOptions, arguments);
            boolean fetchTargetProps = targetCmd.hasOption(CliOption.GETTARGETPROPS.getLongOpt());
            CommandLineArgs.CommandLineArgsBuilder targetBuilder = CommandLineArgs.builder();
            return CommandParser.buildCommonArgs(targetBuilder, targetCmd).fetchTargetProps(fetchTargetProps).build();
        }
        catch (ParseException pe) {
            List<String> argList = Arrays.asList(arguments);
            if (argList.contains("--" + CliOption.GETTARGETPROPS.getLongOpt()) || argList.contains("-" + CliOption.GETTARGETPROPS.getOpt())) {
                throw pe;
            }
            try {
                CommandLine sourceCmd = parser.parse(this.sourceOptions, arguments);
                TargetCloud cloudType = CommandParser.toTargetCloudType(sourceCmd.getOptionValue(CliOption.TARGET_CLOUD.getLongOpt()));
                boolean forceFull = sourceCmd.hasOption(CliOption.FULL.getLongOpt());
                String[] schemasArray = sourceCmd.hasOption(CliOption.SCHEMAS.getLongOpt()) ? sourceCmd.getOptionValues(CliOption.SCHEMAS.getLongOpt()) : new String[]{};
                ArrayList<String> schemas = new ArrayList<String>(Arrays.asList(schemasArray));
                String[] excludeSchemasArray = sourceCmd.hasOption(CliOption.EXCLUDE_SCHEMAS.getLongOpt()) ? sourceCmd.getOptionValues(CliOption.EXCLUDE_SCHEMAS.getLongOpt()) : new String[]{};
                ArrayList<String> excludeSchemas = new ArrayList<String>(Arrays.asList(excludeSchemasArray));
                ArrayList<MigrationMethod> migrationMethods = new ArrayList<MigrationMethod>();
                if (sourceCmd.hasOption(CliOption.MIGRATION_METHOD.getLongOpt())) {
                    for (String mmString : sourceCmd.getOptionValues(CliOption.MIGRATION_METHOD.getLongOpt())) {
                        migrationMethods.add(CommandParser.toMigrationMethodType(mmString));
                    }
                } else {
                    migrationMethods.add(MigrationMethod.DATAPUMP);
                }
                ArrayList<ReportFormat> reportFormats = new ArrayList<ReportFormat>();
                if (sourceCmd.hasOption(CliOption.REPORT_FORMAT.getLongOpt())) {
                    for (String format : sourceCmd.getOptionValues(CliOption.REPORT_FORMAT.getLongOpt())) {
                        ReportFormat reportFormat = CommandParser.toReportFormatType(format);
                        if (reportFormats.contains((Object)reportFormat)) continue;
                        reportFormats.add(reportFormat);
                    }
                } else {
                    reportFormats.add(ReportFormat.TEXT);
                }
                String analysisPropsFile = sourceCmd.hasOption(CliOption.ANALYSISPROPS.getLongOpt()) ? sourceCmd.getOptionValue(CliOption.ANALYSISPROPS.getLongOpt()) : null;
                Integer maxTextRows = sourceCmd.hasOption(CliOption.MAXTEXTROWS.getLongOpt()) ? Integer.valueOf(sourceCmd.getOptionValue(CliOption.MAXTEXTROWS.getLongOpt())) : null;
                boolean textIncludeSql = sourceCmd.hasOption(CliOption.SQL_IN_TEXT_REPORT.getLongOpt());
                Integer maxRelevantObjects = sourceCmd.hasOption(CliOption.MAXRELEVANTOBJECTS.getLongOpt()) ? Integer.valueOf(sourceCmd.getOptionValue(CliOption.MAXRELEVANTOBJECTS.getLongOpt())) : null;
                CommandLineArgs.CommandLineArgsBuilder sourceBuilder = CommandLineArgs.builder();
                return CommandParser.buildCommonArgs(sourceBuilder, sourceCmd).targetCloud(cloudType).forceFull(forceFull).schemas(schemas).excludeSchemas(excludeSchemas).migrationMethods(migrationMethods).reportFormats(reportFormats).analysisPropertiesFile(analysisPropsFile).maxTextRows(maxTextRows).sqlInTextReport(textIncludeSql).maxRelevantObjects(maxRelevantObjects).build();
            }
            catch (NumberFormatException e) {
                ParseException pe2 = new ParseException(e.getLocalizedMessage());
                pe2.initCause((Throwable)e);
                throw pe2;
            }
        }
    }

    private static CommandLineArgs.CommandLineArgsBuilder buildCommonArgs(CommandLineArgs.CommandLineArgsBuilder claBuilder, CommandLine cmd) {
        Level level;
        String connectString = cmd.hasOption(CliOption.CONNECT_STRING.getLongOpt()) ? cmd.getOptionValue(CliOption.CONNECT_STRING.getLongOpt()) : null;
        String username = null;
        char[] password = new char[]{};
        if (cmd.hasOption(CliOption.USERNAME.getLongOpt())) {
            username = cmd.getOptionValue(CliOption.USERNAME.getLongOpt());
            password = CommandParser.getPassword(username);
        }
        String pdbName = cmd.hasOption(CliOption.PDBNAME.getLongOpt()) ? cmd.getOptionValue(CliOption.PDBNAME.getLongOpt()) : null;
        boolean sysdba = cmd.hasOption(CliOption.SYSDBA.getLongOpt());
        String outdir = cmd.hasOption(CliOption.OUTDIR.getLongOpt()) ? cmd.getOptionValue(CliOption.OUTDIR.getLongOpt()) : CommandParser.getDefaultOutputDirectory();
        String outFilePrefix = cmd.hasOption(CliOption.OUTFILEPREFIX.getLongOpt()) ? cmd.getOptionValue(CliOption.OUTFILEPREFIX.getLongOpt()) : null;
        String loggingLevel = cmd.hasOption(CliOption.LOGGINGLEVEL.getLongOpt()) ? cmd.getOptionValue(CliOption.LOGGINGLEVEL.getLongOpt()) : CommandParser.getDefaultLoggingLevel();
        try {
            level = Level.parse(loggingLevel.toUpperCase());
            Enum.valueOf(LoggingLevel.class, loggingLevel.toUpperCase());
        }
        catch (Exception e) {
            level = Level.FINE;
        }
        return claBuilder.username(username).password(password).connectString(connectString).sysdba(sysdba).pdbName(pdbName).outdir(outdir).loggingLevel(level).outFilePrefix(outFilePrefix);
    }

    private static char[] getPassword(String username) {
        String prompt = lang.txt("PASSWORD_PROMPT_MSG", username);
        Console console = System.console();
        if (console != null) {
            return console.readPassword(prompt, new Object[0]);
        }
        System.out.print(prompt);
        char[] password = new Scanner(System.in).next().toCharArray();
        System.out.println();
        return password;
    }

    public static String getDefaultLoggingLevel() {
        return "FINE";
    }

    public static String getDefaultOutputDirectory() {
        return System.getProperty("user.dir");
    }

    private static Option buildOption(CliOption cliOption) {
        Option.Builder builder = Option.builder((String)cliOption.getOpt()).longOpt(cliOption.getLongOpt()).desc(cliOption.getDescription()).required(cliOption.isRequired());
        switch (cliOption.getNumParams()) {
            case TAKES_NO_ARGS: {
                builder.hasArg(false);
                break;
            }
            case TAKES_ONE_ARG: {
                builder.hasArg(true);
                builder.argName(cliOption.getParamName());
                break;
            }
            case TAKES_ONE_OR_MORE_ARGS: {
                builder.hasArgs();
                builder.argName(cliOption.getParamName());
            }
        }
        return builder.build();
    }

    private OptionGroup createGroup(CliOption ... cliOptions) {
        OptionGroup optionGroup = new OptionGroup();
        for (CliOption cliOption : cliOptions) {
            Option option = CommandParser.buildOption(cliOption);
            optionGroup.addOption(option);
        }
        return optionGroup;
    }

    private void addOptions(Options options, CliOption ... cliOptions) {
        for (CliOption cliOption : cliOptions) {
            Option option = CommandParser.buildOption(cliOption);
            options.addOption(option);
        }
    }

    private static ReportFormat toReportFormatType(String reportFormatStr) throws ParseException {
        try {
            return ReportFormat.valueOf(reportFormatStr.toUpperCase());
        }
        catch (Exception e) {
            ParseException parseException = new ParseException("Not a valid Report Format value: " + reportFormatStr);
            parseException.initCause((Throwable)e);
            throw parseException;
        }
    }

    private static MigrationMethod toMigrationMethodType(String migrationMethodStr) throws ParseException {
        try {
            return MigrationMethod.valueOf(migrationMethodStr.toUpperCase());
        }
        catch (Exception e) {
            ParseException parseException = new ParseException("Not a valid Migration Method value: " + migrationMethodStr);
            parseException.initCause((Throwable)e);
            throw parseException;
        }
    }

    private static TargetCloud toTargetCloudType(String targetCloudStr) throws ParseException {
        try {
            return TargetCloud.valueOf(targetCloudStr.toUpperCase());
        }
        catch (Exception e) {
            ParseException parseException = new ParseException("Not a valid Target Cloud value: " + targetCloudStr);
            parseException.initCause((Throwable)e);
            throw parseException;
        }
    }

    public void printHelp(String premigrationSyntax, PrintWriter pw) {
        HelpFormatter formatter = new HelpFormatter();
        int helpWidth = CommandParser.getHelpWidth();
        formatter.printHelp(pw, helpWidth, premigrationSyntax, lang.txt("CLI_HELP_HEADER_MSG"), this.helpOptions, 1, 3, null, true);
        pw.println();
        formatter.printHelp(pw, helpWidth, premigrationSyntax, lang.txt("CLI_HELP_HEADER_UPDATE_MSG"), this.updateOptions, 1, 3, null, true);
        pw.println();
        formatter.printHelp(pw, helpWidth, premigrationSyntax, lang.txt("CLI_HELP_HEADER_SOURCE_MSG"), this.sourceOptions, 1, 3, null, true);
        pw.println();
        String oracleJavaHomeText = lang.txt("CLI_HELP_FOOTER_MSG");
        formatter.printHelp(pw, helpWidth, premigrationSyntax, lang.txt("CLI_HELP_HEADER_TARGET_MSG"), this.targetOptions, 1, 3, oracleJavaHomeText, true);
        pw.println();
        pw.flush();
    }

    private static int getHelpWidth() {
        int terminalWidth = 74;
        String cpatTerminalWidth = System.getProperty("CPAT_TERMINAL_WIDTH", System.getenv("CPAT_TERMINAL_WIDTH"));
        if (cpatTerminalWidth != null && !cpatTerminalWidth.isEmpty()) {
            try {
                terminalWidth = Integer.parseInt(cpatTerminalWidth);
            }
            catch (Throwable throwable) {
                // empty catch block
            }
        }
        return terminalWidth;
    }
}

