/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.premigration.commons.enums;

public enum TargetInstanceProp {
    CPAT_VERSION(null, null, null),
    PDB_LOCKDOWN("SELECT VALUE FROM V$PARAMETER WHERE LOWER(NAME)='pdb_lockdown'", ""),
    TZ_VERSION("SELECT CAST(VERSION AS VARCHAR2(100)) AS TZ_VERSION FROM V$TIMEZONE_FILE", ""),
    ALLOW_ROWID_COLUMN_TYPE("SELECT VALUE AS VALUE FROM V$PARAMETER WHERE LOWER(NAME)='allow_rowid_column_type'", "FALSE"),
    NLS_CHARACTERSET("SELECT VALUE FROM SYS.NLS_DATABASE_PARAMETERS WHERE LOWER(PARAMETER) = 'nls_characterset'", "AL32UTF8"),
    NLS_NCHAR_CHARACTERSET("SELECT  VALUE FROM SYS.NLS_DATABASE_PARAMETERS WHERE LOWER(PARAMETER) = 'nls_nchar_characterset'", "AL16UTF16"),
    MAX_STRING_SIZE("SELECT VALUE FROM V$PARAMETER WHERE LOWER(NAME) = 'max_string_size'", "EXTENDED"),
    DB_BLOCK_SIZE("SELECT VALUE FROM V$PARAMETER WHERE LOWER(NAME) = 'db_block_size'", ""),
    PROFILES("SELECT LISTAGG(PROFILE,',') WITHIN GROUP( ORDER BY PROFILE) FROM (SELECT DISTINCT PROFILE FROM SYS.DBA_PROFILES) ", ""),
    TABLESPACES("SELECT LISTAGG(TABLESPACE_NAME, ',') WITHIN GROUP (ORDER BY TABLESPACE_NAME)   FROM (SELECT TABLESPACE_NAME FROM SYS.DBA_TABLESPACES) ", ""),
    SYSPRIVILEGE("SELECT LISTAGG(PRIVILEGE,',') WITHIN GROUP( ORDER BY PRIVILEGE) FROM (SELECT PRIVILEGE FROM SYS.DBA_SYS_PRIVS WHERE GRANTEE='ADMIN' AND ADMIN_OPTION='YES') ", ""),
    ROLEPRIVILEGE("SELECT LISTAGG(GRANTED_ROLE, ',') WITHIN GROUP (ORDER BY GRANTED_ROLE) FROM (SELECT DISTINCT GRANTED_ROLE FROM SYS.DBA_ROLE_PRIVS START WITH GRANTEE IN ('ADMIN') CONNECT BY PRIOR GRANTED_ROLE = GRANTEE AND ADMIN_OPTION='YES')", ""),
    DIRECTORIES("SELECT LISTAGG(DIRECTORY_NAME, ',') WITHIN GROUP (ORDER BY DIRECTORY_NAME) FROM (SELECT DIRECTORY_NAME FROM SYS.DBA_DIRECTORIES)", "", "[^a-zA-Z0-9.,_#$\\s]"),
    TABLESPACE_BLOCK_SIZE(null, ""),
    DB_VERSION(null, ""),
    DB_PLATFORM_ID("SELECT PLATFORM_ID FROM V$DATABASE", "");

    private final String propertyKey = ((Object)((Object)this)).getClass().getSimpleName() + "." + this.name();
    private final String sqlQuery;
    private final String defaultValue;
    private final String regexFilter;

    private TargetInstanceProp(String sqlQuery, String defaultValue, String regexFilter) {
        this.defaultValue = defaultValue;
        this.sqlQuery = sqlQuery;
        this.regexFilter = regexFilter;
    }

    private TargetInstanceProp(String sqlQuery, String defaultValue) {
        this(sqlQuery, defaultValue, "[^a-zA-Z0-9.,_#\\s]");
    }

    public String toString() {
        return this.propertyKey;
    }

    public String getKey() {
        return this.propertyKey;
    }

    public String getSqlQuery() {
        return this.sqlQuery;
    }

    public String getKey(String suffix) {
        return this.propertyKey + "." + suffix;
    }

    public String getDefaultValue() {
        return this.defaultValue;
    }

    public String getRegexFilter() {
        return this.regexFilter;
    }
}

