/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.premigration.dbinspector;

import com.oracle.premigration.commons.enums.MigrationMethod;
import com.oracle.premigration.commons.enums.TargetCloud;
import com.oracle.premigration.commons.lang.Language;
import com.oracle.premigration.dbinspector.CheckResult;
import com.oracle.premigration.dbinspector.ExecutionContext;
import com.oracle.premigration.helpers.ResultSetProcessor;
import com.oracle.premigration.helpers.Utilities;
import com.oracle.premigration.logger.PremigrationLogger;
import com.oracle.premigration.reports.CheckFiltrationMetadata;
import com.oracle.premigration.reports.json.CpatJsonIgnore;
import com.oracle.premigration.reports.json.CpatJsonIgnoreIfNull;
import com.oracle.premigration.reports.json.CpatJsonPropertyDescription;
import com.oracle.premigration.reports.text.TextProperty;
import com.oracle.premigration.reports.text.TextReportSectionName;
import com.oracle.premigration.reports.text.TextValueHint;
import com.oracle.premigration.reports.text.serialization.TextReportLabeledValue;
import com.oracle.premigration.reports.text.serialization.TextReportTable;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.List;
import java.util.Map;
import lombok.NonNull;

public abstract class Check {
    private static final PremigrationLogger log = PremigrationLogger.getLogger(Check.class.getName());
    @CpatJsonIgnore
    protected final Language lang = Language.getInstance();
    @TextProperty(labelKey="CHECK_NAME_LABEL", section=TextReportSectionName.CHECK_TITLE, serializationClass=TextReportLabeledValue.class, valueHint=TextValueHint.METADATA)
    @CpatJsonPropertyDescription(value="The name of the check")
    @NonNull
    private final String name;
    @CpatJsonPropertyDescription(value="The flavors of Cloud offerings that the check applies to.")
    private final List<TargetCloud> targetCloud = new ArrayList<TargetCloud>();
    @CpatJsonPropertyDescription(value="The Scope of the Check")
    Scope scope;
    @CpatJsonPropertyDescription(value="The title of the check")
    @NonNull
    private final String title;
    @TextProperty(labelKey="CHECK_1_DESCRIPTION_LABEL", section=TextReportSectionName.CHECK_DETAILS, serializationClass=TextReportLabeledValue.class, valueHint=TextValueHint.NATURAL_LANGUAGE)
    @CpatJsonPropertyDescription(value="The Description of what the check does")
    @NonNull
    private String description;
    @TextProperty(labelKey="CHECK_2_FAILURE_IMPACT_LABEL", section=TextReportSectionName.CHECK_DETAILS, serializationClass=TextReportLabeledValue.class, valueHint=TextValueHint.NATURAL_LANGUAGE)
    @CpatJsonPropertyDescription(value="Text describing what the implications are if the check isn't successful (non PASS outcome)")
    @NonNull
    private final String failureImpact;
    @TextProperty(labelKey="CHECK_4_ACTION_LABEL", section=TextReportSectionName.CHECK_DETAILS, serializationClass=TextReportLabeledValue.class, valueHint=TextValueHint.NATURAL_LANGUAGE)
    @CpatJsonPropertyDescription(value="Text describing what action/recourse a DBA might have when the check isn't successful (non PASS outcome)")
    @NonNull
    private String action;
    @TextProperty(labelKey="CHECK_RESULT_LABEL", section=TextReportSectionName.CHECK_TITLE, serializationClass=TextReportLabeledValue.class, valueHint=TextValueHint.METADATA)
    @CpatJsonPropertyDescription(value="The result of executing this check against the source database/schema(s)Typically the contents of the relevantObjectsData field will be used to determine if the result will be PASS or not.")
    @NonNull
    private CheckResult result;
    @CpatJsonIgnore
    private CheckResult declarativeResult;
    @TextProperty(labelKey="CHECK_3_STATUS_LABEL", section=TextReportSectionName.CHECK_DETAILS, serializationClass=TextReportLabeledValue.class, valueHint=TextValueHint.NATURAL_LANGUAGE)
    @CpatJsonIgnoreIfNull
    @CpatJsonPropertyDescription(value="Should a check run to completion as expected then this field should provide some indication as to the cause")
    private String errorMessage;
    @CpatJsonIgnore
    private String sqlQuery;
    @CpatJsonIgnore
    private Boolean skipExecution = false;
    @CpatJsonIgnore
    private final List<MigrationMethod> migrationMethods = new ArrayList<MigrationMethod>();
    @TextProperty(labelKey="CHECK_5_EXECUTED_SQL_LABEL", section=TextReportSectionName.CHECK_DETAILS, serializationClass=TextReportLabeledValue.class, valueHint=TextValueHint.SQL_TEXT)
    @NonNull
    @CpatJsonPropertyDescription(value="The actual SQL executed to perform this Check. Should represent something someone could copy/paste into SQL Developer.")
    private String executedSQL;
    @TextProperty(labelKey="CHECK_6_RELEVANT_OBJECTS_LABEL", section=TextReportSectionName.CHECK_DETAILS, serializationClass=TextReportTable.class, valueHint=TextValueHint.METADATA)
    @CpatJsonPropertyDescription(value="The list of database objects that are relevant to the check. Sometimes this data is referred to as 'Offending Data'. The structure of the objects in this array varies depending on the needs of each particular check.However, the data for each check will always be uniform with same number and name of attributes per object and all object values being strings")
    private List<Map<String, String>> relevantObjectsData = Collections.emptyList();
    @CpatJsonIgnoreIfNull
    @CpatJsonPropertyDescription(value="Metadata pointers that can be used to derive Analysis Property REPORT_FILTER values that can be used to filter (include/exclude) relevant objects data.")
    private CheckFiltrationMetadata filtrationMetadata;
    @TextProperty(labelKey="CHECK_6B_FILTERED_REL_OBJS_LABEL", section=TextReportSectionName.CHECK_DETAILS, serializationClass=TextReportTable.class, valueHint=TextValueHint.METADATA)
    @CpatJsonIgnoreIfNull
    @CpatJsonPropertyDescription(value="The list of database objects that are relevant to the check but are have been 'filtered out' and are ignored when deriving the result of the check")
    private List<Map<String, String>> filteredObjectsData = null;
    @CpatJsonPropertyDescription(value="The number of relevant objects that were omitted due to the invoker of CPAT specifying a maximum")
    private Integer omittedRelevantObjectsCount = 0;
    public static final Comparator<Check> groupByResult = new Comparator<Check>(){

        @Override
        public int compare(Check o1, Check o2) {
            if (o1.result == o2.result) {
                return o2.relevantObjectsData.size() - o1.relevantObjectsData.size();
            }
            return o2.result.compareSeverityTo(o1.result);
        }
    };

    public Check() {
        this.name = this.getClass().getSimpleName();
        this.title = this.lang.txt("CHECK." + this.name.toUpperCase() + ".SHORT_TITLE");
        this.description = this.lang.txt("CHECK." + this.name.toUpperCase() + ".RULE");
        this.failureImpact = this.lang.txt("CHECK." + this.name.toUpperCase() + ".IMPACT");
        this.action = this.lang.txt("CHECK." + this.name.toUpperCase() + ".ACTION");
    }

    public abstract void prepare(ExecutionContext var1);

    public CheckResult determineResult() {
        if (this.declarativeResult == null) {
            IllegalArgumentException error = new IllegalArgumentException("check " + this.name + " did not override 'determineResult' and did not set 'declarativeResult'");
            String message = Utilities.getErrorText("ERROR4002", error, this.name);
            throw new IllegalArgumentException(message);
        }
        switch (this.declarativeResult) {
            case BLOCKER: {
                return this.blockerIfAnyValidator();
            }
            case WARNING: {
                return this.warningIfAnyValidator();
            }
            case INFORMATIONAL: {
                return this.infoIfAnyValidator();
            }
        }
        return CheckResult.FATAL;
    }

    public void setRelevantObjectsData(List<Map<String, String>> relevantObjectsData) {
        this.relevantObjectsData = relevantObjectsData;
        this.result = this.determineResult();
    }

    public final CheckResult blockerIfAnyValidator() {
        if (this.relevantObjectsData == null || this.relevantObjectsData.size() == 0) {
            return CheckResult.PASS;
        }
        return CheckResult.BLOCKER;
    }

    public final CheckResult warningIfAnyValidator() {
        if (this.relevantObjectsData == null || this.relevantObjectsData.size() == 0) {
            return CheckResult.PASS;
        }
        return CheckResult.WARNING;
    }

    public final CheckResult infoIfAnyValidator() {
        if (this.relevantObjectsData == null || this.relevantObjectsData.size() == 0) {
            return CheckResult.PASS;
        }
        return CheckResult.INFORMATIONAL;
    }

    public void skipCheck(@NonNull String reason) {
        if (reason == null) {
            throw new NullPointerException("reason is marked non-null but is null");
        }
        this.skipCheck(reason, CheckResult.INFORMATIONAL);
    }

    public void skipCheck(@NonNull String reason, @NonNull CheckResult result) {
        if (reason == null) {
            throw new NullPointerException("reason is marked non-null but is null");
        }
        if (result == null) {
            throw new NullPointerException("result is marked non-null but is null");
        }
        this.setErrorMessage(reason);
        this.setSkipExecution(true);
        this.setExecutedSQL("");
        this.setResult(result);
    }

    public List<Map<String, String>> resultSetToListMap(ResultSet rs, ExecutionContext exeCtx) throws SQLException {
        Integer maxRelevantObjects = exeCtx.getParsedArgs().getMaxRelevantObjects();
        ResultSetProcessor.RSProcessorInputs inputs = ResultSetProcessor.RSProcessorInputs.builder().resultSet(rs).maxRelevantObjects(maxRelevantObjects).build();
        ResultSetProcessor.RSProcessorOutputs outputs = ResultSetProcessor.processResultSet(inputs);
        this.setOmittedRelevantObjectsCount(outputs.getOmittedRelevantObjectsCount());
        return outputs.getRelevantObjects();
    }

    public String toString() {
        return "Check(lang=" + this.getLang() + ", name=" + this.getName() + ", targetCloud=" + this.getTargetCloud() + ", scope=" + (Object)((Object)this.getScope()) + ", title=" + this.getTitle() + ", description=" + this.getDescription() + ", failureImpact=" + this.getFailureImpact() + ", action=" + this.getAction() + ", result=" + (Object)((Object)this.getResult()) + ", declarativeResult=" + (Object)((Object)this.getDeclarativeResult()) + ", errorMessage=" + this.getErrorMessage() + ", sqlQuery=" + this.getSqlQuery() + ", skipExecution=" + this.getSkipExecution() + ", migrationMethods=" + this.getMigrationMethods() + ", executedSQL=" + this.getExecutedSQL() + ", relevantObjectsData=" + this.getRelevantObjectsData() + ", filtrationMetadata=" + this.getFiltrationMetadata() + ", filteredObjectsData=" + this.getFilteredObjectsData() + ", omittedRelevantObjectsCount=" + this.getOmittedRelevantObjectsCount() + ")";
    }

    @NonNull
    public String getName() {
        return this.name;
    }

    public List<TargetCloud> getTargetCloud() {
        return this.targetCloud;
    }

    public Scope getScope() {
        return this.scope;
    }

    @NonNull
    public String getTitle() {
        return this.title;
    }

    @NonNull
    public String getDescription() {
        return this.description;
    }

    @NonNull
    public String getFailureImpact() {
        return this.failureImpact;
    }

    @NonNull
    public String getAction() {
        return this.action;
    }

    @NonNull
    public CheckResult getResult() {
        return this.result;
    }

    @NonNull
    public String getExecutedSQL() {
        return this.executedSQL;
    }

    public List<Map<String, String>> getRelevantObjectsData() {
        return this.relevantObjectsData;
    }

    public Integer getOmittedRelevantObjectsCount() {
        return this.omittedRelevantObjectsCount;
    }

    @CpatJsonIgnore
    public Language getLang() {
        return this.lang;
    }

    public void setScope(Scope scope) {
        this.scope = scope;
    }

    public void setDescription(@NonNull String description) {
        if (description == null) {
            throw new NullPointerException("description is marked non-null but is null");
        }
        this.description = description;
    }

    public void setAction(@NonNull String action) {
        if (action == null) {
            throw new NullPointerException("action is marked non-null but is null");
        }
        this.action = action;
    }

    public void setResult(@NonNull CheckResult result) {
        if (result == null) {
            throw new NullPointerException("result is marked non-null but is null");
        }
        this.result = result;
    }

    @CpatJsonIgnore
    public CheckResult getDeclarativeResult() {
        return this.declarativeResult;
    }

    public void setDeclarativeResult(CheckResult declarativeResult) {
        this.declarativeResult = declarativeResult;
    }

    @CpatJsonIgnoreIfNull
    public String getErrorMessage() {
        return this.errorMessage;
    }

    public void setErrorMessage(String errorMessage) {
        this.errorMessage = errorMessage;
    }

    @CpatJsonIgnore
    public String getSqlQuery() {
        return this.sqlQuery;
    }

    public void setSqlQuery(String sqlQuery) {
        this.sqlQuery = sqlQuery;
    }

    @CpatJsonIgnore
    public Boolean getSkipExecution() {
        return this.skipExecution;
    }

    private void setSkipExecution(Boolean skipExecution) {
        this.skipExecution = skipExecution;
    }

    @CpatJsonIgnore
    public List<MigrationMethod> getMigrationMethods() {
        return this.migrationMethods;
    }

    public void setExecutedSQL(@NonNull String executedSQL) {
        if (executedSQL == null) {
            throw new NullPointerException("executedSQL is marked non-null but is null");
        }
        this.executedSQL = executedSQL;
    }

    public void setFiltrationMetadata(CheckFiltrationMetadata filtrationMetadata) {
        this.filtrationMetadata = filtrationMetadata;
    }

    @CpatJsonIgnoreIfNull
    public CheckFiltrationMetadata getFiltrationMetadata() {
        return this.filtrationMetadata;
    }

    public void setFilteredObjectsData(List<Map<String, String>> filteredObjectsData) {
        this.filteredObjectsData = filteredObjectsData;
    }

    @CpatJsonIgnoreIfNull
    public List<Map<String, String>> getFilteredObjectsData() {
        return this.filteredObjectsData;
    }

    public void setOmittedRelevantObjectsCount(Integer omittedRelevantObjectsCount) {
        this.omittedRelevantObjectsCount = omittedRelevantObjectsCount;
    }

    public static enum Scope {
        INSTANCE,
        SCHEMA,
        UNIVERSAL;

    }
}

