/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.premigration.dbinspector;

import com.oracle.premigration.dbinspector.Check;
import com.oracle.premigration.dbinspector.CheckResult;
import com.oracle.premigration.dbinspector.ExecutionContext;
import com.oracle.premigration.helpers.SqlUtils;
import com.oracle.premigration.helpers.Utilities;
import com.oracle.premigration.logger.PremigrationLogger;
import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.logging.Level;

public class CheckRunner {
    private static final PremigrationLogger log = PremigrationLogger.getLogger(CheckRunner.class.getName());

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void runCheck(ExecutionContext exeCtx, Check check) throws SQLException {
        String checkName = check.getName();
        if (check.getSkipExecution().booleanValue()) {
            log.info("Skipping Execution of Check: " + checkName);
            return;
        }
        log.fine("Running: " + check.toString());
        log.info("Running Check: " + checkName);
        Connection conn = null;
        PreparedStatement stmt = null;
        ResultSet rs = null;
        try {
            long start = System.currentTimeMillis();
            conn = exeCtx.getConnection();
            log.fine("Elapsed time obtaining a connection: " + Utilities.formatTimeInterval(System.currentTimeMillis() - start));
            String sql = check.getSqlQuery();
            check.setExecutedSQL(sql);
            start = System.currentTimeMillis();
            stmt = SqlUtils.createPreparedStatement(conn, sql);
            log.fine("Elapsed time preparing statement: " + Utilities.formatTimeInterval(System.currentTimeMillis() - start));
            start = System.currentTimeMillis();
            rs = stmt.executeQuery();
            log.fine("Elapsed time executing query: " + Utilities.formatTimeInterval(System.currentTimeMillis() - start));
            rs.setFetchSize(500);
            start = System.currentTimeMillis();
            List<Map<String, String>> relevantObjects = check.resultSetToListMap(rs, exeCtx);
            log.fine("Elapsed time producing relevant data objects: " + Utilities.formatTimeInterval(System.currentTimeMillis() - start));
            check.setRelevantObjectsData(relevantObjects);
        }
        catch (SQLException e) {
            try {
                check.setRelevantObjectsData(Collections.emptyList());
                check.setResult(CheckResult.FATAL);
                String checkFailMsg = Utilities.getErrorText("ERROR2000", e, checkName);
                check.setErrorMessage(checkFailMsg);
                Utilities.printAndLogErrorMessage(checkFailMsg, exeCtx.getEnvCtx(), Level.SEVERE, e);
            }
            catch (Throwable throwable) {
                exeCtx.closeIfNotNull(rs, stmt, conn);
                throw throwable;
            }
            exeCtx.closeIfNotNull(rs, stmt, conn);
        }
        exeCtx.closeIfNotNull(rs, stmt, conn);
    }
}

