/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.premigration.dbinspector;

import com.oracle.premigration.cli.CommandLineArgs;
import com.oracle.premigration.commons.EnvironmentContext;
import com.oracle.premigration.commons.GlobalVariables;
import com.oracle.premigration.commons.enums.MigrationMethodProp;
import com.oracle.premigration.commons.enums.ReportFormat;
import com.oracle.premigration.commons.enums.SourceAnalysisProp;
import com.oracle.premigration.commons.enums.TargetInstanceProp;
import com.oracle.premigration.commons.enums.Version;
import com.oracle.premigration.commons.lang.Language;
import com.oracle.premigration.dbinspector.Check;
import com.oracle.premigration.dbinspector.CheckList;
import com.oracle.premigration.dbinspector.CheckResult;
import com.oracle.premigration.dbinspector.CheckRunner;
import com.oracle.premigration.dbinspector.ExecutionContext;
import com.oracle.premigration.exceptions.PremigrationException;
import com.oracle.premigration.helpers.SqlUtils;
import com.oracle.premigration.helpers.Utilities;
import com.oracle.premigration.logger.PremigrationLogger;
import com.oracle.premigration.reports.ChecksSummary;
import com.oracle.premigration.reports.ReportData;
import com.oracle.premigration.reports.filters.FilterCriteria;
import com.oracle.premigration.reports.json.serialization.JsonSerializer;
import com.oracle.premigration.reports.text.TextReport;
import com.oracle.premigration.reports.text.TextReportContext;
import java.io.FileInputStream;
import java.io.IOException;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.Date;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Properties;
import java.util.logging.Level;

public class SourceInspector {
    private static final PremigrationLogger log = PremigrationLogger.getLogger(SourceInspector.class.getName());

    public static CheckResult analyzeSource(ExecutionContext exeCtx, String appVersion) throws SQLException, PremigrationException, IOException {
        ReportData reportData = new ReportData();
        CommandLineArgs cla = exeCtx.getParsedArgs();
        EnvironmentContext envCtx = exeCtx.getEnvCtx();
        Language lang = Language.getInstance();
        CheckResult overallResult = CheckResult.PASS;
        if (cla.getAnalysisPropertiesFile() != null) {
            CheckResult[] analysisProps = SourceInspector.deserializeAnalysisProps(cla.getAnalysisPropertiesFile());
            SourceInspector.processAnalysisProperties((Properties)analysisProps, appVersion, exeCtx);
            exeCtx.getAnalysisProperties().putAll((Map<?, ?>)analysisProps);
            ArrayList<PremigrationException> nonFatalErrors = new ArrayList<PremigrationException>();
            FilterCriteria filterCriteria = FilterCriteria.fromProperties((Properties)analysisProps, nonFatalErrors);
            exeCtx.setFilterCriteria(filterCriteria);
            for (PremigrationException pe : nonFatalErrors) {
                envCtx.getErrWriter().println(pe.getMessage());
            }
        }
        reportData.setAppVersion(appVersion);
        reportData.setChecksVersion(appVersion);
        reportData.setReportDate(new Date());
        reportData.setHostName(Utilities.getHostName());
        reportData.setTargetMigrationStrategies(cla.getMigrationMethods());
        reportData.setCommandLineOptions(cla.getReconstitutedArgs());
        for (CheckResult checkResult : CheckResult.values()) {
            reportData.getCheckResultDescriptions().add(checkResult.toCheckResultDescription(lang));
        }
        reportData.setSrcDatabasePortString(exeCtx.getDatabasePlatformHW() + "/" + exeCtx.getDatabasePlatformOS());
        reportData.setSrcDatabasePlatformID(exeCtx.getDatabasePlatformID());
        reportData.setSrcDataBaseHostName(SqlUtils.getSingleString("SELECT HOST_NAME FROM V$INSTANCE", exeCtx));
        reportData.setSrcInstanceName(SqlUtils.getSingleString("SELECT INSTANCE_NAME FROM V$INSTANCE", exeCtx));
        reportData.setSrcOracleSID(SqlUtils.getSingleString("SELECT INSTANCE FROM V$THREAD", exeCtx));
        reportData.setSrcDatabaseName(SqlUtils.getSingleString("SELECT NAME FROM V$DATABASE", exeCtx));
        reportData.setSrcDatabaseDBID(SqlUtils.getSingleLong("SELECT DBID FROM V$DATABASE", exeCtx));
        reportData.setSrcDatabaseCreatedDate(SqlUtils.getSingleDate("SELECT CREATED FROM V$DATABASE", exeCtx));
        reportData.setSrcDatabaseUniqueName(SqlUtils.getSingleString("SELECT DB_UNIQUE_NAME FROM V$DATABASE", exeCtx));
        String sourceVersion = exeCtx.getDatabaseVersion();
        reportData.setSrcDatabaseVersion(sourceVersion);
        if (Version.v11_2_0_4.compare(sourceVersion) == 1) {
            String errorMsg = Utilities.getErrorText("ERROR4003", "11.2.0.4", sourceVersion);
            Utilities.printAndLogErrorMessage(errorMsg, envCtx, Level.SEVERE);
            return CheckResult.FATAL;
        }
        String srcDatabaseLockdown = SqlUtils.getSingleString("SELECT UPPER(VALUE) AS PDB_LOCKDOWN FROM V$PARAMETER WHERE UPPER(NAME) = 'PDB_LOCKDOWN'", exeCtx);
        if (srcDatabaseLockdown != null && !srcDatabaseLockdown.isEmpty()) {
            String warningMessage = Utilities.getErrorText("ERROR4005", srcDatabaseLockdown);
            Utilities.printAndLogErrorMessage(warningMessage, envCtx, Level.WARNING);
        }
        reportData.setSrcDatabaseUser(SqlUtils.getSingleString("SELECT USER FROM DUAL", exeCtx));
        reportData.setSrcNumSchemasPresent(SqlUtils.getSingleLong("SELECT COUNT(*) AS NUM_SCHEMAS FROM SYS.DBA_USERS", exeCtx));
        reportData.setSrcDatabasePatchInfo(SqlUtils.getPatchInfo(exeCtx));
        reportData.setSrcDatabaseVersionData(SqlUtils.getVersionData(exeCtx));
        String containerName = "";
        try {
            containerName = SqlUtils.getSingleString("SELECT SYS_CONTEXT('USERENV', 'CON_NAME') CON_NAME FROM DUAL", exeCtx);
            reportData.setSrcContainerName(containerName);
        }
        catch (SQLException e) {
            log.trace("Exception attempting to determine the source database container name. ", e);
        }
        if ("CDB$ROOT".equals(containerName)) {
            throw new PremigrationException(Utilities.getErrorText("ERROR1001", new String[0]));
        }
        reportData.setTargetCloudType(exeCtx.getParsedArgs().getTargetCloud());
        List<String> invalidNames = exeCtx.getInvalidSchemaNames();
        if (invalidNames.size() > 0) {
            String errorMsg = Utilities.getErrorText("ERROR1002", Utilities.join(", ", invalidNames));
            Utilities.printAndLogErrorMessage(errorMsg, envCtx, Level.SEVERE);
            return CheckResult.FATAL;
        }
        reportData.setSrcSchemasAnalyzed(SqlUtils.getAnalysedSchemaNames(exeCtx));
        reportData.setSrcNumSchemasAnalyzed(reportData.getSrcSchemasAnalyzed().size());
        List<Check> fullCheckList = CheckList.createChecksList();
        List<Check> filteredCheckList = CheckList.filterChecksByTargetCloud(fullCheckList, exeCtx.getParsedArgs().getTargetCloud());
        filteredCheckList = CheckList.filterChecksByMigrationMethod(filteredCheckList, exeCtx.getParsedArgs().getMigrationMethods());
        filteredCheckList = CheckList.filterChecksByScope(filteredCheckList, exeCtx.getParsedArgs());
        reportData.setCheckList(filteredCheckList);
        for (Check check : filteredCheckList) {
            long startPrepare = System.currentTimeMillis();
            check.prepare(exeCtx);
            log.info("Elapsed time preparing " + check.getName() + ": " + Utilities.formatTimeInterval(System.currentTimeMillis() - startPrepare));
        }
        int count = 0;
        int numChecks = filteredCheckList.size();
        log.info("Beginning execution of " + numChecks + " Checks...");
        long startAllChecks = System.currentTimeMillis();
        for (Check check : filteredCheckList) {
            long startCheck = System.currentTimeMillis();
            CheckRunner.runCheck(exeCtx, check);
            String elapsed = "Elapsed time running " + check.getName() + ": " + Utilities.formatTimeInterval(System.currentTimeMillis() - startCheck);
            log.info(elapsed);
            String msg = "Completed check " + ++count + " of " + numChecks + " (" + check.getName() + "). Check result: " + check.getResult().toString();
            log.info(msg);
            overallResult = CheckResult.max(overallResult, check.getResult());
        }
        log.info("...completed execution of Checks.");
        log.info("Elapsed time running checks: " + Utilities.formatTimeInterval(System.currentTimeMillis() - startAllChecks));
        reportData.setResult(overallResult);
        String cpatResultCompleted = lang.txt("APP_COMPLETED_MSG", overallResult.toString());
        Utilities.printAndLogMessage(cpatResultCompleted, envCtx, Level.INFO);
        Collections.sort(reportData.getCheckList(), Check.groupByResult);
        reportData.setChecksSummary(new ChecksSummary(reportData));
        for (ReportFormat reportFormat : cla.getReportFormats()) {
            String createdFilePath;
            long startSerialization = System.currentTimeMillis();
            switch (reportFormat) {
                case JSON: {
                    String jsonPath = Utilities.getValidatedFilePath(cla.getOutdir(), GlobalVariables.JSON_OUTPUT_FILENAME);
                    JsonSerializer cpatJsonSerializer = new JsonSerializer();
                    createdFilePath = cpatJsonSerializer.writeJSON(reportData, jsonPath);
                    break;
                }
                case TEXT: {
                    TextReportContext textReportContext = TextReportContext.createTextReportContext(cla);
                    createdFilePath = TextReport.writeText(reportData, textReportContext);
                    break;
                }
                default: {
                    throw new IllegalArgumentException("Invalid report format");
                }
            }
            log.info("Elapsed time serializing " + createdFilePath + ": " + Utilities.formatTimeInterval(System.currentTimeMillis() - startSerialization));
            String reportLocationMsg = lang.txt("APP_REPORT_LOCATION_MSG", createdFilePath);
            Utilities.printAndLogMessage(reportLocationMsg, envCtx, Level.INFO);
        }
        return overallResult;
    }

    private static Properties deserializeAnalysisProps(String propFile) throws IOException {
        Properties analysisProps = new Properties();
        try (FileInputStream fileStream = new FileInputStream(propFile);){
            analysisProps.load(fileStream);
        }
        for (String key : analysisProps.stringPropertyNames()) {
            String value = analysisProps.getProperty(key);
            String regexFilter = Utilities.getRegexScreenForKey(key);
            if (regexFilter != null) {
                value = value.replaceAll(regexFilter, "").trim();
            }
            analysisProps.setProperty(key, value);
            log.info("Deserialized analysis property '" + key + "' has value '" + value + "'");
        }
        return analysisProps;
    }

    private static void processAnalysisProperties(Properties analysisProps, String appVersion, ExecutionContext exeCtx) throws SQLException {
        String targetDatabaseVersionValue;
        String migrationMethodTablespacesNotMappedProp;
        String targetTablespacesProp;
        String propsAppVersion = analysisProps.getProperty(TargetInstanceProp.CPAT_VERSION.getKey());
        if (propsAppVersion != null && !Objects.equals(appVersion, propsAppVersion)) {
            String warningText = Utilities.getErrorText("ERROR2004", new String[0]);
            Utilities.printAndLogErrorMessage(warningText, exeCtx.getEnvCtx(), Level.WARNING);
        }
        String additionalExcludesProp = analysisProps.getProperty(SourceAnalysisProp.ADDITIONAL_EXCLUDED_SCHEMAS.getKey());
        if (exeCtx.getParsedArgs().getSchemas().size() == 0 && additionalExcludesProp != null && !additionalExcludesProp.trim().isEmpty()) {
            ArrayList<String> additionalExcludes = new ArrayList<String>(Arrays.asList(additionalExcludesProp.trim().split(",")));
            List<String> invalidNames = SqlUtils.getInvalidSchemaNames(additionalExcludes, exeCtx);
            additionalExcludes.removeAll(invalidNames);
            List<String> excludeSchemas = exeCtx.getExcludeSchemas();
            for (String additionalExcludeName : additionalExcludes) {
                String trimmedAdditionalExcludeName = additionalExcludeName.trim();
                if (excludeSchemas.contains(trimmedAdditionalExcludeName)) continue;
                excludeSchemas.add(trimmedAdditionalExcludeName);
            }
        }
        String targetDirsProp = analysisProps.getProperty(TargetInstanceProp.DIRECTORIES.getKey());
        String migrationDirsProp = analysisProps.getProperty(MigrationMethodProp.DIRECTORY_MAPPING.getKey());
        if (targetDirsProp != null || migrationDirsProp != null) {
            LinkedHashSet<String> directorySet = new LinkedHashSet<String>();
            if (targetDirsProp != null) {
                directorySet.addAll(Arrays.asList(targetDirsProp.trim().split(",")));
            }
            if (migrationDirsProp != null) {
                directorySet.addAll(Arrays.asList(migrationDirsProp.trim().split(",")));
            }
            String directories = Utilities.join(",", directorySet);
            analysisProps.setProperty(SourceAnalysisProp.DIRECTORIES.getKey(), directories);
        }
        if ((targetTablespacesProp = analysisProps.getProperty(TargetInstanceProp.TABLESPACES.getKey())) != null) {
            ArrayList<String> targetTablespacesList = new ArrayList<String>(Arrays.asList(targetTablespacesProp.trim().split(",")));
            String tablespaceNames = Utilities.join(",", Utilities.cleanAndValidateTablespaceNamesValue(targetTablespacesList, exeCtx, "TargetInstanceProp.TABLESPACES"));
            analysisProps.setProperty(TargetInstanceProp.TABLESPACES.getKey(), tablespaceNames);
        }
        if ((migrationMethodTablespacesNotMappedProp = analysisProps.getProperty(MigrationMethodProp.TABLESPACES_NOT_MAPPED.getKey())) != null) {
            ArrayList<String> migrationMethodTablespacesNotMappedList = new ArrayList<String>(Arrays.asList(migrationMethodTablespacesNotMappedProp.trim().split(",")));
            String tablespaceNames = Utilities.join(",", Utilities.cleanAndValidateTablespaceNamesValue(migrationMethodTablespacesNotMappedList, exeCtx, "MigrationMethodProp.TABLESPACES_NOT_MAPPED"));
            analysisProps.setProperty(MigrationMethodProp.TABLESPACES_NOT_MAPPED.getKey(), tablespaceNames);
        }
        if ((targetDatabaseVersionValue = analysisProps.getProperty(TargetInstanceProp.DB_VERSION.getKey())) != null) {
            try {
                Version.toList(targetDatabaseVersionValue);
            }
            catch (Throwable t) {
                String warningText = Utilities.getErrorText("ERROR4004", new String[0]);
                Utilities.printAndLogErrorMessage(warningText, exeCtx.getEnvCtx(), Level.WARNING, t);
                analysisProps.setProperty(TargetInstanceProp.DB_VERSION.getKey(), "");
            }
        }
    }
}

