/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.premigration.dbinspector;

import com.oracle.premigration.cli.CommandLineArgs;
import com.oracle.premigration.commons.EnvironmentContext;
import com.oracle.premigration.commons.GlobalVariables;
import com.oracle.premigration.commons.enums.SourceAnalysisProp;
import com.oracle.premigration.commons.enums.TargetInstanceProp;
import com.oracle.premigration.commons.lang.Language;
import com.oracle.premigration.dbinspector.CheckResult;
import com.oracle.premigration.dbinspector.ExecutionContext;
import com.oracle.premigration.helpers.SqlUtils;
import com.oracle.premigration.helpers.Utilities;
import com.oracle.premigration.logger.PremigrationLogger;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.Properties;
import java.util.logging.Level;

public class TargetInspector {
    private static final PremigrationLogger log = PremigrationLogger.getLogger(TargetInspector.class.getName());

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static CheckResult fetchTargetProps(ExecutionContext exeCtx, String appVersion) throws SQLException, IOException {
        String propFetchFailMsg;
        Object fetchedValue;
        Language lang = Language.getInstance();
        CheckResult overallResult = CheckResult.PASS;
        CommandLineArgs cla = exeCtx.getParsedArgs();
        EnvironmentContext envCtx = exeCtx.getEnvCtx();
        Properties targetProps = exeCtx.getAnalysisProperties();
        targetProps.setProperty(TargetInstanceProp.CPAT_VERSION.getKey(), appVersion);
        for (TargetInstanceProp tgtProp : TargetInstanceProp.values()) {
            if (tgtProp.getSqlQuery() == null || tgtProp.getSqlQuery().isEmpty()) continue;
            try {
                fetchedValue = SqlUtils.getSingleString(tgtProp.getSqlQuery(), tgtProp.getDefaultValue(), exeCtx);
                if (fetchedValue == null) continue;
                targetProps.setProperty(tgtProp.getKey(), (String)fetchedValue);
            }
            catch (SQLException e) {
                propFetchFailMsg = Utilities.getErrorText("ERROR2003", e, tgtProp.getKey());
                Utilities.printAndLogErrorMessage(propFetchFailMsg, envCtx, Level.WARNING, e);
                overallResult = CheckResult.FATAL;
            }
        }
        targetProps.setProperty(TargetInstanceProp.DB_VERSION.getKey(), exeCtx.getDatabaseVersion());
        Connection conn = null;
        PreparedStatement stmt = null;
        ResultSet rs = null;
        try {
            conn = exeCtx.getConnection();
            stmt = SqlUtils.createPreparedStatement(conn, "SELECT TABLESPACE_NAME, CAST(BLOCK_SIZE AS VARCHAR2(100)) AS BLOCK_SIZE FROM SYS.DBA_TABLESPACES");
            rs = stmt.executeQuery();
            while (rs.next()) {
                String tablespaceName = rs.getString(1);
                String tablespaceSize = rs.getString(2);
                targetProps.setProperty(TargetInstanceProp.TABLESPACE_BLOCK_SIZE.getKey(tablespaceName), tablespaceSize);
            }
        }
        catch (SQLException e) {
            try {
                String propFetchFailMsg2 = Utilities.getErrorText("ERROR2003", e, TargetInstanceProp.TABLESPACE_BLOCK_SIZE.getKey());
                Utilities.printAndLogErrorMessage(propFetchFailMsg2, envCtx, Level.WARNING, e);
                overallResult = CheckResult.FATAL;
            }
            catch (Throwable throwable) {
                exeCtx.closeIfNotNull(rs, stmt, conn);
                throw throwable;
            }
            exeCtx.closeIfNotNull(rs, stmt, conn);
        }
        exeCtx.closeIfNotNull(rs, stmt, conn);
        String keyName = SourceAnalysisProp.ADDITIONAL_EXCLUDED_SCHEMAS.getKey();
        try {
            fetchedValue = SqlUtils.getStringList("SELECT USERNAME FROM SYS.DBA_USERS WHERE ORACLE_MAINTAINED = 'Y'", exeCtx);
            if (fetchedValue != null) {
                targetProps.setProperty(keyName, Utilities.join(",", fetchedValue));
            }
        }
        catch (SQLException e) {
            propFetchFailMsg = Utilities.getErrorText("ERROR2003", e, keyName);
            Utilities.printAndLogErrorMessage(propFetchFailMsg, envCtx, Level.WARNING, e);
            overallResult = CheckResult.FATAL;
        }
        String outdir = cla.getOutdir();
        File outfile = new File(outdir, GlobalVariables.PROPS_OUTPUT_FILENAME);
        try (FileOutputStream outputStream = new FileOutputStream(outfile);){
            targetProps.store(outputStream, "Created by CPAT version " + appVersion);
        }
        String propsLocationMsg = lang.txt("APP_PROPERTIES_LOCATION_MSG", outfile.getCanonicalPath());
        Utilities.printAndLogMessage(propsLocationMsg, envCtx, Level.INFO);
        return overallResult;
    }
}

