/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.premigration.dbinspector.checks;

import com.oracle.premigration.commons.enums.MigrationMethod;
import com.oracle.premigration.commons.enums.TargetCloud;
import com.oracle.premigration.commons.enums.Version;
import com.oracle.premigration.dbinspector.Check;
import com.oracle.premigration.dbinspector.CheckResult;
import com.oracle.premigration.dbinspector.ExecutionContext;
import com.oracle.premigration.dbinspector.FilterableCheck;
import com.oracle.premigration.helpers.SqlUtils;
import com.oracle.premigration.logger.PremigrationLogger;
import com.oracle.premigration.reports.CheckFiltrationMetadata;
import com.oracle.premigration.reports.filters.DataType;
import java.util.Arrays;

public class gg_tables_not_supported
extends FilterableCheck {
    private static final PremigrationLogger log = PremigrationLogger.getLogger(gg_tables_not_supported.class.getName());

    public gg_tables_not_supported() {
        this.getTargetCloud().addAll(Arrays.asList(TargetCloud.ADWD, TargetCloud.ADWS, TargetCloud.ATPD, TargetCloud.ATPS, TargetCloud.DEFAULT));
        this.getMigrationMethods().add(MigrationMethod.GOLDENGATE);
        this.setScope(Check.Scope.SCHEMA);
        this.setDeclarativeResult(CheckResult.BLOCKER);
    }

    @Override
    public void initFiltrationMetadata() {
        this.setFiltrationMetadata(CheckFiltrationMetadata.builder().schemaOwnerColumn("OWNER").objectNameColumn("OBJECT_NAME").objectTypeFixed(DataType.TABLE).build());
    }

    @Override
    public void prepare(ExecutionContext exeCtx) {
        boolean isVersion12;
        String whereClause = SqlUtils.createWhereClauseForColumn(exeCtx, "GGSM.OWNER");
        String sqlQuery = "SELECT OWNER, OBJECT_NAME, SUPPORT_MODE  FROM SYS.DBA_GOLDENGATE_SUPPORT_MODE GGSM " + whereClause + " AND SUPPORT_MODE='NONE' ";
        try {
            isVersion12 = Version.betweenInclusive(exeCtx.getDatabaseVersion(), Version.v12_1_0_1, Version.v12_2_0_2);
        }
        catch (Throwable e) {
            log.severe("Exception calling Version.betweenInclusive with '" + exeCtx.getDatabaseVersion() + "'", e);
            isVersion12 = false;
        }
        if (isVersion12) {
            whereClause = SqlUtils.createWhereClauseForColumn(exeCtx, "DTC.OWNER");
            sqlQuery = sqlQuery + " UNION  SELECT DTC.OWNER, DTC.TABLE_NAME AS OBJECT_NAME, 'NONE' AS SUPPORT_MODE   FROM SYS.DBA_TAB_COLUMNS DTC " + whereClause + "   AND DTC.IDENTITY_COLUMN='YES'";
        }
        this.setSqlQuery(sqlQuery);
    }
}

