/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.premigration.dbinspector.checks;

import com.oracle.premigration.commons.enums.MigrationMethod;
import com.oracle.premigration.commons.enums.TargetCloud;
import com.oracle.premigration.dbinspector.Check;
import com.oracle.premigration.dbinspector.CheckResult;
import com.oracle.premigration.dbinspector.ExecutionContext;
import com.oracle.premigration.dbinspector.FilterableCheck;
import com.oracle.premigration.helpers.AnalysisPropHelper;
import com.oracle.premigration.helpers.SqlUtils;
import com.oracle.premigration.logger.PremigrationLogger;
import com.oracle.premigration.reports.CheckFiltrationMetadata;
import com.oracle.premigration.reports.filters.DataType;
import java.sql.SQLException;
import java.util.Arrays;
import java.util.List;

public abstract class has_absent_tablespaces
extends FilterableCheck {
    private static final PremigrationLogger log = PremigrationLogger.getLogger(has_absent_tablespaces.class.getName());
    protected List<String> defaultList;
    protected String columnName;

    public has_absent_tablespaces() {
        this.getTargetCloud().addAll(Arrays.asList(TargetCloud.ATPD, TargetCloud.ADWD, TargetCloud.DEFAULT));
        this.getMigrationMethods().addAll(Arrays.asList(MigrationMethod.DATAPUMP, MigrationMethod.DATAPUMP_DBLINK, MigrationMethod.GOLDENGATE));
        this.setScope(Check.Scope.SCHEMA);
        this.setDeclarativeResult(CheckResult.WARNING);
    }

    @Override
    public void initFiltrationMetadata() {
        this.setFiltrationMetadata(CheckFiltrationMetadata.builder().schemaOwnerColumn("USERNAME").objectNameColumn("USERNAME").objectTypeFixed(DataType.USER).build());
    }

    @Override
    public void prepare(ExecutionContext exeCtx) {
        AnalysisPropHelper propHelper = new AnalysisPropHelper(exeCtx, this.defaultList, this.columnName);
        String whereClause = SqlUtils.createWhereClauseForColumn(exeCtx, "USERNAME");
        if (propHelper.isMigrationMethodMappingAll()) {
            this.skipCheck(this.lang.txt("CHECK_SKIPPED_BECAUSE_MIGRATION_METHOD_TABLESPACE_MAPPING_ALL", this.getName()), CheckResult.PASS);
        }
        try {
            String andClause = propHelper.getInClause();
            String sqlQuery = "SELECT USERNAME, " + this.columnName + " FROM SYS.DBA_USERS" + whereClause + andClause + " ORDER BY 1";
            this.setSqlQuery(sqlQuery);
        }
        catch (SQLException e) {
            log.warning("Unexpected exception querying tablespace names", e);
        }
    }
}

