/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.premigration.dbinspector.checks;

import com.oracle.premigration.commons.enums.MigrationMethod;
import com.oracle.premigration.commons.enums.TargetCloud;
import com.oracle.premigration.dbinspector.Check;
import com.oracle.premigration.dbinspector.CheckResult;
import com.oracle.premigration.dbinspector.ExecutionContext;
import com.oracle.premigration.helpers.SqlUtils;
import java.util.Arrays;

public class has_compression_disabled_for_objects
extends Check {
    public has_compression_disabled_for_objects() {
        this.getTargetCloud().addAll(Arrays.asList(TargetCloud.ADWD, TargetCloud.ADWS));
        this.getMigrationMethods().addAll(Arrays.asList(MigrationMethod.DATAPUMP, MigrationMethod.DATAPUMP_DBLINK, MigrationMethod.GOLDENGATE));
        this.setScope(Check.Scope.SCHEMA);
        this.setDeclarativeResult(CheckResult.INFORMATIONAL);
    }

    @Override
    public void prepare(ExecutionContext exeCtx) {
        String ownerWhereClause = SqlUtils.createWhereClauseForOwnerColumn(exeCtx);
        String tableOwnerWhereClause = SqlUtils.createWhereClauseForColumn(exeCtx, "TABLE_OWNER");
        String sqlQuery = "SELECT OWNER AS OWNER, TABLE_NAME AS OBJECT_NAME, 'TABLE' AS OBJECT_TYPE  FROM SYS.DBA_TABLES " + ownerWhereClause + " AND COMPRESSION = 'DISABLED'  UNION ALL SELECT TABLE_OWNER AS OWNER, TABLE_NAME||'.'||PARTITION_NAME AS OBJECT_NAME, 'TABLE PARTITION' AS OBJECT_TYPE  FROM SYS.DBA_TAB_PARTITIONS " + tableOwnerWhereClause + " AND COMPRESSION = 'DISABLED'  UNION ALL SELECT TABLE_OWNER AS OWNER, TABLE_NAME||'.'||SUBPARTITION_NAME AS OBJECT_NAME, 'TABLE SUBPARTITION' AS OBJECT_TYPE FROM SYS.DBA_TAB_SUBPARTITIONS " + tableOwnerWhereClause + " AND COMPRESSION = 'DISABLED'";
        this.setSqlQuery(sqlQuery);
    }
}

