/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.premigration.dbinspector.checks;

import com.oracle.premigration.commons.enums.MigrationMethod;
import com.oracle.premigration.dbinspector.Check;
import com.oracle.premigration.dbinspector.CheckResult;
import com.oracle.premigration.dbinspector.ExecutionContext;
import com.oracle.premigration.helpers.AnalysisPropHelper;
import com.oracle.premigration.helpers.SqlUtils;
import com.oracle.premigration.logger.PremigrationLogger;
import java.sql.SQLException;
import java.util.Arrays;
import java.util.Collections;

public abstract class has_data_in_other_tablespaces
extends Check {
    private static final PremigrationLogger log = PremigrationLogger.getLogger(has_data_in_other_tablespaces.class.getName());
    private static final String SELECT_FROM = "SELECT S.TABLESPACE_NAME, O.OWNER, O.OBJECT_NAME, O.OBJECT_TYPE FROM DBA_SEGMENTS S, DBA_OBJECTS O ";
    private static final String COMMON_PREDICATES = " AND S.SEGMENT_NAME=O.OBJECT_NAME AND S.OWNER = O.OWNER ";
    private static final String GROUP_AND_ORDER = " GROUP BY S.TABLESPACE_NAME, O.OWNER, O.OBJECT_NAME, O.OBJECT_TYPE ORDER BY S.TABLESPACE_NAME, O.OWNER, O.OBJECT_NAME, O.OBJECT_TYPE ";

    public has_data_in_other_tablespaces() {
        this.getMigrationMethods().addAll(Arrays.asList(MigrationMethod.DATAPUMP, MigrationMethod.DATAPUMP_DBLINK, MigrationMethod.GOLDENGATE));
        this.setScope(Check.Scope.SCHEMA);
        this.setDeclarativeResult(CheckResult.BLOCKER);
    }

    @Override
    public void prepare(ExecutionContext exeCtx) {
        AnalysisPropHelper propHelper = new AnalysisPropHelper(exeCtx, Collections.singletonList("DATA"), "TABLESPACE_NAME");
        String whereClause = SqlUtils.createWhereClauseForColumn(exeCtx, "S.OWNER");
        if (propHelper.isMigrationMethodMappingAll()) {
            this.skipCheck(this.lang.txt("CHECK_SKIPPED_BECAUSE_MIGRATION_METHOD_TABLESPACE_MAPPING_ALL", this.getName()), CheckResult.PASS);
        }
        try {
            String andClause = propHelper.getInClause();
            String sqlQuery = SELECT_FROM + whereClause + andClause + COMMON_PREDICATES + GROUP_AND_ORDER;
            this.setSqlQuery(sqlQuery);
        }
        catch (SQLException e) {
            log.warning("Unexpected exception querying tablespace names", e);
        }
    }
}

