/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.premigration.dbinspector.checks;

import com.oracle.premigration.commons.enums.MigrationMethod;
import com.oracle.premigration.commons.enums.TargetCloud;
import com.oracle.premigration.dbinspector.Check;
import com.oracle.premigration.dbinspector.CheckResult;
import com.oracle.premigration.dbinspector.DatabaseObject;
import com.oracle.premigration.dbinspector.ExecutionContext;
import com.oracle.premigration.helpers.SqlUtils;
import com.oracle.premigration.logger.PremigrationLogger;
import java.util.Arrays;

public class has_dbms_credentials
extends Check {
    private static final PremigrationLogger log = PremigrationLogger.getLogger(has_dbms_credentials.class.getName());

    public has_dbms_credentials() {
        this.getTargetCloud().addAll(Arrays.asList(TargetCloud.ATPS, TargetCloud.ADWS));
        this.getMigrationMethods().addAll(Arrays.asList(MigrationMethod.DATAPUMP, MigrationMethod.DATAPUMP_DBLINK, MigrationMethod.GOLDENGATE));
        this.setScope(Check.Scope.SCHEMA);
        this.setDeclarativeResult(CheckResult.WARNING);
    }

    @Override
    public void prepare(ExecutionContext exeCtx) {
        String credsTable = "SYS.DBA_SCHEDULER_CREDENTIALS";
        boolean hasDBACredentials = exeCtx.hasDatabaseObject(DatabaseObject.builder().schema("SYS").view("DBA_CREDENTIALS").build());
        if (hasDBACredentials) {
            credsTable = "SYS.DBA_CREDENTIALS";
        }
        String whereClause = SqlUtils.createWhereClauseForColumn(exeCtx, "C.OWNER");
        String query = "SELECT C.OWNER, C.CREDENTIAL_NAME, C.USERNAME,  (SELECT LISTAGG(J.JOB_NAME,',') WITHIN GROUP (ORDER BY J.JOB_NAME)    FROM SYS.DBA_SCHEDULER_JOBS J    WHERE J.CREDENTIAL_OWNER = C.OWNER     AND J.CREDENTIAL_NAME=C.CREDENTIAL_NAME) AS JOBS_USING_CREDS FROM " + credsTable + " C " + whereClause + " AND NVL(C.COMMENTS,'Not Cloud') NOT LIKE '%\"comments\":\"Created via DBMS_CLOUD.create_credential\"%' ORDER BY 1, 2";
        this.setSqlQuery(query);
    }
}

