/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.premigration.dbinspector.checks;

import com.oracle.premigration.commons.enums.MigrationMethod;
import com.oracle.premigration.commons.enums.TargetCloud;
import com.oracle.premigration.dbinspector.Check;
import com.oracle.premigration.dbinspector.CheckResult;
import com.oracle.premigration.dbinspector.ExecutionContext;
import com.oracle.premigration.dbinspector.FilterableCheck;
import com.oracle.premigration.helpers.SqlUtils;
import com.oracle.premigration.reports.CheckFiltrationMetadata;
import com.oracle.premigration.reports.filters.DataType;
import java.util.Arrays;

public class has_external_tables
extends FilterableCheck {
    protected static final String BASE_EXTERNAL_TABLES_QUERY = "SELECT OWNER,TABLE_NAME,TYPE_OWNER,TYPE_NAME,DEFAULT_DIRECTORY_OWNER,DEFAULT_DIRECTORY_NAME FROM SYS.DBA_EXTERNAL_TABLES ";
    protected static final String BASE_EXTERNAL_TABLES_ORDER_BY = " ORDER BY 1, 2";

    public has_external_tables() {
        this.getTargetCloud().addAll(Arrays.asList(TargetCloud.ADWD, TargetCloud.ADWS, TargetCloud.ATPD, TargetCloud.ATPS));
        this.getMigrationMethods().addAll(Arrays.asList(MigrationMethod.DATAPUMP, MigrationMethod.DATAPUMP_DBLINK, MigrationMethod.GOLDENGATE));
        this.setScope(Check.Scope.SCHEMA);
        this.setDeclarativeResult(CheckResult.WARNING);
    }

    @Override
    public void initFiltrationMetadata() {
        this.setFiltrationMetadata(CheckFiltrationMetadata.builder().schemaOwnerColumn("OWNER").objectNameColumn("TABLE_NAME").objectTypeFixed(DataType.TABLE).build());
    }

    @Override
    public void prepare(ExecutionContext exeCtx) {
        TargetCloud targetCloud = exeCtx.getParsedArgs().getTargetCloud();
        if (targetCloud.equals((Object)TargetCloud.ATPD) || targetCloud.equals((Object)TargetCloud.ADWD)) {
            this.setAction(this.lang.txt("CHECK.HAS_EXTERNAL_TABLES.ACTION_ADBD"));
        } else if (targetCloud.equals((Object)TargetCloud.ATPS) || targetCloud.equals((Object)TargetCloud.ADWS)) {
            this.setAction(this.lang.txt("CHECK.HAS_EXTERNAL_TABLES.ACTION_ADBS"));
        }
        String whereClause = SqlUtils.createWhereClauseForOwnerColumn(exeCtx);
        String externalTablesSql = BASE_EXTERNAL_TABLES_QUERY + whereClause + BASE_EXTERNAL_TABLES_ORDER_BY;
        this.setSqlQuery(externalTablesSql);
    }
}

