/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.premigration.dbinspector.checks;

import com.oracle.premigration.commons.enums.MigrationMethod;
import com.oracle.premigration.commons.enums.SourceAnalysisProp;
import com.oracle.premigration.commons.enums.TargetCloud;
import com.oracle.premigration.dbinspector.Check;
import com.oracle.premigration.dbinspector.CheckResult;
import com.oracle.premigration.dbinspector.ExecutionContext;
import com.oracle.premigration.dbinspector.FilterableCheck;
import com.oracle.premigration.helpers.SqlUtils;
import com.oracle.premigration.logger.PremigrationLogger;
import com.oracle.premigration.reports.CheckFiltrationMetadata;
import com.oracle.premigration.reports.filters.DataType;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;

public class has_external_tables_default
extends FilterableCheck {
    private static final PremigrationLogger log = PremigrationLogger.getLogger(has_external_tables_default.class.getName());

    public has_external_tables_default() {
        this.getTargetCloud().add(TargetCloud.DEFAULT);
        this.getMigrationMethods().addAll(Arrays.asList(MigrationMethod.DATAPUMP, MigrationMethod.DATAPUMP_DBLINK, MigrationMethod.GOLDENGATE));
        this.setScope(Check.Scope.SCHEMA);
        this.setDeclarativeResult(CheckResult.BLOCKER);
    }

    @Override
    public void initFiltrationMetadata() {
        this.setFiltrationMetadata(CheckFiltrationMetadata.builder().schemaOwnerColumn("OWNER").objectNameColumn("TABLE_NAME").objectTypeFixed(DataType.TABLE).build());
    }

    @Override
    public void prepare(ExecutionContext exeCtx) {
        if (exeCtx.isFullMode()) {
            this.skipCheck(this.lang.txt("CHECK_SKIPPED_BECAUSE_NOT_SCHEMA_MODE", this.getName()), CheckResult.PASS);
            return;
        }
        String whereClause = SqlUtils.createWhereClauseForOwnerColumn(exeCtx);
        String sqlQuery = "SELECT OWNER,TABLE_NAME,TYPE_OWNER,TYPE_NAME,DEFAULT_DIRECTORY_OWNER,DEFAULT_DIRECTORY_NAME FROM SYS.DBA_EXTERNAL_TABLES " + whereClause + " ORDER BY 1, 2";
        this.setSqlQuery(sqlQuery);
        String targetDirectoriesString = exeCtx.getAnalysisProperty(SourceAnalysisProp.DIRECTORIES.getKey());
        if (targetDirectoriesString != null && targetDirectoriesString.trim().length() != 0) {
            try {
                ArrayList<String> srcDirectoryList = new ArrayList<String>();
                List<String> dirsNotOnTarget = SqlUtils.getDirectoryNamesNotOnTarget(exeCtx, srcDirectoryList);
                if (srcDirectoryList.size() == dirsNotOnTarget.size()) {
                    return;
                }
                boolean andIn = dirsNotOnTarget.size() > 0;
                List<String> dirList = andIn ? dirsNotOnTarget : srcDirectoryList;
                sqlQuery = "SELECT OWNER,TABLE_NAME,TYPE_OWNER,TYPE_NAME,DEFAULT_DIRECTORY_OWNER,DEFAULT_DIRECTORY_NAME FROM SYS.DBA_EXTERNAL_TABLES " + whereClause + SqlUtils.createAndClause("DEFAULT_DIRECTORY_NAME", andIn, dirList) + " ORDER BY 1, 2";
                this.setSqlQuery(sqlQuery);
            }
            catch (SQLException e) {
                log.warning("Unexpected exception querying directory names", e);
            }
        }
    }
}

