/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.premigration.dbinspector.checks;

import com.oracle.premigration.commons.enums.MigrationMethod;
import com.oracle.premigration.commons.enums.TargetCloud;
import com.oracle.premigration.dbinspector.Check;
import com.oracle.premigration.dbinspector.CheckResult;
import com.oracle.premigration.dbinspector.DatabaseObject;
import com.oracle.premigration.dbinspector.ExecutionContext;
import com.oracle.premigration.helpers.SqlUtils;
import com.oracle.premigration.logger.PremigrationLogger;
import java.util.Arrays;

public class has_ilm_ado_policies
extends Check {
    private static final PremigrationLogger log = PremigrationLogger.getLogger(has_ilm_ado_policies.class.getName());

    public has_ilm_ado_policies() {
        this.getTargetCloud().addAll(Arrays.asList(TargetCloud.ADWD, TargetCloud.ADWS, TargetCloud.ATPD, TargetCloud.ATPS));
        this.getMigrationMethods().addAll(Arrays.asList(MigrationMethod.DATAPUMP, MigrationMethod.DATAPUMP_DBLINK, MigrationMethod.GOLDENGATE));
        this.setScope(Check.Scope.SCHEMA);
        this.setDeclarativeResult(CheckResult.WARNING);
    }

    @Override
    public void prepare(ExecutionContext exeCtx) {
        boolean hasILMObjectView = exeCtx.hasDatabaseObject(DatabaseObject.builder().schema("SYS").view("DBA_ILMOBJECTS").build());
        if (hasILMObjectView) {
            String whereClause = SqlUtils.createWhereClauseForColumn(exeCtx, "OBJECT_OWNER");
            String sqlQuery = "SELECT OBJECT_OWNER, POLICY_NAME, OBJECT_NAME, OBJECT_TYPE  FROM SYS.DBA_ILMOBJECTS " + whereClause + " AND OBJECT_TYPE = 'TABLE'  AND ENABLED = 'YES' ORDER BY 1,2,3";
            this.setSqlQuery(sqlQuery);
        } else {
            this.skipCheck(this.lang.txt("CHECK_SKIPPED_BECAUSE_OBJECT_MISSING", this.getName(), "DBA_ILMOBJECTS", "TABLE"), CheckResult.PASS);
        }
    }
}

