/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.premigration.dbinspector.checks;

import com.oracle.premigration.commons.enums.MigrationMethod;
import com.oracle.premigration.commons.enums.TargetCloud;
import com.oracle.premigration.dbinspector.Check;
import com.oracle.premigration.dbinspector.CheckResult;
import com.oracle.premigration.dbinspector.ExecutionContext;
import com.oracle.premigration.dbinspector.FilterableCheck;
import com.oracle.premigration.helpers.SqlUtils;
import com.oracle.premigration.reports.CheckFiltrationMetadata;
import com.oracle.premigration.reports.filters.DataType;
import java.util.Arrays;

public class has_incompatible_jobs
extends FilterableCheck {
    public has_incompatible_jobs() {
        this.getTargetCloud().addAll(Arrays.asList(TargetCloud.ADWD, TargetCloud.ADWS, TargetCloud.ATPD, TargetCloud.ATPS));
        this.getMigrationMethods().addAll(Arrays.asList(MigrationMethod.DATAPUMP, MigrationMethod.DATAPUMP_DBLINK, MigrationMethod.GOLDENGATE));
        this.setScope(Check.Scope.SCHEMA);
        this.setDeclarativeResult(CheckResult.WARNING);
    }

    @Override
    public void initFiltrationMetadata() {
        this.setFiltrationMetadata(CheckFiltrationMetadata.builder().schemaOwnerColumn("OWNER").objectNameColumn("NAME").objectTypeFixed(DataType.JOB).build());
    }

    @Override
    public void prepare(ExecutionContext exeCtx) {
        String whereClause = SqlUtils.createWhereClauseForOwnerColumn(exeCtx);
        String sqlQuery = "SELECT OWNER, NAME, TYPE, LOCUS FROM (    SELECT OWNER, JOB_NAME AS NAME, JOB_TYPE AS TYPE, 'DBA_SCHEDULER_JOBS' AS LOCUS     FROM SYS.DBA_SCHEDULER_JOBS " + whereClause + "    AND JOB_TYPE NOT IN ('STORED_PROCEDURE','PLSQL_BLOCK')   UNION ALL   SELECT OWNER, PROGRAM_NAME AS NAME, PROGRAM_TYPE AS TYPE, 'DBA_SCHEDULER_PROGRAMS' AS LOCUS     FROM SYS.DBA_SCHEDULER_PROGRAMS " + whereClause + "    AND PROGRAM_TYPE NOT IN ('STORED_PROCEDURE','PLSQL_BLOCK') ) ORDER BY 1, 2, 3";
        this.setSqlQuery(sqlQuery);
    }
}

