/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.premigration.dbinspector.checks;

import com.oracle.premigration.commons.enums.MigrationMethod;
import com.oracle.premigration.commons.enums.TargetCloud;
import com.oracle.premigration.dbinspector.Check;
import com.oracle.premigration.dbinspector.CheckResult;
import com.oracle.premigration.dbinspector.ExecutionContext;
import com.oracle.premigration.helpers.SqlUtils;
import java.util.Arrays;

public class has_java_objects
extends Check {
    public has_java_objects() {
        this.getTargetCloud().addAll(Arrays.asList(TargetCloud.ATPS, TargetCloud.ADWS));
        this.getMigrationMethods().addAll(Arrays.asList(MigrationMethod.DATAPUMP, MigrationMethod.DATAPUMP_DBLINK, MigrationMethod.GOLDENGATE));
        this.setScope(Check.Scope.SCHEMA);
        this.setDeclarativeResult(CheckResult.BLOCKER);
    }

    @Override
    public void prepare(ExecutionContext exeCtx) {
        String whereClause = SqlUtils.createWhereClauseForOwnerColumn(exeCtx);
        String hasJavaObjectsSql = "SELECT OWNER, OBJECT_NAME, OBJECT_TYPE, STATUS FROM SYS.DBA_OBJECTS " + whereClause + " AND OBJECT_TYPE IN ('JAVA CLASS', 'JAVA RESOURCES', 'JAVA DATA') ORDER BY 1, 2";
        this.setSqlQuery(hasJavaObjectsSql);
    }
}

