/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.premigration.dbinspector.checks;

import com.oracle.premigration.commons.enums.MigrationMethod;
import com.oracle.premigration.commons.enums.TargetCloud;
import com.oracle.premigration.dbinspector.Check;
import com.oracle.premigration.dbinspector.CheckResult;
import com.oracle.premigration.dbinspector.ExecutionContext;
import com.oracle.premigration.dbinspector.FilterableCheck;
import com.oracle.premigration.helpers.SqlUtils;
import com.oracle.premigration.reports.CheckFiltrationMetadata;
import com.oracle.premigration.reports.filters.DataType;
import java.util.Arrays;

public class has_logging_off_for_partitions
extends FilterableCheck {
    public has_logging_off_for_partitions() {
        this.getTargetCloud().addAll(Arrays.asList(TargetCloud.ADWD, TargetCloud.ADWS, TargetCloud.ATPD, TargetCloud.ATPS));
        this.getMigrationMethods().addAll(Arrays.asList(MigrationMethod.DATAPUMP, MigrationMethod.DATAPUMP_DBLINK, MigrationMethod.GOLDENGATE));
        this.setScope(Check.Scope.SCHEMA);
        this.setDeclarativeResult(CheckResult.INFORMATIONAL);
    }

    @Override
    public void initFiltrationMetadata() {
        this.setFiltrationMetadata(CheckFiltrationMetadata.builder().schemaOwnerColumn("TABLE_OWNER").objectNameColumn("TABLE_NAME").objectTypeFixed(DataType.TABLE).build());
    }

    @Override
    public void prepare(ExecutionContext exeCtx) {
        String dbForceLogging = SqlUtils.getDatabaseForceLogging(exeCtx);
        if ("YES".equalsIgnoreCase(dbForceLogging)) {
            this.skipCheck(this.lang.txt("CHECK_SKIPPED_BECAUSE_DATABASE_SETTING", this.getName(), "FORCE_LOGGING", "YES"), CheckResult.PASS);
        } else {
            String whereClause = SqlUtils.createWhereClauseForColumn(exeCtx, "P.TABLE_OWNER");
            String sqlQuery = "SELECT  P.TABLE_OWNER, P.TABLE_NAME, P.PARTITION_NAME, P.TABLESPACE_NAME  FROM SYS.DBA_TAB_PARTITIONS P, SYS.DBA_TABLESPACES S " + whereClause + "  AND NVL(P.LOGGING,       (CASE S.LOGGING         WHEN 'LOGGING' THEN 'YES'         WHEN 'NOLOGGING' THEN 'NO'         ELSE NULL        END)     ) = 'NO'   AND P.TABLESPACE_NAME = S.TABLESPACE_NAME   AND NOT NVL(S.FORCE_LOGGING, 'NO') = 'YES'  ORDER BY 1,2,3";
            this.setSqlQuery(sqlQuery);
        }
    }
}

