/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.premigration.dbinspector.checks;

import com.oracle.premigration.commons.enums.MigrationMethod;
import com.oracle.premigration.commons.enums.TargetCloud;
import com.oracle.premigration.dbinspector.Check;
import com.oracle.premigration.dbinspector.CheckResult;
import com.oracle.premigration.dbinspector.DatabaseObject;
import com.oracle.premigration.dbinspector.ExecutionContext;
import com.oracle.premigration.helpers.SqlUtils;
import java.util.Arrays;

public class has_mining_model_issues
extends Check {
    public has_mining_model_issues() {
        this.getTargetCloud().addAll(Arrays.asList(TargetCloud.ATPS, TargetCloud.ADWS, TargetCloud.ATPD, TargetCloud.ADWD, TargetCloud.DEFAULT));
        this.getMigrationMethods().addAll(Arrays.asList(MigrationMethod.DATAPUMP, MigrationMethod.DATAPUMP_DBLINK));
        this.setScope(Check.Scope.SCHEMA);
        this.setDeclarativeResult(CheckResult.BLOCKER);
    }

    @Override
    public void prepare(ExecutionContext exeCtx) {
        int expectedUpgradeVersion;
        boolean canSelectSysModel$ = exeCtx.canSelectDatabaseObject(DatabaseObject.builder().schema("SYS").table("MODEL$").build());
        if (!canSelectSysModel$) {
            String message = this.lang.txt("CHECK_SKIPPED_BECAUSE_OBJECT_NOT_ACCESSIBLE", this.getName(), "SYS.MODEL$");
            this.skipCheck(message, CheckResult.WARNING);
            return;
        }
        boolean hasPropertiesColumn = exeCtx.hasDatabaseObject(DatabaseObject.builder().schema("SYS").table("MODEL$").column("PROPERTIES").build());
        String whereClause = SqlUtils.createWhereClauseForOwnerColumn(exeCtx);
        String currentVersion = exeCtx.getDatabaseVersion();
        String propertiesIsNull = "";
        String propertiesColumn = " ";
        if (hasPropertiesColumn) {
            propertiesIsNull = " OR M.PROPERTIES IS NULL";
            propertiesColumn = " ,M.PROPERTIES";
        }
        if (currentVersion.startsWith("11.2")) {
            expectedUpgradeVersion = 0;
        } else if (currentVersion.startsWith("12.1")) {
            expectedUpgradeVersion = 3;
        } else if (currentVersion.startsWith("12.2")) {
            expectedUpgradeVersion = 4;
        } else if (currentVersion.startsWith("19") || currentVersion.startsWith("18")) {
            expectedUpgradeVersion = 5;
        } else if (currentVersion.startsWith("21")) {
            expectedUpgradeVersion = 6;
        } else if (currentVersion.startsWith("23")) {
            expectedUpgradeVersion = 7;
        } else {
            String message = this.lang.txt("CHECK.HAS_MINING_MODEL_ISSUES.SKIP_UNSUPPORTED_VERSION", currentVersion);
            this.skipCheck(message, CheckResult.WARNING);
            return;
        }
        String expectedVersion = " ,'" + expectedUpgradeVersion + "'";
        String sqlQuery = "SELECT O.OWNER, O.OBJECT_NAME, M.VERSION, (M.VERSION-(ROUND(M.VERSION/65536)*65536)) BUILD_VERSION, BITAND(VERSION,4294901760)/POWER(2,16) UPGRADE_VERSION" + expectedVersion + " AS EXPECTED_UPGRADE_VERSION" + propertiesColumn + " FROM SYS.MODEL$ M, SYS.DBA_OBJECTS O" + whereClause + " AND M.OBJ#=O.OBJECT_ID AND (BITAND(VERSION,4294901760)/POWER(2,16) < " + expectedUpgradeVersion + propertiesIsNull + " )";
        this.setSqlQuery(sqlQuery);
    }
}

