/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.premigration.dbinspector.checks;

import com.oracle.premigration.commons.enums.MigrationMethod;
import com.oracle.premigration.commons.enums.TargetCloud;
import com.oracle.premigration.dbinspector.Check;
import com.oracle.premigration.dbinspector.CheckResult;
import com.oracle.premigration.dbinspector.ExecutionContext;
import com.oracle.premigration.helpers.SqlUtils;
import com.oracle.premigration.helpers.Utilities;
import com.oracle.premigration.logger.PremigrationLogger;
import java.sql.SQLException;
import java.util.Arrays;
import java.util.List;

public class has_noexport_object_grants
extends Check {
    private static final PremigrationLogger log = PremigrationLogger.getLogger(has_noexport_object_grants.class.getName());

    public has_noexport_object_grants() {
        this.getTargetCloud().addAll(Arrays.asList(TargetCloud.ADWD, TargetCloud.ADWS, TargetCloud.ATPD, TargetCloud.ATPS, TargetCloud.DEFAULT));
        this.getMigrationMethods().addAll(Arrays.asList(MigrationMethod.DATAPUMP, MigrationMethod.DATAPUMP_DBLINK, MigrationMethod.GOLDENGATE));
        this.setScope(Check.Scope.SCHEMA);
        this.setDeclarativeResult(CheckResult.WARNING);
    }

    @Override
    public void prepare(ExecutionContext exeCtx) {
        try {
            String whereClause = SqlUtils.createWhereClauseForColumn(exeCtx, "KUOJV.GRANTEE");
            List<String> excludeSchemas = SqlUtils.getExcludedSchemaDefaults(exeCtx);
            if (!excludeSchemas.contains("SYS")) {
                excludeSchemas.add("SYS");
            }
            String baseObjectPredicate = SqlUtils.createAndClause("KUOJV.BASE_OBJ.OWNER_NAME", true, excludeSchemas);
            String sqlQuery = "SELECT KUOJV.GRANTEE,   KUOJV.BASE_OBJ.OWNER_NAME AS OBJECT_OWNER,   KUOJV.BASE_OBJ.NAME AS OBJECT_NAME,   KUOJV.PRIVNAME AS PRIVILEGE,   KUOJV.GRANTOR  FROM SYS.KU$_OBJGRANT_VIEW KUOJV " + whereClause + " AND KUOJV.GRANTEE IN (SELECT USERNAME FROM SYS.DBA_USERS) " + baseObjectPredicate + " ORDER BY GRANTEE, OBJECT_OWNER, OBJECT_NAME, PRIVILEGE, GRANTOR";
            this.setSqlQuery(sqlQuery);
        }
        catch (SQLException e) {
            String msg = Utilities.getErrorText("ERROR2000", e, this.getName());
            log.severe(msg, e);
            this.skipCheck(msg, CheckResult.FATAL);
        }
    }
}

