/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.premigration.dbinspector.checks;

import com.oracle.premigration.commons.enums.MigrationMethod;
import com.oracle.premigration.dbinspector.Check;
import com.oracle.premigration.dbinspector.CheckResult;
import com.oracle.premigration.dbinspector.ExecutionContext;
import com.oracle.premigration.helpers.SqlUtils;
import com.oracle.premigration.logger.PremigrationLogger;
import java.util.Arrays;
import java.util.List;

public abstract class has_refs_to_restricted_packages
extends Check {
    private static final PremigrationLogger log = PremigrationLogger.getLogger(has_refs_to_restricted_packages.class.getName());
    protected List<String> unsupportedPackages;
    protected List<String> restrictedPackages;

    public has_refs_to_restricted_packages() {
        this.getMigrationMethods().addAll(Arrays.asList(MigrationMethod.DATAPUMP, MigrationMethod.DATAPUMP_DBLINK, MigrationMethod.GOLDENGATE));
        this.setScope(Check.Scope.SCHEMA);
        this.setDeclarativeResult(CheckResult.WARNING);
    }

    @Override
    public void prepare(ExecutionContext exeCtx) {
        String whereClause = SqlUtils.createWhereClauseForOwnerColumn(exeCtx);
        String sqlQuery = "SELECT OWNER, NAME, TYPE, REFERENCED_NAME, SUPPORT FROM (  SELECT OWNER, NAME, TYPE, REFERENCED_NAME, 'UNSUPPORTED' AS SUPPORT FROM SYS.DBA_DEPENDENCIES" + whereClause + "  AND REFERENCED_NAME " + SqlUtils.createInClause(this.unsupportedPackages) + "  UNION ALL  SELECT OWNER, NAME, TYPE, REFERENCED_NAME, 'PARTIALLY SUPPORTED' AS SUPPORT FROM SYS.DBA_DEPENDENCIES" + whereClause + "  AND REFERENCED_NAME " + SqlUtils.createInClause(this.restrictedPackages) + ") WHERE OWNER <> 'PUBLIC' AND TYPE <> 'SYNONYM' AND NAME <> REFERENCED_NAME ORDER BY 1,2,3,4";
        this.setSqlQuery(sqlQuery);
    }
}

