/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.premigration.dbinspector.checks;

import com.oracle.premigration.commons.enums.MigrationMethod;
import com.oracle.premigration.commons.enums.TargetCloud;
import com.oracle.premigration.commons.enums.TargetInstanceProp;
import com.oracle.premigration.dbinspector.Check;
import com.oracle.premigration.dbinspector.CheckResult;
import com.oracle.premigration.dbinspector.ExecutionContext;
import com.oracle.premigration.dbinspector.FilterableCheck;
import com.oracle.premigration.helpers.SqlUtils;
import com.oracle.premigration.logger.PremigrationLogger;
import com.oracle.premigration.reports.CheckFiltrationMetadata;
import com.oracle.premigration.reports.filters.DataType;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;

public class has_sys_privileges
extends FilterableCheck {
    private static final PremigrationLogger log = PremigrationLogger.getLogger(has_sys_privileges.class.getName());

    public has_sys_privileges() {
        this.getTargetCloud().addAll(Arrays.asList(TargetCloud.ATPD, TargetCloud.ATPS, TargetCloud.ADWD, TargetCloud.ADWS));
        this.getMigrationMethods().addAll(Arrays.asList(MigrationMethod.DATAPUMP, MigrationMethod.DATAPUMP_DBLINK, MigrationMethod.GOLDENGATE));
        this.setScope(Check.Scope.SCHEMA);
        this.setDeclarativeResult(CheckResult.BLOCKER);
    }

    @Override
    public void initFiltrationMetadata() {
        this.setFiltrationMetadata(CheckFiltrationMetadata.builder().schemaOwnerColumn("GRANTEE").objectNameColumn("PRIVILEGE").objectTypeFixed(DataType.GRANT).build());
    }

    @Override
    public void prepare(ExecutionContext exeCtx) {
        boolean hasTargetPrivsProp = true;
        String targetPrivProp = exeCtx.getAnalysisProperty(TargetInstanceProp.SYSPRIVILEGE.getKey());
        if (targetPrivProp == null || targetPrivProp.trim().length() == 0) {
            hasTargetPrivsProp = false;
        }
        if (hasTargetPrivsProp) {
            List<Object> srcPrivList = new ArrayList();
            String granteeWhereClause = SqlUtils.createWhereClauseForColumn(exeCtx, "grantee");
            String srcPrivQuery = "SELECT PRIVILEGE FROM SYS.DBA_SYS_PRIVS " + granteeWhereClause;
            try {
                srcPrivList = SqlUtils.getStringList(srcPrivQuery, exeCtx);
            }
            catch (SQLException e) {
                log.severe("Exception calling SqlUtils.getStringList with '" + srcPrivQuery + "'", e);
            }
            ArrayList<String> targetPrivList = new ArrayList<String>(Arrays.asList(targetPrivProp.split(",")));
            srcPrivList.removeAll(targetPrivList);
            String sqlQuery = "SELECT GRANTEE, PRIVILEGE FROM SYS.DBA_SYS_PRIVS " + granteeWhereClause + " AND GRANTEE IN (SELECT USERNAME FROM SYS.DBA_USERS)  AND PRIVILEGE " + SqlUtils.createInClause(srcPrivList);
            this.setSqlQuery(sqlQuery);
        } else {
            this.skipCheck(this.lang.txt("CHECK_SKIPPED_BECAUSE_PRIVILEGE_MISSING", this.getName()), CheckResult.WARNING);
        }
    }
}

