/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.premigration.dbinspector.checks;

import com.oracle.premigration.commons.enums.MigrationMethod;
import com.oracle.premigration.commons.enums.MigrationMethodProp;
import com.oracle.premigration.commons.enums.TargetCloud;
import com.oracle.premigration.dbinspector.Check;
import com.oracle.premigration.dbinspector.CheckResult;
import com.oracle.premigration.dbinspector.DatabaseObject;
import com.oracle.premigration.dbinspector.ExecutionContext;
import com.oracle.premigration.dbinspector.FilterableCheck;
import com.oracle.premigration.helpers.SqlUtils;
import com.oracle.premigration.reports.CheckFiltrationMetadata;
import com.oracle.premigration.reports.filters.DataType;
import java.util.Arrays;

public class has_tables_with_xmltype_column
extends FilterableCheck {
    public has_tables_with_xmltype_column() {
        this.getTargetCloud().addAll(Arrays.asList(TargetCloud.ADWD, TargetCloud.ADWS, TargetCloud.ATPD, TargetCloud.ATPS));
        this.getMigrationMethods().addAll(Arrays.asList(MigrationMethod.DATAPUMP, MigrationMethod.DATAPUMP_DBLINK, MigrationMethod.GOLDENGATE));
        this.setScope(Check.Scope.SCHEMA);
        this.setDeclarativeResult(CheckResult.BLOCKER);
    }

    @Override
    public void initFiltrationMetadata() {
        this.setFiltrationMetadata(CheckFiltrationMetadata.builder().schemaOwnerColumn("OWNER").objectNameColumn("TABLE_NAME").objectTypeFixed(DataType.TABLE).build());
    }

    @Override
    public void prepare(ExecutionContext exeCtx) {
        String xmlTransformEnabled = exeCtx.getAnalysisProperty(MigrationMethodProp.XML_STORAGE_TRANSFORM.getKey(), "false");
        String orStorageIsBinaryClause = "";
        if (!xmlTransformEnabled.toLowerCase().equals("true")) {
            orStorageIsBinaryClause = " OR STORAGE_TYPE != 'BINARY'";
        }
        String whereClause = SqlUtils.createWhereClauseForOwnerColumn(exeCtx);
        boolean hasXmlTabCols = exeCtx.hasDatabaseObject(DatabaseObject.builder().schema("SYS").view("DBA_XML_TAB_COLS").build());
        if (hasXmlTabCols) {
            String xmlTypeColumnsSql = "SELECT OWNER, TABLE_NAME, COLUMN_NAME, STORAGE_TYPE, XMLSCHEMA, SCHEMA_OWNER  FROM SYS.DBA_XML_TAB_COLS " + whereClause + " AND (XMLSCHEMA IS NOT NULL" + orStorageIsBinaryClause + ") ORDER BY 1,2,3";
            this.setSqlQuery(xmlTypeColumnsSql);
        } else {
            this.skipCheck(this.lang.txt("CHECK_SKIPPED_BECAUSE_COMPONENT_NOT_INSTALLED", this.getName(), "XDB"), CheckResult.PASS);
        }
    }
}

