/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.premigration.dbinspector.checks;

import com.oracle.premigration.commons.enums.MigrationMethod;
import com.oracle.premigration.commons.enums.TargetCloud;
import com.oracle.premigration.dbinspector.Check;
import com.oracle.premigration.dbinspector.CheckResult;
import com.oracle.premigration.dbinspector.DatabaseObject;
import com.oracle.premigration.dbinspector.ExecutionContext;
import com.oracle.premigration.dbinspector.FilterableCheck;
import com.oracle.premigration.helpers.SqlUtils;
import com.oracle.premigration.reports.CheckFiltrationMetadata;
import com.oracle.premigration.reports.filters.DataType;
import java.util.Arrays;

public class has_xmltype_tables
extends FilterableCheck {
    public has_xmltype_tables() {
        this.getTargetCloud().addAll(Arrays.asList(TargetCloud.ADWD, TargetCloud.ADWS, TargetCloud.ATPD, TargetCloud.ATPS));
        this.getMigrationMethods().addAll(Arrays.asList(MigrationMethod.DATAPUMP, MigrationMethod.DATAPUMP_DBLINK, MigrationMethod.GOLDENGATE));
        this.setScope(Check.Scope.SCHEMA);
        this.setDeclarativeResult(CheckResult.BLOCKER);
    }

    @Override
    public void initFiltrationMetadata() {
        this.setFiltrationMetadata(CheckFiltrationMetadata.builder().schemaOwnerColumn("OWNER").objectNameColumn("TABLE_NAME").objectTypeFixed(DataType.TABLE).build());
    }

    @Override
    public void prepare(ExecutionContext exeCtx) {
        String whereClause = SqlUtils.createWhereClauseForOwnerColumn(exeCtx);
        boolean hasXmlTables = exeCtx.hasDatabaseObject(DatabaseObject.builder().schema("SYS").view("DBA_XML_TABLES").build());
        if (hasXmlTables) {
            String xmlTablesSql = "SELECT OWNER, TABLE_NAME, STORAGE_TYPE  FROM SYS.DBA_XML_TABLES " + whereClause + " AND STORAGE_TYPE != 'BINARY' ORDER BY 1,2";
            this.setSqlQuery(xmlTablesSql);
        } else {
            this.skipCheck(this.lang.txt("CHECK_SKIPPED_BECAUSE_COMPONENT_NOT_INSTALLED", this.getName(), "XDB"), CheckResult.PASS);
        }
    }
}

