/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.premigration.dbinspector.checks;

import com.oracle.premigration.commons.enums.MigrationMethod;
import com.oracle.premigration.commons.enums.TargetCloud;
import com.oracle.premigration.dbinspector.Check;
import com.oracle.premigration.dbinspector.CheckResult;
import com.oracle.premigration.dbinspector.ExecutionContext;
import com.oracle.premigration.dbinspector.FilterableCheck;
import com.oracle.premigration.reports.CheckFiltrationMetadata;
import com.oracle.premigration.reports.filters.DataType;
import java.util.Arrays;
import java.util.List;

public class lcm_super_admin_user_exists
extends FilterableCheck {
    private static final String LCM_SUPER_ADMIN = "LCM_SUPER_ADMIN";
    private static final String lcmSuperAdminSql = "SELECT USERNAME, ACCOUNT_STATUS, CREATED, PROFILE FROM SYS.DBA_USERS WHERE USERNAME = 'LCM_SUPER_ADMIN'";

    public lcm_super_admin_user_exists() {
        this.getTargetCloud().addAll(Arrays.asList(TargetCloud.ATPS, TargetCloud.ATPD, TargetCloud.ADWS, TargetCloud.ADWD));
        this.getMigrationMethods().addAll(Arrays.asList(MigrationMethod.DATAPUMP, MigrationMethod.DATAPUMP_DBLINK, MigrationMethod.GOLDENGATE));
        this.setScope(Check.Scope.INSTANCE);
        this.setDeclarativeResult(CheckResult.INFORMATIONAL);
    }

    @Override
    public void initFiltrationMetadata() {
        this.setFiltrationMetadata(CheckFiltrationMetadata.builder().schemaOwnerColumn("USERNAME").objectNameColumn("USERNAME").objectTypeFixed(DataType.USER).build());
    }

    @Override
    public void prepare(ExecutionContext exeCtx) {
        this.setSqlQuery(lcmSuperAdminSql);
        List<String> excludedSchemas = exeCtx.getExcludeSchemas();
        if (excludedSchemas.contains(LCM_SUPER_ADMIN)) {
            this.skipCheck(this.lang.txt("CHECK_SKIPPED_BECAUSE_SCHEMA_EXCLUDED", this.getName(), LCM_SUPER_ADMIN));
        }
    }
}

