/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.premigration.dbinspector.checks;

import com.oracle.premigration.commons.enums.MigrationMethod;
import com.oracle.premigration.commons.enums.TargetCloud;
import com.oracle.premigration.commons.enums.TargetInstanceProp;
import com.oracle.premigration.commons.enums.Version;
import com.oracle.premigration.dbinspector.Check;
import com.oracle.premigration.dbinspector.CheckResult;
import com.oracle.premigration.dbinspector.ExecutionContext;
import com.oracle.premigration.dbinspector.FilterableCheck;
import com.oracle.premigration.helpers.SqlUtils;
import com.oracle.premigration.reports.CheckFiltrationMetadata;
import com.oracle.premigration.reports.filters.DataType;
import java.util.Arrays;

public class nls_nchar_ora_910
extends FilterableCheck {
    public nls_nchar_ora_910() {
        this.getTargetCloud().addAll(Arrays.asList(TargetCloud.ATPD, TargetCloud.ATPS, TargetCloud.ADWD, TargetCloud.ADWS, TargetCloud.DEFAULT));
        this.getMigrationMethods().addAll(Arrays.asList(MigrationMethod.DATAPUMP, MigrationMethod.DATAPUMP_DBLINK, MigrationMethod.GOLDENGATE));
        this.setScope(Check.Scope.SCHEMA);
        this.setDeclarativeResult(CheckResult.BLOCKER);
    }

    @Override
    public void initFiltrationMetadata() {
        this.setFiltrationMetadata(CheckFiltrationMetadata.builder().schemaOwnerColumn("OWNER").objectNameColumn("TABLE_NAME").objectTypeFixed(DataType.TABLE).build());
    }

    @Override
    public void prepare(ExecutionContext exeCtx) {
        block10: {
            String sourceNationalCharSet;
            String sourceMaxStringSize;
            if (Version.v12_1_0_1.compare(exeCtx.getDatabaseVersion()) >= 0) {
                sourceMaxStringSize = "STANDARD";
            } else {
                try {
                    String sqlQuery = "SELECT VALUE FROM V$PARAMETER WHERE LOWER(NAME) = 'max_string_size'";
                    sourceMaxStringSize = SqlUtils.getSingleString("SELECT VALUE FROM V$PARAMETER WHERE LOWER(NAME) = 'max_string_size'", exeCtx);
                }
                catch (Exception e) {
                    this.skipCheck(e.getMessage(), CheckResult.FATAL);
                    break block10;
                }
            }
            try {
                String sqlQuery = "SELECT VALUE FROM NLS_DATABASE_PARAMETERS WHERE PARAMETER = 'NLS_NCHAR_CHARACTERSET'";
                sourceNationalCharSet = SqlUtils.getSingleString("SELECT VALUE FROM NLS_DATABASE_PARAMETERS WHERE PARAMETER = 'NLS_NCHAR_CHARACTERSET'", exeCtx);
            }
            catch (Exception e) {
                this.skipCheck(e.getMessage(), CheckResult.FATAL);
                break block10;
            }
            String targetMaxStringSize = exeCtx.getAnalysisProperty(TargetInstanceProp.MAX_STRING_SIZE.getKey(), "EXTENDED");
            String targetNationalCharSet = exeCtx.getAnalysisProperty(TargetInstanceProp.NLS_NCHAR_CHARACTERSET.getKey(), "AL16UTF16");
            if ("EXTENDED".equals(sourceMaxStringSize) && "STANDARD".equals(targetMaxStringSize)) {
                String message = this.lang.txt("CHECK.NLS_NCHAR_ORA_910.WARNING");
                this.skipCheck(message, CheckResult.WARNING);
            } else if ("AL16UTF16".equals(sourceNationalCharSet) || "UTF8".equals(targetNationalCharSet)) {
                String message = this.lang.txt("CHECK.NLS_NCHAR_ORA_910.PASS");
                this.skipCheck(message, CheckResult.PASS);
            } else {
                String nvarchar2Length = "STANDARD".equals(targetMaxStringSize) ? "2000" : "16383";
                String whereClause = SqlUtils.createWhereClauseForColumn(exeCtx, "OWNER");
                String sqlQueryMain = "SELECT OWNER, TABLE_NAME, COLUMN_NAME, DATA_TYPE, CHAR_LENGTH FROM DBA_TAB_COLUMNS " + whereClause + " AND ((DATA_TYPE='NVARCHAR2' AND CHAR_LENGTH>" + nvarchar2Length + ") OR (DATA_TYPE='NCHAR' AND CHAR_LENGTH>1000))";
                this.setSqlQuery(sqlQueryMain);
            }
        }
    }
}

