/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.premigration.dbinspector.checks;

import com.oracle.premigration.commons.enums.MigrationMethod;
import com.oracle.premigration.commons.enums.TargetCloud;
import com.oracle.premigration.dbinspector.Check;
import com.oracle.premigration.dbinspector.CheckResult;
import com.oracle.premigration.dbinspector.DatabaseObject;
import com.oracle.premigration.dbinspector.ExecutionContext;
import java.util.Arrays;

public class xdb_resource_view_has_entries
extends Check {
    public xdb_resource_view_has_entries() {
        this.getTargetCloud().addAll(Arrays.asList(TargetCloud.ATPS, TargetCloud.ADWS, TargetCloud.ATPD, TargetCloud.ADWD, TargetCloud.DEFAULT));
        this.getMigrationMethods().addAll(Arrays.asList(MigrationMethod.DATAPUMP, MigrationMethod.DATAPUMP_DBLINK, MigrationMethod.GOLDENGATE));
        this.setScope(Check.Scope.INSTANCE);
        this.setDeclarativeResult(CheckResult.WARNING);
    }

    @Override
    public void prepare(ExecutionContext exeCtx) {
        boolean hasResourceView = exeCtx.hasDatabaseObject(DatabaseObject.builder().schema("XDB").view("RESOURCE_VIEW").build());
        if (hasResourceView) {
            this.setSqlQuery("SELECT ANY_PATH FROM RESOURCE_VIEW");
        } else {
            this.skipCheck(this.lang.txt("CHECK_SKIPPED_BECAUSE_OBJECT_MISSING", this.getName(), "RESOURCE_VIEW", "VIEW"), CheckResult.PASS);
        }
    }
}

