/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.premigration.helpers;

import com.oracle.premigration.commons.enums.MigrationMethodProp;
import com.oracle.premigration.commons.enums.TargetInstanceProp;
import com.oracle.premigration.dbinspector.ExecutionContext;
import com.oracle.premigration.helpers.SqlUtils;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;

public class AnalysisPropHelper {
    private final String migrationTablespaceMapping;
    private final List<String> defaultList;
    private final ExecutionContext exeCtx;
    private final String columnName;
    private final List<String> sourceTablespacesList;
    private final List<String> targetPropTablespacesList = new ArrayList<String>();
    private final List<String> migrationMethodPropTablespacesNotMappedList = new ArrayList<String>();

    public AnalysisPropHelper(ExecutionContext exeCtx, List<String> defaultList, String columnName) {
        String migrationMethodPropTablespacesNotMapped;
        this.defaultList = defaultList;
        this.exeCtx = exeCtx;
        this.migrationTablespaceMapping = exeCtx.getAnalysisProperty(MigrationMethodProp.TABLESPACE_MAPPING.getKey());
        String targetPropTablespaces = exeCtx.getAnalysisProperty(TargetInstanceProp.TABLESPACES.getKey());
        if (targetPropTablespaces != null && !targetPropTablespaces.trim().isEmpty()) {
            this.targetPropTablespacesList.addAll(Arrays.asList(targetPropTablespaces.trim().split(",")));
        }
        if ((migrationMethodPropTablespacesNotMapped = exeCtx.getAnalysisProperty(MigrationMethodProp.TABLESPACES_NOT_MAPPED.getKey())) != null && !migrationMethodPropTablespacesNotMapped.trim().isEmpty()) {
            this.migrationMethodPropTablespacesNotMappedList.addAll(Arrays.asList(migrationMethodPropTablespacesNotMapped.trim().split(",")));
        }
        this.columnName = columnName;
        this.sourceTablespacesList = this.exeCtx.getTablespacesNames();
    }

    public String getInClause() throws SQLException {
        boolean hasTargetProperty = true;
        boolean hasMigrationMethodProperty = true;
        if (this.targetPropTablespacesList.isEmpty()) {
            hasTargetProperty = false;
        }
        if (this.migrationMethodPropTablespacesNotMappedList.isEmpty()) {
            hasMigrationMethodProperty = false;
        }
        String andClause = hasMigrationMethodProperty ? SqlUtils.createAndClause(this.columnName, true, this.migrationMethodPropTablespacesNotMappedList) : (hasTargetProperty ? SqlUtils.createAndClause(this.columnName, false, this.targetPropTablespacesList) : SqlUtils.createAndClause(this.columnName, false, this.defaultList));
        return " " + andClause;
    }

    public boolean isMigrationMethodMappingAll() {
        return this.migrationTablespaceMapping != null && this.migrationTablespaceMapping.trim().equals("ALL");
    }
}

