/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.premigration.helpers;

import com.oracle.premigration.commons.EnvironmentContext;
import com.oracle.premigration.commons.enums.SourceAnalysisProp;
import com.oracle.premigration.commons.enums.TargetInstanceProp;
import com.oracle.premigration.commons.lang.Language;
import com.oracle.premigration.dbinspector.ExecutionContext;
import com.oracle.premigration.exceptions.AccessDeniedException;
import com.oracle.premigration.logger.PremigrationLogger;
import java.io.File;
import java.io.IOException;
import java.io.PrintWriter;
import java.io.StringWriter;
import java.io.Writer;
import java.net.InetAddress;
import java.net.UnknownHostException;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.TimeZone;
import java.util.concurrent.TimeUnit;
import java.util.logging.Level;

public class Utilities {
    private static final PremigrationLogger log = PremigrationLogger.getLogger(Utilities.class.getName());
    private static final Language lang = Language.getInstance();
    private static final String OPERATING_SYSTEM = System.getProperty("os.name");

    public static String getISODateTimeString(Object date) {
        SimpleDateFormat df = new SimpleDateFormat("yyyy-MM-dd'T'HH:mm:ss'Z'");
        df.setTimeZone(TimeZone.getTimeZone("UTC"));
        return df.format(date);
    }

    public static String getHostName() {
        String hostname;
        try {
            InetAddress inetAddress = InetAddress.getLocalHost();
            hostname = inetAddress.getCanonicalHostName();
        }
        catch (UnknownHostException e) {
            log.severe("failed to obtain hostname", e);
            hostname = "<unavailable>";
        }
        return hostname;
    }

    public static String exceptionStackTraceToString(Throwable throwable) {
        if (throwable == null) {
            return "";
        }
        StringWriter stackTraceSink = new StringWriter();
        throwable.printStackTrace(new PrintWriter((Writer)stackTraceSink, true));
        return stackTraceSink.toString();
    }

    public static String getErrorText(String errorCode, String ... values) {
        return Utilities.getErrorText(errorCode, null, values);
    }

    public static String getErrorText(String errorCode, Throwable throwable, String ... values) {
        return Utilities.getErrorTextNoAction(errorCode, throwable, values) + lang.txt(errorCode + ".ACTION") + System.lineSeparator();
    }

    public static String getErrorTextNoAction(String errorCode, Throwable throwable, String ... values) {
        String causalText = null;
        if (throwable != null && (causalText = throwable.getLocalizedMessage()) == null && (causalText = throwable.getMessage()) == null) {
            causalText = throwable.toString();
        }
        StringBuilder errorBuffer = new StringBuilder(lang.txt(errorCode + ".ERROR")).append(": ").append(lang.txt(errorCode + ".CAUSE", values)).append(System.lineSeparator());
        if (causalText != null) {
            if (errorCode.endsWith("1004")) {
                boolean isOracleHomeError = causalText.contains("ORA-01034") && causalText.contains("ORA-27101");
                boolean isNoOracleSIDError = causalText.contains("ORA-12162");
                boolean isPermissionIssue = causalText.contains("ORA-01017");
                boolean isNullPasswordError = causalText.contains("ORA-01005");
                if (isOracleHomeError || isNoOracleSIDError) {
                    causalText = lang.txt("APP_HOME_SID_MSG");
                } else if (isPermissionIssue) {
                    causalText = lang.txt("APP_PERMISSION_MSG");
                } else if (isNullPasswordError) {
                    causalText = lang.txt("APP_PASSWORD_MSG");
                }
            }
            errorBuffer.append(causalText).append(System.lineSeparator());
        }
        return errorBuffer.toString();
    }

    public static String getValidFileName(String fileName) {
        String name = fileName.replaceAll("[^-_.A-Za-z0-9]", "").trim();
        if (name.length() == 0) {
            return "";
        }
        if (!Character.isAlphabetic(name.charAt(0))) {
            return null;
        }
        if (name.length() > 200) {
            name = name.substring(0, 199);
        }
        return name;
    }

    public static String join(String delimiter, Iterable<?> list) {
        StringBuilder sb = new StringBuilder();
        String loopDelimiter = "";
        for (Object s : list) {
            sb.append(loopDelimiter);
            sb.append(s.toString());
            loopDelimiter = delimiter;
        }
        return sb.toString();
    }

    public static String padRight(String str, int n) {
        return String.format("%-" + n + "s", str);
    }

    public static String repeatCharacter(int charCount, char character) {
        return new String(new char[charCount]).replace("\u0000", String.valueOf(character));
    }

    public static File getOutDirFile(String outDir) throws IOException {
        File file = new File(outDir);
        if (file.exists()) {
            return file;
        }
        if (file.mkdirs()) {
            return file;
        }
        throw new IOException("Cannot create dir " + outDir);
    }

    public static String getOutdirValidated(String outDir) throws IOException, AccessDeniedException {
        File file = Utilities.getOutDirFile(outDir);
        if (file.canWrite()) {
            return file.getCanonicalPath();
        }
        throw new AccessDeniedException("Cannot write on " + file.getCanonicalPath());
    }

    public static String getValidatedFilePath(String outDir, String fileName) throws IOException, AccessDeniedException {
        String validatedPath = Utilities.getOutdirValidated(outDir);
        Path path = Paths.get(validatedPath, new String[0]).resolve(fileName);
        String pathString = path.toAbsolutePath().toString();
        if (Files.exists(path, new LinkOption[0])) {
            if (!Files.isWritable(path)) {
                throw new AccessDeniedException(pathString);
            }
            if (Files.isDirectory(path, new LinkOption[0])) {
                throw new IOException(Utilities.getErrorText("ERROR3001", pathString));
            }
        }
        return pathString;
    }

    public static String getEnv(String varName, String defaultValue) {
        String value = System.getenv(varName);
        if (value == null) {
            return defaultValue;
        }
        return value;
    }

    public static void logEnvironmentVariables() {
        String defaultValue = "<environment variable not set>";
        ArrayList<String> varsToLog = new ArrayList<String>(Arrays.asList("JAVA_HOME", "CLASS_PATH", "ORACLE_BASE", "ORACLE_HOME", "ORACLE_SID", "TNS_ADMIN", "TWO_TASK", "NLS_LANG", "LD_LIBRARY_PATH", "ORACLE_PATH"));
        for (String envVarName : varsToLog) {
            String envValue = Utilities.getEnv(envVarName, "<environment variable not set>");
            String logMsg = "The value for environment variable '" + envVarName + "' is '" + envValue + "'";
            log.info(logMsg);
        }
    }

    public static String formatTimeInterval(long milliseconds) {
        long hours = TimeUnit.MILLISECONDS.toHours(milliseconds);
        long minutes = TimeUnit.MILLISECONDS.toMinutes(milliseconds - TimeUnit.HOURS.toMillis(hours));
        long seconds = TimeUnit.MILLISECONDS.toSeconds(milliseconds - TimeUnit.HOURS.toMillis(hours) - TimeUnit.MINUTES.toMillis(minutes));
        long millis = TimeUnit.MILLISECONDS.toMillis(milliseconds - TimeUnit.HOURS.toMillis(hours) - TimeUnit.MINUTES.toMillis(minutes) - TimeUnit.SECONDS.toMillis(seconds));
        return String.format("%02d:%02d:%02d.%03d", hours, minutes, seconds, millis);
    }

    public static boolean isInteger(String input) {
        try {
            Integer.parseInt(input);
            return true;
        }
        catch (NumberFormatException e) {
            return false;
        }
    }

    public static boolean isWindows() {
        return OPERATING_SYSTEM.startsWith("Windows");
    }

    public static List<String> getNamesNotInString(List<String> names, String commaSeparatedNames) {
        if (commaSeparatedNames == null || commaSeparatedNames.isEmpty()) {
            return names;
        }
        ArrayList<String> splitList = new ArrayList<String>(Arrays.asList(commaSeparatedNames.trim().split("\\s*,\\s*")));
        ArrayList<String> namesNotInString = new ArrayList<String>();
        for (String srcDir : names) {
            if (splitList.contains(srcDir)) continue;
            namesNotInString.add(srcDir);
        }
        return namesNotInString;
    }

    public static String getRegexScreenForKey(String propertyKey) {
        if (propertyKey == null) {
            throw new IllegalArgumentException("null property key");
        }
        int firstSeparatorLocation = propertyKey.indexOf(".");
        if (firstSeparatorLocation == -1) {
            return "[^a-zA-Z0-9.,_#\\s]";
        }
        String enumName = propertyKey.substring(0, firstSeparatorLocation);
        int secondSeparatorLocation = propertyKey.indexOf(".", firstSeparatorLocation + 1);
        String baseKey = secondSeparatorLocation == -1 ? propertyKey.substring(firstSeparatorLocation + 1) : propertyKey.substring(firstSeparatorLocation + 1, secondSeparatorLocation);
        try {
            switch (enumName) {
                case "TargetInstanceProp": {
                    return TargetInstanceProp.valueOf(baseKey).getRegexFilter();
                }
                case "SourceAnalysisProp": {
                    return SourceAnalysisProp.valueOf(baseKey).getRegexFilter();
                }
            }
            return "[^a-zA-Z0-9.,_#\\s]";
        }
        catch (IllegalArgumentException e) {
            return "[^a-zA-Z0-9.,_#\\s]";
        }
    }

    public static void printAndLogErrorMessage(String errorMsg, EnvironmentContext envCtx, Level lvl) {
        Utilities.printAndLogErrorMessage(errorMsg, envCtx, lvl, null);
    }

    public static void printAndLogErrorMessage(String errorMsg, EnvironmentContext envCtx, Level lvl, Throwable e) {
        envCtx.getErrWriter().println(errorMsg);
        log.logRecord(lvl, errorMsg, e);
    }

    public static void printAndLogMessage(String message, EnvironmentContext envCtx, Level lvl) {
        envCtx.getPrintStream().println(message);
        log.logRecord(lvl, message);
    }

    public static List<String> cleanAndValidateTablespaceNamesValue(List<String> tablespaceList, ExecutionContext exeCtx, String propertyName) {
        ArrayList<String> cleanTablespaceNames = new ArrayList<String>();
        ArrayList<String> invalidNames = new ArrayList<String>();
        for (String tablespace : tablespaceList) {
            String trimTablespace = tablespace.trim();
            if (exeCtx.getTablespacesNames().contains(trimTablespace)) {
                cleanTablespaceNames.add(trimTablespace);
                continue;
            }
            invalidNames.add(trimTablespace);
        }
        if (!invalidNames.isEmpty()) {
            String invalidTablespaces = Utilities.join(",", invalidNames);
            String errorMessage = "Tablespace name(s) in analysis property '" + propertyName + "' not found on source instance: " + invalidTablespaces;
            log.warning(errorMessage);
        }
        return cleanTablespaceNames;
    }
}

