/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.premigration.reports;

import com.oracle.premigration.commons.enums.MigrationMethod;
import com.oracle.premigration.commons.enums.TargetCloud;
import com.oracle.premigration.dbinspector.Check;
import com.oracle.premigration.dbinspector.CheckResult;
import com.oracle.premigration.reports.CheckResultDescription;
import com.oracle.premigration.reports.ChecksSummary;
import com.oracle.premigration.reports.json.CpatJsonIgnoreIfNull;
import com.oracle.premigration.reports.json.CpatJsonPropertyDescription;
import com.oracle.premigration.reports.text.TextProperty;
import com.oracle.premigration.reports.text.TextReportSectionName;
import com.oracle.premigration.reports.text.TextValueHint;
import com.oracle.premigration.reports.text.serialization.TextReportCheckList;
import com.oracle.premigration.reports.text.serialization.TextReportField;
import com.oracle.premigration.reports.text.serialization.TextReportLabeledValue;
import com.oracle.premigration.reports.text.serialization.TextReportResultDescriptionTable;
import com.oracle.premigration.reports.text.serialization.TextReportTable;
import java.util.ArrayList;
import java.util.Date;
import java.util.List;
import java.util.Map;

public final class ReportData {
    @TextProperty(labelKey="APP_VERSION_LABEL", section=TextReportSectionName.REPORT_DETAILS, serializationClass=TextReportLabeledValue.class, valueHint=TextValueHint.METADATA)
    @CpatJsonPropertyDescription(value="Version of the Premigration Advisor Application in standard Oracle version number format with between 3 and 5 segments")
    private String appVersion;
    @TextProperty(labelKey="CHECKS_VERSION_LABEL", section=TextReportSectionName.REPORT_DETAILS, serializationClass=TextReportLabeledValue.class, valueHint=TextValueHint.METADATA)
    @CpatJsonPropertyDescription(value="The version of the Checks being done in standard Oracle version number format with between 3 and 5 segments")
    private String checksVersion;
    @TextProperty(labelKey="REPORT_DATE_LABEL", section=TextReportSectionName.REPORT_DETAILS, serializationClass=TextReportLabeledValue.class, valueHint=TextValueHint.METADATA)
    @CpatJsonPropertyDescription(value="The date-time the analysis was done in ISO_DATE_TIME format. For example: 2019-12-15T08:43:41Z")
    private Date reportDate;
    @TextProperty(labelKey="REPORT_RESULT_LABEL", section=TextReportSectionName.REPORT_DETAILS, serializationClass=TextReportLabeledValue.class, valueHint=TextValueHint.METADATA)
    @CpatJsonPropertyDescription(value="Overall result of running the Cloud Premigration Advisor tool. e.g. whether the analysis completed successfully, or with warnings, etc., or failed to complete at all (FATAL). If 20 checks are completed successfully and one has issues, then this field indicates there were issues.")
    private CheckResult result;
    @TextProperty(labelKey="<none>", section=TextReportSectionName.RESULT_LEGEND, serializationClass=TextReportResultDescriptionTable.class, valueHint=TextValueHint.NATURAL_LANGUAGE)
    @CpatJsonPropertyDescription(value="Maps the result of analysis to the descriptions of what that results means. The 'result' attribute of this report and the 'result' attribute of each Check in the 'checkList' array can be used as an index into this object.")
    private List<CheckResultDescription> checkResultDescriptions = new ArrayList<CheckResultDescription>();
    @CpatJsonIgnoreIfNull
    @CpatJsonPropertyDescription(value="Message indicating what prevented the tool from completing the analysis. Only present when 'result' indicates a fatal error.")
    private String errorMessage;
    @CpatJsonPropertyDescription(value="The host name of the machine where the analysis is running")
    private String hostName;
    @TextProperty(labelKey="SRC_DB_HOST_NAME_LABEL", section=TextReportSectionName.SRC_DATABASE_DETAILS, serializationClass=TextReportLabeledValue.class, valueHint=TextValueHint.METADATA)
    @CpatJsonPropertyDescription(value="The host name of the machine where the source database is running")
    private String srcDataBaseHostName;
    @TextProperty(labelKey="SRC_DB_SID_LABEL", section=TextReportSectionName.SRC_DATABASE_DETAILS, serializationClass=TextReportLabeledValue.class, valueHint=TextValueHint.METADATA)
    @CpatJsonPropertyDescription(value="The ORACLE SID/SERVICE. This field represents something either, a) passed in, b) found in the environment, or, c) derived from 'a' and/or 'b'.")
    private String srcOracleSID;
    @CpatJsonPropertyDescription(value="The source database CREATED date.")
    private Date srcDatabaseCreatedDate;
    @CpatJsonPropertyDescription(value="The source database DBID.")
    private long srcDatabaseDBID;
    @CpatJsonPropertyDescription(value="The source database DB_UNIQUE_NAME")
    private String srcDatabaseUniqueName;
    @TextProperty(labelKey="SRC_DB_INSTANCE_NAME_LABEL", section=TextReportSectionName.SRC_DATABASE_DETAILS, serializationClass=TextReportLabeledValue.class, valueHint=TextValueHint.METADATA)
    @CpatJsonPropertyDescription(value="The Source Instance Name. This field represents something either, a) passed in, b) found in the environment, or, c) derived from 'a' and/or 'b'.")
    private String srcInstanceName;
    @TextProperty(labelKey="SRC_DB_NAME_LABEL", section=TextReportSectionName.SRC_DATABASE_DETAILS, serializationClass=TextReportLabeledValue.class, valueHint=TextValueHint.METADATA)
    @CpatJsonPropertyDescription(value="The Source Database Name.")
    private String srcDatabaseName;
    @TextProperty(labelKey="SRC_DB_USER_NAME_LABEL", section=TextReportSectionName.SRC_DATABASE_DETAILS, serializationClass=TextReportLabeledValue.class, valueHint=TextValueHint.METADATA)
    @CpatJsonPropertyDescription(value="The User that was used to perform the analysis (may not have been specified on the command line if a wallet based connection was used).")
    private String srcDatabaseUser;
    @TextProperty(labelKey="SRC_DB_PORT_STRING_LABEL", section=TextReportSectionName.SRC_DATABASE_DETAILS, serializationClass=TextReportLabeledValue.class, valueHint=TextValueHint.METADATA)
    @CpatJsonPropertyDescription(value="The Source Database PORT_STRING.")
    private String srcDatabasePortString;
    @TextProperty(labelKey="SRC_DB_PLATFORM_ID_LABEL", section=TextReportSectionName.SRC_DATABASE_DETAILS, serializationClass=TextReportLabeledValue.class, valueHint=TextValueHint.METADATA)
    @CpatJsonPropertyDescription(value="The Source Database PLATFORM_ID.")
    private long srcDatabasePlatformID;
    @TextProperty(labelKey="SRC_DB_VERSION_LABEL", section=TextReportSectionName.VERSION_INFORMATION, serializationClass=TextReportLabeledValue.class, valueHint=TextValueHint.METADATA)
    @CpatJsonPropertyDescription(value="The Source Database Version.  Typical format: '\\d+(\\.\\d+){1,4}'")
    private String srcDatabaseVersion;
    @TextProperty(labelKey="SRC_DB_CONTAINER_NAME_LABEL", section=TextReportSectionName.SRC_DATABASE_DETAILS, serializationClass=TextReportLabeledValue.class, valueHint=TextValueHint.METADATA)
    @CpatJsonIgnoreIfNull
    @CpatJsonPropertyDescription(value="The Source Database Container Name (if there is one)")
    private String srcContainerName;
    @TextProperty(labelKey="<none>", section=TextReportSectionName.VERSION_INFORMATION, serializationClass=TextReportTable.class, valueHint=TextValueHint.METADATA)
    @CpatJsonPropertyDescription(value="Additional Source Database Version info")
    private List<Map<String, String>> srcDatabaseVersionData;
    @TextProperty(labelKey="<none>", section=TextReportSectionName.PATCH_INFORMATION, serializationClass=TextReportTable.class, valueHint=TextValueHint.METADATA)
    @CpatJsonPropertyDescription(value="Source Database Patch info")
    private List<Map<String, String>> srcDatabasePatchInfo;
    @TextProperty(labelKey="CHECK_NUM_SCHEMAS_IN_SRC_DB_LABEL", section=TextReportSectionName.CHECK_SUMMARY, serializationClass=TextReportLabeledValue.class, valueHint=TextValueHint.METADATA)
    @CpatJsonPropertyDescription(value="The number of schemas found in the database.")
    private long srcNumSchemasPresent;
    @TextProperty(labelKey="CHECK_NUM_SCHEMAS_ANALYZED_LABEL", section=TextReportSectionName.CHECK_SUMMARY, serializationClass=TextReportLabeledValue.class, valueHint=TextValueHint.METADATA)
    @CpatJsonPropertyDescription(value="The number of schemas analyzed in this report.")
    private long srcNumSchemasAnalyzed;
    @TextProperty(labelKey="CHECK_SCHEMAS_ANALYZED_LABEL", section=TextReportSectionName.CHECK_SUMMARY, serializationClass=TextReportLabeledValue.class, valueHint=TextValueHint.METADATA)
    @CpatJsonPropertyDescription(value="The list of schemas that were analyzed.  This will either be the exact same list as what was passed to --schemas, or the list of schemas not in what was passed to --excludeschemas, or the full list of schemas in the database (minus any filtering done the Premigration Advisor).")
    private List<String> srcSchemasAnalyzed;
    @TextProperty(labelKey="CLOUD_TYPE_LABEL", section=TextReportSectionName.REPORT_DETAILS, serializationClass=TextReportLabeledValue.class, valueHint=TextValueHint.METADATA)
    @CpatJsonPropertyDescription(value="The type of ADB instance that the Premigration Advisor is targeting")
    private TargetCloud targetCloudType;
    @CpatJsonIgnoreIfNull
    @CpatJsonPropertyDescription(value="Version of the target database. Not present when app invoked without valid --analysisprops file.\tformat: '\\d+(\\.\\d+){1,4}'")
    private String targetCloudVersion;
    @TextProperty(labelKey="MIGRATION_METHODS_LABEL", section=TextReportSectionName.REPORT_DETAILS, serializationClass=TextReportLabeledValue.class, valueHint=TextValueHint.METADATA)
    @CpatJsonPropertyDescription(value="The migration approaches the caller of our app indicated (or defaulted). This field filters/alters the list of Checks that will be performed. Defaults to 'DATAPUMP'")
    private List<MigrationMethod> targetMigrationStrategies;
    @CpatJsonIgnoreIfNull
    @CpatJsonPropertyDescription(value="The resultant command line used to invoke the Cloud Premigration Advisor Tool")
    private String commandLineOptions;
    @TextProperty(labelKey="<none>", section=TextReportSectionName.CHECK_SUMMARY, serializationClass=TextReportField.class, valueHint=TextValueHint.INLINED)
    @CpatJsonPropertyDescription(value="Summarizes the results of the checks.")
    private ChecksSummary checksSummary;
    @TextProperty(labelKey="<none>", section=TextReportSectionName.CHECK_LIST, serializationClass=TextReportCheckList.class, valueHint=TextValueHint.METADATA)
    @CpatJsonPropertyDescription(value="The list of all Checks performed (Schema Specific and Instance-wide).")
    private List<Check> checkList;

    public String getAppVersion() {
        return this.appVersion;
    }

    public String getChecksVersion() {
        return this.checksVersion;
    }

    public Date getReportDate() {
        return this.reportDate;
    }

    public CheckResult getResult() {
        return this.result;
    }

    public List<CheckResultDescription> getCheckResultDescriptions() {
        return this.checkResultDescriptions;
    }

    public String getHostName() {
        return this.hostName;
    }

    public String getSrcDataBaseHostName() {
        return this.srcDataBaseHostName;
    }

    public String getSrcOracleSID() {
        return this.srcOracleSID;
    }

    public Date getSrcDatabaseCreatedDate() {
        return this.srcDatabaseCreatedDate;
    }

    public long getSrcDatabaseDBID() {
        return this.srcDatabaseDBID;
    }

    public String getSrcDatabaseUniqueName() {
        return this.srcDatabaseUniqueName;
    }

    public String getSrcInstanceName() {
        return this.srcInstanceName;
    }

    public String getSrcDatabaseName() {
        return this.srcDatabaseName;
    }

    public String getSrcDatabaseUser() {
        return this.srcDatabaseUser;
    }

    public String getSrcDatabasePortString() {
        return this.srcDatabasePortString;
    }

    public long getSrcDatabasePlatformID() {
        return this.srcDatabasePlatformID;
    }

    public String getSrcDatabaseVersion() {
        return this.srcDatabaseVersion;
    }

    public List<Map<String, String>> getSrcDatabaseVersionData() {
        return this.srcDatabaseVersionData;
    }

    public List<Map<String, String>> getSrcDatabasePatchInfo() {
        return this.srcDatabasePatchInfo;
    }

    public long getSrcNumSchemasPresent() {
        return this.srcNumSchemasPresent;
    }

    public long getSrcNumSchemasAnalyzed() {
        return this.srcNumSchemasAnalyzed;
    }

    public List<String> getSrcSchemasAnalyzed() {
        return this.srcSchemasAnalyzed;
    }

    public TargetCloud getTargetCloudType() {
        return this.targetCloudType;
    }

    public List<MigrationMethod> getTargetMigrationStrategies() {
        return this.targetMigrationStrategies;
    }

    public ChecksSummary getChecksSummary() {
        return this.checksSummary;
    }

    public List<Check> getCheckList() {
        return this.checkList;
    }

    public void setAppVersion(String appVersion) {
        this.appVersion = appVersion;
    }

    public void setChecksVersion(String checksVersion) {
        this.checksVersion = checksVersion;
    }

    public void setReportDate(Date reportDate) {
        this.reportDate = reportDate;
    }

    public void setResult(CheckResult result) {
        this.result = result;
    }

    public void setCheckResultDescriptions(List<CheckResultDescription> checkResultDescriptions) {
        this.checkResultDescriptions = checkResultDescriptions;
    }

    public void setErrorMessage(String errorMessage) {
        this.errorMessage = errorMessage;
    }

    public void setHostName(String hostName) {
        this.hostName = hostName;
    }

    public void setSrcDataBaseHostName(String srcDataBaseHostName) {
        this.srcDataBaseHostName = srcDataBaseHostName;
    }

    public void setSrcOracleSID(String srcOracleSID) {
        this.srcOracleSID = srcOracleSID;
    }

    public void setSrcDatabaseCreatedDate(Date srcDatabaseCreatedDate) {
        this.srcDatabaseCreatedDate = srcDatabaseCreatedDate;
    }

    public void setSrcDatabaseDBID(long srcDatabaseDBID) {
        this.srcDatabaseDBID = srcDatabaseDBID;
    }

    public void setSrcDatabaseUniqueName(String srcDatabaseUniqueName) {
        this.srcDatabaseUniqueName = srcDatabaseUniqueName;
    }

    public void setSrcInstanceName(String srcInstanceName) {
        this.srcInstanceName = srcInstanceName;
    }

    public void setSrcDatabaseName(String srcDatabaseName) {
        this.srcDatabaseName = srcDatabaseName;
    }

    public void setSrcDatabaseUser(String srcDatabaseUser) {
        this.srcDatabaseUser = srcDatabaseUser;
    }

    public void setSrcDatabasePortString(String srcDatabasePortString) {
        this.srcDatabasePortString = srcDatabasePortString;
    }

    public void setSrcDatabasePlatformID(long srcDatabasePlatformID) {
        this.srcDatabasePlatformID = srcDatabasePlatformID;
    }

    public void setSrcDatabaseVersion(String srcDatabaseVersion) {
        this.srcDatabaseVersion = srcDatabaseVersion;
    }

    public void setSrcContainerName(String srcContainerName) {
        this.srcContainerName = srcContainerName;
    }

    public void setSrcDatabaseVersionData(List<Map<String, String>> srcDatabaseVersionData) {
        this.srcDatabaseVersionData = srcDatabaseVersionData;
    }

    public void setSrcDatabasePatchInfo(List<Map<String, String>> srcDatabasePatchInfo) {
        this.srcDatabasePatchInfo = srcDatabasePatchInfo;
    }

    public void setSrcNumSchemasPresent(long srcNumSchemasPresent) {
        this.srcNumSchemasPresent = srcNumSchemasPresent;
    }

    public void setSrcNumSchemasAnalyzed(long srcNumSchemasAnalyzed) {
        this.srcNumSchemasAnalyzed = srcNumSchemasAnalyzed;
    }

    public void setSrcSchemasAnalyzed(List<String> srcSchemasAnalyzed) {
        this.srcSchemasAnalyzed = srcSchemasAnalyzed;
    }

    public void setTargetCloudType(TargetCloud targetCloudType) {
        this.targetCloudType = targetCloudType;
    }

    public void setTargetCloudVersion(String targetCloudVersion) {
        this.targetCloudVersion = targetCloudVersion;
    }

    public void setTargetMigrationStrategies(List<MigrationMethod> targetMigrationStrategies) {
        this.targetMigrationStrategies = targetMigrationStrategies;
    }

    public void setCommandLineOptions(String commandLineOptions) {
        this.commandLineOptions = commandLineOptions;
    }

    public void setChecksSummary(ChecksSummary checksSummary) {
        this.checksSummary = checksSummary;
    }

    public void setCheckList(List<Check> checkList) {
        this.checkList = checkList;
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof ReportData)) {
            return false;
        }
        ReportData other = (ReportData)o;
        if (this.getSrcDatabaseDBID() != other.getSrcDatabaseDBID()) {
            return false;
        }
        if (this.getSrcDatabasePlatformID() != other.getSrcDatabasePlatformID()) {
            return false;
        }
        if (this.getSrcNumSchemasPresent() != other.getSrcNumSchemasPresent()) {
            return false;
        }
        if (this.getSrcNumSchemasAnalyzed() != other.getSrcNumSchemasAnalyzed()) {
            return false;
        }
        String this$appVersion = this.getAppVersion();
        String other$appVersion = other.getAppVersion();
        if (this$appVersion == null ? other$appVersion != null : !this$appVersion.equals(other$appVersion)) {
            return false;
        }
        String this$checksVersion = this.getChecksVersion();
        String other$checksVersion = other.getChecksVersion();
        if (this$checksVersion == null ? other$checksVersion != null : !this$checksVersion.equals(other$checksVersion)) {
            return false;
        }
        Date this$reportDate = this.getReportDate();
        Date other$reportDate = other.getReportDate();
        if (this$reportDate == null ? other$reportDate != null : !((Object)this$reportDate).equals(other$reportDate)) {
            return false;
        }
        CheckResult this$result = this.getResult();
        CheckResult other$result = other.getResult();
        if (this$result == null ? other$result != null : !((Object)((Object)this$result)).equals((Object)other$result)) {
            return false;
        }
        List<CheckResultDescription> this$checkResultDescriptions = this.getCheckResultDescriptions();
        List<CheckResultDescription> other$checkResultDescriptions = other.getCheckResultDescriptions();
        if (this$checkResultDescriptions == null ? other$checkResultDescriptions != null : !((Object)this$checkResultDescriptions).equals(other$checkResultDescriptions)) {
            return false;
        }
        String this$errorMessage = this.getErrorMessage();
        String other$errorMessage = other.getErrorMessage();
        if (this$errorMessage == null ? other$errorMessage != null : !this$errorMessage.equals(other$errorMessage)) {
            return false;
        }
        String this$hostName = this.getHostName();
        String other$hostName = other.getHostName();
        if (this$hostName == null ? other$hostName != null : !this$hostName.equals(other$hostName)) {
            return false;
        }
        String this$srcDataBaseHostName = this.getSrcDataBaseHostName();
        String other$srcDataBaseHostName = other.getSrcDataBaseHostName();
        if (this$srcDataBaseHostName == null ? other$srcDataBaseHostName != null : !this$srcDataBaseHostName.equals(other$srcDataBaseHostName)) {
            return false;
        }
        String this$srcOracleSID = this.getSrcOracleSID();
        String other$srcOracleSID = other.getSrcOracleSID();
        if (this$srcOracleSID == null ? other$srcOracleSID != null : !this$srcOracleSID.equals(other$srcOracleSID)) {
            return false;
        }
        Date this$srcDatabaseCreatedDate = this.getSrcDatabaseCreatedDate();
        Date other$srcDatabaseCreatedDate = other.getSrcDatabaseCreatedDate();
        if (this$srcDatabaseCreatedDate == null ? other$srcDatabaseCreatedDate != null : !((Object)this$srcDatabaseCreatedDate).equals(other$srcDatabaseCreatedDate)) {
            return false;
        }
        String this$srcDatabaseUniqueName = this.getSrcDatabaseUniqueName();
        String other$srcDatabaseUniqueName = other.getSrcDatabaseUniqueName();
        if (this$srcDatabaseUniqueName == null ? other$srcDatabaseUniqueName != null : !this$srcDatabaseUniqueName.equals(other$srcDatabaseUniqueName)) {
            return false;
        }
        String this$srcInstanceName = this.getSrcInstanceName();
        String other$srcInstanceName = other.getSrcInstanceName();
        if (this$srcInstanceName == null ? other$srcInstanceName != null : !this$srcInstanceName.equals(other$srcInstanceName)) {
            return false;
        }
        String this$srcDatabaseName = this.getSrcDatabaseName();
        String other$srcDatabaseName = other.getSrcDatabaseName();
        if (this$srcDatabaseName == null ? other$srcDatabaseName != null : !this$srcDatabaseName.equals(other$srcDatabaseName)) {
            return false;
        }
        String this$srcDatabaseUser = this.getSrcDatabaseUser();
        String other$srcDatabaseUser = other.getSrcDatabaseUser();
        if (this$srcDatabaseUser == null ? other$srcDatabaseUser != null : !this$srcDatabaseUser.equals(other$srcDatabaseUser)) {
            return false;
        }
        String this$srcDatabasePortString = this.getSrcDatabasePortString();
        String other$srcDatabasePortString = other.getSrcDatabasePortString();
        if (this$srcDatabasePortString == null ? other$srcDatabasePortString != null : !this$srcDatabasePortString.equals(other$srcDatabasePortString)) {
            return false;
        }
        String this$srcDatabaseVersion = this.getSrcDatabaseVersion();
        String other$srcDatabaseVersion = other.getSrcDatabaseVersion();
        if (this$srcDatabaseVersion == null ? other$srcDatabaseVersion != null : !this$srcDatabaseVersion.equals(other$srcDatabaseVersion)) {
            return false;
        }
        String this$srcContainerName = this.getSrcContainerName();
        String other$srcContainerName = other.getSrcContainerName();
        if (this$srcContainerName == null ? other$srcContainerName != null : !this$srcContainerName.equals(other$srcContainerName)) {
            return false;
        }
        List<Map<String, String>> this$srcDatabaseVersionData = this.getSrcDatabaseVersionData();
        List<Map<String, String>> other$srcDatabaseVersionData = other.getSrcDatabaseVersionData();
        if (this$srcDatabaseVersionData == null ? other$srcDatabaseVersionData != null : !((Object)this$srcDatabaseVersionData).equals(other$srcDatabaseVersionData)) {
            return false;
        }
        List<Map<String, String>> this$srcDatabasePatchInfo = this.getSrcDatabasePatchInfo();
        List<Map<String, String>> other$srcDatabasePatchInfo = other.getSrcDatabasePatchInfo();
        if (this$srcDatabasePatchInfo == null ? other$srcDatabasePatchInfo != null : !((Object)this$srcDatabasePatchInfo).equals(other$srcDatabasePatchInfo)) {
            return false;
        }
        List<String> this$srcSchemasAnalyzed = this.getSrcSchemasAnalyzed();
        List<String> other$srcSchemasAnalyzed = other.getSrcSchemasAnalyzed();
        if (this$srcSchemasAnalyzed == null ? other$srcSchemasAnalyzed != null : !((Object)this$srcSchemasAnalyzed).equals(other$srcSchemasAnalyzed)) {
            return false;
        }
        TargetCloud this$targetCloudType = this.getTargetCloudType();
        TargetCloud other$targetCloudType = other.getTargetCloudType();
        if (this$targetCloudType == null ? other$targetCloudType != null : !((Object)((Object)this$targetCloudType)).equals((Object)other$targetCloudType)) {
            return false;
        }
        String this$targetCloudVersion = this.getTargetCloudVersion();
        String other$targetCloudVersion = other.getTargetCloudVersion();
        if (this$targetCloudVersion == null ? other$targetCloudVersion != null : !this$targetCloudVersion.equals(other$targetCloudVersion)) {
            return false;
        }
        List<MigrationMethod> this$targetMigrationStrategies = this.getTargetMigrationStrategies();
        List<MigrationMethod> other$targetMigrationStrategies = other.getTargetMigrationStrategies();
        if (this$targetMigrationStrategies == null ? other$targetMigrationStrategies != null : !((Object)this$targetMigrationStrategies).equals(other$targetMigrationStrategies)) {
            return false;
        }
        String this$commandLineOptions = this.getCommandLineOptions();
        String other$commandLineOptions = other.getCommandLineOptions();
        if (this$commandLineOptions == null ? other$commandLineOptions != null : !this$commandLineOptions.equals(other$commandLineOptions)) {
            return false;
        }
        ChecksSummary this$checksSummary = this.getChecksSummary();
        ChecksSummary other$checksSummary = other.getChecksSummary();
        if (this$checksSummary == null ? other$checksSummary != null : !((Object)this$checksSummary).equals(other$checksSummary)) {
            return false;
        }
        List<Check> this$checkList = this.getCheckList();
        List<Check> other$checkList = other.getCheckList();
        return !(this$checkList == null ? other$checkList != null : !((Object)this$checkList).equals(other$checkList));
    }

    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        long $srcDatabaseDBID = this.getSrcDatabaseDBID();
        result = result * 59 + (int)($srcDatabaseDBID >>> 32 ^ $srcDatabaseDBID);
        long $srcDatabasePlatformID = this.getSrcDatabasePlatformID();
        result = result * 59 + (int)($srcDatabasePlatformID >>> 32 ^ $srcDatabasePlatformID);
        long $srcNumSchemasPresent = this.getSrcNumSchemasPresent();
        result = result * 59 + (int)($srcNumSchemasPresent >>> 32 ^ $srcNumSchemasPresent);
        long $srcNumSchemasAnalyzed = this.getSrcNumSchemasAnalyzed();
        result = result * 59 + (int)($srcNumSchemasAnalyzed >>> 32 ^ $srcNumSchemasAnalyzed);
        String $appVersion = this.getAppVersion();
        result = result * 59 + ($appVersion == null ? 43 : $appVersion.hashCode());
        String $checksVersion = this.getChecksVersion();
        result = result * 59 + ($checksVersion == null ? 43 : $checksVersion.hashCode());
        Date $reportDate = this.getReportDate();
        result = result * 59 + ($reportDate == null ? 43 : ((Object)$reportDate).hashCode());
        CheckResult $result = this.getResult();
        result = result * 59 + ($result == null ? 43 : ((Object)((Object)$result)).hashCode());
        List<CheckResultDescription> $checkResultDescriptions = this.getCheckResultDescriptions();
        result = result * 59 + ($checkResultDescriptions == null ? 43 : ((Object)$checkResultDescriptions).hashCode());
        String $errorMessage = this.getErrorMessage();
        result = result * 59 + ($errorMessage == null ? 43 : $errorMessage.hashCode());
        String $hostName = this.getHostName();
        result = result * 59 + ($hostName == null ? 43 : $hostName.hashCode());
        String $srcDataBaseHostName = this.getSrcDataBaseHostName();
        result = result * 59 + ($srcDataBaseHostName == null ? 43 : $srcDataBaseHostName.hashCode());
        String $srcOracleSID = this.getSrcOracleSID();
        result = result * 59 + ($srcOracleSID == null ? 43 : $srcOracleSID.hashCode());
        Date $srcDatabaseCreatedDate = this.getSrcDatabaseCreatedDate();
        result = result * 59 + ($srcDatabaseCreatedDate == null ? 43 : ((Object)$srcDatabaseCreatedDate).hashCode());
        String $srcDatabaseUniqueName = this.getSrcDatabaseUniqueName();
        result = result * 59 + ($srcDatabaseUniqueName == null ? 43 : $srcDatabaseUniqueName.hashCode());
        String $srcInstanceName = this.getSrcInstanceName();
        result = result * 59 + ($srcInstanceName == null ? 43 : $srcInstanceName.hashCode());
        String $srcDatabaseName = this.getSrcDatabaseName();
        result = result * 59 + ($srcDatabaseName == null ? 43 : $srcDatabaseName.hashCode());
        String $srcDatabaseUser = this.getSrcDatabaseUser();
        result = result * 59 + ($srcDatabaseUser == null ? 43 : $srcDatabaseUser.hashCode());
        String $srcDatabasePortString = this.getSrcDatabasePortString();
        result = result * 59 + ($srcDatabasePortString == null ? 43 : $srcDatabasePortString.hashCode());
        String $srcDatabaseVersion = this.getSrcDatabaseVersion();
        result = result * 59 + ($srcDatabaseVersion == null ? 43 : $srcDatabaseVersion.hashCode());
        String $srcContainerName = this.getSrcContainerName();
        result = result * 59 + ($srcContainerName == null ? 43 : $srcContainerName.hashCode());
        List<Map<String, String>> $srcDatabaseVersionData = this.getSrcDatabaseVersionData();
        result = result * 59 + ($srcDatabaseVersionData == null ? 43 : ((Object)$srcDatabaseVersionData).hashCode());
        List<Map<String, String>> $srcDatabasePatchInfo = this.getSrcDatabasePatchInfo();
        result = result * 59 + ($srcDatabasePatchInfo == null ? 43 : ((Object)$srcDatabasePatchInfo).hashCode());
        List<String> $srcSchemasAnalyzed = this.getSrcSchemasAnalyzed();
        result = result * 59 + ($srcSchemasAnalyzed == null ? 43 : ((Object)$srcSchemasAnalyzed).hashCode());
        TargetCloud $targetCloudType = this.getTargetCloudType();
        result = result * 59 + ($targetCloudType == null ? 43 : ((Object)((Object)$targetCloudType)).hashCode());
        String $targetCloudVersion = this.getTargetCloudVersion();
        result = result * 59 + ($targetCloudVersion == null ? 43 : $targetCloudVersion.hashCode());
        List<MigrationMethod> $targetMigrationStrategies = this.getTargetMigrationStrategies();
        result = result * 59 + ($targetMigrationStrategies == null ? 43 : ((Object)$targetMigrationStrategies).hashCode());
        String $commandLineOptions = this.getCommandLineOptions();
        result = result * 59 + ($commandLineOptions == null ? 43 : $commandLineOptions.hashCode());
        ChecksSummary $checksSummary = this.getChecksSummary();
        result = result * 59 + ($checksSummary == null ? 43 : ((Object)$checksSummary).hashCode());
        List<Check> $checkList = this.getCheckList();
        result = result * 59 + ($checkList == null ? 43 : ((Object)$checkList).hashCode());
        return result;
    }

    public String toString() {
        return "ReportData(appVersion=" + this.getAppVersion() + ", checksVersion=" + this.getChecksVersion() + ", reportDate=" + this.getReportDate() + ", result=" + (Object)((Object)this.getResult()) + ", checkResultDescriptions=" + this.getCheckResultDescriptions() + ", errorMessage=" + this.getErrorMessage() + ", hostName=" + this.getHostName() + ", srcDataBaseHostName=" + this.getSrcDataBaseHostName() + ", srcOracleSID=" + this.getSrcOracleSID() + ", srcDatabaseCreatedDate=" + this.getSrcDatabaseCreatedDate() + ", srcDatabaseDBID=" + this.getSrcDatabaseDBID() + ", srcDatabaseUniqueName=" + this.getSrcDatabaseUniqueName() + ", srcInstanceName=" + this.getSrcInstanceName() + ", srcDatabaseName=" + this.getSrcDatabaseName() + ", srcDatabaseUser=" + this.getSrcDatabaseUser() + ", srcDatabasePortString=" + this.getSrcDatabasePortString() + ", srcDatabasePlatformID=" + this.getSrcDatabasePlatformID() + ", srcDatabaseVersion=" + this.getSrcDatabaseVersion() + ", srcContainerName=" + this.getSrcContainerName() + ", srcDatabaseVersionData=" + this.getSrcDatabaseVersionData() + ", srcDatabasePatchInfo=" + this.getSrcDatabasePatchInfo() + ", srcNumSchemasPresent=" + this.getSrcNumSchemasPresent() + ", srcNumSchemasAnalyzed=" + this.getSrcNumSchemasAnalyzed() + ", srcSchemasAnalyzed=" + this.getSrcSchemasAnalyzed() + ", targetCloudType=" + (Object)((Object)this.getTargetCloudType()) + ", targetCloudVersion=" + this.getTargetCloudVersion() + ", targetMigrationStrategies=" + this.getTargetMigrationStrategies() + ", commandLineOptions=" + this.getCommandLineOptions() + ", checksSummary=" + this.getChecksSummary() + ", checkList=" + this.getCheckList() + ")";
    }

    @CpatJsonIgnoreIfNull
    public String getErrorMessage() {
        return this.errorMessage;
    }

    @CpatJsonIgnoreIfNull
    public String getSrcContainerName() {
        return this.srcContainerName;
    }

    @CpatJsonIgnoreIfNull
    public String getTargetCloudVersion() {
        return this.targetCloudVersion;
    }

    @CpatJsonIgnoreIfNull
    public String getCommandLineOptions() {
        return this.commandLineOptions;
    }
}

